/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.rif.FlexAtahRif;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FAClientHelper {
    public static final int ADMIN_UP = 1;
    public static final int ADMIN_DOWN = 2;
    public static final Logger logger = Logger.getLogger(FAClientHelper.class);
    private static FAClientHelper instance;
    public static MibEnum[] adminModeEnums;
    public static MibEnum[] adminStatEnums;

    public static synchronized FAClientHelper getInstancee() {
        if (instance == null) {
            instance = new FAClientHelper();
        }
        return instance;
    }

    private FAClientHelper() {
    }

    public static FlexAtahRif getRemote() throws Exception {
        FlexAtahRif remote = ClientController.getInstance().assertFlexAtah();
        return remote;
    }

    public static void sort(List<SwitchBase> sws) {
        Collections.sort(sws);
    }

    public static void removeNpPort(List<FlexAtahCfg> cfgs) {
        if (cfgs == null || cfgs.size() <= 0) {
            return;
        }
        ArrayList<FlexAtahCfg> removeMe = new ArrayList<FlexAtahCfg>();
        for (FlexAtahCfg cfg : cfgs) {
            String mode = FAClientHelper.getAdminPort(cfg);
            if (!"NP".equalsIgnoreCase(mode.trim())) continue;
            removeMe.add(cfg);
        }
        for (FlexAtahCfg rm : removeMe) {
            cfgs.remove(rm);
        }
    }

    public static String getAdminPort(FlexAtahCfg cfg) {
        return MibEnum.getLabel(adminModeEnums, cfg.getAdminMode());
    }

    public static String buildExceptionMessage(Map<SwitchBase, Exception> swExceptions) {
        StringBuilder msg = new StringBuilder("There were errors retrieving configuration. \n\n");
        if (swExceptions != null && swExceptions.size() > 0) {
            for (SwitchBase key : swExceptions.keySet()) {
                Exception ex = swExceptions.get(key);
                msg.append(key.toString() + " : " + ex.getMessage() + "\n");
            }
        }
        return msg.toString();
    }

    public static void checkWwn(String fromWwn) throws Exception {
        Wwn nWwn = new Wwn("");
        Wwn wwn = new Wwn(fromWwn);
        if (wwn == null || wwn.toString() == null || wwn.toString().equals(nWwn.toString())) {
            throw new Exception("Invalid WWN");
        }
    }

    public static boolean isEqual(String fromWwn, String toWwn) {
        try {
            Wwn fWwn = new Wwn(fromWwn);
            Wwn tWwn = new Wwn(toWwn);
            return fWwn.equals(tWwn) || fWwn.toString().equals(tWwn.toString());
        }
        catch (Exception ex) {
            return false;
        }
    }

    static {
        adminModeEnums = MibNode.get("fcIfAdminMode").getEnums();
        adminStatEnums = MibNode.get("ifAdminStatus").getEnums();
    }
}

