/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa.wizard;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.sm.client.fa.FAClientHelper;
import com.cisco.dcbu.sm.client.fa.FAReplaceController;
import com.cisco.dcbu.sm.client.fa.wizard.FAReplaceWizard;
import com.cisco.dcbu.sm.client.fa.wizard.SwitchIfPanel;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class ReplaceDestStep
extends SwitchIfPanel {
    public static String BRIEF = "Please select a new port.  To select a port, click on its corresponding row.";
    protected static String SAME_SWITCH = "Same switch card";
    protected static String DIFF_SWITCH = "Diff switch card";
    protected static String TITLE = "Choose New Port";
    protected FAReplaceController controller = null;

    public ReplaceDestStep(String title, String brief, ImageIcon icon) {
        super(title, brief, icon);
    }

    public ReplaceDestStep() {
        this(TITLE, BRIEF, FAReplaceWizard.ICON);
    }

    @Override
    public boolean refresh() {
        SwitchBase selectedSw;
        this.setTitle("Step 3:  " + TITLE);
        if (this.controller == null) {
            this.controller = new FAReplaceController(this.swSelectCard, this.swSelectPanel, FAReplaceWizard.getInstance().faCfgMap, 0);
            this.npvCombo.addItemListener(this.controller);
        }
        SwitchBase item = FAReplaceWizard.getInstance().getSourceSw();
        boolean sameSw = FAReplaceWizard.getInstance().isSameSwitch();
        this.npvCombo.removeAllItems();
        for (SwitchBase sw : FAReplaceWizard.getInstance().faCfgMap.keySet()) {
            if (sameSw) {
                if (!sw.equals(item)) continue;
                this.npvCombo.addItem(sw);
                break;
            }
            if (sw.equals(item)) continue;
            this.npvCombo.addItem(sw);
        }
        if ((selectedSw = (SwitchBase)this.npvCombo.getSelectedItem()) != null && !selectedSw.equals(FAReplaceWizard.getInstance().getSourceSw())) {
            this.npvCombo.setSelectedItem(FAReplaceWizard.getInstance().getSourceSw());
        }
        this.controller.removeFromTable(FAReplaceWizard.getInstance().getSourceSw(), FAReplaceWizard.getInstance().getSourceIf());
        if (FAReplaceWizard.getInstance().isSameSwitch()) {
            this.npvCombo.setVisible(false);
            this.label.setVisible(false);
            this.label.setText("Selected switch: ");
        } else if (FAReplaceWizard.getInstance().isDifferentSwitch()) {
            this.npvCombo.setVisible(true);
            this.label.setVisible(true);
            this.label.setText("Select a switch: ");
        }
        if (FAReplaceWizard.getInstance().isSameSwitch()) {
            this.mainCard.show(this.mainCardPanel, SAME_SWITCH);
        } else if (FAReplaceWizard.getInstance().isDifferentSwitch()) {
            this.mainCard.show(this.mainCardPanel, DIFF_SWITCH);
        }
        return super.refresh();
    }

    @Override
    public void doNext() {
        int rc;
        if (!this.controller.stopCellEditing()) {
            return;
        }
        if (!this.controller.hasSelection()) {
            JOptionPane.showMessageDialog(this.getParent(), "Please select an interface before continuing.");
            return;
        }
        FlexAtahCfg cfg = this.controller.getSelection();
        String admin = MibEnum.getLabel(FAClientHelper.adminStatEnums, cfg.getOperStatus());
        if ("up".equalsIgnoreCase(admin) && (rc = JOptionPane.showConfirmDialog(this.getParent(), "This port is being used.  Are you sure you want to replace old server with the one on this port?", "Flex Attach:  Replace Server - " + TITLE, 0, 2)) == 1) {
            return;
        }
        this.setDataValid(false);
        super.doNext();
    }

    public FlexAtahCfg getDest() {
        return this.controller.getSelection();
    }

    public SwitchBase getSwitch() {
        return (SwitchBase)this.npvCombo.getSelectedItem();
    }
}

