/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fa.wizard;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.ui.script.AbstractWorker;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fa.FAClientHelper;
import com.cisco.dcbu.sm.client.fa.FAReplaceController;
import com.cisco.dcbu.sm.client.fa.wizard.FAPreConfigFinishPanel;
import com.cisco.dcbu.sm.client.fa.wizard.FAPreConfigWizard;
import com.cisco.dcbu.sm.client.fa.wizard.FAReplaceWizard;
import com.cisco.dcbu.sm.client.fa.wizard.FAWizard;
import com.cisco.dcbu.sm.client.fa.wizard.SwitchIfPanel;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.npv.view.ProgressWindow;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.dto.FlexAtahSwBaseVPWWN;
import com.cisco.dcbu.sm.common.dto.FlexAtahVPWWN;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ReplaceSourceStep
extends SwitchIfPanel {
    public static final Logger logger = Logger.getLogger(FAPreConfigWizard.class);
    protected List<FlexAtahVPWWN> globalVPWWN;
    protected Wwn interfaceVPWWN;
    public static String BRIEF = "Please select a port you like to replace.  To select a port, click on its corresponding row.";
    public static String FINISH = "finish";
    protected static String TITLE = "Step 2:  Choose Failed Port";
    protected FAReplaceController controller = null;
    FAPreConfigFinishPanel progress = new FAPreConfigFinishPanel();

    public ReplaceSourceStep() {
        this(TITLE, BRIEF, FAReplaceWizard.ICON);
    }

    public ReplaceSourceStep(String title, String brief, ImageIcon icon) {
        super(title, brief, icon);
        this.mainCardPanel.add(FINISH, this.progress);
    }

    @Override
    public boolean refresh() {
        this.npvCombo.removeAllItems();
        this.controller = new FAReplaceController(this.swSelectCard, this.swSelectPanel, FAReplaceWizard.getInstance().faCfgMap, 0);
        this.npvCombo.addItemListener(this.controller);
        for (SwitchBase sw : FAReplaceWizard.getInstance().faCfgMap.keySet()) {
            this.npvCombo.addItem(sw);
        }
        return super.refresh();
    }

    @Override
    public void doNext() {
        int rc;
        if (!this.controller.stopCellEditing()) {
            return;
        }
        if (!this.controller.hasSelection()) {
            JOptionPane.showMessageDialog(this.getParent(), "Please select an interface before continuing.");
            return;
        }
        FlexAtahCfg cfg = this.controller.getSelection();
        String oper = MibEnum.getLabel(FAClientHelper.adminStatEnums, cfg.getOperStatus());
        if ("up".equalsIgnoreCase(oper) && (rc = JOptionPane.showConfirmDialog(this.getParent(), "This port is up and may be in use.  Are you sure you want to replace the server on this port?", "Flex Attach:  Move Server - " + TITLE, 0, 2)) == 1) {
            return;
        }
        if (FAReplaceWizard.getInstance().isSamePort()) {
            FAReplaceWizard.getInstance().updateStep();
        } else {
            this.checkGlobalVPWWN(FAReplaceWizard.getInstance(), FAReplaceWizard.getInstance().getSourceSw(), "Flex Attach:  Replace Server");
        }
        this.setDataValid(false);
        super.doNext();
    }

    @Override
    public void doFinish() {
        if (!this.controller.stopCellEditing()) {
            return;
        }
        if (!this.controller.hasSelection()) {
            JOptionPane.showMessageDialog(this.getParent(), "Please select an interface before continuing.");
            return;
        }
        this.getWizard().getNavigator().getBackBtn().setEnabled(false);
        this.mainCard.show(this.mainCardPanel, FINISH);
        try {
            FAReplaceWizard.getInstance().applyReplace(this.progress);
        }
        catch (Exception ex) {
            FAReplaceWizard.getInstance();
            FAReplaceWizard.logger.error((Object)("Unable to apply configuration: " + ex.getMessage()));
            this.progress.postError(ex.getMessage());
            this.progress.complete();
        }
        super.doFinish();
    }

    @Override
    public void actionFinished(boolean b) {
        if (b) {
            super.actionFinished(b);
        }
        this.getWizard().getNavigator().getCancel().setText("Close");
    }

    public SwitchBase getSwitch() {
        return (SwitchBase)this.npvCombo.getSelectedItem();
    }

    public FlexAtahCfg getSource() {
        return this.controller.getSelection();
    }

    public List<FlexAtahVPWWN> getGlobalVPWWNList() {
        return this.globalVPWWN;
    }

    public Wwn getInterfaceVPWWN() {
        return this.interfaceVPWWN;
    }

    protected void checkGlobalVPWWN(final FAWizard instance, final SwitchBase fromSw, final String name) {
        ClientController.getInstance();
        final SnmpUserOpt userOptFrom = ClientController.findFabricSwitchByWwn(fromSw.getWwn()).getFabric().getSnmpUserOpt();
        JFrame frame = (JFrame)instance.getParent();
        final ProgressWindow progressWindow = new ProgressWindow(frame, name, "Checking data...please wait.");
        AbstractWorker worker = new AbstractWorker(){
            Map<SwitchBase, Exception> swExceptions = new HashMap<SwitchBase, Exception>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object construct() {
                try {
                    progressWindow.setMaximum(5);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Starting progress window");
                    }
                    progressWindow.start();
                    Fabric fabric = ClientController.getInstance().getFabric();
                    if (fabric == null) {
                        RuntimeException runtimeException = new RuntimeException("Fabric is null, unable to initialize " + name);
                        return runtimeException;
                    }
                    progressWindow.setProgress(1);
                    ArrayList<SwitchBase> baseList = new ArrayList<SwitchBase>();
                    baseList.add(fromSw);
                    ArrayList<SnmpUserOpt> optList = new ArrayList<SnmpUserOpt>();
                    optList.add(userOptFrom);
                    Map<SwitchBase, FlexAtahSwBaseVPWWN> vpWWNList = FAClientHelper.getRemote().getFlexAtahVPWWN(baseList, optList);
                    progressWindow.setProgress(1);
                    HashMap<SwitchBase, List<FlexAtahVPWWN>> vpWWNHash = new HashMap<SwitchBase, List<FlexAtahVPWWN>>();
                    for (SwitchBase key : vpWWNList.keySet()) {
                        FlexAtahSwBaseVPWWN val = vpWWNList.get(key);
                        if (val.getException() != null) {
                            this.swExceptions.put(key, val.getException());
                            continue;
                        }
                        vpWWNHash.put(key, val.getVPWWNList());
                        ReplaceSourceStep.this.globalVPWWN = val.getVPWWNList();
                    }
                    for (SwitchBase key : this.swExceptions.keySet()) {
                        vpWWNHash.remove(key);
                        baseList.remove(key);
                    }
                    progressWindow.setProgress(2);
                    if (vpWWNHash.size() != baseList.size() || vpWWNHash.size() == 0) {
                        String msg;
                        String string = msg = vpWWNHash.size() != baseList.size() ? FAWizard.NUM_SWITCH_MISMATCH_ERR : "Not able to retrieve Virtual PWWN";
                        if (this.swExceptions.size() > 0) {
                            msg = msg + "\n\n" + FAClientHelper.buildExceptionMessage(this.swExceptions);
                        }
                        Exception exception = new Exception(msg);
                        return exception;
                    }
                    if (ReplaceSourceStep.this.globalVPWWN == null || ReplaceSourceStep.this.globalVPWWN.size() == 0) {
                        ReplaceSourceStep.this.interfaceVPWWN = FAClientHelper.getRemote().getFlexAtahIfVPWWN(fromSw, userOptFrom, ReplaceSourceStep.this.getSource().getIfIndex());
                        progressWindow.setProgress(3);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage());
                    Exception exception = ex;
                    return exception;
                }
                finally {
                    if (progressWindow != null) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"Stopping progress window");
                        }
                        progressWindow.stop();
                        progressWindow.dispose();
                    }
                }
                if (this.swExceptions.size() > 0) {
                    String msg = FAClientHelper.buildExceptionMessage(this.swExceptions);
                    if (!this.isInterrupted()) {
                        JOptionPane.showMessageDialog(instance, msg, name, 2);
                    }
                }
                return true;
            }

            @Override
            public void finished() {
                Object retObj = this.getValue();
                if (retObj instanceof Exception) {
                    Exception ex = (Exception)retObj;
                    logger.error((Object)ex.getStackTrace());
                    logger.warn((Object)"Unable to load Flex Attach data: ", (Throwable)ex);
                    if (!this.isInterrupted()) {
                        ReplaceSourceStep.showError((JFrame)ReplaceSourceStep.this.getParent(), ex, name);
                        if (progressWindow != null) {
                            progressWindow.dispose();
                        }
                    }
                } else if (!this.isInterrupted()) {
                    ReplaceSourceStep.this.updateAskPanel();
                }
                if (progressWindow != null) {
                    progressWindow.stop();
                    progressWindow.dispose();
                }
            }
        };
        this.addWorker(worker);
        worker.start();
    }

    protected void updateAskPanel() {
        FAReplaceWizard.getInstance().updateAskPanel();
    }

    protected void addWorker(AbstractWorker worker) {
        FAReplaceWizard.getInstance().addWorker(worker);
    }

    static void showError(JFrame parent, Exception ex, String NAME) {
        String errMsg = "Unable to load data.  " + NAME + " cannot continue.";
        if (ex.getMessage() != null) {
            errMsg = errMsg + "\n\n" + ex.getMessage();
        }
        JOptionPane.showMessageDialog(parent, errMsg, NAME, 0);
    }
}

