/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpCounter;
import com.cisco.dcbu.lib.snmp.SnmpCounter64;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpOpaque;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fc.CheckData;
import com.cisco.dcbu.sm.client.fc.ResolveData;
import com.cisco.dcbu.sm.client.model.Switch;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class AbstractFabricCheck
implements SnmpCallbackIf {
    static final int TIMEOUT = 6000;
    static final String _VALUE = "value";
    Array _peers;
    Array _attr;
    int _attrLen;
    String _attrName;
    int _numReqs;
    MibEnum[][] _enums;
    Array _data;
    boolean _checkMismatch = true;
    boolean _checkMissing = true;
    boolean _checkExtra = true;
    SnmpOID _rowAddRm = null;
    int _indexOffset;

    AbstractFabricCheck() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        --this._numReqs;
        SnmpPeer peer = ClientController.findFabricSwitchByIpAddress(pdu.getAddress()).getPeer();
        if (this.handleErrorCallBack(peer, pdu, timedOut)) {
            this.handleCallBack(peer, pdu);
        }
        if (this._numReqs <= 0) {
            try {
                Array array = this._data;
                synchronized (array) {
                    this._data.notify();
                }
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.error((Object)("callback notify failed: " + ex));
            }
        }
    }

    void handleCallBack(SnmpPeer peer, SnmpPDU pdu) {
        this.modifyForVersion(peer, this._attrLen, pdu);
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        this.compare(peer, this._attrName, this._attr, this.buildRows(pdu.getVariables(), this.getAttributeLength(), sw));
    }

    boolean handleErrorCallBack(SnmpPeer peer, SnmpPDU pdu, boolean timedOut) {
        if (peer == null) {
            DefaultLogger._DefLogger.error((Object)("Can't find peer " + pdu.getAddress()));
            return false;
        }
        if (timedOut) {
            if (this._peers.findEquals(peer) != -1) {
                this._peers.removeElement(peer);
                this.addData(peer, false, this._attrName, "Timeout; no further checking", null);
            }
            return false;
        }
        if (pdu.getError() != 0) {
            if (this._peers.findEquals(peer) != -1) {
                this._peers.removeElement(peer);
                this.addData(peer, false, this._attrName, SnmpException.toError(pdu.getError()) + "; no further checking", null);
            }
            return false;
        }
        return true;
    }

    protected abstract void doIt(SnmpPeer var1, Array var2, String var3, CheckData var4, Array var5, String var6, Node var7) throws SnmpException;

    protected abstract Array buildRows(VarBindList var1, int var2, Switch var3);

    protected abstract void compare(SnmpPeer var1, String var2, Array var3, Array var4);

    protected String getVarName(SnmpVarBind vb, MibEnum[] enums) {
        SnmpVar theVar = vb.getVar();
        if (enums != null) {
            int value = 0;
            if (theVar instanceof SnmpInt) {
                value = ((SnmpInt)vb.getVar()).getValue();
            } else if (theVar instanceof SnmpUnsignedInt) {
                value = (int)((SnmpUnsignedInt)vb.getVar()).getValue();
            }
            return this.getMibOidName(vb) + "=" + MibEnum.getLabel(enums, value);
        }
        MibNode mbNd = MibNode.lookupOid(vb.getOid().getValue());
        if (mbNd.getTCLabel() != null && mbNd.getTCLabel().equals("InetAddress")) {
            String addVal = null;
            if (theVar.getType() == 4) {
                addVal = SnmpIpAddress.toString(((SnmpString)theVar).getValue());
            }
            return this.getMibOidName(vb) + "=" + addVal;
        }
        return this.getMibOidName(vb) + "=" + vb.getVar();
    }

    String getMibOidName(SnmpVarBind vb) {
        return MibNode.oidToName(vb.getOid().getValue());
    }

    protected boolean equals(SnmpVar v1, SnmpVar v2) {
        if (v1 == null || v2 == null) {
            return false;
        }
        if (v1.getType() != v2.getType()) {
            return false;
        }
        switch (v1.getType()) {
            case 2: {
                return ((SnmpInt)v1).getValue() == ((SnmpInt)v2).getValue();
            }
            case 4: 
            case 64: {
                return ((SnmpString)v1).equals((SnmpString)v2);
            }
            case 6: {
                return MibNode.equals(((SnmpOID)v1).getValue(), ((SnmpOID)v2).getValue()) == 0;
            }
            case 66: {
                return ((SnmpUnsignedInt)v1).getValue() == ((SnmpUnsignedInt)v2).getValue();
            }
        }
        return false;
    }

    protected void addData(SnmpPeer peer, boolean resolvable, String type, String description, ResolveData data) {
        Object[] row = new Object[6];
        row[0] = peer;
        row[2] = type;
        row[3] = description;
        row[4] = data;
        Object object = row[1] = resolvable ? Boolean.FALSE : null;
        if (resolvable && data != null && data._varBinds != null) {
            Object[] varBnds = data._varBinds;
            for (int i = 0; i < varBnds.length; ++i) {
                Array dataArray = (Array)varBnds[i];
                if (dataArray == null) continue;
                for (int k = 0; k < dataArray.size(); ++k) {
                    SnmpVarBind theVar = (SnmpVarBind)dataArray.elementAt(k);
                    if (theVar.getVar().getType() != 5) continue;
                    row[1] = null;
                }
            }
        }
        this._data.addElement(row);
    }

    public VarBindList buildRequest(String[] attrs) {
        VarBindList request = new VarBindList();
        this._enums = new MibEnum[attrs.length][];
        for (int i = 0; i < attrs.length; ++i) {
            MibNode node = MibNode.get(attrs[i]);
            this._enums[i] = node.getEnums();
            int[] oid = node.getOid();
            if (this._indexOffset == 0) {
                this._indexOffset = oid.length;
            }
            request.add(new SnmpVarBind(new SnmpOID(oid)));
        }
        return request;
    }

    protected VarBindList getRefData(String[] attrs, SnmpPeer peer) throws SnmpException {
        try {
            VarBindList request = this.buildRequest(attrs);
            VarBindList response = SnmpFetch.getBulk(peer, request).getVariables();
            return response;
        }
        catch (SnmpException ex) {
            throw new SnmpException(this._attrName + ":" + ex.getMessage());
        }
    }

    public VarBindList buildScalarRequest(String[] attrs) {
        VarBindList request = new VarBindList();
        this._enums = new MibEnum[attrs.length][];
        for (int i = 0; i < attrs.length; ++i) {
            MibNode node = MibNode.get(attrs[i]);
            this._enums[i] = node.getEnums();
            int[] oid = node.getOid();
            if (this._indexOffset == 0) {
                this._indexOffset = oid.length;
            }
            request.add(new SnmpVarBind(new SnmpOID(oid, 0)));
        }
        return request;
    }

    protected VarBindList getScalarRefData(String[] attrs, SnmpPeer peer) throws SnmpException {
        VarBindList request = this.buildScalarRequest(attrs);
        VarBindList response = SnmpFetch.get(peer, request).getVariables();
        return response;
    }

    public Array varBindLstToArray(VarBindList response) {
        Array<SnmpVarBind> res = new Array<SnmpVarBind>();
        int maxi = response.size();
        for (int i = 0; i < maxi; ++i) {
            res.addElement(response.get(i));
        }
        return res;
    }

    public void addToFile(SnmpPeer peer, String category, CheckData chkAttrs, Node elNd) throws SnmpException {
        String[] attrs = chkAttrs._attrs;
        VarBindList response = this.getRefData(attrs, peer);
        Document xmlDoc = elNd.getOwnerDocument();
        Element attName = xmlDoc.createElement(category);
        elNd.appendChild(attName);
        int MAX = response.size();
        for (int j = 0; j < MAX; ++j) {
            SnmpVarBind vb = response.getVb(j);
            int[] oid = vb.getOid().getValue();
            SnmpVar vr = vb.getVar();
            if (vr.getType() != 5) {
                MibNode node;
                boolean isPrintable;
                String varnm = MibNode.oidToName(oid);
                boolean bl = isPrintable = vr.getType() != 4;
                if (vr.getType() == 4 && (node = MibNode.oidToNode(oid)) != null && node.getTCLabel() != null) {
                    String tc = node.getTCLabel();
                    isPrintable = tc != null && (tc.equals("DisplayString") || tc.equals("SnmpAdminString"));
                }
                Element prop = xmlDoc.createElement("varbind");
                attName.appendChild(prop);
                prop.setAttribute("oid", varnm);
                prop.setAttribute("type", Integer.toString(vr.getType()));
                if (isPrintable) {
                    prop.setAttribute(_VALUE, vr.toString());
                    continue;
                }
                if (vr.getType() != 4) continue;
                byte[] stringVal = ((SnmpString)vr).getValue();
                prop.setAttribute(_VALUE, stringVal != null && stringVal.length > 0 ? SnmpString.toHexString(stringVal) : "");
                continue;
            }
            DefaultLogger._DefLogger.debug((Object)("SNMP NULL :" + MibNode.oidToName(oid) + "  TYPE:" + vr.getType()));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected VarBindList readCategoryFromPolicyFile(Node rootNd, String category) throws SnmpException {
        VarBindList response = new VarBindList();
        String refVersion = this.getSwVersionFromFile(rootNd);
        Document xmlDoc = rootNd.getOwnerDocument();
        NodeList ndLst = xmlDoc.getElementsByTagName(category);
        if (ndLst == null) {
            return response;
        }
        Node nd = ndLst.item(0);
        if (nd == null) {
            return response;
        }
        NodeList ndCh = ((Element)nd).getElementsByTagName("varbind");
        int iCh = 0;
        int MAXCH = ndCh.getLength();
        while (true) {
            block26: {
                void var18_17;
                if (iCh >= MAXCH) {
                    return response;
                }
                Element ch = (Element)ndCh.item(iCh);
                String oid = ch.getAttribute("oid");
                String strVal = ch.getAttribute(_VALUE);
                String strType = null;
                int type = -1;
                long val = -1L;
                try {
                    strType = ch.getAttribute("type");
                    type = Integer.parseInt(strType);
                    if (type == 65 || type == 70 || type == 67) {
                        val = Long.parseLong(strVal);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SnmpException("Error in File at type " + strType + ".");
                }
                Object var18_19 = null;
                switch (type) {
                    case 2: {
                        SnmpInt snmpInt = new SnmpInt(strVal);
                        break;
                    }
                    case 3: {
                        SnmpBitmap snmpBitmap = new SnmpBitmap(strVal);
                        break;
                    }
                    case 4: {
                        SnmpString snmpString = new SnmpString(strVal);
                        break;
                    }
                    case 5: {
                        break block26;
                    }
                    case 6: {
                        SnmpOID snmpOID = new SnmpOID(strVal);
                        break;
                    }
                    case 64: {
                        SnmpIpAddress snmpIpAddress = new SnmpIpAddress(strVal);
                        break;
                    }
                    case 65: {
                        SnmpCounter snmpCounter = new SnmpCounter(val);
                        break;
                    }
                    case 67: {
                        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(val);
                        break;
                    }
                    case 68: {
                        SnmpOpaque snmpOpaque = new SnmpOpaque(strVal);
                        break;
                    }
                    case 69: {
                        break block26;
                    }
                    case 70: {
                        SnmpCounter64 snmpCounter64 = new SnmpCounter64(val);
                        break;
                    }
                    case 66: {
                        SnmpUnsignedInt snmpUnsignedInt = new SnmpUnsignedInt(strVal);
                        break;
                    }
                    case -128: {
                        break block26;
                    }
                    case -127: {
                        break block26;
                    }
                    case -126: {
                        break block26;
                    }
                }
                int[] theOid = MibNode.parseName(oid);
                SnmpVarBind vbnd = this.buidPolicyFileVarBind(rootNd, theOid, (SnmpVar)var18_17);
                if (null != vbnd) {
                    response.add(vbnd);
                }
                if (refVersion.compareTo("1.2") < 0) {
                    this.addNewPolicyFileVarBind(rootNd, theOid, (SnmpVar)var18_17, response);
                }
            }
            ++iCh;
        }
    }

    String getSwVersionFromFile(Node rootNd) {
        Document xmlDoc = rootNd.getOwnerDocument();
        Node elm = xmlDoc.getFirstChild();
        return ((Element)elm).getAttribute("swver");
    }

    protected SnmpVarBind buidPolicyFileVarBind(Node rootNd, int[] oid, SnmpVar theVar) {
        return new SnmpVarBind(new SnmpOID(oid), theVar);
    }

    protected void modifyForVersion(SnmpPeer peer, int attLen, SnmpPDU response) {
    }

    protected int getAttributeLength() {
        return this._attrLen;
    }

    protected void addNewPolicyFileVarBind(Node rootNd, int[] oid, SnmpVar theVar, VarBindList response) {
    }
}

