/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fc.FabricCheckTable;
import com.cisco.dcbu.sm.client.fc.ResolveData;

class FabricCheckFspfIfTable
extends FabricCheckTable {
    long[] _intervals = new long[]{80L, 20L, 5L};
    final String[] _Vars = new String[]{"fspfIfDeadInterval", "fspfIfHelloInterval", "fspfIfRetransmitInterval"};

    FabricCheckFspfIfTable() {
    }

    @Override
    protected void compare(SnmpPeer peer, String name, Array source, Array target) {
        this.checkResponse(peer, name, target);
    }

    @Override
    protected void checkResponse(SnmpPeer peer, String name, Array rows) {
        for (int i = 0; i < rows.size(); ++i) {
            FabricCheckTable.SnmpRow sRow = (FabricCheckTable.SnmpRow)rows.elementAt(i);
            for (int j = 0; j < sRow._vars.length; ++j) {
                long interval = ((SnmpUnsignedInt)sRow._vars[j].getVar()).getValue();
                if (interval == this._intervals[j]) continue;
                StringBuffer sb = new StringBuffer();
                sb.append("Mismatch ");
                sb.append(this._Vars[j]);
                sb.append('.');
                sb.append(sRow._index[0]);
                sb.append('.');
                sb.append(ClientController.findFabricSwitchByIpAddress(peer.getAddress()).ifIndexToName(sRow._index[1]));
                sb.append('=');
                sb.append(interval);
                Array<SnmpVarBind> varbinds = new Array<SnmpVarBind>();
                ((SnmpUnsignedInt)sRow._vars[j].getVar()).setValue(this._intervals[j]);
                varbinds.addElement(sRow._vars[j]);
                this.addData(peer, true, name, sb.toString(), new ResolveData(varbinds, this._rndr));
            }
        }
    }
}

