/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.jnm.IndexCellRenderer;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fc.AbstractFabricCheck;
import com.cisco.dcbu.sm.client.fc.CheckData;
import com.cisco.dcbu.sm.client.fc.ResolveData;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.HashMap;
import org.w3c.dom.Node;

class FabricCheckTable
extends AbstractFabricCheck {
    IndexCellRenderer _rndr;
    CheckData _chkAttr;
    boolean _sepCreateVarBnd = false;
    HashMap _lastTargetIndex;

    FabricCheckTable() {
    }

    void setCreateVarBndFlag(boolean flag) {
        this._sepCreateVarBnd = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doIt(SnmpPeer peer, Array peers, String category, CheckData chkAttrs, Array data, String rowAddRm, Node rtNd) throws SnmpException {
        int i;
        VarBindList response;
        MibNode mbNd;
        String[] attrs = chkAttrs._attrs;
        this._chkAttr = chkAttrs;
        this._data = data;
        this._attrName = category;
        this._rndr = chkAttrs._rndr;
        this._peers = peers;
        if (rowAddRm != null && null != (mbNd = MibNode.get(rowAddRm))) {
            this._rowAddRm = new SnmpOID(mbNd.getOid());
        }
        VarBindList request = this.buildRequest(attrs);
        if (null == rtNd) {
            response = this.getRefData(attrs, peer);
        } else {
            response = this.readCategoryFromPolicyFile(rtNd, this._attrName);
            if (response.size() == 0) {
                return;
            }
        }
        this._attrLen = attrs.length;
        Switch sw = null;
        if (null == rtNd) {
            ClientController.getInstance();
            sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        }
        this._attr = this.buildRows(response, this.getAttributeLength(), sw);
        this.checkResponse(peer, this._attrName, this._attr);
        this._numReqs = peers.size();
        SnmpPeer[] p = new SnmpPeer[this._numReqs];
        for (i = 0; i < p.length; ++i) {
            p[i] = (SnmpPeer)peers.elementAt(i);
        }
        for (i = 0; i < p.length; ++i) {
            new SnmpFetch().getBulk(p[i], request, (SnmpCallbackIf)this);
        }
        try {
            Array i2 = this._data;
            synchronized (i2) {
                this._data.wait(12000L);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected void checkResponse(SnmpPeer peer, String name, Array rows) {
    }

    @Override
    protected Array buildRows(VarBindList response, int numCols, Switch sw) {
        Array<SnmpRow> rows = new Array<SnmpRow>();
        int j = 0;
        while (j < response.size()) {
            SnmpVarBind vb = response.getVb(j);
            int[] oid = vb.getOid().getValue();
            int[] index = new int[oid.length - this._indexOffset];
            System.arraycopy(oid, this._indexOffset, index, 0, index.length);
            SnmpRow row = new SnmpRow(index, new SnmpVarBind[numCols], sw);
            for (int i = 0; i < numCols; ++i) {
                row._vars[i] = response.getVb(j++);
            }
            rows.addElement(row);
        }
        return rows;
    }

    protected boolean ignoreRow(int[] index) {
        return false;
    }

    public HashMap buildLastIndex(Array target) {
        return new HashMap();
    }

    public int[] getNewIndex(HashMap hm, SnmpRow sRow) {
        return sRow._index;
    }

    @Override
    protected void compare(SnmpPeer peer, String name, Array source, Array target) {
        StringBuffer missing = new StringBuffer();
        boolean resolvable = this._rowAddRm != null;
        this._lastTargetIndex = this.buildLastIndex(target);
        Array varbinds = new Array();
        for (int i = 0; i < source.size(); ++i) {
            SnmpRow sRow = (SnmpRow)source.elementAt(i);
            int targetIndex = this.findRow(sRow, target);
            if (targetIndex == -1) {
                this.checkMissing(peer, name, varbinds, missing, sRow);
                continue;
            }
            this.checkMismatch(peer, name, sRow, target, targetIndex);
        }
        if (missing.toString().length() > 0) {
            this.addData(peer, resolvable, name, missing.toString(), new ResolveData(varbinds, this._rndr));
        }
        if (this._checkExtra) {
            this.checkExtra(peer, name, target);
        }
    }

    private void buildExtraMsg(StringBuffer extra, SnmpRow tRow, String name) {
        this.buildExtraOrMissingMsg(extra, true, tRow, name);
    }

    private void buildMissingMsg(StringBuffer missing, SnmpRow sRow, String name) {
        this.buildExtraOrMissingMsg(missing, false, sRow, name);
    }

    private void buildExtraOrMissingMsg(StringBuffer buffer, boolean isExtra, SnmpRow row, String name) {
        if (buffer.toString().length() == 0) {
            if (isExtra) {
                buffer.append("Extra ");
            } else {
                buffer.append("Missing ");
            }
            buffer.append(name);
            buffer.append("(s):");
        } else if (buffer.toString().charAt(buffer.toString().length() - 1) != ':') {
            buffer.append(", ");
        }
        this.appendSnmpRow(buffer, row);
    }

    void appendSnmpRow(StringBuffer buffer, SnmpRow sRow) {
        if (null != this._rndr) {
            if (sRow._switch != null) {
                buffer.append(this._rndr.getMixSwitchLabel(sRow._index, sRow._switch));
            } else {
                buffer.append(this._rndr.getLabel(sRow._index));
            }
        } else {
            buffer.append(this.getIndex(sRow._index));
        }
    }

    protected void checkMissing(SnmpPeer peer, String name, Array varbinds, StringBuffer missing, SnmpRow sRow) {
        boolean resolvable;
        boolean bl = resolvable = this._rowAddRm != null;
        if (!this._checkMissing) {
            return;
        }
        if (this._sepCreateVarBnd) {
            varbinds = new Array<SnmpVarBind>();
            missing = new StringBuffer("Missing ");
            missing.append(name);
            missing.append("(s):");
        }
        this.buildMissingMsg(missing, sRow, name);
        if (this._rowAddRm != null) {
            int[] theIndex = this.getNewIndex(this._lastTargetIndex, sRow);
            varbinds.addElement(new SnmpVarBind(new SnmpOID(this._rowAddRm.getValue(), theIndex), new SnmpInt(4)));
            int MAXVR = sRow._vars.length;
            for (int vr = 0; vr < MAXVR; ++vr) {
                varbinds.addElement(new SnmpVarBind(new SnmpOID(MibNode.get(this._chkAttr._attrs[vr]).getOid(), theIndex), sRow._vars[vr].getVar()));
            }
        }
        if (this._sepCreateVarBnd) {
            this.addData(peer, resolvable, name, missing.toString(), new ResolveData(varbinds, this._rndr));
        }
    }

    protected void checkMismatch(SnmpPeer peer, String name, SnmpRow sRow, Array target, int targetIndex) {
        if (this._checkMismatch) {
            SnmpRow tRow = (SnmpRow)target.elementAt(targetIndex);
            for (int j = 0; j < sRow._vars.length; ++j) {
                if (this.equals(sRow._vars[j].getVar(), tRow._vars[j].getVar())) continue;
                Array<SnmpVarBind> varbind = new Array<SnmpVarBind>();
                varbind.addElement(sRow._vars[j]);
                this.addData(peer, true, name, this.buildMismatchmessage(tRow, j), new ResolveData(varbind, this._rndr));
            }
        }
        target.removeElementAt(targetIndex);
    }

    String buildMismatchmessage(SnmpRow row, int index) {
        return "Mismatch " + this.getVarName(row._vars[index], this._enums[index]);
    }

    protected void checkExtra(SnmpPeer peer, String name, Array target) {
        Array<SnmpVarBind> varbinds = new Array<SnmpVarBind>();
        boolean resolvable = false;
        StringBuffer extra = new StringBuffer();
        int MAX = target.size();
        for (int i = 0; i < MAX; ++i) {
            SnmpRow tRow = (SnmpRow)target.elementAt(i);
            this.buildExtraMsg(extra, tRow, name);
            if (null == this._rowAddRm) continue;
            varbinds.addElement(new SnmpVarBind(new SnmpOID(this._rowAddRm.getValue(), tRow._index), new SnmpInt(6)));
            resolvable = true;
        }
        if (extra.length() > 0) {
            this.addData(peer, resolvable, name, extra.toString(), new ResolveData(varbinds, this._rndr));
        }
    }

    protected String getIndex(int[] index) {
        return SnmpOID.toString(index);
    }

    protected int findRow(SnmpRow sRow, Array target) {
        int[] index = sRow._index;
        int hi = target.size();
        int lo = 0;
        while (hi > lo) {
            int mid = (hi - lo) / 2 + lo;
            SnmpRow row = (SnmpRow)target.elementAt(mid);
            int comparison = this.compare(index, row._index);
            if (comparison == 0) {
                return mid;
            }
            if (comparison < 0) {
                hi = mid;
                continue;
            }
            lo = mid + 1;
        }
        return -1;
    }

    final int compare(int[] first, int[] second) {
        for (int i = 0; i < first.length && i < second.length; ++i) {
            if (first[i] < second[i]) {
                return -1;
            }
            if (first[i] <= second[i]) continue;
            return 1;
        }
        return 0;
    }

    final class SnmpRow {
        int[] _index;
        SnmpVarBind[] _vars;
        Switch _switch;

        public SnmpRow(int[] idx, SnmpVarBind[] vb, Switch sw) {
            this._index = idx;
            this._vars = vb;
            this._switch = sw;
        }
    }
}

