/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fc;

import com.cisco.dcbu.lib.jnm.IndexCellRenderer;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fc.CheckThread;
import com.cisco.dcbu.sm.client.fc.FCTable;
import com.cisco.dcbu.sm.client.fc.MessageDialog;
import com.cisco.dcbu.sm.client.fc.OptionDialog;
import com.cisco.dcbu.sm.client.fc.OptionsTableModel;
import com.cisco.dcbu.sm.client.fc.ResolveData;
import com.cisco.dcbu.sm.client.fc.ResolveThread;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FabricChecker
extends JDialog
implements ActionListener,
TableModelListener,
ItemListener {
    static final int SWITCH_COL = 1;
    static final int SEL_COL = 1;
    static final int CATEGORY_COL = 2;
    static final int INFO_COL = 3;
    static final int RESOLVE_COL = 4;
    static final String[] _ColLabels = new String[]{"Switch", "Resolve", "Feature", "Description", ""};
    static final boolean[] _Editable = new boolean[]{false, true, false, false, false};
    static final String[] _Labels = new String[]{"Compare Against:", null, null};
    static final String[] _Comparison = new String[]{"Policy Switch", "Policy File"};
    static final String[] _BLabels = new String[]{"Compare", "Resolve Issues", "Clear", "Close"};
    static final String[] _BtnLabels = new String[]{"Rules...", "Create Policy..."};
    static final String _Space = " ";
    static final int MISMATCH = 0;
    static final int MISSING = 1;
    static final int EXTRA = 2;
    static final Object[][] _Options = new Object[][]{{"Version", Boolean.TRUE, null, null, null}, {"VSAN", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"IPFC", Boolean.TRUE, null, null, null}, {"ISL", Boolean.TRUE, null, null, null}, {"FCIP", Boolean.TRUE, null, null, null}, {"FSPF", Boolean.TRUE, null, null, null}, {"Port_Channels", Boolean.TRUE, null, null, null}, {"Domain_Manager", Boolean.TRUE, null, null, null}, {"Zone_Policies", Boolean.TRUE, null, null, null}, {"NameServer_Proxy", Boolean.TRUE, null, null, null}, {"Timers_Policies", Boolean.TRUE, null, null, null}, {"VRRP", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"CallHome", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"Syslog", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"AAA", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"Snmp_User", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"Snmp_Events", Boolean.TRUE, null, null, null}, {"Autolearn Port_Security", Boolean.TRUE, null, null, null}, {"NTP_Server", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"IP_Filter", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"Feature", Boolean.TRUE, null, null, null}};
    Array _optionsData;
    JComponent[] _values;
    JButton[] _buttons;
    JComboBox _sourceCb;
    FieldPanel _policyFile;
    JScrollPane _sp;
    FCTable _table;
    KTableModel _model;
    Array _data;
    SnmpPeer[] _peers;
    JLabel _status;
    CheckThread _checkThread;
    JRadioButton[] _comparison;
    JButton[] _optionBtn = new JButton[_BtnLabels.length];

    public FabricChecker(JFrame parent, SnmpPeer[] peers) {
        super(parent);
        this.setTitle("Fabric Configuration Analysis" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this._peers = peers;
        this._optionsData = new Array();
        for (int i = 0; i < _Options.length; ++i) {
            this._optionsData.addElement(_Options[i]);
        }
        this._values = new JComponent[_Labels.length];
        this._comparison = new JRadioButton[_Comparison.length];
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < this._comparison.length; ++i) {
            this._comparison[i] = new JRadioButton(_Comparison[i], i == 0);
            this._comparison[i].addItemListener(this);
            bg.add(this._comparison[i]);
        }
        JComponent[] comValues = new JComponent[_Comparison.length];
        comValues[0] = this._sourceCb = new JComboBox();
        this.updatePeers(peers);
        JButton browse = new JButton("...");
        browse.addActionListener(this);
        browse.setMargin(DialogUtil.getInsets());
        this._policyFile = new FieldPanel(26, (JComponent)browse);
        comValues[1] = this._policyFile;
        this._policyFile.setEnabled(false);
        this._values[0] = DialogUtil.buildPanel(this._comparison, comValues);
        this._values[0].setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        DialogUtil.constrain(this._values[0], this._comparison[0], gbc, 0, 1, 0, 17);
        DialogUtil.constrain(this._values[0], this._comparison[1], gbc, 0, 2, 0, 17);
        JPanel p1 = new JPanel(new FlowLayout(2));
        for (int i = 0; i < _BtnLabels.length; ++i) {
            this._optionBtn[i] = new JButton(_BtnLabels[i]);
            this._optionBtn[i].addActionListener(this);
            p1.add(this._optionBtn[i]);
        }
        this._optionBtn[1].setEnabled(false);
        this._values[1] = p1;
        this._values[2] = new DialogSeparator("Inconsistencies");
        JPanel fields = DialogUtil.buildPanel(DialogUtil.buildLabels(_Labels), this._values);
        DialogUtil.constrain(fields, p1, gbc, 1, 2, 0, 13);
        JPanel p = new JPanel(new BorderLayout());
        p.add("North", fields);
        this._data = new Array();
        this._model = new OptionsTableModel();
        this._model.setData(this._data);
        this._model.setHeaders(_ColLabels);
        this._model.setEditable(_Editable);
        this._table = new FCTable(this._model, this);
        this._table.removeColumn(this._table.getColumnModel().getColumn(4));
        this._table.getTableHeader().addMouseListener(new HeaderListener());
        this._table.setSortable(true);
        this._sp = new JScrollPane(this._table);
        this._table.setAutoResizeMode(0);
        this._model.addTableModelListener(this);
        this._sp.setPreferredSize(new Dimension(500, 300));
        p.add("Center", this._sp);
        this._buttons = DialogUtil.buildButtons(_BLabels, (ActionListener)this);
        this._buttons[1].setEnabled(false);
        this.getRootPane().setDefaultButton(this._buttons[0]);
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < this._buttons.length; ++i) {
            buttonPanel.add(this._buttons[i]);
        }
        southPanel.add("North", buttonPanel);
        this._status = new JLabel(_Space);
        this._status.setFont((Font)UIManager.getDefaults().get("Table.font"));
        this._status.setBorder(null);
        southPanel.add("South", this._status);
        this.getRootPane().setDefaultButton(this._buttons[0]);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)p, southPanel);
        this.setResizable(true);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this._buttons[1].setEnabled(this._model.isChanged());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        String str = ((JToggleButton)e.getSource()).getText();
        boolean switchPolicy = str.indexOf("Switch") != -1;
        this._sourceCb.setEnabled(switchPolicy);
        this._policyFile.setEnabled(!switchPolicy);
        if (this._policyFile.isEnabled()) {
            this._policyFile.setText(this._sourceCb.getSelectedItem() + "._pcy.xml");
        }
        this._optionBtn[1].setEnabled(!switchPolicy);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block17: {
            String cmd = ((AbstractButton)e.getSource()).getText();
            try {
                switch (cmd.charAt(0)) {
                    case 'S': {
                        this._checkThread.cancel();
                        break;
                    }
                    case 'R': {
                        if (cmd.charAt(1) == 'u') {
                            OptionDialog od = new OptionDialog(this, this._optionsData);
                            od.setVisible(true);
                            break;
                        }
                        int nOption = JOptionPane.showConfirmDialog(this, "Would you like to see the proposed resolutions before proceeding?", this.getTitle(), 1);
                        if (nOption == 0 ? !this.checkDetailedResolution() : nOption != 1) break;
                        ResolveThread rsThread = new ResolveThread(this, this._table);
                        this._buttons[1].setEnabled(false);
                        rsThread.start();
                        this._buttons[0].setText("Stop");
                        break;
                    }
                    case 'C': {
                        if (cmd.charAt(1) == 'o') {
                            if (!this.compareAction()) {
                                break;
                            }
                        } else if (cmd.charAt(1) == 'l') {
                            if (cmd.charAt(2) == 'o') {
                                this.setVisible(false);
                            } else if (cmd.charAt(2) == 'e') {
                                this._data.clear();
                                this._model.fireTableDataChanged();
                            }
                        } else {
                            this.creatPolicyAction();
                        }
                        return;
                    }
                    case '.': {
                        String fName = Util.getFileName((JFrame)this.getParent(), "Open Policy - DCNM-SAN", "*_pcy.xml", 0, null, true);
                        if (fName == null) break;
                        this._policyFile.setText(fName);
                    }
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                if (!SnmpSession.isTrace()) break block17;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    boolean checkDetailedResolution() {
        Array<CharSequence> message = new Array<CharSequence>();
        Object[] theMsg = null;
        int MAX = this._table.getRowCount();
        for (int row = 0; row < MAX; ++row) {
            Object obRslv;
            Boolean bVal;
            Object val = this._model.getValueAt(row, 1);
            Object name = this._model.getValueAt(row, 2);
            String info = (String)this._model.getValueAt(row, 3);
            if (val != null && (bVal = (Boolean)val).booleanValue() && null != (obRslv = this._model.getValueAt(row, 4))) {
                Array obmsg = ((ResolveData)obRslv)._message;
                Object[] varBnds = ((ResolveData)obRslv)._varBinds;
                if (null == varBnds) continue;
                int MAXVARBNDS = varBnds.length;
                for (int vbnds = 0; vbnds < MAXVARBNDS; ++vbnds) {
                    Array data = (Array)varBnds[vbnds];
                    if (null == obmsg) {
                        SnmpPeer peer = (SnmpPeer)this._model.getValueAt(row, 0);
                        IndexCellRenderer obRndr = ((ResolveData)obRslv)._rndr;
                        message.addElement(peer + ":");
                        int initialVal = 0;
                        char chInfo = info.charAt(3);
                        int VARMAX = data.size();
                        for (int i = initialVal; i < VARMAX; ++i) {
                            SnmpVarBind theVar = (SnmpVarBind)data.elementAt(i);
                            MibNode mibNd = MibNode.oidToNode(theVar.getOid().getValue());
                            MibNode.IndexVar theDat = MibNode.oidToNameAndIndex(theVar.getOid().getValue());
                            String strTClable = mibNd.getTCLabel();
                            StringBuffer msgBuf = new StringBuffer();
                            boolean bRowStatus = false;
                            if (null != strTClable) {
                                bRowStatus = strTClable.equalsIgnoreCase("RowStatus");
                            }
                            if (bRowStatus) {
                                int rowStatus = ((SnmpInt)theVar.getVar()).getValue();
                                switch (rowStatus) {
                                    case 4: {
                                        msgBuf.append("Create new ");
                                        msgBuf.append(name);
                                        msgBuf.append(_Space);
                                        break;
                                    }
                                    case 6: {
                                        msgBuf.append("Delete ");
                                        msgBuf.append(name);
                                        msgBuf.append(_Space);
                                    }
                                }
                                if (null != obRndr) {
                                    msgBuf.append(obRndr.getLabel(theDat._index));
                                } else {
                                    msgBuf.append(theDat.indexToString());
                                }
                            } else {
                                msgBuf.append("\tset ");
                            }
                            if (!bRowStatus) {
                                msgBuf.append(theDat._var + _Space);
                            }
                            if (chInfo == 'm') {
                                if (null != obRndr) {
                                    msgBuf.append(obRndr.getLabel(theDat._index));
                                } else {
                                    msgBuf.append(theDat.indexToString());
                                }
                            }
                            if (!bRowStatus) {
                                msgBuf.append("  to  ");
                                MibEnum[] mibEnm = mibNd.getEnums();
                                if (null != mibEnm) {
                                    try {
                                        msgBuf.append(MibEnum.getLabel(mibNd.getEnums(), Integer.parseInt(theVar.getVar().toString())));
                                    }
                                    catch (NumberFormatException ex) {}
                                } else {
                                    msgBuf.append(theVar.getVar());
                                }
                            }
                            message.addElement(msgBuf);
                        }
                        continue;
                    }
                    message.append(obmsg);
                }
            }
            theMsg = new Object[message.size()];
            int MMAX = message.size();
            for (int im = 0; im < MMAX; ++im) {
                theMsg[im] = message.elementAt(im);
            }
        }
        MessageDialog msgDlg = new MessageDialog(this, theMsg, "Fabric Checker Resolution Details" + ClientController.getInstance().getDialogTitlePostfix());
        msgDlg.setVisible(true);
        return msgDlg._chAction == 'O';
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean compareAction() throws Exception {
        this._data.clear();
        this._model.fireTableDataChanged();
        this._buttons[1].setEnabled(false);
        if (this._comparison[1].isSelected()) {
            String strPolicy = this._policyFile.getText();
            if (null != strPolicy && strPolicy.length() > 0) {
                try {
                    FileInputStream pout = new FileInputStream(strPolicy);
                    this._buttons[1].setEnabled(false);
                    this._checkThread = new CheckThread(this, (SnmpPeer)this._sourceCb.getSelectedItem(), this._data, this._optionsData, pout);
                }
                catch (IOException exx) {
                    throw new Exception("Failed to open file " + strPolicy + ".");
                }
            } else {
                Util.errorMessage((Component)this, "Please enter a policy file name.");
                return false;
            }
        }
        if (this._peers.length == 1) {
            Util.errorMessage((Component)this, "Fabric checker cannot be run on one switch.");
            return false;
        }
        SnmpPeer source = (SnmpPeer)this._sourceCb.getSelectedItem();
        ClientController.getInstance();
        Switch swSource = ClientController.findFabricSwitchByIpAddress(source.getAddress());
        if (swSource == null || !swSource.isManageable()) {
            Util.errorMessage((Component)this, "The switch " + source + " is not manageable.");
            return false;
        }
        this._checkThread = new CheckThread(this, source, this._data, this._optionsData, null);
        this._checkThread.start();
        this._buttons[0].setText("Stop");
        return true;
    }

    void creatPolicyAction() throws Exception {
        if (JOptionPane.showConfirmDialog(this, "Automatically create policy from selected switch [" + this._sourceCb.getSelectedItem() + "]?", this.getTitle(), 0) == 0) {
            this._data.clear();
            String strPolicy = this._policyFile.getText();
            if (null != strPolicy && strPolicy.length() > 0) {
                try {
                    PrintStream pout = new PrintStream(new FileOutputStream(strPolicy));
                    this._buttons[1].setEnabled(false);
                    this._checkThread = new CheckThread(this, (SnmpPeer)this._sourceCb.getSelectedItem(), null, this._optionsData, pout);
                    this._checkThread.start();
                    this._buttons[0].setText("Stop");
                }
                catch (IOException exx) {
                    throw new Exception("Failed to open file " + strPolicy + ".");
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please enter a policy file name.");
            }
        }
    }

    public void updatePeers(SnmpPeer[] peers) {
        ArrayList<SnmpPeer> manageablePeers = new ArrayList<SnmpPeer>();
        if (peers != null) {
            for (int i = 0; i < peers.length; ++i) {
                ClientController.getInstance();
                Switch sw = ClientController.findFabricSwitchByIpAddress(peers[i].getAddress());
                if (sw == null || !sw.isManageable()) continue;
                manageablePeers.add(peers[i]);
            }
        }
        if (manageablePeers.size() > 0) {
            this._sourceCb.setModel(new DefaultComboBoxModel<Object>(manageablePeers.toArray()));
            Switch seedSw = ClientController.getInstance().getFabric().getSeedSwitch();
            if (seedSw != null && seedSw.getSnmpPeer() != null) {
                this._sourceCb.setSelectedItem(seedSw.getSnmpPeer());
            }
        }
    }
}

