/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcip;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.sm.client.model.Switch;

public class EtherPort {
    int _index;
    byte[] _address = null;
    int _mask = 0;
    int _operStatus = 0;
    int _adminStatus = 0;
    int[] _pchnlMems = null;
    MibEnum[] _enum = MibNode.get("ifOperStatus").getEnums();
    Switch _sw;

    public String getIfName() {
        return this._sw != null ? this._sw.ifIndexToName(this._index) : IfIndexUtil.ifIndexToName(this._index);
    }

    public int getIfIndex(String ifName) {
        return this._sw != null ? this._sw.nameToIfIndex(ifName) : IfIndexUtil.name2IfIndex(ifName);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getIfName());
        if (this._operStatus != 1) {
            buf.append(", (");
            if (this._operStatus != this._adminStatus) {
                buf.append("failed");
            } else {
                buf.append(MibEnum.getLabel(this._enum, this._operStatus));
            }
            buf.append(")");
        }
        if (null != this._address) {
            buf.append(", ");
            buf.append(SnmpIpAddress.toString(this._address));
            buf.append('/');
            buf.append(this._mask);
        }
        return buf.toString();
    }

    public EtherPort(Switch sw) {
        this._sw = sw;
    }

    public EtherPort(EtherPort prt) {
        this._index = prt._index;
        this._mask = prt._mask;
        this._sw = prt._sw;
        if (prt._address == null) {
            this._address = null;
        } else {
            this._address = new byte[prt._address.length];
            for (byte this._address[i] : prt._address) {
            }
        }
    }

    public static void copy(EtherPort prt, EtherPort dst) {
        dst._index = prt._index;
        dst._mask = prt._mask;
        dst._sw = prt._sw;
        if (prt._address == null) {
            dst._address = null;
        } else {
            dst._address = new byte[prt._address.length];
            for (byte dst._address[i] : prt._address) {
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EtherPort)) {
            return false;
        }
        EtherPort prt = (EtherPort)obj;
        if (this._index != prt._index || this._mask != prt._mask) {
            return false;
        }
        if (this._address == null && prt._address == null) {
            return true;
        }
        if (this._address.length != prt._address.length) {
            return false;
        }
        int MAXI = prt._address.length;
        for (int i = 0; i < MAXI; ++i) {
            if (this._address[i] == prt._address[i]) continue;
            return false;
        }
        return true;
    }
}

