/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcip;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.VshDump;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FeatureEnabler;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.mds.ficon.FiconPortAddrList;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.SortModel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fcip.EtherPort;
import com.cisco.dcbu.sm.client.fcip.FcipWizard;
import com.cisco.dcbu.sm.client.fcip.IpSecurityController;
import com.cisco.dcbu.sm.client.fcip.SwitchInfo;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class FcipPropPanel
extends WizardPanel
implements ItemListener,
StatusIf,
ActionListener {
    static final String PORT_VSAN = "Port VSAN:";
    static final String VSAN_LIST = "VSAN List:";
    static String[] _LABELS = new String[]{null, "FICON Port Address", null, "FICON Port Address", null, "Port VSAN:", "Trunk Mode:", "FICON Tape Acceleration:", null};
    static final int BASE_TCP_PORT = 3225;
    static final int SW1_DLGSEP = 0;
    static final int SW1_FICON_PORT = 1;
    static final int SW2_DLGSEP = 2;
    static final int SW2_FICON_PORT = 3;
    static final int PC_DLGSEP = 4;
    static final int PC_VSAN = 5;
    static final int PC_TRUNK = 6;
    static final int FICON_TAPE_ACCELERATION = 7;
    static final int FICON_TAPE_ACCELERATION_NOTE = 8;
    static final SnmpOID _FCIP_PROF_ADD_OID = new SnmpOID(MibNode.get("cfmFcipEntityAddress").getOid());
    static final SnmpOID _FCIP_PROF_TCPPORT_OID = new SnmpOID(MibNode.get("cfmFcipEntityTcpConnPort").getOid());
    static final SnmpOID _FCIP_REMPROF_ID_OID = new SnmpOID(MibNode.get("cfmFcipLinkRemFcipEntityId").getOid());
    static final SnmpOID _FCIP_REMPROF_ADD_OID = new SnmpOID(MibNode.get("cfmFcipLinkRemFcipEntityAddress").getOid());
    static final SnmpOID _FCIP_REMPROF_TCPPORT_OID = new SnmpOID(MibNode.get("cfmFcipLinkExtTcpRemPort").getOid());
    static final String Description = "Please supply following parameters to create a FCIP tunnel. Specify Port VSAN for nontrunk/auto and allowed VSAN list for Trunk tunnel.\nNOTE: the FCIP link may take time to appear in map.";
    private boolean _panelCreated;
    private JComponent[] _fields;
    private RadioButtonPanel _select;
    private JCheckBox _ficonTapeAcceleration;
    private JLabel ficonTapeNote;
    static final String[] _Selector = FcipPropPanel.getTrunkModes();
    static MibEnum[] _trnkEnum;
    private String mibNodeMaxBdWidth = "cfmFcipEntityExtTcpMaxBW";
    private String mibNodeMinBdWidth = "cfmFcipEntityExtTcpMinAvailBW";
    private SnmpPeer _sw1;
    private SnmpPeer _sw2;
    private EtherPort[] _etherPorts;
    private Array _profiles1 = new Array();
    private Array _profiles2 = new Array();
    private Array _tunnels1 = new Array();
    private Array _tunnels2 = new Array();
    private JComponent[] _Labels;
    private JLabel _ficon1Label = new JLabel("e.g. 0xA1, 0xE9");
    private JLabel _ficon2Label = new JLabel("e.g. 0xA1, 0xE9");
    private JButton _ficonMore1;
    private JButton _ficonMore2;
    private FieldPanel _ficonVsanList;
    private JLabel _ficonVsanListLabel;
    private JButton _profile1Btn;
    private JButton _profile2Btn;
    private int _selProfileId1;
    private int _selTnlId1;
    private int _selProfileId2;
    private int _selTnlId2;
    private DialogSeparator _dlgSep1;
    private DialogSeparator _dlgSep2;
    private FinishActionData _finishData;
    public static final String _Fcip_Wiz_Sig = "FCIP";

    static String[] getTrunkModes() {
        MibNode trnkNode = MibNode.get("fcIfAdminTrunkMode");
        _trnkEnum = trnkNode.getEnums();
        String[] trunkModes = new String[_trnkEnum.length];
        int MAXI = _trnkEnum.length;
        for (int i = 0; i < MAXI; ++i) {
            trunkModes[i] = _trnkEnum[i].getLabel();
        }
        return trunkModes;
    }

    private FcipPropPanel() {
        this((JWizard)null);
    }

    public FcipPropPanel(JWizard wizard) {
        super("5 of 5: Create FCIP ISL", Description, wizard, FcipWizard._ImageFcip);
        this._Labels = DialogUtil.buildLabels(_LABELS);
        this._fields = new JComponent[this._Labels.length];
        JButton[] btns = DialogUtil.buildButtons(new String[]{"...", "..."}, (ActionListener)this);
        this._ficonMore1 = btns[0];
        this._ficonMore2 = btns[1];
        this._ficonMore1.setToolTipText("Show First Available FICON Port");
        this._ficonMore2.setToolTipText("Show First Available FICON Port");
        this._ficonMore1.setPreferredSize(new Dimension(15, 20));
        this._ficonMore2.setPreferredSize(new Dimension(15, 20));
        JPanel pnl1 = new JPanel(new FlowLayout());
        pnl1.add(this._ficonMore1);
        pnl1.add(this._ficon1Label);
        JPanel pnl2 = new JPanel(new FlowLayout());
        pnl2.add(this._ficonMore2);
        pnl2.add(this._ficon2Label);
        this._fields[1] = new FieldPanel(10, (JComponent)pnl1);
        this._fields[3] = new FieldPanel(10, (JComponent)pnl2);
        this._fields[4] = new DialogSeparator("Attributes");
        this._fields[5] = new FieldPanel(15, 1, 1, 4093);
        this._select = new RadioButtonPanel(_Selector);
        this._fields[6] = this._select;
        this._ficonTapeAcceleration = new JCheckBox();
        this._select.addChangeListener(this);
        this._ficonTapeAcceleration.addActionListener(this);
        this._ficonVsanList = new FieldPanel(10);
        JPanel pnlFicon = new JPanel(new BorderLayout());
        pnlFicon.add((Component)this._ficonTapeAcceleration, "West");
        this._ficonVsanListLabel = new JLabel("VSAN List: ");
        pnlFicon.add((Component)DialogUtil.buildPanel(new JComponent[]{this._ficonVsanListLabel}, new JComponent[]{this._ficonVsanList}), "Center");
        this._fields[7] = pnlFicon;
        this.ficonTapeNote = DialogUtil.buildLabels(new String[]{"(FTA is available when XRC is disabled in IP Properties panel)"})[0];
        this._fields[8] = this.ficonTapeNote;
        this._ficonVsanList.setEnabled(this._ficonTapeAcceleration.isSelected());
        this._ficonVsanListLabel.setEnabled(this._ficonTapeAcceleration.isSelected());
    }

    private void buildPanel(JPanel panel, JComponent[] labels, JComponent[] value) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = DialogUtil._Insets;
        gbc.gridwidth = 1;
        for (int i = 0; i < labels.length; ++i) {
            gbc.gridy = i + 1;
            if (labels[i] != null) {
                gbc.anchor = 13;
                gbc.gridx = 0;
                panel.add((Component)labels[i], gbc);
            }
            if (value[i] == null) continue;
            gbc.anchor = 17;
            gbc.gridx = i == 2 || i == 0 ? 0 : 1;
            gbc.weightx = 1.0;
            DialogUtil.extend(gbc, panel, value[i]);
        }
    }

    @Override
    public boolean refresh() {
        try {
            SwitchInfo sw1Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_A");
            SwitchInfo sw2Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_B");
            Boolean ficon = (Boolean)this.getModelValue("FICON_ENABLED");
            boolean ficonenabled = ficon != null && ficon != false;
            this._fields[1].setVisible(ficonenabled);
            this._fields[3].setVisible(ficonenabled);
            this._Labels[1].setVisible(ficonenabled);
            this._Labels[3].setVisible(ficonenabled);
            Integer xrcInt = (Integer)this.getModelValue("XRC");
            boolean xrcEnabled = xrcInt != null && xrcInt == 1;
            boolean showFiconAcceleration = ficonenabled && sw1Info._version != null && sw1Info._version.toString().compareTo("3.1(1)") >= 0 && sw2Info._version != null && sw2Info._version.toString().compareTo("3.1(1)") >= 0;
            this._ficonTapeAcceleration.setVisible(showFiconAcceleration);
            this._Labels[7].setVisible(showFiconAcceleration);
            this._ficonTapeAcceleration.setEnabled(this._select.getSelected() != 2 && !xrcEnabled);
            this._Labels[7].setEnabled(this._select.getSelected() != 2 && !xrcEnabled);
            this._ficonTapeAcceleration.setSelected(false);
            this._ficonVsanList.setVisible(showFiconAcceleration);
            this._ficonVsanListLabel.setVisible(showFiconAcceleration);
            this._sw1 = (SnmpPeer)this.getModelValue("PEER_A");
            this._sw2 = (SnmpPeer)this.getModelValue("PEER_B");
            this._etherPorts = (EtherPort[])this.getModelValue("ETHER_PORTS");
            if (ficonenabled) {
                Switch sw1 = ClientController.findFabricSwitchByIpAddress(this._sw1.getAddress());
                Switch sw2 = ClientController.findFabricSwitchByIpAddress(this._sw2.getAddress());
                this._ficon1Label.setText("0x" + new FiconPortAddrList(((SwitchBase)sw1.getBaseModelObject()).getFiconPortRange()).toString());
                this._ficon2Label.setText("0x" + new FiconPortAddrList(((SwitchBase)sw2.getBaseModelObject()).getFiconPortRange()).toString());
            }
            this.getProfileTnlInfo(this._sw1, this._profiles1, this._tunnels1);
            new TunnelSortModel(this._tunnels1).sort();
            this.getProfileTnlInfo(this._sw2, this._profiles2, this._tunnels2);
            new TunnelSortModel(this._tunnels2).sort();
            this._selTnlId1 = this._selTnlId2 = this.getUniqueIndex(this._tunnels1, this._tunnels2, true);
            if (this._selTnlId1 < 0) {
                Util.errorMessage((Component)this.getWizard(), "No unique tunnel number is available between switches " + this._sw1 + " and " + this._sw2 + ".");
            }
            IpSecurityController cont = (IpSecurityController)this.getModelValue("SECURITY_CONTROLLER");
            this._selProfileId1 = this._selProfileId2 = this.getUniqueIndex(this._profiles1, this._profiles2, false);
            this._dlgSep1 = new DialogSeparator("");
            this.setDialogSepText(this._dlgSep1, cont, this._sw1, this._selTnlId1 + 1, 0, this._selProfileId1);
            this._dlgSep2 = new DialogSeparator("");
            this.setDialogSepText(this._dlgSep2, cont, this._sw2, this._selTnlId2 + 1, 1, this._selProfileId2);
            if (!this._panelCreated) {
                JPanel pnl1 = new JPanel(new BorderLayout());
                pnl1.add((Component)this._dlgSep1, "Center");
                this._profile1Btn = new JButton("...");
                this._profile1Btn.setMargin(Util.getNoBorder());
                this._profile1Btn.setActionCommand("p1");
                this._profile1Btn.addActionListener(this);
                this._profile1Btn.setToolTipText("Select Profile/Tunnel ID");
                pnl1.add((Component)this._profile1Btn, "East");
                this._fields[0] = pnl1;
                JPanel pnl2 = new JPanel(new BorderLayout());
                pnl2.add((Component)this._dlgSep2, "Center");
                this._profile2Btn = new JButton("...");
                this._profile2Btn.setMargin(Util.getNoBorder());
                this._profile2Btn.setActionCommand("p1");
                this._profile2Btn.addActionListener(this);
                this._profile2Btn.setToolTipText("Select Profile/Tunnel ID");
                pnl2.add((Component)this._profile2Btn, "East");
                this._fields[2] = pnl2;
                JPanel p = new JPanel(new GridBagLayout());
                this.buildPanel(p, this._Labels, this._fields);
                this.add((Component)p, "Center");
                this._panelCreated = true;
            }
            this.setSecurityDescription();
            return true;
        }
        catch (SnmpException ex) {
            this.doPrevious();
            Util.errorMessage((Component)this, ex);
            return false;
        }
    }

    private void setDialogSepText(DialogSeparator sep, IpSecurityController cont, SnmpPeer sw, int selTnlId, int ethr, int selProfileId) {
        sep.setLabel("Between Switch " + sw + " (fcip" + selTnlId + " over " + this._etherPorts[ethr].getIfName() + ", Profile ID:" + selProfileId + " " + (cont != null && cont.isSecure(sw, this._etherPorts[ethr]._index) ? "[Secure])" : ")"));
    }

    void validateVsan(SnmpPeer peer, int vsan) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get("vsanName").getOid(), vsan));
        SnmpPDU resp = peer.send(pdu);
        VarBindList vbnds = resp.getVariables();
        SnmpVar theVar = vbnds.getVb(0).getVar();
        if (theVar.getType() == 5) {
            throw new SnmpException("VSAN " + vsan + " does not exist on switch " + peer);
        }
    }

    @Override
    public void doFinish() {
        try {
            this._finishData = new FinishActionData();
            this._finishData._prtVsan = 1;
            this._finishData._vsanList = null;
            this._finishData._address1 = null;
            this._finishData._address2 = null;
            try {
                if (this._select.getSelected() == 1) {
                    this._finishData._vsanList = SnmpBitmap.parse(((FieldPanel)this._fields[5]).getField().getText().trim());
                    if (this._finishData._vsanList == null || this._finishData._vsanList.length == 0) {
                        throw new Exception("Please specify VSAN list.");
                    }
                } else {
                    this._finishData._prtVsan = ((FieldPanel)this._fields[5]).getInt();
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this.getWizard(), this._select.getSelected() == 1 ? "Invalid VSAN List" : "Invalid Port VSAN");
                return;
            }
            this.validateVsan(this._sw1, this._finishData._prtVsan);
            this.validateVsan(this._sw2, this._finishData._prtVsan);
            this._finishData._ficonPorts = this.validateAndGetFiconPort();
            if (this._finishData._ficonPorts == null) {
                return;
            }
            try {
                if ((this._select.getSelected() == 1 || this._select.getSelected() == 0) && this._ficonTapeAcceleration.isSelected()) {
                    this._finishData._ficonVsanList = SnmpBitmap.parse(this._ficonVsanList.getField().getText().trim());
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this.getWizard(), "Invalid FICON VSAN List");
                return;
            }
            this._finishData._mask1 = this._etherPorts[0]._mask;
            this._finishData._address1 = this._etherPorts[0]._address;
            this._finishData._add1 = this._finishData._address1;
            this._finishData._mask2 = this._etherPorts[1]._mask;
            this._finishData._address2 = this._etherPorts[1]._address;
            this._finishData._add2 = this._finishData._address2;
            if (this._finishData._add1.length != this._finishData._add2.length) {
                throw new SnmpException("IP address on both side of the FCIP tunnel are not the same address family.");
            }
            if (!this.validateEtherAddress(this._finishData._add1, this._finishData._mask1, this._finishData._add2, this._finishData._mask2)) {
                StringBuffer buf = new StringBuffer("The selected ethernet ports are in different subnets. \nPlease make sure a route exists between these subnets. \n ");
                buf.append("Do you still want to continue?");
                int userOption = JOptionPane.showConfirmDialog(this, buf.toString(), "Fcip Wizard", 0, 2);
                if (userOption != 0) {
                    return;
                }
            }
            this.validateTunnelIndex(this._tunnels1, this._finishData._add1, this._sw1, this._etherPorts[0]);
            this.validateTunnelIndex(this._tunnels2, this._finishData._add2, this._sw2, this._etherPorts[1]);
            SwitchInfo sw1Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_A");
            SwitchInfo sw2Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_B");
            StringBuffer msg1 = new StringBuffer();
            StringBuffer msg2 = new StringBuffer();
            StringBuffer msg = new StringBuffer();
            this.buildSwitchInfoMsg(msg1, sw1Info);
            this.buildSwitchInfoMsg(msg2, sw2Info);
            if (msg1.length() > 0 || msg2.length() > 0) {
                msg.append("The following features should be enabled\n");
            }
            if (msg1.length() > 0) {
                msg.append(this._sw1 + ":" + msg1.toString() + "\n");
            }
            if (msg2.length() > 0) {
                msg.append(this._sw2 + ":" + msg2.toString() + "\n");
            }
            if (msg.length() > 0) {
                msg.append("Do you want FCIP Wizard to enable these features?");
                if (JOptionPane.showConfirmDialog(this.getWizard(), msg.toString(), this.getWizard().getTitle(), 0, 2) == 0) {
                    ArrayList list = this.getEnableFeatueTasks(this._sw1, sw1Info, this._sw2, sw2Info);
                    FeatureEnabler featureE = new FeatureEnabler(list, true, this);
                    featureE.startAction();
                }
                return;
            }
            this.doSetOperations();
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this, ex);
        }
    }

    private ArrayList getEnableFeatueTasks(SnmpPeer sw1, SwitchInfo swInfo1, SnmpPeer sw2, SwitchInfo swInfo2) {
        ArrayList<Object[]> tasks = new ArrayList<Object[]>();
        Boolean applySecurity = (Boolean)this.getModelValue("APPLY_SECURITY");
        Object[] ob = this.getFeatureTask(sw1, swInfo1, applySecurity);
        if (ob != null) {
            tasks.add(ob);
        }
        if ((ob = this.getFeatureTask(sw2, swInfo2, applySecurity)) != null) {
            tasks.add(ob);
        }
        return tasks;
    }

    private Object[] getFeatureTask(SnmpPeer sw1, SwitchInfo swInfo1, Boolean applySecurity) {
        if (swInfo1._enableFcip || swInfo1._enableIpSec) {
            Object[] ob = new Object[2];
            ob[0] = sw1;
            ArrayList<Integer> featuresLst = new ArrayList<Integer>();
            if (swInfo1._enableFcip) {
                featuresLst.add(new Integer(2));
            }
            if (applySecurity.booleanValue() && swInfo1._enableIpSec) {
                if (swInfo1._enableIKE) {
                    featuresLst.add(new Integer(11));
                }
                if (swInfo1._enableIpSec) {
                    featuresLst.add(new Integer(13));
                }
            }
            int[] features = new int[featuresLst.size()];
            for (int k = 0; k < featuresLst.size(); ++k) {
                features[k] = (Integer)featuresLst.get(k);
            }
            ob[1] = features;
            return ob;
        }
        return null;
    }

    private void buildSwitchInfoMsg(StringBuffer buf, SwitchInfo swInfo) {
        Boolean applySecurity = (Boolean)this.getModelValue("APPLY_SECURITY");
        if (swInfo._enableFcip) {
            buf.append(_Fcip_Wiz_Sig);
        }
        if (applySecurity.booleanValue() && swInfo._enableIpSec) {
            buf.append((buf.length() > 0 ? "," : "") + "IKE, IPSEC");
        }
    }

    private void doSetOperations() throws SnmpException {
        long nextTcpPort1;
        Boolean mtu = (Boolean)this.getModelValue("MTU");
        long nextTcpPort2 = nextTcpPort1 = this.getUniqueTcpPort(this._profiles1, this._profiles2, this._finishData._address1, this._finishData._address2);
        long maxBdWith = (Long)this.getModelValue("MAX_BANDWIDTH");
        long minBdWith = (Long)this.getModelValue("MIN_BANDWIDTH");
        long estRndTrpTime = (Long)this.getModelValue("EST_RNDTRIP_TIME");
        int compression = (Integer)this.getModelValue("COMPRESSION");
        int writeAcc = (Integer)this.getModelValue("WRITE_ACC");
        Integer xrcInt = (Integer)this.getModelValue("XRC");
        int xrc = xrcInt != null ? xrcInt : -1;
        StringBuffer errBuf = new StringBuffer();
        ClientController.getInstance();
        Switch swL = ClientController.findFabricSwitchByIpAddress(this._sw1.getAddress());
        SwitchBase swLBase = swL != null ? (SwitchBase)swL.getBaseModelObject() : null;
        int maxTunnels = swLBase != null && swLBase.isAlishan() ? 6 : 3;
        this.mibNodeMaxBdWidth = swLBase != null && swLBase.isVersionGreaterThanEqual("6.2(5)") ? "cfmFcipEntityExt2TcpMaxBW" : "cfmFcipEntityExtTcpMaxBW";
        this.mibNodeMinBdWidth = swLBase != null && swLBase.isVersionGreaterThanEqual("6.2(5)") ? "cfmFcipEntityExt2TcpMinAvailBW" : "cfmFcipEntityExtTcpMinAvailBW";
        Profile exitingProfile1 = this.validateSelection(errBuf, this._selProfileId1, this._selTnlId1, this._profiles1, this._tunnels1, this._etherPorts[0], this._finishData._add2, maxTunnels);
        if (errBuf.length() != 0) {
            throw new SnmpException(errBuf.toString());
        }
        errBuf.setLength(0);
        ClientController.getInstance();
        swL = ClientController.findFabricSwitchByIpAddress(this._sw2.getAddress());
        maxTunnels = swL != null && ((SwitchBase)swL.getBaseModelObject()).isAlishan() ? 6 : 3;
        Profile exitingProfile2 = this.validateSelection(errBuf, this._selProfileId2, this._selTnlId2, this._profiles2, this._tunnels2, this._etherPorts[1], this._finishData._add1, maxTunnels);
        if (errBuf.length() != 0) {
            throw new SnmpException(errBuf.toString());
        }
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        if (exitingProfile1 == null) {
            this.buildProfilePdu(pdu, this._selProfileId1, nextTcpPort1, this._finishData._add1, maxBdWith, minBdWith, estRndTrpTime);
        }
        this.buildTunnelPdu(pdu, this._selTnlId1, this._selProfileId1, nextTcpPort2, this._finishData._add2, writeAcc, compression, xrc, this._finishData._prtVsan, this._finishData._vsanList);
        this.getWizard().getNavigator().getBackBtn().setEnabled(false);
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
        this.applySecurity();
        try {
            this._sw1.set(pdu);
            this.setFcipPortProperties(this._sw1, 0xA000000 + this._selTnlId1, this._finishData._prtVsan, this._finishData._vsanList);
        }
        catch (SnmpException ex) {
            throw new SnmpException(this._sw1.toString() + ":" + ex.getMessage());
        }
        pdu = new SnmpPDU(-93, new VarBindList());
        if (exitingProfile2 == null) {
            this.buildProfilePdu(pdu, this._selProfileId2, nextTcpPort2, this._finishData._add2, maxBdWith, minBdWith, estRndTrpTime);
        }
        this.buildTunnelPdu(pdu, this._selTnlId2, this._selProfileId2, nextTcpPort1, this._finishData._add1, writeAcc, compression, xrc, this._finishData._prtVsan, this._finishData._vsanList);
        try {
            this._sw2.set(pdu);
            this.setFcipPortProperties(this._sw2, 0xA000000 + this._selTnlId2, this._finishData._prtVsan, this._finishData._vsanList);
        }
        catch (SnmpException ex) {
            throw new SnmpException(this._sw2.toString() + ":" + ex.getMessage());
        }
        this.setFiconPorts(this._sw1, IfIndexUtil.name2IfIndex("fcip" + Integer.toString(this._selTnlId1 + 1)), this._sw2, IfIndexUtil.name2IfIndex("fcip" + Integer.toString(this._selTnlId2 + 1)), this._finishData._ficonPorts[0], this._finishData._ficonPorts[1]);
        this.enableFcipPort(this._sw1, 0xA000000 + this._selTnlId1);
        this.enableFcipPort(this._sw2, 0xA000000 + this._selTnlId2);
        if (this._ficonTapeAcceleration.isVisible() && this._ficonTapeAcceleration.isSelected()) {
            this.setFcipFiconPortTapeAcceleration(this._sw1, this._selProfileId1, this._selTnlId1, this._finishData._ficonVsanList);
            this.setFcipFiconPortTapeAcceleration(this._sw2, this._selProfileId2, this._selTnlId2, this._finishData._ficonVsanList);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FcipPropPanel.this.doCancel();
                BrowserFrame.getDataView().refreshWizardOwner(FcipPropPanel._Fcip_Wiz_Sig);
            }
        });
    }

    private Profile validateSelection(StringBuffer buf, int prfId, int tnlId, Array allProfiles, Array allTunnels, EtherPort selEtherPort, byte[] destIpAddress, int maxAllowedTunnels) {
        int i;
        Profile matchedProfile = null;
        for (i = 0; i < allProfiles.size(); ++i) {
            Profile prf = (Profile)allProfiles.elementAt(i);
            if (prf._index != prfId) continue;
            matchedProfile = prf;
            if (!SnmpString.equals(prf._ipAddr.getValue(), selEtherPort._address)) {
                buf.append("The selected Profile ID is associated with different IP Address " + prf._ipAddr + "\n");
            }
            int associatedTunnels = 0;
            for (int t = 0; t < allTunnels.size(); ++t) {
                Tunnel tnl = (Tunnel)allTunnels.elementAt(t);
                if (SnmpString.equals(prf._ipAddr.getValue(), tnl._localProfile._ipAddr.getValue())) {
                    ++associatedTunnels;
                }
                if (tnl._localProfile._index != prf._index || tnl._localProfile._tcpPort != prf._tcpPort || !SnmpString.equals(tnl._remoteProfile._ipAddr.getValue(), destIpAddress)) continue;
                buf.append("The selected profile is associated with a Tunnel with same Remote IP address.\nPlease select a different profile ID.\n");
                break;
            }
            if (associatedTunnels < maxAllowedTunnels) break;
            buf.append("The selected profile IP address " + SnmpIpAddress.toString(prf._ipAddr.getValue()) + " is already associated with " + maxAllowedTunnels + " tunnels.\n");
            break;
        }
        for (i = 0; i < allTunnels.size(); ++i) {
            Tunnel tnl = (Tunnel)allTunnels.elementAt(i);
            if (tnlId != tnl._index) continue;
            buf.append("The selected Tunnel ID " + (tnlId + 1) + " is already used. Please select another Id.\n");
        }
        return matchedProfile;
    }

    private String getGigiPortAddress(String addressMask) throws SnmpException {
        int ind = addressMask.indexOf(47);
        if (-1 == ind) {
            new SnmpException("Bad ip address");
        }
        return addressMask.substring(0, ind);
    }

    boolean validateEtherAddress(byte[] add1, int mask1, byte[] add2, int mask2) throws SnmpException {
        if (mask1 != mask2) {
            return false;
        }
        byte[] subnet1 = SnmpIpAddress.getSubNet(add1, mask1);
        byte[] subnet2 = SnmpIpAddress.getSubNet(add2, mask2);
        return SnmpString.equals(subnet1, subnet2);
    }

    private void setEtherProperties(SnmpPeer peer, EtherPort prt, byte[] address, int mask, Boolean setJumboMtu) throws SnmpException {
        VarBindList vbl = new VarBindList();
        boolean setMtu = false;
        if (setJumboMtu != null && setJumboMtu.booleanValue()) {
            vbl.add(MibNode.get("cieIfMtu").getOid(), prt._index);
            setMtu = peer.send(new SnmpPDU(-96, vbl)).getVariables().intValue(0) < 2300;
        }
        vbl.clear();
        if (prt._address == null || !SnmpString.equals(address, prt._address)) {
            int[] oid = new int[3 + address.length];
            oid[0] = prt._index;
            oid[1] = address.length == 16 ? 2 : 1;
            oid[2] = address.length;
            for (int i = 0; i < address.length; ++i) {
                oid[3 + i] = address[i];
            }
            vbl.add(MibNode.get("ciiIPIfAddressStatus").getOid(), oid, (SnmpVar)new SnmpInt(4));
            vbl.add(MibNode.get("ciiIPIfAddressPrefixLength").getOid(), oid, (SnmpVar)new SnmpUnsignedInt(mask));
        }
        if (setMtu) {
            vbl.add(MibNode.get("cieIfMtu").getOid(), prt._index, (SnmpVar)new SnmpInt(2300));
        }
        if (prt._adminStatus != 1) {
            vbl.add(MibNode.get("ifAdminStatus").getOid(), prt._index, (SnmpVar)new SnmpInt(1));
        }
        if (vbl.size() > 0) {
            peer.set(new SnmpPDU(-93, vbl));
            prt._address = address;
            prt._adminStatus = 1;
        }
    }

    void buildProfilePdu(SnmpPDU pdu, int profileIndex, long tcpPort, byte[] address, long maxBdWith, long minBdWith, long estRndTrpTime) throws SnmpException {
        pdu.addVar(new SnmpOID(MibNode.get("cfmFcipEntityStatus").getOid(), profileIndex), new SnmpInt(4));
        pdu.addVar(new SnmpOID(MibNode.get("cfmFcipEntityTcpConnPort").getOid(), profileIndex), new SnmpGauge(tcpPort));
        pdu.addVar(new SnmpOID(MibNode.get("cfmFcipEntityAddress").getOid(), profileIndex), new SnmpString(address));
        pdu.addVar(new SnmpOID(MibNode.get(this.mibNodeMaxBdWidth).getOid(), profileIndex), new SnmpGauge(maxBdWith));
        pdu.addVar(new SnmpOID(MibNode.get(this.mibNodeMinBdWidth).getOid(), profileIndex), new SnmpGauge(minBdWith));
        pdu.addVar(new SnmpOID(MibNode.get("cfmFcipEntityExtTcpRndTrpTimeEst").getOid(), profileIndex), new SnmpGauge(estRndTrpTime));
    }

    void buildTunnelPdu(SnmpPDU pdu, int tunnelIndex, int profileIndex, long tcpPort, byte[] address, int writeAcc, int compression, int xrc, int prtVsan, byte[] vsanList) throws SnmpException {
        int[] oid = new int[]{profileIndex, tunnelIndex};
        pdu.addVar(new SnmpOID(MibNode.get("cfmFcipLinkStatus").getOid(), oid), new SnmpInt(4));
        pdu.addVar(new SnmpOID(MibNode.get("cfmFcipLinkRemFcipEntityAddress").getOid(), oid), new SnmpString(address));
        pdu.addVar(new SnmpOID(MibNode.get("cfmFcipLinkExtTcpRemPort").getOid(), oid), new SnmpInt((int)tcpPort));
        pdu.addVar(new SnmpOID(MibNode.get("cfmFcipLinkExtIPComp").getOid(), oid), new SnmpInt(compression));
        pdu.addVar(new SnmpOID(MibNode.get("cfmFcipLinkExtWriteAccelerator").getOid(), oid), new SnmpInt(writeAcc));
        if (xrc != -1) {
            pdu.addVar(new SnmpOID(MibNode.get("cfmFcipLinkExtFiconXRCEmulator").getOid(), oid), new SnmpInt(xrc));
        }
    }

    void getProfileTnlInfo(SnmpPeer peer, Array prfAr, Array tnlAr) throws SnmpException {
        int[] oid;
        SnmpVarBind vbnd;
        prfAr.clear();
        tnlAr.clear();
        VarBindList profileVarBnd = new VarBindList();
        profileVarBnd.add(new SnmpVarBind(_FCIP_PROF_TCPPORT_OID));
        profileVarBnd.add(new SnmpVarBind(_FCIP_PROF_ADD_OID));
        VarBindList profileAr = SnmpFetch.getBulk(peer, profileVarBnd).getVariables();
        VarBindList tunnelVarBnd = new VarBindList();
        tunnelVarBnd.add(new SnmpVarBind(_FCIP_REMPROF_ID_OID));
        tunnelVarBnd.add(new SnmpVarBind(_FCIP_REMPROF_ADD_OID));
        tunnelVarBnd.add(new SnmpVarBind(_FCIP_REMPROF_TCPPORT_OID));
        VarBindList tunnelAr = SnmpFetch.getBulk(peer, tunnelVarBnd).getVariables();
        int MAXI = profileAr.size();
        for (int i = 0; i < MAXI; i += 2) {
            Profile prf = new Profile();
            vbnd = profileAr.getVb(i);
            oid = vbnd.getOid().getValue();
            prf._index = oid[oid.length - 1];
            prf._tcpPort = ((SnmpGauge)vbnd.getVar()).getValue();
            vbnd = profileAr.getVb(i + 1);
            prf._ipAddr = (SnmpString)vbnd.getVar();
            prfAr.addElement(prf);
        }
        int MAXJ = tunnelAr.size();
        for (int j = 0; j < MAXJ; j += 3) {
            Tunnel tnl = new Tunnel();
            vbnd = tunnelAr.getVb(j);
            oid = vbnd.getOid().getValue();
            tnl._index = oid[oid.length - 1];
            int prfIndex = oid[oid.length - 2];
            tnl._remoteProfile = new Profile();
            tnl._remoteProfile._index = tunnelAr.intValue(j);
            tnl._remoteProfile._ipAddr = (SnmpString)tunnelAr.getVb(j + 1).getVar();
            tnl._remoteProfile._tcpPort = tunnelAr.intValue(j + 2);
            int MAXI2 = prfAr.size();
            for (int i = 0; i < MAXI2; ++i) {
                Profile prfLc = (Profile)prfAr.elementAt(i);
                if (prfLc._index != prfIndex) continue;
                tnl._localProfile = prfLc;
                break;
            }
            tnlAr.addElement(tnl);
        }
    }

    void validateTunnelIndex(Array tunnels, byte[] add, SnmpPeer sw, EtherPort etherPrt) throws SnmpException {
        if (null == add) {
            return;
        }
        int totTunnels = 0;
        int MAXI = tunnels.size();
        for (int i = 0; i < MAXI; ++i) {
            int MaxTunnels;
            byte[] refAdd;
            Tunnel tnl = (Tunnel)tunnels.elementAt(i);
            if (tnl._localProfile == null || tnl._localProfile._ipAddr == null || null == (refAdd = tnl._localProfile._ipAddr.getValue()) || refAdd.length != add.length) continue;
            boolean addMatch = true;
            int MAXJ = refAdd.length;
            for (int j = 0; j < MAXJ; ++j) {
                if (refAdd[j] == add[j]) continue;
                addMatch = false;
                break;
            }
            if (!addMatch) continue;
            ClientController.getInstance();
            Switch swL = ClientController.findFabricSwitchByIpAddress(sw.getAddress());
            int n = MaxTunnels = swL != null && ((SwitchBase)swL.getBaseModelObject()).isAlishan() ? 6 : 3;
            if (++totTunnels < MaxTunnels) continue;
            StringBuffer buf = new StringBuffer("The ether port ");
            buf.append(etherPrt.getIfName());
            buf.append(" for switch ");
            buf.append(sw);
            buf.append(" is already associated with " + MaxTunnels + " tunnels.");
            throw new SnmpException(buf.toString());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ((FieldPanel)this._fields[5]).setText(this._select.getSelected() == 1 ? "1-4093" : "1");
        ((FieldPanel)this._fields[5]).getComponent(1).setVisible(this._select.getSelected() != 1);
        ((JLabel)((FieldPanel)this._fields[5]).getComponent(2)).setText(this._select.getSelected() == 1 ? "(1-4093) e.g. 1-22,29-45" : "1..4093");
        ((JLabel)this._Labels[5]).setText(this._select.getSelected() == 1 ? VSAN_LIST : PORT_VSAN);
        if (this._ficonTapeAcceleration.isVisible()) {
            Integer xrcInt;
            boolean ficonenabled;
            Boolean ficon = (Boolean)this.getModelValue("FICON_ENABLED");
            boolean bl = ficonenabled = ficon != null && ficon != false;
            if (this._select.getSelected() != 1) {
                this._ficonTapeAcceleration.setSelected(false);
            }
            boolean xrcEnabled = (xrcInt = (Integer)this.getModelValue("XRC")) != null && xrcInt == 1;
            this._ficonTapeAcceleration.setEnabled(this._select.getSelected() != 2 && ficonenabled && !xrcEnabled);
            this._Labels[7].setEnabled(this._select.getSelected() != 2 && ficonenabled && !xrcEnabled);
            this._ficonVsanList.setEnabled(this._ficonTapeAcceleration.isSelected());
            this._ficonVsanListLabel.setEnabled(this._ficonTapeAcceleration.isSelected());
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            boolean xrcEnabled;
            Integer xrcInt = (Integer)this.getModelValue("XRC");
            boolean bl = xrcEnabled = xrcInt != null && xrcInt == 1;
            if (this.ficonTapeNote != null) {
                this.ficonTapeNote.setVisible(xrcEnabled);
            }
            if (this._ficonTapeAcceleration != null && this._select != null) {
                this._ficonTapeAcceleration.setEnabled(this._select.getSelected() != 2 && !xrcEnabled);
            }
        }
        super.setVisible(b);
    }

    int getUniqueIndex(Array list1, Array list2, boolean isZeroBased) {
        int i;
        int index = isZeroBased ? -1 : 0;
        ArrayList<Integer> prfIndices = new ArrayList<Integer>();
        for (i = 0; i < list1.size(); ++i) {
            prfIndices.add(new Integer(((IndexClass)list1.elementAt((int)i))._index));
        }
        for (i = 0; i < list2.size(); ++i) {
            Integer profId = new Integer(((IndexClass)list2.elementAt((int)i))._index);
            if (prfIndices.contains(profId)) continue;
            prfIndices.add(profId);
        }
        Collections.sort(prfIndices);
        int MAXI = prfIndices.size();
        for (i = 0; i < MAXI; ++i) {
            Integer prf = (Integer)prfIndices.get(i);
            if (prf - index > 1) {
                return index + 1;
            }
            index = prf;
        }
        if (++index > 0 && index < 255) {
            return index;
        }
        return 0;
    }

    long getUniqueTcpPort(Array prof1, Array prof2, byte[] addr1, byte[] addr2) {
        Profile prf;
        int i;
        int index = 3224;
        ArrayList<Long> prfIndices = new ArrayList<Long>();
        for (i = 0; i < prof1.size(); ++i) {
            prf = (Profile)prof1.elementAt(i);
            if (!SnmpIpAddress.equals(prf._ipAddr.getValue(), addr1)) continue;
            prfIndices.add(new Long(prf._tcpPort));
        }
        for (i = 0; i < prof2.size(); ++i) {
            Long profId;
            prf = (Profile)prof2.elementAt(i);
            if (!SnmpIpAddress.equals(prf._ipAddr.getValue(), addr2) || prfIndices.contains(profId = new Long(prf._tcpPort))) continue;
            prfIndices.add(profId);
        }
        Collections.sort(prfIndices);
        int MAXI = prfIndices.size();
        for (i = 0; i < MAXI; ++i) {
            Long prf2 = (Long)prfIndices.get(i);
            if (prf2 < 3225L) continue;
            if (prf2 - (long)index > 1L) {
                return index + 1;
            }
            index = prf2.intValue();
        }
        return ++index;
    }

    private void applySecurity() throws SnmpException {
        IpSecurityController con;
        Boolean applySecurity = (Boolean)this.getModelValue("APPLY_SECURITY");
        if (applySecurity.booleanValue() && (con = (IpSecurityController)this.getModelValue("SECURITY_CONTROLLER")) != null && !con.isSecure()) {
            con.setSecurity(this._etherPorts[0]._address, this._etherPorts[1]._address);
        }
    }

    private void setSecurityDescription() {
        IpSecurityController con;
        Boolean applySecurity = (Boolean)this.getModelValue("APPLY_SECURITY");
        if (applySecurity.booleanValue() && (con = (IpSecurityController)this.getModelValue("SECURITY_CONTROLLER")) != null && !con.isSecure()) {
            this.setDescription("Please supply following parameters to create a FCIP tunnel. Specify Port VSAN for nontrunk/auto and allowed VSAN list for Trunk tunnel.\nNOTE: the FCIP link may take time to appear in map.Security Policy with " + IpSecurityController.DEFAULT_SET + " will be applied.");
            return;
        }
        this.setDescription(Description);
    }

    private void setFcipPortProperties(SnmpPeer peer, int ifIndex, int prtVsan, byte[] vsanList) throws SnmpException {
        VarBindList vbl = new VarBindList();
        if (this._select.getSelected() != 1) {
            vbl.add(MibNode.get("vsanIfVsan").getOid(), ifIndex, (SnmpVar)new SnmpInt(prtVsan));
        } else {
            SnmpString vsan2K = PortInterfaceUtil.getInstance(1).get2KString(vsanList);
            SnmpString vsan4K = PortInterfaceUtil.getInstance(1).get4KString(vsanList);
            if (vsan2K != null) {
                vbl.add(MibNode.get("fcIfAllowedVsanList2k").getOid(), ifIndex, (SnmpVar)vsan2K);
            }
            if (vsan4K != null) {
                vbl.add(MibNode.get("fcIfAllowedVsanList4k").getOid(), ifIndex, (SnmpVar)vsan4K);
            }
        }
        int trunkMode = _trnkEnum[this._select.getSelected()].getValue();
        vbl.add(MibNode.get("fcIfAdminTrunkMode").getOid(), ifIndex, (SnmpVar)new SnmpInt(trunkMode));
        peer.set(new SnmpPDU(-93, vbl));
    }

    private void setFcipFiconPortTapeAcceleration(SnmpPeer peer, int profileId, int tunnelId, byte[] vsanList) throws SnmpException {
        VarBindList vbl = new VarBindList();
        if (this._select.getSelected() == 1) {
            SnmpString vsan2K = PortInterfaceUtil.getInstance(1).get2KString(vsanList);
            SnmpString vsan4K = PortInterfaceUtil.getInstance(1).get4KString(vsanList);
            int[] index = new int[]{profileId, tunnelId};
            if (vsan2K != null) {
                vbl.add(MibNode.get("cfmFcipLinkExtFiconTAVsanL2k").getOid(), index, (SnmpVar)vsan2K);
            }
            if (vsan4K != null) {
                vbl.add(MibNode.get("cfmFcipLinkExtFiconTAVsanL4k").getOid(), index, (SnmpVar)vsan4K);
            }
        }
        peer.set(new SnmpPDU(-93, vbl));
    }

    private void enableFcipPort(SnmpPeer peer, int ifIndex) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("ifAdminStatus").getOid(), ifIndex, (SnmpVar)new SnmpInt(1));
        peer.set(new SnmpPDU(-93, vbl));
    }

    private void setFiconPorts(SnmpPeer peer1, int ifIndex1, SnmpPeer peer2, int ifIndex2, int ficPort1, int ficPort2) throws SnmpException {
        boolean ficonenabled;
        Boolean ficon = (Boolean)this.getModelValue("FICON_ENABLED");
        boolean bl = ficonenabled = ficon != null && ficon != false;
        if (!ficonenabled) {
            return;
        }
        StringBuffer errMsg = new StringBuffer();
        if (ficonenabled) {
            if (ficPort1 != -1) {
                try {
                    this.setFiconPort(peer1, ifIndex1, ficPort1);
                }
                catch (SnmpException ex) {
                    errMsg.append("Failed to set ficon port " + ficPort1 + " for newly created FCIP tunnel " + IfIndexUtil.ifIndexToName(ifIndex1) + " on " + peer1 + ".");
                }
            }
            if (ficPort2 != -1) {
                try {
                    this.setFiconPort(peer2, ifIndex2, ficPort2);
                }
                catch (SnmpException ex) {
                    if (errMsg.length() > 0) {
                        errMsg.append("\n");
                    }
                    errMsg.append("Failed to set ficon port " + ficPort2 + " for newly created FCIP tunnel " + IfIndexUtil.ifIndexToName(ifIndex2) + " on " + peer2 + ".");
                }
            }
        }
        if (errMsg.length() > 0) {
            throw new SnmpException(errMsg.toString());
        }
    }

    private int[] validateAndGetFiconPort() {
        SwitchInfo sw1Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_A");
        SwitchInfo sw2Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_B");
        Switch sw1 = ClientController.findFabricSwitchByIpAddress(this._sw1.getAddress());
        Switch sw2 = ClientController.findFabricSwitchByIpAddress(this._sw2.getAddress());
        String ficPortStr = ((FieldPanel)this._fields[1]).getText().trim();
        int ficPort1 = -1;
        try {
            if (ficPortStr != null && ficPortStr.length() > 0) {
                ficPort1 = FcipPropPanel.getNumber(ficPortStr);
                byte[] ficonRange = ((SwitchBase)sw1.getBaseModelObject()).getFiconPortRange();
                if (ficonRange != null && ficonRange.length > 0 && !new FiconPortAddrList(ficonRange).isOn(ficPort1) && JOptionPane.showConfirmDialog(this.getWizard(), "FICON Port address must be in 0x" + new FiconPortAddrList(ficonRange).toString() + " for " + this._sw1 + ". Continue?", this.getWizard().getTitle(), 0) != 0) {
                    return null;
                }
            }
        }
        catch (NumberFormatException ex) {
            Util.errorMessage((Component)this.getWizard(), "Invalid FICON Port " + ficPortStr + ". Please specify FICON Port with 0xF7 format.");
            return null;
        }
        ficPortStr = ((FieldPanel)this._fields[3]).getText().trim();
        int ficPort2 = -1;
        try {
            if (ficPortStr != null && ficPortStr.length() > 0) {
                ficPort2 = FcipPropPanel.getNumber(ficPortStr);
                byte[] ficonRange = ((SwitchBase)sw2.getBaseModelObject()).getFiconPortRange();
                if (ficonRange != null && ficonRange.length > 0 && !new FiconPortAddrList(ficonRange).isOn(ficPort2) && JOptionPane.showConfirmDialog(this.getWizard(), "FICON Port address must be in 0x" + new FiconPortAddrList(ficonRange).toString() + " for " + this._sw2 + ". Continue?", this.getWizard().getTitle(), 0) != 0) {
                    return null;
                }
            }
        }
        catch (NumberFormatException ex) {
            Util.errorMessage((Component)this.getWizard(), "Invalid FICON Port " + ficPortStr + ". Please specify FICON Port with 0xF7 format.");
            return null;
        }
        return new int[]{ficPort1, ficPort2};
    }

    private void setFiconPort(SnmpPeer peer, int ifIndex, int ficPort) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cficonPortIfIndex").getOid(), ficPort, (SnmpVar)new SnmpInt(ifIndex));
        SnmpFetch.set(peer, vbl);
    }

    private static int getNumber(String n) throws NumberFormatException {
        if (n.startsWith("0x")) {
            return Integer.parseInt(n.substring(2), 16);
        }
        return Integer.parseInt(n);
    }

    @Override
    public void handleError(Exception[] ex) {
        Util.errorMessage((Component)this, SmZoneUtil.buildErrorMessage(ex).toString());
    }

    @Override
    public void actionFinished() {
        this.getWizard().setStatus("");
        try {
            this.doSetOperations();
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this, ex);
        }
    }

    @Override
    public void setStatus(String status) {
        this.getWizard().setStatus(status);
    }

    @Override
    public void dispose() {
        this.getWizard().dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IpSecurityController cont = (IpSecurityController)this.getModelValue("SECURITY_CONTROLLER");
        if (e.getSource() == this._ficonTapeAcceleration) {
            this._ficonVsanList.setEnabled(this._ficonTapeAcceleration.isSelected());
            this._ficonVsanListLabel.setEnabled(this._ficonTapeAcceleration.isSelected());
        } else if (e.getSource() == this._profile1Btn) {
            ProfileSelector psel = new ProfileSelector(this.getWizard(), this._profiles1, this._tunnels1, this._selProfileId1, this._selTnlId1, this._etherPorts[0], this._sw1, this._etherPorts[1]._address);
            psel.setVisible(true);
            if (psel.getSelectedProfile() != -1) {
                this._selProfileId1 = psel.getSelectedProfile();
                this._selTnlId1 = psel.getSelectedTnl();
                this.setDialogSepText(this._dlgSep1, cont, this._sw1, this._selTnlId1 + 1, 0, this._selProfileId1);
                this.repaint();
            }
        } else if (e.getSource() == this._profile2Btn) {
            ProfileSelector psel = new ProfileSelector(this.getWizard(), this._profiles2, this._tunnels2, this._selProfileId2, this._selTnlId2, this._etherPorts[1], this._sw2, this._etherPorts[0]._address);
            psel.setVisible(true);
            if (psel.getSelectedProfile() != -1) {
                this._selProfileId2 = psel.getSelectedProfile();
                this._selTnlId2 = psel.getSelectedTnl();
                this.setDialogSepText(this._dlgSep2, cont, this._sw2, this._selTnlId2 + 1, 1, this._selProfileId2);
                this.repaint();
            }
        } else {
            SnmpPeer peer = e.getSource() == this._ficonMore1 ? this._sw1 : this._sw2;
            try {
                String[] cmd = new String[]{"show ficon first-available port-number \n"};
                DefaultLogger._DefLogger.debug((Object)("Command :" + cmd[0]));
                VshDump dlg = new VshDump(Util.getFrameAncestor(this.getWizard()), "First Available FICON Port for " + peer, cmd, peer);
                dlg.setVisible(true);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this.getWizard(), "Show First available FICON port failed.");
            }
        }
    }

    class ProfileSelector
    extends JDialog
    implements ActionListener {
        private int selTnl;
        private int selPrfile;
        private FieldPanel prfFieldPnl;
        private FieldPanel tnlFieldPnl;
        private Array allTunnels;
        private Array allProfiles;
        private EtherPort selEtherPort;
        private byte[] remoteIpAddress;
        private int maxTunnels;

        public ProfileSelector(JDialog parent, Array profiles, Array tunnels, int curProfileId, int curTnlId, EtherPort etPrt, SnmpPeer sw, byte[] rmtAdd) {
            super(parent);
            this.selTnl = -1;
            this.selPrfile = -1;
            this.maxTunnels = 3;
            this.allProfiles = profiles;
            this.allTunnels = tunnels;
            this.prfFieldPnl = new FieldPanel(10, curProfileId, 1, 255);
            this.tnlFieldPnl = new FieldPanel(10, curTnlId + 1, 1, 255);
            this.selEtherPort = etPrt;
            this.remoteIpAddress = rmtAdd;
            ClientController.getInstance();
            Switch swL = ClientController.findFabricSwitchByIpAddress(sw.getAddress());
            this.maxTunnels = swL != null && ((SwitchBase)swL.getBaseModelObject()).isAlishan() ? 6 : 3;
            JPanel prfTnlSelPnl = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"Profile ID:", "Tunnel ID:"}), new JComponent[]{this.prfFieldPnl, this.tnlFieldPnl});
            KTableModel prfModel = new KTableModel();
            Array<Object[]> prfData = new Array<Object[]>();
            for (int i = 0; i < profiles.size(); ++i) {
                Profile prf = (Profile)profiles.elementAt(i);
                Object[] data = new Object[4];
                data[0] = Integer.toString(prf._index);
                data[1] = new SnmpIpAddress(prf._ipAddr.getValue());
                data[2] = Long.toString(prf._tcpPort);
                prfData.addElement(data);
            }
            prfModel.setHeaders(new String[]{"ID", "IP Address", "TCP Port"});
            prfModel.setData(prfData);
            KTableModel tnlModel = new KTableModel();
            Array<Object[]> tnlData = new Array<Object[]>();
            for (int i = 0; i < tunnels.size(); ++i) {
                Tunnel tnl = (Tunnel)tunnels.elementAt(i);
                Object[] data = new Object[4];
                data[0] = Integer.toString(tnl._index + 1);
                data[1] = new SnmpIpAddress(tnl._localProfile._ipAddr.getValue()) + "(" + tnl._localProfile._index + ")";
                data[2] = new SnmpIpAddress(tnl._remoteProfile._ipAddr.getValue());
                tnlData.addElement(data);
            }
            tnlModel.setHeaders(new String[]{"ID", "Local Profile Address(ID)", "Remote Profile Address"});
            tnlModel.setData(tnlData);
            KTable prfTbl = new KTable(prfModel);
            JScrollPane pn1 = new JScrollPane(prfTbl);
            KTable tnlTbl = new KTable(tnlModel);
            JScrollPane pn2 = new JScrollPane(tnlTbl);
            prfTbl.calcPreferredSize();
            tnlTbl.calcPreferredSize();
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab("Profiles", pn1);
            tabbedPane.addTab("Tunnels", pn2);
            JPanel secondPnl = new JPanel(new BorderLayout());
            secondPnl.add((Component)new DialogSeparator("Configured"), "North");
            secondPnl.add((Component)tabbedPane, "Center");
            JPanel mainPnl = new JPanel(new BorderLayout());
            mainPnl.add((Component)prfTnlSelPnl, "North");
            mainPnl.add((Component)secondPnl, "Center");
            DialogUtil.buildDialog(this, parent, mainPnl);
            this.setResizable(true);
            this.setSize(400, 300);
            this.setTitle("Select Profile/Tunnel for Switch " + sw + ClientController.getInstance().getDialogFabricTitlePostfix());
            this.setModal(true);
        }

        int getSelectedProfile() {
            return this.selPrfile;
        }

        int getSelectedTnl() {
            return this.selTnl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            char cmd = e.getActionCommand().charAt(0);
            try {
                switch (cmd) {
                    case 'O': {
                        this.selPrfile = this.prfFieldPnl.getInt();
                        this.selTnl = this.tnlFieldPnl.getInt() - 1;
                        StringBuffer errBuf = new StringBuffer();
                        FcipPropPanel.this.validateSelection(errBuf, this.selPrfile, this.selTnl, this.allProfiles, this.allTunnels, this.selEtherPort, this.remoteIpAddress, this.maxTunnels);
                        if (errBuf.length() == 0) break;
                        this.selTnl = -1;
                        this.selPrfile = -1;
                        Util.errorMessage((Component)this, errBuf.toString());
                        return;
                    }
                    default: {
                        this.selTnl = -1;
                        this.selPrfile = -1;
                    }
                }
                this.dispose();
            }
            catch (NumberFormatException ex) {
                Util.errorMessage((Component)this, ex);
            }
        }
    }

    class FinishActionData {
        byte[] _add1;
        int _mask1;
        byte[] _address1;
        byte[] _add2;
        int _mask2;
        byte[] _address2;
        int _prtVsan;
        byte[] _vsanList;
        int[] _ficonPorts;
        byte[] _ficonVsanList;

        FinishActionData() {
        }
    }

    public final class ProfTcpPortSortModel
    extends SortModel {
        public ProfTcpPortSortModel(Array model) {
            super(model);
        }

        @Override
        public boolean lt(Object first, Object second) {
            if (first == null) {
                return true;
            }
            if (second == null) {
                return false;
            }
            return ((Profile)first)._tcpPort < ((Profile)second)._tcpPort;
        }
    }

    public final class TunnelSortModel
    extends SortModel {
        public TunnelSortModel(Array model) {
            super(model);
        }

        @Override
        public boolean lt(Object first, Object second) {
            if (first == null) {
                return true;
            }
            if (second == null) {
                return false;
            }
            return ((Tunnel)first)._index < ((Tunnel)second)._index;
        }
    }

    class Tunnel
    extends IndexClass {
        Profile _localProfile;
        Profile _remoteProfile;

        Tunnel() {
        }

        public String toString() {
            return Integer.toString(this._index);
        }
    }

    class IndexClass {
        int _index;

        IndexClass() {
        }

        int getIndex() {
            return this._index;
        }
    }

    class Profile
    extends IndexClass {
        SnmpString _ipAddr;
        long _tcpPort;

        Profile() {
        }
    }
}

