/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcip;

import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fcip.FcipWizard;
import com.cisco.dcbu.sm.client.fcip.IpSecurityController;
import com.cisco.dcbu.sm.client.fcip.SwitchInfo;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SelectFcipSwitchPanel
extends WizardPanel {
    static final String[] _Labels = new String[]{"Between Switch:", "and Switch:", null};
    JComboBox[] _fields;
    SnmpPeer _fabricPeer;
    SnmpPeer _initialSw1;
    SnmpPeer _initialSw2;

    public SelectFcipSwitchPanel(JWizard wizard) {
        super("1 of 5: Select Switch Pair", "Please select two MDS switches to be connected via FCIP. Each switch must have an ethernet port connected to IP network to function correctly.", wizard, FcipWizard._ImageFcip);
        this.setModelValue("SWITCH_INFO_A", new SwitchInfo());
        this.setModelValue("SWITCH_INFO_B", new SwitchInfo());
        JComponent[] values = new JComponent[_Labels.length];
        this._fields = new JComboBox[2];
        values[0] = this._fields[0] = new JComboBox();
        values[1] = this._fields[1] = new JComboBox();
        values[2] = new JLabel("");
        JPanel p = new JPanel(new GridBagLayout());
        DialogUtil.buildPanel(p, DialogUtil.buildLabels(_Labels), values);
        this.add((Component)p, "Center");
    }

    public SelectFcipSwitchPanel(SnmpPeer fabricPeer, SnmpPeer peer1, SnmpPeer peer2, JWizard wizard) {
        this(fabricPeer, wizard);
        JPanel p = new JPanel(new GridBagLayout());
        DialogUtil.buildPanel(p, DialogUtil.buildLabels(_Labels), this._fields);
        this.add((Component)p, "Center");
        this._initialSw1 = peer1;
        this._initialSw2 = peer2;
    }

    public SelectFcipSwitchPanel(SnmpPeer fabricPeer, JWizard wizard) {
        this(wizard);
        this._fabricPeer = fabricPeer;
        this.refresh();
    }

    private SnmpPeer[] getFilteredPeers() {
        MgmtDomainIf domain = ClientController.getInstance().getSelectedDomain();
        if (domain.isVsan() || domain.isZone()) {
            return domain.getFabric().getSnmpPeers();
        }
        return domain.getSnmpPeers();
    }

    @Override
    public boolean refresh() {
        this._fields[0].removeAllItems();
        this._fields[1].removeAllItems();
        if (null == this._fabricPeer) {
            Object obPeer = this.getModelValue("SEED_PEER");
            if (null != obPeer && obPeer instanceof SnmpPeer) {
                this._fabricPeer = (SnmpPeer)obPeer;
            } else {
                JOptionPane.showMessageDialog(this, "No seed switch is available.");
                return false;
            }
        }
        SnmpPeer[] allPeers = this.getFilteredPeers();
        for (int i = 0; i < allPeers.length; ++i) {
            Switch sww = ClientController.findFabricSwitchByIpAddress(allPeers[i].getAddress());
            if (sww == null || !sww.isManageable() || !sww.isMDS() || !sww.hasIPSCard() || sww.isN7K()) continue;
            this._fields[0].addItem(allPeers[i]);
            this._fields[1].addItem(allPeers[i]);
        }
        if (null != this._initialSw1) {
            this._fields[0].setSelectedItem(this._initialSw1);
            this._initialSw1 = null;
        } else if (this._fields[0].getItemCount() > 0) {
            this._fields[0].setSelectedIndex(0);
        }
        if (null != this._initialSw2) {
            this._fields[1].setSelectedItem(this._initialSw2);
            this._initialSw2 = null;
        } else if (this._fields[0].getItemCount() > 1) {
            this._fields[0].setSelectedIndex(1);
        }
        return true;
    }

    @Override
    public void doNext() {
        try {
            SwitchInfo sw1Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_A");
            SwitchInfo sw2Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_B");
            SnmpPeer peer1 = (SnmpPeer)this._fields[0].getSelectedItem();
            SnmpPeer peer2 = (SnmpPeer)this._fields[1].getSelectedItem();
            if (peer1 == null || peer2 == null) {
                Util.errorMessage((Component)this.getWizard(), "Please select a valid switch");
                return;
            }
            this.buildSwitchInfo(peer1, this._fields[0], sw1Info);
            this.buildSwitchInfo(peer2, this._fields[1], sw2Info);
            IpSecurityController.getLicense(peer1, sw1Info);
            IpSecurityController.getLicense(peer2, sw2Info);
            if (peer2 == null) {
                return;
            }
            if (peer1.getAddress().equals(peer2.getAddress())) {
                Util.errorMessage((Component)this, "Choose different source and target switches");
            } else {
                Object ob1 = this.getModelValue("PEER_A");
                Object ob2 = this.getModelValue("PEER_B");
                if (null == ob1 || null == ob2) {
                    this.setDataValid(false);
                } else {
                    SnmpPeer ob1pr = (SnmpPeer)ob1;
                    SnmpPeer ob2pr = (SnmpPeer)ob2;
                    if (!ob1pr.getAddress().equals(peer1.getAddress()) || !ob2pr.getAddress().equals(peer2.getAddress())) {
                        this.setDataValid(false);
                    }
                }
                this.setModelValue("PEER_A", peer1);
                this.setModelValue("PEER_B", peer2);
                if (!this.isDataValid()) {
                    if (!this.validateFcipCapability(peer1, peer2)) {
                        return;
                    }
                    this.getIPSECRemoteAddresses(peer1, peer2);
                }
                this.updateSwitchFiconStatus(peer1, peer2);
                super.doNext();
            }
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this, ex);
        }
    }

    private void getIPSECRemoteAddresses(SnmpPeer peer1, SnmpPeer peer2) throws SnmpException {
        StringBuffer ver1 = ((SwitchInfo)this.getModelValue((String)"SWITCH_INFO_A"))._version;
        StringBuffer ver2 = ((SwitchInfo)this.getModelValue((String)"SWITCH_INFO_B"))._version;
        if (ver1 == null || ver2 == null || ver1.toString().compareTo("2.0(0)") < 0 || ver2.toString().compareTo("2.0(0)") < 0) {
            return;
        }
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cicIkeCfgPskRemIdentity").getOid());
        SnmpPDU[] pdu = new SnmpAggregrate().getBulk(new SnmpPeer[]{peer1, peer2}, vbl);
        VarBindList vbl1 = pdu[0].getVariables();
        VarBindList vbl2 = pdu[1].getVariables();
        if (pdu[0].getAddress().equals(peer2.getAddress())) {
            VarBindList tmp = vbl2;
            vbl2 = vbl1;
            vbl1 = tmp;
        }
        this.setModelValue("IKE_AUTH_KEY_A", vbl1);
        this.setModelValue("IKE_AUTH_KEY_B", vbl2);
    }

    private void updateSwitchFiconStatus(SnmpPeer peer1, SnmpPeer peer2) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cficonAutoSaveState").getOid(), 0);
        SnmpPDU[] pdu = new SnmpAggregrate().get(new SnmpPeer[]{peer1, peer2}, vbl);
        this.setModelValue("FICON_ENABLED", pdu[0].getVar(0).getType() != 5 && pdu[1].getVar(0).getType() != 5);
    }

    private boolean validateFcipCapability(SnmpPeer peer1, SnmpPeer peer2) throws SnmpException {
        Switch sw1 = ClientController.findFabricSwitchByIpAddress(peer1.getAddress());
        Switch sw2 = ClientController.findFabricSwitchByIpAddress(peer2.getAddress());
        boolean[] featureSupportInfo1 = new boolean[2];
        boolean[] featureSupportInfo2 = new boolean[2];
        if (sw1 == null) {
            this.getCardSupportInfo(this.getVendorType(peer1), featureSupportInfo1);
        } else {
            this.getCardSupportInfo(sw1, featureSupportInfo1);
        }
        if (sw2 == null) {
            this.getCardSupportInfo(this.getVendorType(peer2), featureSupportInfo2);
        } else {
            this.getCardSupportInfo(sw2, featureSupportInfo2);
        }
        if (!featureSupportInfo1[0]) {
            Util.errorMessage((Component)this.getWizard(), "Switch " + peer1 + " does not have IPS card.");
            return false;
        }
        if (!featureSupportInfo2[0]) {
            Util.errorMessage((Component)this.getWizard(), "Switch " + peer2 + " does not have IPS card.");
            return false;
        }
        SwitchInfo sw1Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_A");
        sw1Info._enableFcip = !IpSecurityController.isFcipFeatureEnabled(peer1);
        SwitchInfo sw2Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_B");
        sw2Info._enableFcip = !IpSecurityController.isFcipFeatureEnabled(peer2);
        this.setModelValue("SECURITY_CAPABLE", featureSupportInfo2[1] && featureSupportInfo1[1]);
        return true;
    }

    private void getCardSupportInfo(VarBindList vbl, boolean[] data) {
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVar var = vbl.getVb(i).getVar();
            if (var.getType() != 6) continue;
            int[] oid = vbl.getVb(i).getOid().getValue();
            if (oid[oid.length - 2] != 3) break;
            if (oid[oid.length - 1] <= 21) continue;
            if (oid[oid.length - 1] > 85) break;
            int[] vendorType = ((SnmpOID)var).getValue();
            boolean bl = data[1] = vendorType[vendorType.length - 1] == 22 || vendorType[vendorType.length - 1] == 27 || vendorType[vendorType.length - 1] == 39 || vendorType[vendorType.length - 1] == 41 || vendorType[vendorType.length - 1] == 68 || vendorType[vendorType.length - 1] == 44;
            if (data[1]) {
                data[0] = data[1];
                break;
            }
            if (data[0]) continue;
            data[0] = FRUConstants.hasGigEPorts(vendorType[vendorType.length - 1]);
        }
    }

    private VarBindList getVendorType(SnmpPeer peer) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("entPhysicalVendorType").getOid());
        int[][] oids = new int[][]{MibNode.get("entPhysicalVendorType").getOid()};
        return SnmpFetch.getBulk(peer, (int[][])oids, new int[]{21}, 64).getVariables();
    }

    private void getCardSupportInfo(Switch sw, boolean[] data) {
        Card[] cards = sw.getCards();
        if (cards != null) {
            for (int i = 0; i < cards.length; ++i) {
                if (cards[i] == null || cards[i].getType() != 22 && cards[i].getType() != 27 && cards[i].getType() != 41 && cards[i].getType() != 39 && cards[i].getType() != 44 && cards[i].getType() != 68) continue;
                data[1] = true;
                data[0] = true;
                return;
            }
        }
        data[0] = sw.hasIPSCard();
    }

    private void buildSwitchInfo(SnmpPeer peer, JComboBox cmb, SwitchInfo swInfo) {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (swInfo._version != null && sw != null) {
            swInfo._version.setLength(0);
            swInfo._version.append(sw.getVersion());
            swInfo._mdsModel = sw.getModelType();
        }
    }
}

