/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcip;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.PerspectiveIf;
import com.cisco.dcbu.lib.ui.PerspectiveManager;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.fcip.EtherPort;
import com.cisco.dcbu.sm.client.fcip.FcipWizard;
import com.cisco.dcbu.sm.client.fcip.IpSecurityController;
import com.cisco.dcbu.sm.client.fcip.SwitchInfo;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectGigPortPanel
extends WizardPanel
implements ActionListener,
ListSelectionListener {
    JList _gigPrtLst1;
    JList _gigPrtLst2;
    JLabel _fromPort;
    JLabel _toPort;
    Array _ether1;
    Array _ether2;
    EtherPort[] _selEther = new EtherPort[2];
    boolean _panelCreated = false;
    private JCheckBox _security;
    private JCheckBox _setJumboMtu;
    private JPasswordField _ikeKey;
    private JLabel _ikeKeyLabel;
    final SnmpOID _phyOid = new SnmpOID(MibNode.get("ciiIPIfAddressPrefixLength").getOid());
    final SnmpOID _ifOid = new SnmpOID(MibNode.get("ifOperStatus").getOid());
    final SnmpOID _ifAdminOid = new SnmpOID(MibNode.get("ifAdminStatus").getOid());
    final SnmpOID _pchMemLstOid = new SnmpOID(MibNode.get("portChannelMemberList").getOid());

    private SelectGigPortPanel() {
        this((JWizard)null);
    }

    public SelectGigPortPanel(JWizard wizard) {
        super("2 of 5: Select Ethernet Ports", "Please select ethernet port pair to be used for FCIP link. Security can be enforced for unconfigured 14+2 & 18+4 ethernet ports.", wizard, FcipWizard._ImageFcip);
        this._gigPrtLst1 = new JList(new DefaultListModel());
        this._gigPrtLst1.addListSelectionListener(this);
        this._gigPrtLst1.setSelectionMode(0);
        this._gigPrtLst2 = new JList(new DefaultListModel());
        this._gigPrtLst2.addListSelectionListener(this);
        this._gigPrtLst2.setSelectionMode(0);
        this._fromPort = new JLabel();
        this._toPort = new JLabel();
    }

    void createPanel() {
        JScrollPane scp1 = new JScrollPane(this._gigPrtLst1);
        JScrollPane scp2 = new JScrollPane(this._gigPrtLst2);
        JPanel p1 = this.buildPanel(this._fromPort, scp1);
        JPanel p2 = this.buildPanel(this._toPort, scp2);
        JPanel pnl1 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = DialogUtil.getInsets();
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        pnl1.add((Component)p1, gbc);
        gbc.gridx = 2;
        pnl1.add((Component)p2, gbc);
        this.add((Component)pnl1, "Center");
        JPanel secPanel = new JPanel(new BorderLayout());
        this._security = new JCheckBox("Enforce IPSEC Security");
        this._security.addActionListener(this);
        this._ikeKey = new JPasswordField(15);
        this._ikeKeyLabel = new JLabel("IKE Auth Key:");
        secPanel.add((Component)this._security, "West");
        secPanel.add((Component)DialogUtil.buildPanel(new JComponent[]{this._ikeKeyLabel}, new JComponent[]{this._ikeKey}), "East");
        this._setJumboMtu = new JCheckBox("Use Large MTU Size (Jumbo Frames)");
        this._setJumboMtu.setSelected(false);
        secPanel.add((Component)this._setJumboMtu, "South");
        this.add((Component)secPanel, "South");
    }

    JPanel buildPanel(JComponent cmp1, JComponent cmp2) {
        JPanel p = new JPanel(new GridBagLayout());
        JComponent[] fields = new JComponent[]{cmp1, cmp2};
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = DialogUtil.getInsets();
        gbc1.gridwidth = 1;
        gbc1.anchor = 17;
        gbc1.weightx = 1.0;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = 2;
        DialogUtil.extend(gbc1, p, fields[0]);
        gbc1.gridy = 1;
        gbc1.fill = 1;
        gbc1.weighty = 1.0;
        p.add((Component)fields[1], gbc1);
        return p;
    }

    @Override
    public boolean refresh() {
        try {
            Object ob;
            boolean supportsSecurity;
            int i;
            if (this._security != null) {
                this._security.setEnabled(false);
                this._security.setSelected(false);
            }
            SnmpPeer peer1 = (SnmpPeer)this.getModelValue("PEER_A");
            SnmpPeer peer2 = (SnmpPeer)this.getModelValue("PEER_B");
            String desc = "Please select ethernet ports to be used in FCIP ISL between " + peer1 + " and " + peer2 + ".  Down ports should be enabled to function correctly. ";
            PerspectiveIf view = PerspectiveManager.getInstance().getView();
            if (view.isVisible("feature", "cpt")) {
                desc = desc + "Security can be enforced for unconfigured 14+2, 18+4, 9250i & SSN16 ethernet ports.";
            }
            this.setDescription(desc);
            this._fromPort.setText(peer1 + ":");
            this._toPort.setText(peer2 + ":");
            this._ether1 = this.getEtherPorts(peer1);
            this._ether2 = this.getEtherPorts(peer2);
            if (this._ether1.size() == 0 || this._ether2.size() == 0) {
                StringBuffer bf = new StringBuffer("No IPS/GE ports are available on ");
                if (this._ether1.size() == 0) {
                    bf.append(peer1);
                    bf.append(" ");
                }
                if (this._ether2.size() == 0) {
                    bf.append(peer2);
                }
                throw new SnmpException(bf.toString());
            }
            DefaultListModel listModel = (DefaultListModel)this._gigPrtLst1.getModel();
            listModel.removeAllElements();
            int maxi = this._ether1.size();
            for (i = 0; i < maxi; ++i) {
                listModel.addElement(this._ether1.elementAt(i));
            }
            listModel = (DefaultListModel)this._gigPrtLst2.getModel();
            listModel.removeAllElements();
            maxi = this._ether2.size();
            for (i = 0; i < maxi; ++i) {
                listModel.addElement(this._ether2.elementAt(i));
            }
            this._gigPrtLst1.setSelectedIndex(0);
            this._gigPrtLst2.setSelectedIndex(0);
            if (!this._panelCreated) {
                this.createPanel();
                this._panelCreated = true;
            }
            boolean bl = supportsSecurity = (ob = this.getModelValue("SECURITY_CAPABLE")) != null && ob instanceof Boolean && (Boolean)ob != false;
            if (!view.isVisible("feature", "cpt")) {
                supportsSecurity = false;
            }
            this._security.setEnabled(supportsSecurity);
            this._security.setVisible(supportsSecurity);
            this._ikeKey.setText("");
            this._ikeKey.setEnabled(supportsSecurity);
            this._ikeKey.setVisible(supportsSecurity);
            this._ikeKeyLabel.setEnabled(supportsSecurity);
            this._ikeKeyLabel.setVisible(supportsSecurity);
            if (supportsSecurity) {
                this.buildSecurityParams(-1, -1, null);
                this.setIkeControls(false);
            }
            this.repaint();
            return true;
        }
        catch (SnmpException ex) {
            this.doPrevious();
            Util.errorMessage((Component)this, ex);
            return false;
        }
    }

    private void setIkeControls(boolean secChkBoxEvent) {
        if (this._ikeKey == null) {
            return;
        }
        EtherPort prt1 = (EtherPort)this._gigPrtLst1.getSelectedValue();
        EtherPort prt2 = (EtherPort)this._gigPrtLst2.getSelectedValue();
        if (prt1 == null || prt2 == null) {
            this._ikeKey.setEnabled(false);
            this._ikeKeyLabel.setEnabled(false);
            return;
        }
        Boolean secCapable = (Boolean)this.getModelValue("SECURITY_CAPABLE");
        VarBindList vbl1 = (VarBindList)this.getModelValue("IKE_AUTH_KEY_A");
        VarBindList vbl2 = (VarBindList)this.getModelValue("IKE_AUTH_KEY_B");
        boolean cansetIkeAuthKey = prt1._address == null || prt2._address == null || vbl1 == null || vbl2 == null || vbl1.size() == 0 || vbl2.size() == 0;
        IpSecurityController con = (IpSecurityController)this.getModelValue("SECURITY_CONTROLLER");
        if (con != null) {
            con.updateGigiPortVbl(prt1._index, prt2._index);
            try {
                con.updateCryptoMapSet();
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this.getWizard(), ex.getMessage());
            }
        }
        boolean canSetIPSECParam = true;
        if (!cansetIkeAuthKey) {
            boolean bl = cansetIkeAuthKey = !FcipWizard.hasIKEAuthKey(vbl1, prt2._address) || !FcipWizard.hasIKEAuthKey(vbl2, prt1._address);
        }
        if (con != null) {
            SnmpPeer peer2;
            SnmpPeer peer1 = (SnmpPeer)this.getModelValue("PEER_A");
            boolean bl = canSetIPSECParam = !con.isSecure(peer1, peer2 = (SnmpPeer)this.getModelValue("PEER_B"));
        }
        if (!secChkBoxEvent) {
            boolean isLnkAlreadySecured = !cansetIkeAuthKey && secCapable != false && !canSetIPSECParam;
            this.getWizard().setStatus(isLnkAlreadySecured ? "ACL,IKE,IPSEC Configured" : (cansetIkeAuthKey ? "" : "IKE Configured"));
            this._security.setSelected(isLnkAlreadySecured);
        }
        this._ikeKey.setEnabled(cansetIkeAuthKey && secCapable != false && this._security.isSelected());
        this._ikeKey.setVisible(cansetIkeAuthKey && secCapable != false);
        this._ikeKeyLabel.setEnabled(cansetIkeAuthKey && secCapable != false && this._security.isSelected());
        this._ikeKeyLabel.setVisible(cansetIkeAuthKey && secCapable != false);
    }

    @Override
    public void doNext() {
        try {
            boolean security;
            String password;
            if (this._ikeKey.isEnabled() && ((password = new String(this._ikeKey.getPassword()).trim()).length() < 1 || password.length() > 128)) {
                throw new SnmpException("Invalid IKE Auth key. Length should be 1-128.");
            }
            int sel = this._gigPrtLst1.getSelectedIndex();
            if (-1 == sel) {
                throw new SnmpException("Please select an Ethernet port");
            }
            EtherPort prtNew1 = (EtherPort)this._ether1.elementAt(sel);
            sel = this._gigPrtLst2.getSelectedIndex();
            if (-1 == sel) {
                throw new SnmpException("Please select an Ethernet port");
            }
            EtherPort prtNew2 = (EtherPort)this._ether2.elementAt(sel);
            Object ob = this.getModelValue("ETHER_PORTS");
            if (null == ob) {
                this.setDataValid(false);
            } else {
                EtherPort[] prtOri = (EtherPort[])ob;
                if (!prtOri[0].equals(prtNew1) || !prtOri[1].equals(prtNew2)) {
                    this.setDataValid(false);
                }
            }
            this._selEther[0] = prtNew1;
            this._selEther[1] = prtNew2;
            this.setModelValue("ETHER_PORTS", this._selEther);
            SwitchInfo sw1Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_A");
            SwitchInfo sw2Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_B");
            SnmpPeer peer1 = (SnmpPeer)this.getModelValue("PEER_A");
            SnmpPeer peer2 = (SnmpPeer)this.getModelValue("PEER_B");
            boolean bl = security = this._security.isEnabled() && this._security.isSelected();
            if (!this.validateLicense(peer1, sw1Info, security, prtNew1) || !this.validateLicense(peer2, sw2Info, security, prtNew2)) {
                return;
            }
            Boolean cachedSec = (Boolean)this.getModelValue("APPLY_SECURITY");
            IpSecurityController con = (IpSecurityController)this.getModelValue("SECURITY_CONTROLLER");
            if (this._security.isEnabled() && this._security.isSelected()) {
                if (!this.ValidateValidPortsForSecurity(prtNew1, prtNew2)) {
                    return;
                }
                if (con == null) {
                    this.buildSecurityParams(-1, -1, null);
                }
                if (this._ikeKey.isEnabled() && new String(this._ikeKey.getPassword()).trim().length() == 0) {
                    Util.errorMessage((Component)this.getWizard(), "Please specify valid Authorization key");
                    return;
                }
                con.updateIkeKey(this._ikeKey.isEnabled() ? new String(this._ikeKey.getPassword()).trim() : null);
                con.updateGigiPortVbl(this._selEther[0]._index, this._selEther[1]._index);
                if (!this.ValidateSecurity(prtNew1._address, prtNew2._address)) {
                    return;
                }
                this.setDataValid(false);
            }
            if (cachedSec != Boolean.valueOf(this._security.isEnabled() && this._security.isSelected())) {
                this.setDataValid(false);
            }
            this.setModelValue("APPLY_SECURITY", this._security.isEnabled() && this._security.isSelected());
            this.setModelValue("IKE_KEY", new String(this._ikeKey.getPassword()).trim());
            this.setModelValue("MTU", this._setJumboMtu.isSelected());
            super.doNext();
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this, ex);
        }
    }

    private boolean validateLicense(SnmpPeer peer, SwitchInfo swInfo, boolean security, EtherPort selPort) {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        Card crd = sw.getCard(sw.ifIndex2Card(selPort._index) + 1);
        String LicenseMsg = "";
        switch (crd.getType()) {
            case 6: {
                if (swInfo.isIPS8Licensed() || swInfo.isGraceIPS8Licensed()) break;
                LicenseMsg = "IPS 8";
                break;
            }
            case 24: {
                if (swInfo.isIPS4Licensed() || swInfo.isGraceIPS4Licensed()) break;
                LicenseMsg = "IPS 4";
                break;
            }
            case 22: 
            case 27: {
                if (swInfo.isIPS142Licensed() || swInfo.isGraceIPS142Licensed()) break;
                LicenseMsg = "IPS 14+2";
                break;
            }
            case 39: 
            case 41: {
                if (crd.getSlotId() == 1 && crd.getType() == 41 || swInfo.isIPS184Licensed() || swInfo.isGraceIPS184Licensed()) break;
                LicenseMsg = "IPS 18+4";
                break;
            }
            case 44: {
                if (swInfo.isIPSSSN16Licensed() || swInfo.isGraceIPSSSN16Licensed()) break;
                LicenseMsg = "SAN_EXTN_OVER_IP_SSN16";
            }
        }
        if (security && !swInfo.isEnterpriseLicensed() && !swInfo.isGraceEnterpriseLicensed()) {
            if (LicenseMsg.length() > 0) {
                LicenseMsg = ", ";
            }
            LicenseMsg = "Enterprise";
        }
        if (LicenseMsg.length() > 0) {
            return JOptionPane.showConfirmDialog((JFrame)SwingUtilities.windowForComponent(this.getWizard()), "License for " + LicenseMsg + " is required " + " on Switch " + sw + " for enabling FCIP" + (security ? " and Security" : "") + ".\n" + "Continue?", "No License", 0, 2) == 0;
        }
        return true;
    }

    Array getEtherPorts(SnmpPeer peer) throws SnmpException {
        Array<EtherPort> ether = new Array<EtherPort>();
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        int phyoidlen = this._phyOid.getValue().length;
        VarBindList etherVarBnd = new VarBindList();
        etherVarBnd.add(new SnmpVarBind(this._ifOid));
        etherVarBnd.add(new SnmpVarBind(this._ifAdminOid));
        VarBindList etherAr = SnmpFetch.getBulk(peer, etherVarBnd).getVariables();
        VarBindList etherAddVarBnd = new VarBindList();
        etherAddVarBnd.add(new SnmpVarBind(this._phyOid));
        VarBindList etherAddAr = SnmpFetch.getBulk(peer, etherAddVarBnd).getVariables();
        VarBindList etherPchAddVarBnd = new VarBindList();
        etherPchAddVarBnd.add(new SnmpVarBind(this._pchMemLstOid));
        VarBindList etherPchAddAr = SnmpFetch.getBulk(peer, etherPchAddVarBnd).getVariables();
        int MAXI = etherAr.size();
        for (int i = 0; i < MAXI; i += 2) {
            SnmpVarBind vbnd = etherAr.getVb(i);
            int[] ifOid = vbnd.getOid().getValue();
            int ifIndex = ifOid[ifOid.length - 1];
            int type = IfIndexUtil.getType(ifIndex);
            int[] ports = null;
            if (type == 4) {
                boolean addPchnl = false;
                int MAXP = etherPchAddAr.size();
                for (int p = 0; p < MAXP; ++p) {
                    SnmpVarBind pcVbnd = etherPchAddAr.getVb(p);
                    int[] pchOid = pcVbnd.getOid().getValue();
                    if (pchOid[pchOid.length - 1] != (ifIndex & 0xFF) + 1) continue;
                    SnmpVar theVar = pcVbnd.getVar();
                    if (theVar.getType() != 4) {
                        addPchnl = false;
                        break;
                    }
                    ports = SnmpIntList.valueOf(((SnmpString)theVar).getValue());
                    if (ports.length <= 0 || IfIndexUtil.getType(ports[0]) != 2) break;
                    addPchnl = true;
                    break;
                }
                if (!addPchnl) {
                    continue;
                }
            } else if (type != 2) continue;
            boolean isAnyAddress = false;
            int MAXJ = etherAddAr.size();
            for (int j = 0; j < MAXJ; ++j) {
                vbnd = etherAddAr.getVb(j);
                int[] oid = vbnd.getOid().getValue();
                int ifInd = oid[phyoidlen];
                if (ifInd != ifIndex) continue;
                byte[] add = new byte[oid.length - phyoidlen - 3];
                int MAXK = add.length;
                for (int k = 0; k < MAXK; ++k) {
                    add[k] = (byte)oid[phyoidlen + 3 + k];
                }
                if (add.length == 16 && oid[phyoidlen + 3] == 254 && oid[phyoidlen + 4] == 128) continue;
                EtherPort ethPrt = new EtherPort(sw);
                ethPrt._index = ifIndex;
                ethPrt._operStatus = etherAr.intValue(i);
                ethPrt._adminStatus = etherAr.intValue(i + 1);
                ethPrt._address = add;
                ethPrt._mask = (int)((SnmpGauge)vbnd.getVar()).getValue();
                ethPrt._pchnlMems = ports;
                ether.addElement(ethPrt);
                isAnyAddress = true;
            }
            if (isAnyAddress) continue;
            EtherPort ethPrt = new EtherPort(sw);
            ethPrt._index = ifIndex;
            ethPrt._operStatus = etherAr.intValue(i);
            ethPrt._adminStatus = etherAr.intValue(i + 1);
            ether.addElement(ethPrt);
        }
        return ether;
    }

    private boolean buildSecurityParams(int ifIndex1, int ifIndex2, String ikeKeyVal) throws SnmpException {
        boolean supportsSecurity;
        this.setModelValue("SECURITY_CONTROLLER", null);
        SnmpPeer peer1 = (SnmpPeer)this.getModelValue("PEER_A");
        SnmpPeer peer2 = (SnmpPeer)this.getModelValue("PEER_B");
        Object ob = this.getModelValue("SECURITY_CAPABLE");
        boolean bl = supportsSecurity = ob != null && ob instanceof Boolean && (Boolean)ob != false;
        if (peer1 != null && peer2 != null && supportsSecurity) {
            SwitchInfo sw2Info;
            SwitchInfo sw1Info;
            if (ikeKeyVal != null && this._ikeKey.isEnabled() && new String(this._ikeKey.getPassword()).trim().length() == 0) {
                Util.errorMessage((Component)this.getWizard(), "Please specify valid Authorization key");
                return false;
            }
            VarBindList remotePorts1 = (VarBindList)this.getModelValue("IKE_AUTH_KEY_A");
            VarBindList remotePorts2 = (VarBindList)this.getModelValue("IKE_AUTH_KEY_B");
            IpSecurityController con = new IpSecurityController(peer1, peer2, ifIndex1, ifIndex2, ikeKeyVal, remotePorts1, remotePorts2);
            if (!IpSecurityController.isIpSecFeatureEnabled(peer1)) {
                sw1Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_A");
                sw1Info._enableIpSec = true;
            }
            if (!IpSecurityController.isIKEFeatureEnabled(peer1)) {
                sw1Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_A");
                sw1Info._enableIKE = true;
            }
            if (!IpSecurityController.isIpSecFeatureEnabled(peer2)) {
                sw2Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_B");
                sw2Info._enableIpSec = true;
            }
            if (!IpSecurityController.isIKEFeatureEnabled(peer2)) {
                sw2Info = (SwitchInfo)this.getModelValue("SWITCH_INFO_B");
                sw2Info._enableIKE = true;
            }
            con.updateCryptoMapData();
            this.setModelValue("SECURITY_CONTROLLER", con);
        }
        return true;
    }

    private boolean ValidateSecurity(byte[] add1, byte[] add2) {
        StringBuffer errMsg;
        String key = new String(this._ikeKey.getPassword()).trim();
        if (this._ikeKey.isEnabled() && (key == null || key.length() == 0)) {
            Util.errorMessage((Component)this.getWizard(), "Please specify valid IKE key");
            return false;
        }
        IpSecurityController con = (IpSecurityController)this.getModelValue("SECURITY_CONTROLLER");
        if (con != null && (errMsg = con.validateCryproMapEntries(add1, add2)).length() > 0) {
            Util.errorMessage((Component)this.getWizard(), "The selected ether ports are already secured with inconsistent parameters.\nPlease see log for more information.");
            DefaultLogger._DefLogger.debug((Object)errMsg.toString());
            return false;
        }
        return true;
    }

    private boolean ValidateValidPortsForSecurity(EtherPort port1, EtherPort port2) {
        SnmpPeer peer1 = (SnmpPeer)this.getModelValue("PEER_A");
        SnmpPeer peer2 = (SnmpPeer)this.getModelValue("PEER_B");
        ClientController.getInstance();
        Switch sw1 = ClientController.findFabricSwitchByIpAddress(peer1.getAddress());
        ClientController.getInstance();
        Switch sw2 = ClientController.findFabricSwitchByIpAddress(peer2.getAddress());
        if (sw1 != null && sw2 != null) {
            Card card1 = sw1.getCard(sw1.ifIndex2Card(port1._index) + 1);
            Card card2 = sw2.getCard(sw2.ifIndex2Card(port2._index) + 1);
            StringBuffer errBuf = new StringBuffer();
            if (card1.getType() != 22 && card1.getType() != 27 && card1.getType() != 39 && card1.getType() != 41 && card1.getType() != 44 && card1.getType() != 68) {
                errBuf.append(sw1.ifIndexToName(port1._index) + "-" + sw1 + "\n");
            }
            if (card2.getType() != 22 && card2.getType() != 27 && card2.getType() != 39 && card2.getType() != 41 && card2.getType() != 44 && card2.getType() != 68) {
                errBuf.append(sw2.ifIndexToName(port2._index) + "-" + sw2 + "\n");
            }
            if (errBuf.length() > 0) {
                Util.errorMessage((Component)this.getWizard(), "The port(s) " + errBuf.toString() + " do not support IP Security feature.");
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object ob = e.getSource();
        if (ob == this._security) {
            this.setIkeControls(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.setIkeControls(false);
            this.setDataValid(false);
        }
    }
}

