/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.fcoe.view;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.fcoe.model.VEVLANVSANTableModel;
import com.cisco.dcbu.sm.client.fcoe.view.VLANVSANMappingTable;
import com.cisco.dcbu.sm.client.fcoe.view.VLANVSANMappingView;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class VEVLANVSANMappingView
extends VLANVSANMappingView {
    private static final long serialVersionUID = 7014206905121004472L;
    protected AbstractSwitch[] _selectedSwitches;
    private JLabel _selSwitch1Lbl;
    private JLabel _selSwitch2Lbl;
    private VEVLANVSANTableModel _veVlanVsanTableModel;

    @Override
    protected JPanel createSummaryPanel() {
        JPanel sumaryPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        JLabel lbl = new JLabel("Selected Switch 1: ");
        lbl.setHorizontalAlignment(4);
        sumaryPanel.add((Component)lbl, gbc);
        this._selSwitch1Lbl = new JLabel();
        this._selSwitch1Lbl.setHorizontalAlignment(2);
        Font lblFont = this._selSwitch1Lbl.getFont().deriveFont(1);
        this._selSwitch1Lbl.setFont(lblFont);
        ++gbc.gridx;
        gbc.anchor = 21;
        sumaryPanel.add((Component)this._selSwitch1Lbl, gbc);
        lbl = new JLabel("Selected Switch 2: ");
        lbl.setHorizontalAlignment(4);
        ++gbc.gridx;
        gbc.anchor = 13;
        sumaryPanel.add((Component)lbl, gbc);
        this._selSwitch2Lbl = new JLabel();
        this._selSwitch2Lbl.setHorizontalAlignment(2);
        lblFont = this._selSwitch1Lbl.getFont().deriveFont(1);
        this._selSwitch2Lbl.setFont(lblFont);
        ++gbc.gridx;
        gbc.anchor = 17;
        sumaryPanel.add((Component)this._selSwitch2Lbl, gbc);
        return sumaryPanel;
    }

    @Override
    protected VLANVSANMappingTable createVlanVsanMappingTable() {
        String[] vars = new String[]{"cfcoeVLANOperState", "cfcoeVLANOperState", "cfcoeVLANOperState"};
        this._veVlanVsanTableModel = new VEVLANVSANTableModel(vars);
        this._vlanVsanMappingTable = new VLANVSANMappingTable(this._veVlanVsanTableModel);
        this._vlanVsanMappingTable.getSelectionModel().addListSelectionListener(this);
        return this._vlanVsanMappingTable;
    }

    @Override
    protected void addNewRowToTable() {
        this._veVlanVsanTableModel.createNewRow();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.getNewRowDataThread().start();
    }

    @Override
    protected Thread getTableDataThread() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VEVLANVSANMappingView vEVLANVSANMappingView = VEVLANVSANMappingView.this;
                synchronized (vEVLANVSANMappingView) {
                    if (VEVLANVSANMappingView.this._selectedSwitches != null) {
                        try {
                            if (DefaultLogger._DefLogger.isDebugEnabled()) {
                                DefaultLogger._DefLogger.debug((Object)"VEVLANVSANMappingView : getDataThread() Getting the VLAN VSAN Mappings.");
                            }
                            VEVLANVSANMappingView.this._veVlanVsanTableModel.getTableVars(VEVLANVSANMappingView.this._selectedSwitches);
                            VEVLANVSANMappingView.this._veVlanVsanTableModel.fireTableDataChanged();
                        }
                        catch (SnmpException ex) {
                            JOptionPane.showMessageDialog(VEVLANVSANMappingView.this, ex.getMessage());
                        }
                    }
                    VEVLANVSANMappingView.this._delButton.setEnabled(false);
                    VEVLANVSANMappingView.this._refreshComplete = true;
                    Util.setBusy(false, VEVLANVSANMappingView.this);
                    VEVLANVSANMappingView.this.notifyAll();
                }
            }
        };
        return new Thread(runnable);
    }

    @Override
    protected Thread getNewRowDataThread() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Util.setBusy(true, VEVLANVSANMappingView.this);
                ArrayList<Integer> vsanList = VEVLANVSANMappingView.this.getMappableVsans();
                VEVLANVSANMappingView.this._vlanVsanMappingTable.setVsanCmbValues(vsanList);
                VEVLANVSANMappingView.this._vlanVsanMappingTable.setVlanCmbValues(vsanList);
                Util.setBusy(false, VEVLANVSANMappingView.this);
            }
        };
        return new Thread(runnable);
    }

    public boolean insertNewVlanVsanMapping(AbstractSwitch selectedSwitch) {
        int[] intInsertArr;
        if (DefaultLogger._DefLogger.isDebugEnabled()) {
            DefaultLogger._DefLogger.debug((Object)"VEVLANVSANMappingView : insertNewVlanVsanMapping() Trying to create new Vlan Vsan mappings on the switch.");
        }
        if (this._vlanVsanMappingTable.isEditing()) {
            this._vlanVsanMappingTable.getCellEditor().stopCellEditing();
        }
        if ((intInsertArr = this.getNewRows()).length > 0) {
            HashSet<Integer> newVlans = new HashSet<Integer>();
            HashSet<Integer> newVsans = new HashSet<Integer>();
            HashSet<Integer> mappedVlans = this._veVlanVsanTableModel.getMappedVlans();
            HashSet<Integer> mappedVsans = this._veVlanVsanTableModel.getMappedVsans();
            HashMap<Integer, Integer> newMappings = new HashMap<Integer, Integer>();
            for (int count = 0; count < intInsertArr.length; ++count) {
                Integer vsan = this._veVlanVsanTableModel.getVSANId(intInsertArr[count]);
                Integer vlan = this._veVlanVsanTableModel.getVLANId(intInsertArr[count]);
                if (!this.isValidVlanVsan(vlan, vsan, newVlans, newVsans, mappedVlans, mappedVsans)) {
                    return false;
                }
                newVlans.add(vlan);
                newVsans.add(vsan);
                newMappings.put(vlan, vsan);
            }
            try {
                if (DefaultLogger._DefLogger.isDebugEnabled()) {
                    DefaultLogger._DefLogger.debug((Object)"VEVLANVSANMappingView : insertNewVlanVsanMapping() Creating the new VLAN VSAN mappings.");
                }
                this._veVlanVsanTableModel.createMappings(selectedSwitch, newMappings);
            }
            catch (SnmpException ex) {
                Util.errorMessage(this.getWizard(), "Failed to create VLAN-VSAN Mapping on switch " + selectedSwitch.getSysName() + ". Reason : " + ex.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public ArrayList<Integer> getMappableVsans() {
        if (DefaultLogger._DefLogger.isDebugEnabled()) {
            DefaultLogger._DefLogger.debug((Object)"VEVLANVSANMappingView : getMappableVsans() Getting all the vsans from switch which are not mapped.");
        }
        TreeSet<Integer> vsanIds = this._veVlanVsanTableModel.getVsans(this._selectedSwitches);
        HashSet<Integer> vsans = this._veVlanVsanTableModel.getMappedVsans();
        ArrayList<Integer> filteredVsanList = new ArrayList<Integer>();
        if (vsanIds != null) {
            filteredVsanList.addAll(vsanIds);
            if (vsans != null) {
                filteredVsanList.removeAll(vsans);
            }
        }
        return filteredVsanList;
    }

    @Override
    public VEVLANVSANTableModel getTableModel() {
        return this._veVlanVsanTableModel;
    }

    public void setTableModel(VEVLANVSANTableModel tableModel) {
        this._vlanVsanMappingTable.setModel(tableModel, false);
        this._veVlanVsanTableModel = tableModel;
    }

    @Override
    protected void updateSummaryInfo() {
        AbstractSwitch sw1 = this._selectedSwitches[0];
        AbstractSwitch sw2 = this._selectedSwitches[1];
        if (this._selSwitch1Lbl != null) {
            this._selSwitch1Lbl.setText(sw1.getName());
        }
        if (this._selSwitch2Lbl != null) {
            this._selSwitch2Lbl.setText(sw2.getName());
        }
    }

    public void setSwitches(AbstractSwitch[] selectedSwitches) {
        this._selectedSwitches = selectedSwitches;
    }

    public boolean insertNewVlanVsanMapping() {
        int[] intInsertArr;
        if (this._vlanVsanMappingTable.isEditing()) {
            this._vlanVsanMappingTable.getCellEditor().stopCellEditing();
        }
        if ((intInsertArr = this.getNewRows()).length > 0) {
            boolean insertStatus;
            boolean bl = insertStatus = this.insertNewVlanVsanMapping(this._selectedSwitches[0]) && this.insertNewVlanVsanMapping(this._selectedSwitches[1]);
            if (insertStatus) {
                this.refresh();
            }
            return insertStatus;
        }
        return true;
    }
}

