/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.jnm.LogWriter;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.map.client.TopologyWindow;
import com.cisco.dcbu.lib.mds.PortSetEditor;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.sm.client.ClientContext;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.ISLContext;
import com.cisco.dcbu.sm.client.SM;
import com.cisco.dcbu.sm.client.SwitchContext;
import com.cisco.dcbu.sm.client.event.EventLog;
import com.cisco.dcbu.sm.client.gui.AddFabricDialog;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.DockableFabricFrameListener;
import com.cisco.dcbu.sm.client.gui.PhysicalTree;
import com.cisco.dcbu.sm.client.gui.SanMapListener;
import com.cisco.dcbu.sm.client.gui.SmCommandDispatcher;
import com.cisco.dcbu.sm.client.gui.SmLogWindow;
import com.cisco.dcbu.sm.client.gui.TreeCommand;
import com.cisco.dcbu.sm.client.gui.UIActions;
import com.cisco.dcbu.sm.client.gui.UIControls;
import com.cisco.dcbu.sm.client.logicaltree.VsanTree;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.MapMenus;
import com.cisco.dcbu.sm.client.map.MenuFactory;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Lan;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandMenuBar;
import com.jidesoft.action.DefaultDockableBarManager;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarHolder;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.status.MemoryStatusBarItem;
import com.jidesoft.status.StatusBar;
import com.jidesoft.status.TimeStatusBarItem;
import com.jidesoft.swing.ContentContainer;
import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.swing.LayoutPersistenceManager;
import com.jidesoft.utils.Lm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;

public class BrowserFrame
extends JFrame
implements DockableHolder,
DockableBarHolder {
    private static final String DEFAULT_TABLE_TITLE = "Info";
    private static final String[][] _TabAttr = new String[][]{{"Map", "icons/topography.gif", "Fabric Topology"}, {"Log", "icons/log16.gif", "Error Messages"}};
    private static final String USERS_ICON = "icons/users.png";
    private static final int MAP_WINDOW = 0;
    private static final int LOG_WINDOW = 1;
    private static final String DEFAULT_PROFILE_KEY = "CISCO FM JIDE PROFILE";
    private static final int MAP_DOCK_SIDE = 2;
    private static final int MAP_INIT_SIDE = 4;
    private static BrowserFrame _Instance;
    private static DefaultDockingManager _dockingManager;
    private static DockableBarManager _dockableBarManager;
    private static boolean dataLoaded;
    private static Object _InitObj;
    public static Dimension _PreferredSize;
    private static Dimension leftPanelDim;
    private static Dimension tablePanelDim;
    private static Dimension mapAreaDim;
    private PhysicalTree _treeDisplayed;
    private PhysicalTree _dcTree;
    private PhysicalTree _lanTree;
    private PhysicalTree _sanTree;
    private DataView _dataView;
    private LabelStatusBarItem _status;
    private LabelStatusBarItem _longTermStatus;
    private static LabelStatusBarItem _serverFailure;
    private static LabelStatusBarItem _loginUser;
    private MemoryStatusBarItem _memStatus;
    private TimeStatusBarItem _timeItem;
    private LabelStatusBarItem _installType;
    private JTextArea _log;
    private JScrollPane _physicalPane;
    private TopologyWindow _sanMapWindow = null;
    private TopologyWindow _dataCenterMapWindow = null;
    private TopologyWindow _lanMapWindow = null;
    private ArrayList<FabricPK> _mapFabricOrder = new ArrayList();
    private HashMap<FabricPK, TopologyWindow> _mapTabHashMap;
    private boolean _inited = false;
    private boolean _pathTabDisplayed = false;
    private boolean _dataCenterTabDisplayed = true;
    private boolean _lanTabDisplayed = true;
    private boolean _dataCenterPopulated = false;
    private boolean _lanPopulated = false;
    private static boolean _readyForContext;
    private Container _dockableToolbarArea;
    private JPanel _dockableArea;
    private LayoutPersistenceManager _layoutPersistence;
    private String _title = "DCNM-SAN 6.3(1)";
    private JApplet _applet;
    private DockableFrame _logDF;
    private DockableFrame _eventDF;
    private DockableFrame logicalDF;
    private DockableFrame physicalDF;
    private DockableFrame tablePaneDoc;
    private CommandBar _toolbar = null;
    private static DockableFabricFrameListener dFrameListener;
    private String fileLocation = ClientCache.getDir() + File.separator + "JIDE_PROFILE";
    private static boolean _showRolloverDockedJideFrames;
    private Logger _logger = Logger.getLogger(this.getClass());
    private boolean _showMapEventTab = false;

    public static BrowserFrame getInstance() {
        if (_Instance == null) {
            _Instance = BrowserFrame.createInstance();
        }
        return _Instance;
    }

    public static BrowserFrame createInstance() {
        long fStart = System.currentTimeMillis();
        if (_Instance == null) {
            fStart = System.currentTimeMillis();
            _Instance = new BrowserFrame();
            if (BrowserFrame._Instance._logger.isInfoEnabled()) {
                BrowserFrame._Instance._logger.info((Object)("time in BrowserFrame new BrowserFrame() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
            }
            fStart = System.currentTimeMillis();
            dFrameListener = new DockableFabricFrameListener();
            if (BrowserFrame._Instance._logger.isInfoEnabled()) {
                BrowserFrame._Instance._logger.info((Object)("time in BrowserFrame new DockableFabricFrameListener() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
            }
            _Instance.displayView();
            try {
                String prefSize = ClientController.getInstance().getClientProperties().getProperty("PreferredSize");
                if (prefSize != null && prefSize.length() > 0) {
                    int w = 0;
                    int h = 0;
                    StringTokenizer st = new StringTokenizer(prefSize, ",");
                    if (st.countTokens() == 2) {
                        String tmp = st.nextToken();
                        w = (int)Double.parseDouble(tmp);
                        tmp = st.nextToken();
                        h = (int)Double.parseDouble(tmp);
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        _PreferredSize.setSize(Math.min(w, screenSize.width - 66), Math.min(h, screenSize.height - 66));
                        _Instance.setSize(Math.min(w, screenSize.width - 66), Math.min(h, screenSize.height - 66));
                        _Instance.setLocationRelativeTo(null);
                    }
                }
            }
            catch (Exception ex) {
                BrowserFrame._Instance._logger.error((Object)"Show BrowserFrame", (Throwable)ex);
            }
            fStart = System.currentTimeMillis();
            San.getInstance().addPropertyChangeListener(new SanMapListener());
            if (BrowserFrame._Instance._logger.isInfoEnabled()) {
                BrowserFrame._Instance._logger.info((Object)("time in BrowserFrame San.getInstance().addPropertyChangeListener() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
            }
        }
        return _Instance;
    }

    public static boolean hasInstance() {
        return _Instance != null;
    }

    @Override
    public void setCursor(Cursor cursor) {
        boolean wantBusyCursor = cursor != null && cursor.getType() == 3;
        this.getGlassPane().setVisible(wantBusyCursor);
        this.getGlassPane().setCursor(wantBusyCursor ? Cursor.getPredefinedCursor(3) : null);
    }

    public BrowserFrame() {
        this.setTitle(this._title);
        long fStart = System.currentTimeMillis();
        Lm.verifyLicense((String)"Cisco Systems", (String)"Fabric Manager", (String)"mJtZx7k7TIY3gmveNk1akrjwNihgcBa");
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("time in BrowserFrame com.jidesoft.utils.Lm.verifyLicense() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        fStart = System.currentTimeMillis();
        PortSetEditor.getInstance(this);
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("time in BrowserFrame PortSetEditor.getInstance() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        fStart = System.currentTimeMillis();
        this._dockableToolbarArea = new ContentContainer();
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("time in BrowserFrame new ContentContainer() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        this._dockableArea = new JPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._dockableToolbarArea, "Center");
        fStart = System.currentTimeMillis();
        _dockingManager = new DefaultDockingManager((RootPaneContainer)_Instance, (Container)this._dockableArea);
        _dockingManager.setShowWorkspace(false);
        _dockingManager.setHidable(true);
        _dockingManager.setFloatable(false);
        _dockingManager.setProportionalSplits(false);
        _dockingManager.setSidebarRollover(_showRolloverDockedJideFrames);
        _dockingManager.setDoubleClickAction(1);
        _dockableBarManager = new DefaultDockableBarManager((RootPaneContainer)_Instance, this._dockableToolbarArea);
        _dockableBarManager.setHidable(false);
        _dockableBarManager.setFloatable(false);
        _dockableBarManager.setShowContextMenu(false);
        _dockableBarManager.getMainContainer().setLayout((LayoutManager)new BorderLayout());
        this._layoutPersistence = new LayoutPersistenceManager();
        this._layoutPersistence.setProfileKey(DEFAULT_PROFILE_KEY);
        this._layoutPersistence.setUsePref(false);
        File fileLoc = new File(this.fileLocation);
        if (!fileLoc.exists()) {
            fileLoc.mkdirs();
        }
        this._layoutPersistence.setLayoutDirectory(this.fileLocation);
        this._layoutPersistence.addLayoutPersistence((LayoutPersistence)_dockableBarManager);
        this._layoutPersistence.addLayoutPersistence((LayoutPersistence)_dockingManager);
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("time in BrowserFrame () method REMAINING - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        this._showMapEventTab = new Boolean(System.getProperty("server.eventlog.showmaptab", "false"));
    }

    public DockingManager getDockingManager() {
        return _dockingManager;
    }

    public DockableBarManager getDockableBarManager() {
        return _dockableBarManager;
    }

    public LayoutPersistence getLayoutPersistence() {
        return this._layoutPersistence;
    }

    public void saveJIDELayout() {
        this.getLayoutPersistence().saveLayoutData();
    }

    public void loadJIDELayout() {
        this.getLayoutPersistence().loadLayoutData();
    }

    public void reloadJIDELayout() {
        this.getLayoutPersistence().loadLayoutData();
    }

    public static void setShowRolloverDockedJideFrames(boolean show) {
        _showRolloverDockedJideFrames = show;
        if (_dockingManager != null) {
            _dockingManager.setSidebarRollover(_showRolloverDockedJideFrames);
        }
    }

    public boolean getShowRolloverDockedJideFrames() {
        return _showRolloverDockedJideFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetJIDELayout() {
        DefaultDockingManager defaultDockingManager = _dockingManager;
        synchronized (defaultDockingManager) {
            String activeFrameKey = _dockingManager.getActiveFrameKey();
            this.getLayoutPersistence().resetToDefault();
            _dockingManager.removeContext(DEFAULT_PROFILE_KEY);
            _dockingManager.removeExtraContexts();
            _dockingManager.setProportionalSplits(false);
            if (this._pathTabDisplayed) {
                _dockingManager.setFrameAvailable("Paths");
            } else {
                _dockingManager.setFrameUnavailable("Paths");
            }
            if (this._lanTabDisplayed && ClientController.getInstance().showLan()) {
                _dockingManager.setFrameAvailable("LAN");
            } else {
                _dockingManager.setFrameUnavailable("LAN");
            }
            if (activeFrameKey != null) {
                _dockingManager.activateFrame(activeFrameKey);
            } else if (this._mapFabricOrder.size() > 0) {
                FabricPK pk = this._mapFabricOrder.get(0);
                _dockingManager.activateFrame(pk.toString());
            }
            this.logicalDF.setPreferredSize(leftPanelDim);
            this.physicalDF.setPreferredSize(leftPanelDim);
            this.tablePaneDoc.setPreferredSize(tablePanelDim);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectNextView() {
        DefaultDockingManager defaultDockingManager = _dockingManager;
        synchronized (defaultDockingManager) {
            String frameKey = _dockingManager.getNextFrame(_dockingManager.getActiveFrameKey());
            if (frameKey != null) {
                _dockingManager.showFrame(frameKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPreviousView() {
        DefaultDockingManager defaultDockingManager = _dockingManager;
        synchronized (defaultDockingManager) {
            String frameKey = _dockingManager.getPreviousFrame(_dockingManager.getActiveFrameKey());
            if (frameKey != null) {
                _dockingManager.showFrame(frameKey);
            }
        }
    }

    public void setDockableFrameTitle(String frameName, String title) {
        DockableFrame dFrame = _dockingManager.getFrame(frameName);
        dFrame.setTitle(title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayView() {
        if (!this._inited) {
            this._inited = true;
            Object object = _InitObj;
            synchronized (object) {
                if (this._dataView == null) {
                    this.initUI(false);
                }
                if (!SM._ConsoleOut) {
                    // empty if block
                }
                this.setLocationRelativeTo(null);
                this.setSanPhysicalTreeEnable(false);
            }
            if (ClientController.getInstance().showLan()) {
                _dockingManager.setFrameAvailable("LAN");
            } else {
                _dockingManager.setFrameUnavailable("LAN");
            }
        } else {
            this._dataView.resetView();
            this.buildTree();
        }
    }

    @Override
    public void validate() {
        if (this._applet == null) {
            super.validate();
        } else {
            this._applet.setContentPane(this.getContentPane());
            this._applet.validate();
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (this._applet == null) {
            super.setVisible(b);
            if (b && !this.isVisible()) {
                this.setLocationRelativeTo(null);
            }
            if (!dataLoaded && b) {
                dataLoaded = true;
                this.loadJIDELayout();
            }
        } else {
            if (!dataLoaded && b) {
                dataLoaded = true;
                this.loadJIDELayout();
            }
            this._applet.setContentPane(this.getContentPane());
            this._applet.validate();
        }
    }

    public void setApplet(JApplet applet) {
        this._applet = applet;
    }

    @Override
    public void setJMenuBar(JMenuBar menu) {
        if (menu instanceof CommandMenuBar) {
            ((CommandMenuBar)menu).setHidable(false);
            ((CommandMenuBar)menu).setKey("FMMenu");
            ((CommandMenuBar)menu).setFloatable(false);
            ((CommandMenuBar)menu).setAllowedDockSides(3);
            _dockableBarManager.addDockableBar((DockableBar)((CommandMenuBar)menu));
            return;
        }
        if (this._applet == null) {
            super.setJMenuBar(menu);
        } else {
            this._applet.setJMenuBar(menu);
        }
    }

    @Override
    public JMenuBar getJMenuBar() {
        if (this.getDockableBarManager() != null) {
            Collection col = this.getDockableBarManager().getAllDockableBars();
            for (DockableBar bar : col) {
                if (!(bar instanceof CommandBar) || !((CommandBar)bar).isMenuBar()) continue;
                return bar;
            }
        }
        return super.getJMenuBar();
    }

    public void update() {
        this.updateTitle();
    }

    public static boolean mdsInFabric(Switch[] sws) {
        if (sws == null || sws.length == 0) {
            return false;
        }
        for (int i = 0; i < sws.length; ++i) {
            if (!sws[i].isMDS()) continue;
            return true;
        }
        return false;
    }

    public void updateTitle() {
        StringBuffer title = new StringBuffer(80);
        title.append(" [" + ClientController.getInstance().getFMUsername());
        title.append("@" + ClientController.getInstance().getServer());
        title.append(" (session " + System.getProperty("fm.sessionid") + ")] ");
        if (ClientController.getInstance().getSelectedDomain() != null) {
            Fabric fabric;
            GroupBase groupBase;
            MgmtDomainIf mgmtDomainIf = ClientController.getInstance().getSelectedDomain();
            title.append(mgmtDomainIf.getPath('/'));
            if (mgmtDomainIf instanceof Fabric && (groupBase = (fabric = (Fabric)mgmtDomainIf).getGroup()) != null) {
                title.append("/").append(groupBase.getGroupPK().getName());
            }
        }
        this.setTitle(this._title + title.toString());
        _loginUser.setText(ClientController.getInstance().getFMUsername());
    }

    public void updatePerspectiveView() {
        this.rebuildPhysicalTree();
        this.rebuildToolbarPanel();
        this.rebuildMenuBar();
    }

    private void initUI(boolean visible) {
        if (this._physicalPane != null) {
            return;
        }
        this.setIconImage(Util.loadIcon("icons/LogoIcon.gif").getImage());
        this.setJMenuBar(UIControls.getInstance().buildMenubar(null));
        this.buildToolbarPanel(true);
        JPanel logicalPanel = new JPanel(new BorderLayout());
        JScrollPane sp = new JScrollPane(VsanTree.getInstance());
        sp.setVerticalScrollBarPolicy(20);
        sp.setHorizontalScrollBarPolicy(30);
        logicalPanel.add((Component)sp, "Center");
        logicalPanel.setMinimumSize(new Dimension(120, 120));
        logicalPanel.setPreferredSize(leftPanelDim);
        this._physicalPane = new JScrollPane();
        this.buildTree();
        this._physicalPane.setPreferredSize(leftPanelDim);
        this.logicalDF = new DockableFrame("Logical Domains", null);
        this.logicalDF.setInitMode(4);
        this.logicalDF.setInitSide(8);
        this.logicalDF.setInitIndex(0);
        this.logicalDF.setHidable(false);
        this.logicalDF.add((Component)logicalPanel);
        this.logicalDF.setPreferredSize(leftPanelDim);
        _dockingManager.addFrame(this.logicalDF);
        this.physicalDF = new DockableFrame("Physical Attributes", null);
        this.physicalDF.setInitMode(4);
        this.physicalDF.setInitSide(8);
        this.physicalDF.setInitIndex(1);
        this.physicalDF.setHidable(false);
        this.physicalDF.add((Component)this._physicalPane);
        this.physicalDF.setPreferredSize(leftPanelDim);
        _dockingManager.addFrame(this.physicalDF);
        this._dataView = new DataView();
        this._dataView.setPreferredSize(tablePanelDim);
        this._mapTabHashMap = new HashMap();
        LogWriter logWriter = new LogWriter(SmLogWindow.getInstance());
        WriterAppender appender = new WriterAppender((Layout)new PatternLayout("%d{yyyy.MM.dd HH:mm:ss } %-5p %c{2} - %m%n"), (OutputStream)logWriter);
        LogManager.getRootLogger().addAppender((Appender)appender);
        this._log = logWriter._log;
        this.tablePaneDoc = new DockableFrame("Information", null);
        this.tablePaneDoc.setInitMode(4);
        this.tablePaneDoc.setInitSide(4);
        this.tablePaneDoc.setInitIndex(0);
        this.tablePaneDoc.setHidable(false);
        this.tablePaneDoc.add((Component)this._dataView);
        this.tablePaneDoc.setPreferredSize(tablePanelDim);
        this.tablePaneDoc.setAvailableButtons(20);
        _dockingManager.addFrame(this.tablePaneDoc);
        this.addDataCenterMapTabToDockingManager();
        this.addLanMapTabToDockingManager();
        this._logDF = new DockableFrame(_TabAttr[1][0], (Icon)Util.loadIcon(_TabAttr[1][1]));
        this._logDF.setToolTipText(_TabAttr[1][2]);
        this._logDF.setInitMode(4);
        this._logDF.setInitSide(4);
        this._logDF.setInitIndex(1);
        this._logDF.setHidable(false);
        this._logDF.setPreferredAutohideSide(2);
        this._logDF.add((Component)new JScrollPane(this._log));
        this._logDF.setPreferredSize(mapAreaDim);
        this._logDF.setAvailableButtons(20);
        _dockingManager.addFrame(this._logDF);
        if (this._showMapEventTab) {
            this._eventDF = new DockableFrame("Events", (Icon)Util.loadIcon("icons/alarm_log16.gif"));
            this._eventDF.setToolTipText("Fabric Notifications Received");
            this._eventDF.setInitMode(4);
            this._eventDF.setInitSide(4);
            this._eventDF.setPreferredAutohideSide(2);
            this._eventDF.setInitIndex(1);
            this._eventDF.add((Component)new JScrollPane(EventLog.getInstance().buildTable()));
            this._eventDF.setPreferredSize(mapAreaDim);
            this._eventDF.setAvailableButtons(20);
            _dockingManager.addFrame(this._eventDF);
        }
        dFrameListener.addChangeListener(VsanTree.getInstance());
        this._status = new LabelStatusBarItem();
        this._longTermStatus = new LabelStatusBarItem();
        StatusBar footer = new StatusBar();
        _serverFailure.setIcon((Icon)Util.loadIcon("icons/logout16.gif"));
        _serverFailure.setToolTipText("ERROR: Server has disconnected!");
        _serverFailure.setVisible(false);
        this._installType = new LabelStatusBarItem("InstallType");
        if (SM._FmStandalone) {
            this._installType.setText("Install: Standalone");
        } else {
            this._installType.setText("Install: Server");
        }
        this._installType.setToolTipText("Install type is either server or standalone");
        this._installType.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JSeparator separator = new JSeparator(1);
        separator.setPreferredSize(new Dimension(2, 20));
        footer.add((Component)this._status, (Object)"flexible");
        footer.add((Component)this._longTermStatus, (Object)"flexible");
        footer.add((Component)_serverFailure, (Object)"flexible");
        _loginUser.setText("");
        _loginUser.setIcon((Icon)Util.loadIcon(USERS_ICON));
        _loginUser.setPreferredWidth(20);
        footer.add((Component)_loginUser, (Object)"fix");
        this._timeItem = new TimeStatusBarItem();
        this._timeItem.setPreferredWidth(20);
        footer.add((Component)this._timeItem, (Object)"fix");
        this._memStatus = new MemoryStatusBarItem();
        this._memStatus.setPreferredWidth(20);
        footer.add((Component)this._memStatus, (Object)"fix");
        footer.add((Component)this._installType, (Object)"fix");
        _dockableBarManager.getMainContainer().add((Component)footer, (Object)"Last");
        _dockableBarManager.getMainContainer().add((Component)this._dockableArea, (Object)"Center");
        _dockableBarManager.getMainContainer().setPreferredSize(_PreferredSize);
        this.pack();
        if (visible) {
            this.setVisible(visible);
        }
        SmCommandDispatcher.init();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UIActions.getInstance().closeAction();
            }
        });
    }

    public void resetAllFabricMap() {
        SmMap sanMap = SmMap.getInstance();
        sanMap.resetData();
        sanMap.clear();
        sanMap.fabricDiscovered(null);
    }

    public void resyncLan() {
        this.updateLan();
        if (SmMap.hasInstance(2)) {
            SmMap lanMap = SmMap.getInstance(2);
            lanMap.resetData();
            lanMap.clear();
            lanMap.fabricDiscovered(null);
        }
        if (SmMap.hasInstance(1)) {
            SmMap dataCenterMap = SmMap.getInstance(1);
            dataCenterMap.resetData();
            dataCenterMap.clear();
            dataCenterMap.fabricDiscovered(null);
        }
    }

    public void resyncAllFabricMaps() {
        MapFactory.removeAllMaps();
    }

    public void addFabric(Fabric fabric) {
        this.setVisible(true);
        TopologyWindow window = BrowserFrame.getInstance().addFabricTab(fabric);
        SmMap map = MapFactory.getInstance().getGraph(fabric, true);
        window.getGraphComponent().setGraph(map, false);
        map.fabricDiscovered(fabric);
        this.setSanPhysicalTreeEnable(true);
        if (fabric != null) {
            JButton sanButton = map.getSanButton();
            sanButton.getParent().remove(sanButton);
        }
    }

    public void renameFabric(Fabric fabric, String oldName) {
        if (fabric != null) {
            String activeName = _dockingManager.getActiveFrameKey();
            FabricPK fabricPk = (FabricPK)fabric.getPK();
            this._mapFabricOrder.remove(fabricPk);
            DockableFrame fabricFrame = _dockingManager.getFrame(oldName);
            _dockingManager.removeFrame(oldName, true);
            this._mapFabricOrder.add(fabricPk);
            fabricFrame.setKey(fabricPk.getName());
            _dockingManager.addFrame(fabricFrame);
            if (activeName.equals(oldName)) {
                _dockingManager.showFrame(fabricPk.getName());
            } else {
                _dockingManager.showFrame(activeName);
            }
        }
    }

    public void removeFabric(FabricPK fabricPk, boolean isResync) {
        BrowserFrame.getInstance().removeFabricTab(fabricPk, isResync);
        SmMap map = MapFactory.getInstance().removeGraph(fabricPk);
        if (map != null) {
            map.destroy();
        }
        if (San.getInstance().getFabricCount() == 0 && !ClientController.getInstance().isOpening()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BrowserFrame.getInstance().setVisible(false);
                    ClientController.getInstance().showOpenDialog();
                }
            });
        }
    }

    private void addTab(JTabbedPane parent, JComponent child, int attrIndex, int tabIndex, int mnemonicIndex) {
        parent.addTab(_TabAttr[attrIndex][0], Util.loadIcon(_TabAttr[attrIndex][1]), child, _TabAttr[attrIndex][2]);
        parent.setDisplayedMnemonicIndexAt(tabIndex, mnemonicIndex);
    }

    public Fabric getFirstFabric() {
        return VsanTree.getInstance().getFirstFabric();
    }

    public SmMap getSelectedMap() {
        String activeName = _dockingManager.getActiveFrameKey();
        DockableFrame activeFrame = _dockingManager.getFrame(activeName);
        if (activeFrame != null) {
            String lastActiveFrameName;
            String activeFrameName = activeFrame.getName();
            if (activeFrameName.equals("Paths")) {
                if (this._sanMapWindow != null) {
                    return (SmMap)this._sanMapWindow.getGraph();
                }
                return null;
            }
            if (activeFrameName.equals("LAN")) {
                if (this._lanMapWindow != null) {
                    return (SmMap)this._lanMapWindow.getGraph();
                }
                return null;
            }
            if (activeFrameName.equals("DataCenter")) {
                if (this._dataCenterMapWindow != null) {
                    return (SmMap)this._dataCenterMapWindow.getGraph();
                }
                return null;
            }
            for (FabricPK nextFabPk : this._mapFabricOrder) {
                TopologyWindow win;
                if (!nextFabPk.getName().equals(activeFrameName) || (win = this._mapTabHashMap.get(nextFabPk)) == null) continue;
                return (SmMap)win.getGraph();
            }
            if (dFrameListener != null && (lastActiveFrameName = dFrameListener.getLastActiveMapName()) != null) {
                if (lastActiveFrameName.equals("Paths")) {
                    if (this._sanMapWindow != null) {
                        return (SmMap)this._sanMapWindow.getGraph();
                    }
                    return null;
                }
                if (lastActiveFrameName.equals("LAN")) {
                    if (this._lanMapWindow != null) {
                        return (SmMap)this._lanMapWindow.getGraph();
                    }
                    return null;
                }
                if (lastActiveFrameName.equals("DataCenter")) {
                    if (this._dataCenterMapWindow != null) {
                        return (SmMap)this._dataCenterMapWindow.getGraph();
                    }
                    return null;
                }
                for (FabricPK nextFabPk : this._mapFabricOrder) {
                    TopologyWindow win;
                    if (!nextFabPk.getName().equals(lastActiveFrameName) || (win = this._mapTabHashMap.get(nextFabPk)) == null) continue;
                    return (SmMap)win.getGraph();
                }
            }
        }
        return null;
    }

    public TopologyWindow getTopologyWindow(Fabric fabric) {
        if (fabric == null && this._mapFabricOrder.size() > 0) {
            FabricPK fab = this._mapFabricOrder.get(0);
            return this._mapTabHashMap.get(fab);
        }
        FabricPK fabricPk = (FabricPK)fabric.getPK();
        TopologyWindow window = this._mapTabHashMap.get(fabricPk);
        if (window != null) {
            return window;
        }
        return null;
    }

    public void selectFabricTab(Fabric fabric) {
        this.showFabricTab(fabric);
    }

    public void refreshDataCenterTab(boolean force) {
        if (this._dataCenterTabDisplayed) {
            this._dataCenterPopulated = true;
            DataCenter.getInstance().refresh(force);
            this._dataCenterPopulated = DataCenter.getInstance().inited();
            SmMap.getInstance(1).fabricDiscovered(null);
        }
    }

    public void showDataCenterTab() {
        String currentActiveFrame = _dockingManager.getActiveFrameKey();
        if (this._dataCenterTabDisplayed) {
            if (!this._dataCenterPopulated) {
                this._dataCenterPopulated = true;
                DataCenter.getInstance().refresh(true);
                SmMap.getInstance(1).fabricDiscovered(null);
            }
            _dockingManager.showFrame("DataCenter");
        }
        if (currentActiveFrame != null && currentActiveFrame.equals("Logical Domains")) {
            _dockingManager.showFrame(currentActiveFrame);
        }
    }

    public void showLanTab() {
        String currentActiveFrame = _dockingManager.getActiveFrameKey();
        if (this._lanTabDisplayed) {
            if (!this._lanPopulated) {
                this._lanPopulated = true;
                Lan.getInstance().refresh(false);
                this._lanPopulated = Lan.getInstance().inited();
                SmMap.getInstance(2).fabricDiscovered(null);
            }
            _dockingManager.showFrame("LAN");
        }
        if (currentActiveFrame != null && currentActiveFrame.equals("Logical Domains")) {
            _dockingManager.showFrame(currentActiveFrame);
        }
    }

    public void addPathTab() {
        String currentActiveFrame = _dockingManager.getActiveFrameKey();
        if (!this._pathTabDisplayed) {
            this.addPathMapTabToDockingManager();
        }
        _dockingManager.showFrame("Paths", true);
        if (currentActiveFrame != null && currentActiveFrame.equals("Logical Domains")) {
            _dockingManager.showFrame(currentActiveFrame);
        }
    }

    public void removePathTab() {
        String currentActiveFrame = _dockingManager.getActiveFrameKey();
        if (this._pathTabDisplayed) {
            this.removePathMapTabAreaFromDockingManager();
            _dockingManager.showFrame("Paths", true);
        }
        if (currentActiveFrame != null && currentActiveFrame.equals("Logical Domains")) {
            _dockingManager.showFrame(currentActiveFrame);
        }
    }

    public void showPathTab() {
        String currentActiveFrame = _dockingManager.getActiveFrameKey();
        if (this._pathTabDisplayed) {
            _dockingManager.showFrame("Paths", true);
        }
        if (currentActiveFrame != null && currentActiveFrame.equals("Logical Domains")) {
            _dockingManager.showFrame(currentActiveFrame);
        }
    }

    public void showFabricTab(Fabric fabric) {
        String currentActiveFrame = _dockingManager.getActiveFrameKey();
        if (fabric == null) {
            if (this._mapFabricOrder.size() > 0) {
                FabricPK fabPk = this._mapFabricOrder.get(0);
                _dockingManager.showFrame(fabPk.getName());
            }
        } else {
            FabricPK fabricPk = (FabricPK)fabric.getPK();
            _dockingManager.showFrame(fabricPk.getName());
        }
        if (currentActiveFrame != null && currentActiveFrame.equals("Logical Domains")) {
            _dockingManager.showFrame(currentActiveFrame);
        }
    }

    private DockableFrame addToMapTabAreaOfDockingManager(String key, ImageIcon icon, TopologyWindow map, FabricPK fabricPk) {
        DockableFrame mapDF = new DockableFrame(key, (Icon)icon);
        mapDF.setInitMode(4);
        mapDF.setInitSide(4);
        mapDF.setInitIndex(1);
        mapDF.add((Component)map);
        mapDF.setPreferredAutohideSide(2);
        mapDF.setPreferredSize(mapAreaDim);
        mapDF.setAvailableButtons(21);
        this._mapTabHashMap.put(fabricPk, map);
        _dockingManager.addFrame(mapDF);
        this._mapFabricOrder.add(fabricPk);
        mapDF.addDockableFrameListener((DockableFrameListener)dFrameListener);
        return mapDF;
    }

    private void removeMapTabAreaFromDockingManager(String key, FabricPK fabricPk, boolean isResync) {
        DockableFrame mapDF = _dockingManager.getFrame(key);
        mapDF.removeDockableFrameListener((DockableFrameListener)dFrameListener);
        _dockingManager.removeFrame(key, isResync);
        this._mapFabricOrder.remove(fabricPk);
        this._mapTabHashMap.remove(fabricPk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockableFrame addPathMapTabToDockingManager() {
        DefaultDockingManager defaultDockingManager = _dockingManager;
        synchronized (defaultDockingManager) {
            if (this._sanMapWindow == null) {
                this._sanMapWindow = SmMap.getInstance().getWindow();
                SmMap.getInstance(0).getDimHideVsanButton().getParent().remove(SmMap.getInstance(0).getDimHideVsanButton());
                DockableFrame sanFrame = new DockableFrame("Paths", (Icon)Util.loadIcon(_TabAttr[0][1]));
                sanFrame.addDockableFrameListener((DockableFrameListener)dFrameListener);
                sanFrame.setInitMode(4);
                sanFrame.setInitSide(4);
                sanFrame.setInitIndex(1);
                sanFrame.setPreferredAutohideSide(2);
                sanFrame.add((Component)this._sanMapWindow);
                sanFrame.setPreferredSize(mapAreaDim);
                sanFrame.setAvailableButtons(21);
                _dockingManager.addFrame(sanFrame);
                this._pathTabDisplayed = true;
                return sanFrame;
            }
            DockableFrame sanFrame = _dockingManager.getFrame("Paths");
            _dockingManager.setFrameAvailable("Paths");
            this._pathTabDisplayed = true;
            return sanFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePathMapTabAreaFromDockingManager() {
        DefaultDockingManager defaultDockingManager = _dockingManager;
        synchronized (defaultDockingManager) {
            _dockingManager.setFrameUnavailable("Paths");
            this._pathTabDisplayed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DockableFrame addDataCenterMapTabToDockingManager() {
        DefaultDockingManager defaultDockingManager = _dockingManager;
        synchronized (defaultDockingManager) {
            DockableFrame dataCenterFrame;
            if (this._dataCenterMapWindow == null) {
                this._dataCenterMapWindow = SmMap.getInstance(1).getWindow();
                SmMap.getInstance(1).getDimHideVsanButton().getParent().remove(SmMap.getInstance(1).getDimHideVsanButton());
                SmMap.getInstance(1).getShowHideEndDevicesButton().getParent().remove(SmMap.getInstance(1).getShowHideEndDevicesButton());
                SmMap.getInstance(1).getSanButton().getParent().remove(SmMap.getInstance(1).getSanButton());
                dataCenterFrame = new DockableFrame("DataCenter", (Icon)Util.loadIcon(_TabAttr[0][1]));
                dataCenterFrame.addDockableFrameListener((DockableFrameListener)dFrameListener);
                dataCenterFrame.setInitMode(4);
                dataCenterFrame.setInitSide(4);
                dataCenterFrame.setInitIndex(1);
                dataCenterFrame.setPreferredAutohideSide(2);
                dataCenterFrame.add((Component)this._dataCenterMapWindow);
                dataCenterFrame.setPreferredSize(mapAreaDim);
                dataCenterFrame.setAvailableButtons(21);
                _dockingManager.addFrame(dataCenterFrame);
            } else {
                dataCenterFrame = _dockingManager.getFrame("DataCenter");
                _dockingManager.setFrameAvailable("DataCenter");
            }
            this._dataCenterTabDisplayed = true;
            return dataCenterFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DockableFrame addLanMapTabToDockingManager() {
        DefaultDockingManager defaultDockingManager = _dockingManager;
        synchronized (defaultDockingManager) {
            DockableFrame lanFrame;
            if (this._lanMapWindow == null) {
                this._lanMapWindow = SmMap.getInstance(2).getWindow();
                SmMap.getInstance(2).getDimHideVsanButton().getParent().remove(SmMap.getInstance(2).getDimHideVsanButton());
                SmMap.getInstance(2).getShowHideEndDevicesButton().getParent().remove(SmMap.getInstance(2).getShowHideEndDevicesButton());
                SmMap.getInstance(2).getSanButton().getParent().remove(SmMap.getInstance(2).getSanButton());
                lanFrame = new DockableFrame("LAN", (Icon)Util.loadIcon(_TabAttr[0][1]));
                lanFrame.addDockableFrameListener((DockableFrameListener)dFrameListener);
                lanFrame.setInitMode(4);
                lanFrame.setInitSide(4);
                lanFrame.setInitIndex(1);
                lanFrame.setPreferredAutohideSide(2);
                lanFrame.add((Component)this._lanMapWindow);
                lanFrame.setPreferredSize(mapAreaDim);
                lanFrame.setAvailableButtons(21);
                _dockingManager.addFrame(lanFrame);
                this._lanTabDisplayed = true;
            } else {
                lanFrame = _dockingManager.getFrame("LAN");
                _dockingManager.setFrameAvailable("LAN");
            }
            this._lanTabDisplayed = true;
            return lanFrame;
        }
    }

    public TopologyWindow addFabricTab(Fabric fabric) {
        int pos = this._mapFabricOrder.size();
        if (this._pathTabDisplayed) {
            ++pos;
        }
        FabricPK fabricPk = (FabricPK)fabric.getPK();
        String name = fabricPk.toString();
        TopologyWindow window = new TopologyWindow();
        if (window.getToolPanel() == null) {
            window.setToolPanel(MapMenus.getToolPanel());
        }
        DockableFrame fabFrame = this.addToMapTabAreaOfDockingManager(name, Util.loadIcon(_TabAttr[0][1]), window, fabricPk);
        if (pos == 0) {
            _dockingManager.activateFrame(name);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VsanTree.getInstance().selectFirstFabric();
            }
        });
        return window;
    }

    public void removeFabricTab(FabricPK fabricPk, boolean isResync) {
        if (fabricPk == null) {
            return;
        }
        int count = this._mapFabricOrder.size();
        TopologyWindow window = this._mapTabHashMap.get(fabricPk);
        if (window == null) {
            return;
        }
        this.removeMapTabAreaFromDockingManager(fabricPk.getName(), fabricPk, isResync);
        if (count == 1) {
            SmMap.getInstance().clear();
            this._dataView.resetView();
            this.setSanPhysicalTreeEnable(false);
        }
    }

    public void clearFabricTab() {
        for (FabricPK nextFabPk : this._mapFabricOrder) {
            _dockingManager.removeFrame(nextFabPk.getName());
        }
        this._mapTabHashMap.clear();
        this._mapFabricOrder.clear();
    }

    public void setSanPhysicalTreeVisible() {
        this.changeVisibleTreeTo(this._sanTree);
    }

    public void setLanPhysicalTreeVisible() {
        this.changeVisibleTreeTo(this._lanTree);
    }

    public void setDataCenterPhysicalTreeVisible() {
        this.changeVisibleTreeTo(this._dcTree);
    }

    private void changeVisibleTreeTo(PhysicalTree tree) {
        this._treeDisplayed = tree;
        tree.clearSelection();
        this._physicalPane.setViewportView(this._treeDisplayed);
        this._treeDisplayed.setVisible(true);
    }

    private void buildTree() {
        DefaultMutableTreeNode santop = new DefaultMutableTreeNode(new TreeCommand("/", null));
        TreeCommand.load(santop);
        this._sanTree = new PhysicalTree(santop);
        this.setPropertiesForTree(this._sanTree);
        DefaultMutableTreeNode lantop = new DefaultMutableTreeNode(new TreeCommand("/", null));
        TreeCommand.loadLan(lantop);
        this._lanTree = new PhysicalTree(lantop);
        this.setPropertiesForTree(this._lanTree);
        DefaultMutableTreeNode dctop = new DefaultMutableTreeNode(new TreeCommand("/", null));
        TreeCommand.loadDataCenter(dctop);
        this._dcTree = new PhysicalTree(dctop);
        this.setPropertiesForTree(this._dcTree);
        MgmtDomainIf mgmtDomainIf = ClientController.getInstance().getSelectedDomain();
        if (mgmtDomainIf == null) {
            this.changeVisibleTreeTo(this._dcTree);
        } else if (mgmtDomainIf.isFabric() || mgmtDomainIf.isSan() || mgmtDomainIf.isVsan() || mgmtDomainIf.isZone() || mgmtDomainIf.isCustomDefined()) {
            this.changeVisibleTreeTo(this._sanTree);
        } else if (mgmtDomainIf.isDataCenter()) {
            this.changeVisibleTreeTo(this._dcTree);
        } else if (mgmtDomainIf.isLAN() || mgmtDomainIf.isVlan()) {
            this.changeVisibleTreeTo(this._lanTree);
        }
    }

    private void setPropertiesForTree(PhysicalTree tree) {
        tree.setShowsRootHandles(true);
        TreeSelectionModel selectionModel = tree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        DefaultTreeCellRenderer tcr = (DefaultTreeCellRenderer)tree.getCellRenderer();
        tcr.setLeafIcon(null);
        tree.setRootVisible(false);
    }

    public void rebuildPhysicalTree() {
        if (this._sanTree != null) {
            this._sanTree.removeAll();
        }
        if (this._lanTree != null) {
            this._lanTree.removeAll();
        }
        if (this._dcTree != null) {
            this._dcTree.removeAll();
        }
        this.buildTree();
    }

    public void setVisiblePhysicalTree(boolean wantVisible) {
        if (this._treeDisplayed != null) {
            this._treeDisplayed.setVisible(wantVisible);
        }
    }

    void buildToolbarPanel(boolean isInit) {
        if (isInit) {
            this._toolbar = UIControls.getInstance().buildToolbar(this._toolbar);
            this._toolbar.setHidable(false);
            this._toolbar.setFloatable(false);
            this._toolbar.setKey("FMToolbar");
            _dockableBarManager.addDockableBar((DockableBar)this._toolbar);
            if (!ClientController.getInstance().isSAAdmin()) {
                JComponent perspectiveControl = UIControls.getInstance().buildSimpleMode();
                CommandBar perspectiveToolBar = new CommandBar("Perspective");
                perspectiveToolBar.add((Component)perspectiveControl);
                perspectiveToolBar.setInitIndex(1);
                perspectiveToolBar.setMenuBar(false);
                perspectiveToolBar.setHidable(false);
                perspectiveToolBar.setFloatable(false);
                perspectiveToolBar.setAllowedDockSides(3);
                perspectiveToolBar.setKey("FMPerspectiveToolbar");
                _dockableBarManager.addDockableBar((DockableBar)perspectiveToolBar);
            }
        } else {
            this._toolbar = UIControls.getInstance().buildToolbar(this._toolbar);
        }
    }

    public void rebuildToolbarPanel() {
        this.buildToolbarPanel(false);
    }

    public void rebuildMenuBar() {
        JMenuBar menu = this.getJMenuBar();
        if (menu != null) {
            menu.removeAll();
        }
        UIControls.getInstance().buildMenubar((CommandMenuBar)menu);
    }

    public void rebuildLogicalTree() {
        VsanTree.getInstance().updateSan();
        this.updateLan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLan() {
        DefaultDockingManager defaultDockingManager = _dockingManager;
        synchronized (defaultDockingManager) {
            if (ClientController.getInstance().showLan()) {
                _dockingManager.setFrameAvailable("LAN");
            } else {
                _dockingManager.setFrameUnavailable("LAN");
            }
        }
        VsanTree.getInstance().updateLan();
    }

    public static String getPathName(TreePath p) {
        Object[] o = p.getPath();
        StringBuffer sb = new StringBuffer(64);
        sb.append('/');
        for (int i = 1; i < o.length - 1; ++i) {
            sb.append(o[i].toString());
            sb.append('/');
        }
        sb.append(o[o.length - 1].toString());
        return sb.toString();
    }

    public void setStatus(String status) {
        if (this._status != null) {
            this._status.setText(status);
        }
    }

    public String getStatus() {
        return this._status.getText();
    }

    public void clearStatus() {
        this.setStatus("");
        this.setLongTermStatus("");
    }

    public void setLongTermStatus(String status) {
        if (this._longTermStatus != null) {
            this._longTermStatus.setText(status);
        }
    }

    public static void showServerStatus(boolean ok) {
        if (_serverFailure != null) {
            _serverFailure.setVisible(!ok);
        }
    }

    public static DataView getDataView() {
        return BrowserFrame.getInstance()._dataView;
    }

    public void setDataPanelTitle(String title) {
        if (title == null || title.trim().equals("")) {
            title = DEFAULT_TABLE_TITLE;
        }
        this.tablePaneDoc.setTitle(title);
        this.tablePaneDoc.setSideTitle(title);
        this.tablePaneDoc.setTabTitle(title);
    }

    public String getDataPanelTitle() {
        if (this.tablePaneDoc == null) {
            return null;
        }
        return this.tablePaneDoc.getTitle();
    }

    public static SnmpKTable getTable() {
        return BrowserFrame._Instance._dataView._table;
    }

    public static JTextArea getLog() {
        return BrowserFrame._Instance._log;
    }

    public static TreePath getTreePath() {
        return BrowserFrame._Instance._treeDisplayed.getTreePath();
    }

    public static void changeTreeNode(DefaultMutableTreeNode node) {
        PhysicalTree phytree = BrowserFrame._Instance._treeDisplayed;
        ((DefaultTreeModel)phytree.getModel()).nodeStructureChanged(node);
    }

    public boolean isPhysicalTreeEnable() {
        return this._treeDisplayed.isEnabled();
    }

    public void setSanPhysicalTreeEnable(boolean enable) {
        this._sanTree.setEnabled(enable);
    }

    public void setLanPhysicalTreeEnable(boolean enable) {
        this._lanTree.setEnabled(enable);
    }

    public void clearPhysicalTreeSelection() {
        this._treeDisplayed.clearSelection();
    }

    public void checkTreeSelection(boolean isResync) {
        VsanTree.getInstance().checkSelection(isResync);
    }

    public void recordTreeSelection() {
        VsanTree.getInstance().recordSelectionPath();
    }

    public static boolean areAnyDiscoveryThreadsRunning() {
        return AddFabricDialog.areAnyDiscoveryThreadsRunning();
    }

    public static boolean areAllMapsReadyForContext() {
        return SmMap.areAllMapsReadyForContext();
    }

    public static void setReadyForContext(boolean readyForContext) {
        _readyForContext = readyForContext;
    }

    public static boolean isReadyForContext() {
        return _readyForContext;
    }

    public void setContextNow(ClientContext context) {
        if (context == null) {
            return;
        }
        VsanTree.getInstance().setContext(context);
        if (context.getFabricName() != null && _dockingManager != null) {
            _dockingManager.showFrame(context.getFabricName());
        }
        this._treeDisplayed.setContext(context);
        if (context.getTableSelection() != null || context.getTableSelectionArrayList() != null) {
            BrowserFrame.getDataView()._table.getSelectionModel().clearSelection();
            ArrayList<String> tableSelectionArrayList = context.getTableSelectionArrayList();
            String tableSelection = context.getTableSelection();
            if (tableSelection != null) {
                BrowserFrame.getDataView()._table.findFirstOccurance(new String[]{tableSelection}, context.getTableColumnIndex(), false, true, false);
            } else if (tableSelectionArrayList != null) {
                BrowserFrame.getDataView()._table.findFirstOccurance(tableSelectionArrayList.toArray(new String[tableSelectionArrayList.size()]), context.getTableColumnIndex(), false, true, false);
            }
        }
    }

    public void setContext(final ClientContext context) {
        if (context == null) {
            return;
        }
        this._logger.warn((Object)("BrowserFrame.setContext context.toString()=" + context.toString()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VsanTree.getInstance().setContext(context);
                if (context.getFabricName() != null && _dockingManager != null) {
                    _dockingManager.showFrame(context.getFabricName());
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserFrame.this._treeDisplayed.setContext(context);
            }
        });
        if (context.getTableSelection() != null || context.getTableSelectionArrayList() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BrowserFrame.getDataView()._table.getSelectionModel().clearSelection();
                    ArrayList<String> tableSelectionArrayList = context.getTableSelectionArrayList();
                    String tableSelection = context.getTableSelection();
                    if (tableSelection != null) {
                        BrowserFrame.getDataView()._table.findFirstOccurance(new String[]{tableSelection}, context.getTableColumnIndex(), false, true, false);
                    } else if (tableSelectionArrayList != null) {
                        BrowserFrame.getDataView()._table.findFirstOccurance(tableSelectionArrayList.toArray(new String[tableSelectionArrayList.size()]), context.getTableColumnIndex(), false, true, false);
                    }
                }
            });
        }
        if (context instanceof SwitchContext) {
            final SwitchContext switchContext = (SwitchContext)context;
            if (switchContext.getSwitchMenuActionName() != null) {
                this._logger.warn((Object)("BrowserFrame.setContext context.getSwitchMenuActionName()=" + switchContext.getSwitchMenuActionName()));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SmMap.getSelectedMap().setContext(switchContext);
                        ActionEvent e = new ActionEvent(context, 1001, switchContext.getSwitchMenuActionName());
                        if (switchContext.getSwitchMenuActionName() != null && switchContext.getSwitchMenuActionName().equalsIgnoreCase("eventsTab")) {
                            ClientContext treecontext = new ClientContext();
                            treecontext.setPhysicalAttributeSelection("Events");
                            BrowserFrame.this._treeDisplayed.setContext(treecontext);
                        } else {
                            MenuFactory.getInstance().actionPerformed(e);
                        }
                    }
                });
                return;
            }
            this._logger.warn((Object)("BrowserFrame.setContext switchContext.getUIActionName()=" + switchContext.getUIActionName()));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SmMap.getSelectedMap().setContext(switchContext);
                    ActionEvent e = new ActionEvent(context, 1001, switchContext.getUIActionName());
                    if (switchContext.getUIActionName() != null) {
                        UIControls.getInstance().actionPerformed(e);
                    }
                }
            });
            return;
        }
        if (context instanceof ISLContext) {
            final ISLContext islContext = (ISLContext)context;
            if (islContext.getISLActionName() != null) {
                this._logger.warn((Object)("BrowserFrame.setContext context.getISLActionName()=" + islContext.getISLActionName()));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SmMap.getSelectedMap().setContext(islContext);
                        ActionEvent e = new ActionEvent(context, 1001, islContext.getISLActionName());
                        MenuFactory.getInstance().actionPerformed(e);
                    }
                });
            }
            return;
        }
        if (context.getUIActionName() != null) {
            this._logger.warn((Object)("BrowserFrame.setContext context.getUIActionName()=" + context.getUIActionName()));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionEvent e = new ActionEvent(context, 1001, context.getUIActionName());
                    UIControls.getInstance().actionPerformed(e);
                }
            });
            return;
        }
    }

    static {
        dataLoaded = false;
        _InitObj = new Object();
        _PreferredSize = new Dimension(950, 700);
        leftPanelDim = new Dimension((int)_PreferredSize.getWidth() / 4, (int)_PreferredSize.getHeight() / 2);
        tablePanelDim = new Dimension((int)_PreferredSize.getWidth() / 4 * 3, (int)_PreferredSize.getHeight() / 2);
        mapAreaDim = new Dimension((int)(_PreferredSize.getWidth() / 4.0) * 3, (int)_PreferredSize.getHeight() / 2);
        _serverFailure = new LabelStatusBarItem("SERVER FAILURE AREA");
        _loginUser = new LabelStatusBarItem("CurrentLogin");
        _readyForContext = false;
        _showRolloverDockedJideFrames = false;
    }

    class CategoryTab
    extends JTabbedPane
    implements ChangeListener {
        public CategoryTab(int placement) {
            super(placement);
            this.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int curTab = this.getSelectedIndex();
            if (curTab == 0) {
                VsanTree.getInstance().clearSelection();
            } else {
                BrowserFrame.this._treeDisplayed.clearSelection();
            }
        }
    }
}

