/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.MnemonicTabbedPane;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.table.PasswordCellEditor;
import com.cisco.dcbu.lib.ui.table.PasswordCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.SM;
import com.cisco.dcbu.sm.client.ServerConnection;
import com.cisco.dcbu.sm.client.gui.AddFabricDialog;
import com.cisco.dcbu.sm.client.gui.AdminTableIf;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.ControlPanelFrame;
import com.cisco.dcbu.sm.client.gui.EditFMUserDialog;
import com.cisco.dcbu.sm.client.gui.EditUserIf;
import com.cisco.dcbu.sm.client.gui.EditViewScopeDialog;
import com.cisco.dcbu.sm.client.gui.EditViewScopeIf;
import com.cisco.dcbu.sm.client.gui.EditVirtualCenterIf;
import com.cisco.dcbu.sm.client.gui.EditVirtualCenterServerDialog;
import com.cisco.dcbu.sm.client.gui.FabricItem;
import com.cisco.dcbu.sm.client.gui.ManageFabricThread;
import com.cisco.dcbu.sm.client.gui.ManageFabricThreadListenerIf;
import com.cisco.dcbu.sm.client.gui.ManageLanThread;
import com.cisco.dcbu.sm.client.gui.ManageVirtualCenterThread;
import com.cisco.dcbu.sm.client.gui.MoveFabricDialog;
import com.cisco.dcbu.sm.client.gui.NewOpenDialogIf;
import com.cisco.dcbu.sm.client.gui.OpenFabricsPanel;
import com.cisco.dcbu.sm.client.gui.PercentBarCellObject;
import com.cisco.dcbu.sm.client.gui.UIActions;
import com.cisco.dcbu.sm.client.gui.renderers.PercentBarCellRenderer;
import com.cisco.dcbu.sm.client.gui.renderers.RedLicenseExpiringRenderer;
import com.cisco.dcbu.sm.client.gui.renderers.YellowUnlicensedRenderer;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.common.dto.LicenseFileUsage;
import com.cisco.dcbu.sm.common.dto.LicenseInfoFlex;
import com.cisco.dcbu.sm.common.dto.SessionDetails;
import com.cisco.dcbu.sm.common.dto.SwitchAssignedLicenseInfo;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.model.CdpSeedBase;
import com.cisco.dcbu.sm.common.model.FMUserBase;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchLicenseDetails;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.rif.SuperSessionRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.GroupPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.VcenterPK;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class ControlPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ChangeListener,
EditUserIf,
EditViewScopeIf,
NewOpenDialogIf,
ManageFabricThreadListenerIf,
EditVirtualCenterIf {
    static final String[] CLIENT_LABELS = new String[]{"SessionId", "Client", "User", "Role", "Login", "Last Access", "Server"};
    static final int CLIENT_SERVER_COL = 6;
    static final String[] USER_LABELS = new String[]{"Username", "Password", "Role", "Failed Attempts"};
    static final String[] VIEW_SCOPE_LABELS = new String[]{"Username", "Scoped View"};
    static final String[] SERVER_LABELS = new String[]{"Fabric/LAN", "Server", "ServerId"};
    static final String[] FABRIC_LABELS = new String[]{"Name", "<html>Polling<br>Interval<br>(sec)", "<html>Rediscover<br>Cycles", "<html>Server<br>Username", "<html>Server<br>Password/<br>Community", "<html>Server<br>SNMPv3", "<html>Server<br>Auth.<br>Privacy", "<html>Use FC<br>Alias", "<html>Included<br>VSAN List", "<html>Excluded<br>VSAN List", "Admin", "Status", "Server"};
    static final String[] ETHERNET_LABELS = new String[]{"LAN", "Seed Switch IP", "Username", "<html>Password/<br>Community", "SNMPv3", "Auth-Privacy", "Max Hops", "Subnet/Mask", "IP Range", "Status", "Server"};
    static final int ETHERNET_LANNAME_IDX = 0;
    static final int ETHERNET_SEEDIP_IDX = 1;
    static final int ETHERNET_USERNAME_IDX = 2;
    static final int ETHERNET_PASSWORD_IDX = 3;
    static final int ETHERNET_SNMPV3_IDX = 4;
    static final int ETHERNET_AUTHPRIV_IDX = 5;
    static final int ETHERNET_MAXHOP_IDX = 6;
    static final int ETHERNET_SUBNET_IDX = 7;
    static final int ETHERNET_IPRANGE_IDX = 8;
    static final int ETHERNET_STATUS_IDX = 9;
    static final int ETHERNET_SERVER_IDX = 10;
    static final int ETHERNET_CHANGESET_IDX = ETHERNET_LABELS.length + 0;
    static final int ETHERNET_CDPSEED_IDX = ETHERNET_LABELS.length + 1;
    static final String[] VIRTUAL_CENTER_SERVER_LABELS = new String[]{"IP Address", "Username", "Password", "Admin", "Status", "Server"};
    static final String[] LICENSE_FILE_LABELS = new String[]{"Filename", "Feature", "PID", "SAN (Free/Total)", "LAN (Free/Total)", "Eval Expiration"};
    static final String License_Tab_Name = "License Assignments";
    static final String[] LICENSE_ASSIGN_LABELS = new String[]{"Group", "Switch Name", "Model", "Licensed State", "License Type", "Eval Expiration"};
    private String lastDirectory = null;
    static final int FABRIC_NAME = 0;
    static final int FABRIC_POLLING_INTERVAL = 1;
    static final int FABRIC_REDISCOVER_CYCLES = 2;
    static final int FABRIC_USERNAME = 3;
    static final int FABRIC_PASSWORD = 4;
    static final int FABRIC_SNMPV3 = 5;
    static final int FABRIC_SNMP_PARAMS = 6;
    static final int FABRIC_FC_ALIAS = 7;
    static final int FABRIC_INCLUDED_VSANS = 8;
    static final int FABRIC_EXCLUDED_VSANS = 9;
    static final int FABRIC_ADMIN = 10;
    static final int FABRIC_STATUS = 11;
    static final int FABRIC_SERVER = 12;
    static final int FABRIC_NEXT = 13;
    static final int VIRTUAL_CENTER_SERVER_IP_ADDRESS = 0;
    static final int VIRTUAL_CENTER_SERVER_USERNAME = 1;
    static final int VIRTUAL_CENTER_SERVER_PASSWORD = 2;
    static final int VIRTUAL_CENTER_SERVER_ADMIN = 3;
    static final int VIRTUAL_CENTER_SERVER_STATUS = 4;
    static final int VIRTUAL_CENTER_SERVER_SERVER_IP = 5;
    static final int VIRTUAL_CENTER_SERVER_BASE = 7;
    private static final int MIN_INTERVAL = 76;
    MnemonicTabbedPane _tab;
    OpenFabricsPanel _openPanel;
    FabricsPanel _fabricsPanel;
    EthernetsPanel _ethernetsPanel;
    ClientsPanel _clientsPanel;
    UsersPanel _usersPanel;
    ViewScopePanel _viewScopePanel;
    VirtualCenterServerPanel _virtualCenterServerPanel;
    ServerPanel _serverPanel;
    LicenseFilePanel _licenseFilePanel;
    LicensePanel _licenseAssignmentPanel;
    JButton _openButton;
    JButton _tabsButton;
    JButton _connectButton;
    JButton _discoverButton;
    JButton _rediscoverButton;
    JButton _purgeButton;
    JButton _applyButton;
    JButton _deleteButton;
    JButton _newButton;
    JButton _editButton;
    JButton _moveButton;
    JButton _manageLanButton;
    JButton _unManageLanButton;
    JButton _addLicenseFileButton;
    JButton _reloadLicenseFileButton;
    JButton _unassignLicenseButton;
    JButton _assignLicenseButton;
    boolean _fabricChanged = false;
    boolean _ethernetChanged = false;
    boolean _virtualCenterServerChanged = false;
    boolean _inited = false;
    boolean _serverPanelAdded = false;
    private Logger _logger = Logger.getLogger(this.getClass());
    private Dimension _preferredSize = new Dimension(950, 400);
    Window _parentWindow = null;
    private ManageFabricThread _manageFabricThread = null;
    private ManageLanThread _manageLanThread = null;
    private ManageVirtualCenterThread _manageVirtualCenterServerThread = null;
    private boolean _needToUpdateFabricSelection = false;
    private JLabel discoveringFabricPleaseWait = new JLabel("");
    private HashMap usersWithSwitchGroup = new HashMap();
    TableModelListener _fabricTableModelLisnter = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                ControlPanel.this._fabricChanged = true;
                ControlPanel.this.updateApplyButton();
            }
        }
    };
    TableModelListener _ethernetTableModelLisnter = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                ControlPanel.this._ethernetChanged = true;
                ControlPanel.this.updateApplyButton();
            }
        }
    };
    TableModelListener _virtualCenterServerTableModelLisnter = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                ControlPanel.this._virtualCenterServerChanged = true;
                ControlPanel.this.updateApplyButton();
            }
        }
    };
    String[] hiddenTabStrings = null;
    Component[] hiddenTabComponents = null;
    static Map resyncSelectedFabricsMap = new HashMap();
    static Map resyncSelectedFabricItemsMap = new HashMap();

    public void showTab(String tabName) {
        if (tabName == null) {
            return;
        }
        if (tabName.equalsIgnoreCase("Open")) {
            this._tab.setSelectedIndex(0);
        } else if (tabName.equalsIgnoreCase("Fabrics")) {
            this._tab.setSelectedIndex(1);
        } else if (tabName.equalsIgnoreCase(License_Tab_Name)) {
            this._tab.setSelectedIndex(3);
        }
        this.addServerPanel();
    }

    public synchronized void addServerPanel() {
        if (!this._serverPanelAdded && ClientController.getInstance().getServerNodes().size() > 1) {
            this._tab.add("Federated Servers", this._serverPanel);
            this._serverPanelAdded = true;
        }
    }

    public ControlPanel(Window parent) {
        super(new BorderLayout());
        long fStart = System.currentTimeMillis();
        this._parentWindow = parent;
        this._tab = new MnemonicTabbedPane(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.setSize(d.getWidth(), d.getHeight() + (double)DialogUtil._MarginInsets.top);
                return d;
            }
        };
        this.setBorder(DialogUtil._Margin);
        this.add((Component)((Object)this._tab), "Center");
        this._openPanel = new OpenFabricsPanel(this);
        this._tab.add("Open", this._openPanel);
        this._openPanel._table.getSelectionModel().addListSelectionListener(this);
        this._fabricsPanel = new FabricsPanel(this);
        this._tab.add("Fabrics", this._fabricsPanel);
        this._fabricsPanel._table.getSelectionModel().addListSelectionListener(this);
        ((AbstractTableModel)this._fabricsPanel.getTable().getModel()).addTableModelListener(this._fabricTableModelLisnter);
        this._licenseFilePanel = new LicenseFilePanel(this);
        this._licenseFilePanel._table.getSelectionModel().addListSelectionListener(this);
        this._tab.add("License Files", this._licenseFilePanel);
        this._licenseAssignmentPanel = new LicensePanel(this);
        this._licenseAssignmentPanel._table.getSelectionModel().addListSelectionListener(this);
        this._tab.add(License_Tab_Name, this._licenseAssignmentPanel);
        this._viewScopePanel = new ViewScopePanel(this);
        this._viewScopePanel._table.getSelectionModel().addListSelectionListener(this);
        this._tab.add("Local Roles", this._viewScopePanel);
        this._serverPanel = new ServerPanel(this);
        this._serverPanel._table.getSelectionModel().addListSelectionListener(this);
        if (ClientController.getInstance().getServerNodes().size() > 1) {
            this._tab.add("Federated Servers", this._serverPanel);
            this._serverPanelAdded = true;
        }
        JButton[] buttons = DialogUtil.buildButtons(new String[]{"Open", "Discover...", "Add...", "Edit...", "Apply", "Move...", "Manage LAN", "Unmanage LAN", "Rediscover", "Purge", "Remove", "Add License File...", "Reload License Files", "Assign License", "Unassign License", "Connect", "Refresh", "More >>", "Close"}, (ActionListener)this);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        buttonPanel.add(this.discoveringFabricPleaseWait);
        for (int i = 0; i < buttons.length; ++i) {
            buttonPanel.add(buttons[i]);
        }
        this._openButton = buttons[0];
        this._openPanel.setOpenButton(this._openButton);
        this._discoverButton = buttons[1];
        this._discoverButton.setEnabled(ClientController.getInstance().isAdmin() || ClientController.getInstance().isSAAdmin());
        this._newButton = buttons[2];
        this._newButton.setEnabled(false);
        this._editButton = buttons[3];
        this._editButton.setEnabled(false);
        this._applyButton = buttons[4];
        this._applyButton.setEnabled(false);
        this._moveButton = buttons[5];
        this._moveButton.setEnabled(false);
        this._moveButton.setVisible(false);
        this._manageLanButton = buttons[6];
        this._manageLanButton.setEnabled(false);
        this._unManageLanButton = buttons[7];
        this._unManageLanButton.setEnabled(false);
        this._rediscoverButton = buttons[8];
        this._purgeButton = buttons[9];
        this._purgeButton.setEnabled(false);
        this._purgeButton.setVisible(false);
        this._deleteButton = buttons[10];
        this._deleteButton.setEnabled(false);
        this._addLicenseFileButton = buttons[11];
        this._addLicenseFileButton.setEnabled(false);
        this._addLicenseFileButton.setVisible(false);
        this._reloadLicenseFileButton = buttons[12];
        this._reloadLicenseFileButton.setEnabled(false);
        this._reloadLicenseFileButton.setVisible(false);
        this._assignLicenseButton = buttons[13];
        this._assignLicenseButton.setVisible(false);
        this._assignLicenseButton.setEnabled(false);
        this._unassignLicenseButton = buttons[14];
        this._unassignLicenseButton.setVisible(false);
        this._unassignLicenseButton.setEnabled(false);
        this._connectButton = buttons[15];
        this._connectButton.setEnabled(false);
        this._tabsButton = buttons[17];
        this._tabsButton.setEnabled(true);
        this._tabsButton.setVisible(false);
        this.add((Component)buttonPanel, "South");
        if (this._parentWindow instanceof JFrame) {
            ((JFrame)this._parentWindow).getRootPane().setDefaultButton(this._applyButton);
        } else if (this._parentWindow instanceof JDialog) {
            ((JDialog)this._parentWindow).getRootPane().setDefaultButton(this._applyButton);
        }
        if (!ClientController.getInstance().isAdmin()) {
            this._tab.setEnabledAt(1, false);
            this._tab.setEnabledAt(2, false);
        }
        if (ClientController.getInstance().isAdmin() || ClientController.getInstance().isSAAdmin()) {
            this._tab.setEnabledAt(0, true);
            this._tab.setEnabledAt(1, true);
        }
        this._tab.addChangeListener(this);
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("time in ControlPanel() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        this.showMoreTabs();
        this.stateChanged(null);
    }

    public void handleNoFabrics() {
        LanPK[] allLans = null;
        try {
            allLans = ClientController.getInstance().getAllLanPKs();
        }
        catch (Exception ex) {
            this._logger.warn((Object)"Cannot get all LanPKs", (Throwable)ex);
        }
        FabricPK[] allFabrics = null;
        try {
            ModelFacadeRif modelFacade = ClientController.getInstance().assertModelFacade();
            allFabrics = modelFacade.getFabricPKs();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!(allFabrics != null && allFabrics.length != 0 || allLans != null && allLans.length != 0)) {
            if (ClientController.getInstance().isAdmin() || ClientController.getInstance().isSAAdmin()) {
                AddFabricDialog d;
                if (this._parentWindow instanceof JFrame) {
                    d = new AddFabricDialog((JFrame)this._parentWindow, true, false);
                    d.setVisible(true);
                } else if (this._parentWindow instanceof JDialog) {
                    d = new AddFabricDialog((JDialog)this._parentWindow, true, false);
                    d.setVisible(true);
                }
            } else {
                Object[] options = new Object[]{"Exit"};
                int n = JOptionPane.showOptionDialog(this, "There are no fabrics available for " + ClientController.getInstance().getFMUsername() + ".", "Exit - DCNM-SAN", -1, 2, null, options, options[0]);
                UIActions.getInstance().closeAction();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this._preferredSize;
    }

    void showMoreTabs() {
        this._tabsButton.setText("<< Less");
        if (this.hiddenTabStrings == null) {
            return;
        }
        int nTabs = this.hiddenTabStrings.length;
        this._tab.removeChangeListener(this);
        for (int i = 2; i < nTabs; ++i) {
            this._tab.add(this.hiddenTabStrings[i], this.hiddenTabComponents[i]);
        }
        this._tab.addChangeListener(this);
    }

    void showLessTabs() {
        this._tabsButton.setText("More >>");
        if (this._tab == null) {
            return;
        }
        int nTabs = this._tab.getTabCount();
        this.hiddenTabStrings = new String[nTabs];
        this.hiddenTabComponents = new Component[nTabs];
        for (int i = nTabs - 1; i > 1; --i) {
            this.hiddenTabStrings[i] = this._tab.getTitleAt(i);
            this.hiddenTabComponents[i] = this._tab.getComponentAt(i);
            this._tab.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._parentWindow instanceof RootPaneContainer && ((RootPaneContainer)((Object)this._parentWindow)).getGlassPane().isVisible()) {
            return;
        }
        String cmd = e.getActionCommand();
        final Component c = this._tab.getSelectedComponent();
        if (((AdminTableIf)((Object)c)).getTable().isEditing()) {
            ((AdminTableIf)((Object)c)).getTable().editingStopped(null);
        }
        if (e.getSource() == this._tabsButton) {
            if (cmd.startsWith("<<")) {
                this.showLessTabs();
            } else {
                this.showMoreTabs();
            }
            return;
        }
        Array cells = null;
        if (cmd.startsWith("Apply")) {
            if (c instanceof EthernetsPanel) {
                return;
            }
            if (c instanceof VirtualCenterServerPanel) {
                cells = this._virtualCenterServerPanel._tableModel.getChanged();
                if (cells != null && cells.size() > 0) {
                    try {
                        ModelFacadeRif modelFacadeRif = ClientController.getInstance().assertModelFacade();
                        for (int i = 0; i < cells.size(); ++i) {
                            Cell cell = (Cell)cells.elementAt(i);
                            int row = cell._row;
                            String vcIP = (String)this._virtualCenterServerPanel._tableModel.getValueAt(row, 0);
                            String username = (String)this._virtualCenterServerPanel._tableModel.getValueAt(row, 1);
                            String passwd = (String)this._virtualCenterServerPanel._tableModel.getValueAt(row, 2);
                            String discovery = (String)this._virtualCenterServerPanel._tableModel.getValueAt(row, 3);
                            username = username == null ? "" : username.trim();
                            String string = passwd = passwd == null ? "" : passwd.trim();
                            if (username.length() == 0 || passwd.length() == 0) {
                                throw new Exception("Username and password can not be empty");
                            }
                            boolean doDiscovery = discovery != null && discovery.startsWith("M");
                            modelFacadeRif.updateVirtualCenter(InetAddress.getByName(vcIP), username, passwd, doDiscovery);
                            if (!doDiscovery) continue;
                            this.addVirtualCenterToMonitorAndWaitLoop(((VirtualCenterBase)this._virtualCenterServerPanel._tableModel.getValueAt(row, 7)).getPK());
                        }
                    }
                    catch (Exception ex) {
                        this.doneAddingVirtualCentersToMonitorAndWaitLoop();
                        this._parentWindow.setCursor(null);
                        Util.errorMessage((Component)this, ex);
                    }
                    finally {
                        this.doneAddingVirtualCentersToMonitorAndWaitLoop();
                    }
                }
                return;
            }
            if (!(c instanceof FabricsPanel)) {
                return;
            }
            cells = this._fabricsPanel._tableModel.getChanged();
            if (cells != null && cells.size() > 0) {
                try {
                    FabricPK pk;
                    int i;
                    int[] credentialRowChange = new int[this._fabricsPanel._tableModel.getRowCount()];
                    ArrayList<CellData> cellData = new ArrayList<CellData>();
                    for (i = 0; i < cells.size(); ++i) {
                        Cell cell = (Cell)cells.elementAt(i);
                        pk = (FabricPK)this._fabricsPanel._tableModel.getValueAt(cell._row, 14);
                        if (cell._col >= 3 && cell._col <= 6) {
                            credentialRowChange[cell._row] = 1;
                            continue;
                        }
                        Object obj = this._fabricsPanel._tableModel.getValueAt(cell._row, cell._col);
                        if (obj == null) continue;
                        cellData.add(new CellData(pk, cell._row, cell._col, obj));
                    }
                    this._logger.debug((Object)"Updating Credentials");
                    for (i = 0; i < credentialRowChange.length; ++i) {
                        String password;
                        boolean isSnmpV3 = (Boolean)this._fabricsPanel._tableModel.getValueAt(i, 5);
                        if (credentialRowChange[i] != 1) continue;
                        pk = (FabricPK)this._fabricsPanel._tableModel.getValueAt(i, 14);
                        Object obj1 = this._fabricsPanel._tableModel.getValueAt(i, 3);
                        Object obj2 = this._fabricsPanel._tableModel.getValueAt(i, 4);
                        String userName = obj1 == null ? "" : obj1.toString().trim();
                        String string = password = obj2 == null ? "" : obj2.toString().trim();
                        if (isSnmpV3) {
                            if (userName.length() == 0 || password.length() == 0) {
                                throw new Exception("Username and password can not be empty");
                            }
                        } else if (userName.length() == 0) {
                            throw new Exception("Community can not be empty");
                        }
                        String snmpParams = (String)this._fabricsPanel._tableModel.getValueAt(i, 6);
                        SnmpUserOpt snmpUserOpt = new SnmpUserOpt(userName, password, userName, snmpParams, isSnmpV3);
                        try {
                            FMServerRif server = ClientController.getInstance().assertFMSConnection();
                            String ssoToken = ClientController.getInstance().getServerSession().getSSOToken();
                            server.setFabricCredentials(pk, snmpUserOpt, ssoToken);
                            JOptionPane.showMessageDialog(this, "SNMP credential is changed in " + pk);
                            continue;
                        }
                        catch (Exception ex) {
                            Util.errorMessage((Component)this, ex);
                        }
                    }
                    final ArrayList<CellData> finalCellData = cellData;
                    Thread updateCellsThread = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ControlPanel.this.updateCells(finalCellData);
                            }
                            catch (Exception ex) {
                                ControlPanel.this.doneAddingFabricsToMonitorAndWaitLoop();
                                ControlPanel.this._parentWindow.setCursor(null);
                                try {
                                    ((FabricsPanel)c).refresh(true);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                Util.errorMessage((Component)ControlPanel.this._parentWindow, ex);
                            }
                            finally {
                                ControlPanel.this.doneAddingFabricsToMonitorAndWaitLoop();
                                ControlPanel.this._parentWindow.setCursor(null);
                                ControlPanel.this._fabricsPanel._tableModel.resetChanges(false);
                                ControlPanel.this._fabricChanged = false;
                                ControlPanel.this.updateApplyButton();
                            }
                        }
                    });
                    updateCellsThread.start();
                }
                catch (Exception ex) {
                    this.doneAddingFabricsToMonitorAndWaitLoop();
                    this._parentWindow.setCursor(null);
                    Util.errorMessage((Component)this, ex);
                }
                this.doneAddingFabricsToMonitorAndWaitLoop();
                this._fabricsPanel._tableModel.resetChanges(false);
                this._fabricChanged = false;
                this.updateApplyButton();
            }
        } else if (cmd.startsWith("Remove")) {
            try {
                String title = null;
                if (this._parentWindow instanceof JDialog) {
                    title = ((JDialog)this._parentWindow).getTitle();
                } else if (this._parentWindow instanceof JFrame) {
                    title = ((JFrame)this._parentWindow).getTitle();
                }
                if (JOptionPane.showConfirmDialog(this, "Are you sure?", title, 0) == 0) {
                    ((AdminTableIf)((Object)c)).removeSelections();
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
            }
        } else if (cmd.startsWith("Refresh")) {
            this._parentWindow.setCursor(Cursor.getPredefinedCursor(3));
            RefreshThread refreshThread = new RefreshThread((AdminTableIf)((Object)c), false);
            refreshThread.start();
        } else if (cmd.startsWith("Add.")) {
            this.onAdd();
        } else if (cmd.startsWith("Edit")) {
            this.onEdit();
        } else if (cmd.startsWith("Close")) {
            this.onClose();
        } else if (cmd.startsWith("Open")) {
            try {
                this.onOpenFabric();
            }
            catch (Exception e1) {
                Util.errorMessage((Component)this, e1);
            }
        } else if (cmd.startsWith("Discover")) {
            this.onDiscoverFabric();
        } else if (cmd.startsWith("Rediscover")) {
            if (c instanceof VirtualCenterServerPanel) {
                try {
                    String title = null;
                    if (this._parentWindow instanceof JDialog) {
                        title = ((JDialog)this._parentWindow).getTitle();
                    } else if (this._parentWindow instanceof JFrame) {
                        title = ((JFrame)this._parentWindow).getTitle();
                    }
                    if (JOptionPane.showConfirmDialog(this, "Are you sure?", title, 0) == 0) {
                        ((VirtualCenterServerPanel)c).rediscoverSelection();
                    }
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, ex);
                }
            }
        } else if (cmd.startsWith("Connect")) {
            this.onConnect();
        } else if (cmd.startsWith("Move")) {
            if (!(c instanceof ServerPanel)) {
                return;
            }
            int[] rows = this._serverPanel._table.getSelectedRows();
            Object rowEditable = null;
            if (rows == null || rows.length == 0) {
                return;
            }
            ArrayList<FabricPK> fabricPks = new ArrayList<FabricPK>();
            for (int i = rows.length - 1; i >= 0; --i) {
                try {
                    int row = rows[i];
                    fabricPks.add((FabricPK)this._serverPanel._tableModel.getValueAt(row, this._serverPanel.FABRIC_PK_COLUMN));
                    continue;
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, ex);
                }
            }
            this.onMoveFabric(fabricPks);
        } else if (!cmd.startsWith("Manage LAN") && !cmd.startsWith("Unmanage LAN")) {
            if (cmd.startsWith("Reload License")) {
                this.onReloadLicenseFiles(null);
            } else if (cmd.startsWith("Assign License")) {
                this.onAssignLicense();
            } else if (cmd.startsWith("Unassign License")) {
                this.onUnassignLicense();
            } else if (cmd.startsWith("Add License")) {
                this.onAddLicenseFile();
            }
        }
    }

    private boolean onReloadLicenseFiles(String interestedFileName) {
        boolean loadSuccessful = false;
        Component c = this._tab.getSelectedComponent();
        if (c instanceof LicenseFilePanel) {
            try {
                List<String> errFileNames = ClientController.getInstance().assertFMSConnection().reloadLicenseFiles();
                ((LicenseFilePanel)c).refresh(false);
                if (errFileNames != null && errFileNames.size() > 0) {
                    if (interestedFileName == null) {
                        Object[] results = new Object[3];
                        results[0] = "The following files didn't load as they were considered invalid:";
                        results[1] = "<Possible reasons include: HOSTID didn't match, license expired, file not for this product or the license file was modified>";
                        JList<Object> displayList = new JList<Object>(errFileNames.toArray());
                        JScrollPane scrPan = new JScrollPane(displayList);
                        results[2] = scrPan;
                        JOptionPane.showMessageDialog(this, results, "Reload License Files", 0);
                        loadSuccessful = false;
                    } else if (interestedFileName != null && errFileNames.contains(interestedFileName)) {
                        Util.errorMessage((Component)this, "License file: " + interestedFileName + " not loaded as it was considered invalid.\nPossible reasons include: HOSTID didn't match, license expired or the license file was modified.");
                        loadSuccessful = false;
                    } else {
                        loadSuccessful = true;
                    }
                } else {
                    loadSuccessful = true;
                }
            }
            catch (Exception e) {
                this._logger.error((Object)"Error reloading the license files tab:", (Throwable)e);
                try {
                    ((LicenseFilePanel)c).refresh(false);
                }
                catch (Exception e2) {
                    this._logger.error((Object)"Error refreshing the license files tab:", (Throwable)e2);
                }
                Util.errorMessage((Component)this, e);
                loadSuccessful = false;
            }
        }
        return loadSuccessful;
    }

    private void onAddLicenseFile() {
        block10: {
            try {
                JFileChooser chooser = null;
                chooser = this.lastDirectory == null ? new JFileChooser() : new JFileChooser(this.lastDirectory);
                chooser.setDialogTitle("Select License File");
                chooser.setDialogType(0);
                chooser.setMultiSelectionEnabled(false);
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() ? true : f.getAbsolutePath().toLowerCase().endsWith(".lic");
                    }

                    @Override
                    public String getDescription() {
                        return "License files";
                    }
                };
                chooser.setFileFilter(filter);
                chooser.setFileSelectionMode(0);
                if (chooser.showOpenDialog(this) != 0) break block10;
                File file = chooser.getSelectedFile();
                this.lastDirectory = file.getParent();
                BufferedReader fileBR = null;
                if (!file.exists()) {
                    throw new Exception("File not found.");
                }
                if (!file.canRead()) {
                    throw new Exception("File cannot be read.");
                }
                fileBR = new BufferedReader(new FileReader(file));
                if (fileBR == null) {
                    throw new Exception("File cannot be loaded");
                }
                StringBuilder fileContents = new StringBuilder();
                char[] buf = new char[(int)file.length()];
                int len = fileBR.read(buf, 0, buf.length);
                fileContents.append(buf);
                fileBR.close();
                FMServerRif fmServerRif = ClientController.getInstance().assertFMSConnection();
                fmServerRif.saveLicenseFileToServer(fileContents.toString(), file.getName());
                boolean loadSuccessful = this.onReloadLicenseFiles(file.getName());
                if (!loadSuccessful) break block10;
                LanPK[] allLans = null;
                FabricPK[] allFabrics = ClientController.getInstance().getFabricPKs();
                try {
                    allLans = ClientController.getInstance().getAllLanPKs();
                }
                catch (Exception ex) {
                    this._logger.warn((Object)"Cannot get all LanPKs", (Throwable)ex);
                }
                try {
                    ClientController.getInstance().getFabricPKs();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if ((allFabrics != null && allFabrics.length > 0 || allLans != null && allLans.length > 0) && JOptionPane.showConfirmDialog(this, "License file loaded successfully.  Would you like to manually assign license files to existing switches now?", "License File Loaded", 0) == 0) {
                    this.showTab(License_Tab_Name);
                }
            }
            catch (Exception e) {
                Util.errorMessage((Component)this, e);
            }
        }
    }

    private void onAssignLicense() {
        Component c = this._tab.getSelectedComponent();
        if (c instanceof LicensePanel) {
            try {
                int rowNum = ((LicensePanel)c).getSelectedRowNum();
                Object[] row = ((LicensePanel)c).getSeletedRow();
                if (row != null) {
                    SwitchAssignedLicenseInfo oldLicObj = (SwitchAssignedLicenseInfo)row[((LicensePanel)c).LIC_ASSIGN_OBJ_COL];
                    SwitchAssignedLicenseInfo newlicObj = ClientController.getInstance().assertFMSConnection().assignAvailableLicenseToSwitch(oldLicObj.getDbID(), oldLicObj.getFabOrLanId(), oldLicObj.getProductType());
                    ((LicensePanel)c).updateLicenseDataAt(rowNum, newlicObj);
                    this.updateLicenseButtonState((LicensePanel)c, ((LicensePanel)c).getSelectedRowNum());
                }
            }
            catch (Exception e) {
                Util.errorMessage((Component)this, e);
            }
        }
    }

    private void onUnassignLicense() {
        Component c = this._tab.getSelectedComponent();
        if (c instanceof LicensePanel) {
            try {
                int rowNum = ((LicensePanel)c).getSelectedRowNum();
                Object[] row = ((LicensePanel)c).getSeletedRow();
                if (row != null) {
                    SwitchAssignedLicenseInfo oldLicObj = (SwitchAssignedLicenseInfo)row[((LicensePanel)c).LIC_ASSIGN_OBJ_COL];
                    SwitchAssignedLicenseInfo newlicObj = ClientController.getInstance().assertFMSConnection().unassignLicenseFromSwitch(oldLicObj.getDbID(), oldLicObj.getFabOrLanId(), oldLicObj.getProductType());
                    ((LicensePanel)c).updateLicenseDataAt(rowNum, newlicObj);
                    this.updateLicenseButtonState((LicensePanel)c, ((LicensePanel)c).getSelectedRowNum());
                }
            }
            catch (Exception e) {
                Util.errorMessage((Component)this, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUnManageLAN(LanPK lanPK) {
        Component c = this._tab.getSelectedComponent();
        if (c instanceof EthernetsPanel) {
            String title = null;
            if (this._parentWindow instanceof JDialog) {
                title = ((JDialog)this._parentWindow).getTitle();
            } else if (this._parentWindow instanceof JFrame) {
                title = ((JFrame)this._parentWindow).getTitle();
            }
            if (JOptionPane.showConfirmDialog(this, "Are you sure?", title, 0) == 0) {
                try {
                    ClientController.getInstance().closeLan(lanPK);
                }
                catch (Exception e) {
                    Util.errorMessage((Component)this, e);
                }
                finally {
                    try {
                        ((EthernetsPanel)c).refresh(false);
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onManageLAN(LanPK lanPK) {
        Component c = this._tab.getSelectedComponent();
        if (c instanceof EthernetsPanel) {
            String title = null;
            if (this._parentWindow instanceof JDialog) {
                title = ((JDialog)this._parentWindow).getTitle();
            } else if (this._parentWindow instanceof JFrame) {
                title = ((JFrame)this._parentWindow).getTitle();
            }
            if (JOptionPane.showConfirmDialog(this, "Are you sure?", title, 0) == 0) {
                try {
                    this.addLanToMonitorAndWaitLoop(lanPK);
                    ClientController.getInstance().openLan(lanPK);
                }
                catch (Exception e) {
                    this.doneAddingLansToMonitorAndWaitLoop();
                    Util.errorMessage((Component)this, e);
                }
                finally {
                    this.doneAddingLansToMonitorAndWaitLoop();
                    try {
                        ((EthernetsPanel)c).refresh(false);
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public void onConnect() {
        int i = this._serverPanel._table.getSelectedRow();
        String ip = (String)this._serverPanel._table.getValueAt(i, 1);
        try {
            ClientController.getInstance().resetConnection(ip);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, ex);
        }
    }

    public void onClose() {
        this._parentWindow.dispose();
        ClientController.getInstance().closeOnEmpty();
        if (this._needToUpdateFabricSelection) {
            try {
                this.onOpenFabric();
            }
            catch (Exception e1) {
                Util.errorMessage((Component)this, e1);
            }
        }
        this._needToUpdateFabricSelection = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resync() throws Exception {
        HashMap selectedFabricsMap = new HashMap();
        selectedFabricsMap.putAll(resyncSelectedFabricsMap);
        if (selectedFabricsMap != null) {
            try {
                BrowserFrame.getInstance().recordTreeSelection();
                ClientController.isLoadingFabrics = true;
                ClientController.getInstance().openFabrics(selectedFabricsMap, true, resyncSelectedFabricItemsMap);
            }
            finally {
                ClientController.isLoadingFabrics = false;
            }
        } else {
            ClientController.getInstance().setResyncComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOpenFabric() throws Exception {
        TableCellEditor editor;
        ControlPanelFrame f = ControlPanelFrame.getExistingInstance();
        if (f != null && f.isVisible()) {
            f.setCursor(Cursor.getPredefinedCursor(3));
        }
        if (this._openPanel._table.isEditing() && (editor = this._openPanel._table.getCellEditor()) != null) {
            try {
                editor.stopCellEditing();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        boolean isAAA = false;
        String authMode = ClientController.getInstance().assertSession().getServerProperty("authentication.mode");
        if (!(authMode == null || authMode.isEmpty() || authMode.equalsIgnoreCase("Local") || authMode.equalsIgnoreCase("mds"))) {
            isAAA = true;
        }
        if (isAAA) {
            int response;
            String fmLoginPassword = String.valueOf(ClientController.getInstance().getFMPassword()).trim();
            String username = ClientController.getInstance().getFMUsername();
            Map selectedFabricsMismatchMap = this._openPanel._tableModel.getSelectedFabricsWithAAAMismatchMap(ClientController.getInstance().getFMUsername(), fmLoginPassword);
            if (selectedFabricsMismatchMap != null && !selectedFabricsMismatchMap.isEmpty() && (response = JOptionPane.showConfirmDialog(this, "You logged in to DCNM with a different password than the selected fabrics' current password for '" + username + "'.\n" + "Would you like to replace the fabrics' passwords with your current login password?", "AAA Fabric Password Mismatch", 0)) == 0) {
                Set indices = selectedFabricsMismatchMap.keySet();
                for (Integer index : indices) {
                    this._openPanel._tableModel.setValueAt(fmLoginPassword, index, 4);
                }
            }
        }
        try {
            Map selectedFabricsMap = this._openPanel._tableModel.getSelectedFabricsAsMap();
            Map selectedFabricItemsMap = this._openPanel._tableModel.getSelectedFabricItemsAsMap();
            this.validateDataSourcesFromSameServer(selectedFabricsMap);
            this.handleSelectedLansToOpen();
            resyncSelectedFabricsMap.clear();
            resyncSelectedFabricItemsMap.clear();
            if (selectedFabricsMap != null) {
                resyncSelectedFabricsMap.putAll(selectedFabricsMap);
                resyncSelectedFabricItemsMap.putAll(selectedFabricItemsMap);
            }
            this.handleFabricsInClosing(selectedFabricsMap);
            this.handleFabricsInDiscovery(selectedFabricsMap);
            ClientController.isLoadingFabrics = true;
            ClientController.getInstance().openFabrics(selectedFabricsMap, false, selectedFabricItemsMap);
            f = ControlPanelFrame.getExistingInstance();
            if (f != null && f.isVisible()) {
                f.setCursor(null);
                f.setVisible(false);
            }
        }
        finally {
            ClientController.isLoadingFabrics = false;
            f = ControlPanelFrame.getExistingInstance();
            if (f != null && f.isVisible()) {
                f.setCursor(null);
            }
        }
    }

    private void validateDataSourcesFromSameServer(Map fabricOpts) throws Exception {
        FMServerRif serverif = ServerConnection.getInstance().getFMServerRif();
        String serverForFirstFabric = null;
        if (fabricOpts != null && fabricOpts.size() > 0) {
            FabricPK firstFPK = (FabricPK)fabricOpts.keySet().iterator().next();
            serverForFirstFabric = serverif.getServerForFabric(firstFPK);
            for (FabricPK fabricPk : fabricOpts.keySet()) {
                String serverForFabric = serverif.getServerForFabric(fabricPk);
                if (serverForFirstFabric == null || serverForFirstFabric.equals(serverForFabric)) continue;
                throw new Exception("Opening multiple fabrics/LAN is only supported for fabrics/LAN which are managed by the same server:\n" + firstFPK + ":" + serverForFirstFabric + "  " + fabricPk + ":" + serverForFabric);
            }
            ClientController cc = ClientController.getInstance();
            Map<LanPK, FabricItem> selectedLans = this._openPanel._tableModel.getSelectedLansAsMap();
            if (selectedLans != null && selectedLans.size() > 0) {
                Map.Entry<LanPK, FabricItem> ent = selectedLans.entrySet().iterator().next();
                LanPK selectedLanPK = ent.getKey();
                String serverForLan = serverif.getServerForFabric(selectedLanPK);
                if (serverForFirstFabric != null && !serverForFirstFabric.equals(serverForLan)) {
                    throw new Exception("Opening multiple fabrics/LAN is only supported for fabrics/LAN which are managed by the same server:\n" + firstFPK + ":" + serverForFirstFabric + "  " + selectedLanPK + ":" + serverForLan);
                }
            }
        }
    }

    private void handleSelectedLansToOpen() throws Exception {
        ClientController cc = ClientController.getInstance();
        Map<LanPK, FabricItem> selectedLans = this._openPanel._tableModel.getSelectedLansAsMap();
        LanPK prevLanPK = cc.getCurrentLanPK();
        if (selectedLans == null || selectedLans.size() == 0) {
            if (cc.showLan()) {
                cc.clientMonitorLan(prevLanPK, false);
            }
        } else {
            Map.Entry<LanPK, FabricItem> ent = selectedLans.entrySet().iterator().next();
            LanPK selectedLanPK = ent.getKey();
            FabricItem selectedLan = ent.getValue();
            FMServerRif serverif = ServerConnection.getInstance().getFMServerRif();
            String serverId = serverif.getServerForFabric(selectedLanPK);
            cc.resetServerConnection(serverif, serverId);
            if (prevLanPK != null && prevLanPK.equals(selectedLanPK)) {
                cc.clientMonitorLan(prevLanPK, true);
            } else if (prevLanPK != null) {
                cc.clientMonitorLan(prevLanPK, false);
            } else if (selectedLan.isManaged()) {
                cc.clientMonitorLan(selectedLanPK, true);
            } else {
                throw new Exception("Client cannot monitor an unmanaged LAN:" + selectedLanPK);
            }
        }
    }

    private void handleFabricsInDiscovery(Map fabricMap) throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        if (fabricMap != null && fabricMap.size() > 0) {
            ModelFacadeRif modelFacade = ClientController.getInstance().assertModelFacade();
            for (FabricPK fabricPk : fabricMap.keySet()) {
                if (modelFacade.isFabricOpened(fabricPk)) continue;
                ++i;
                sb.append("\n");
                sb.append(fabricPk.getName());
            }
        }
        if (i == 1) {
            throw new Exception("This fabric is still in discovery.  Please wait and try again." + sb.toString());
        }
        if (i > 1) {
            throw new Exception("These fabrics are still in discovery.  Please wait and try again." + sb.toString());
        }
    }

    private void handleFabricsInClosing(Map fabricMap) throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        if (fabricMap != null && fabricMap.size() > 0) {
            ClientController clientController = ClientController.getInstance();
            for (FabricPK fabricPk : fabricMap.keySet()) {
                int managedState = clientController.getFabricStatus(fabricPk);
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("fabric managed state - " + fabricPk + "," + managedState));
                }
                if (managedState != 5 && managedState != 6) continue;
                ++i;
                sb.append("\n");
                sb.append(fabricPk.getName());
            }
        }
        if (i == 1) {
            throw new Exception("This fabric is in the process of or is already unmanaged.  Please click refresh to update the fabric status." + sb.toString());
        }
        if (i > 1) {
            throw new Exception("These fabrics are in the process of or are already unmanaged.  Please click refresh to update the fabric status." + sb.toString());
        }
    }

    private void onDiscoverFabric() {
        Component c = this._tab.getSelectedComponent();
        boolean wantCDPDiscovery = false;
        if (c != null && c instanceof EthernetsPanel) {
            wantCDPDiscovery = true;
        }
        if (this._parentWindow instanceof JFrame) {
            AddFabricDialog d = new AddFabricDialog((JFrame)this._parentWindow, true, wantCDPDiscovery);
            d.setVisible(true);
        } else if (this._parentWindow instanceof JDialog) {
            AddFabricDialog d = new AddFabricDialog((JDialog)this._parentWindow, true, wantCDPDiscovery);
            d.setVisible(true);
        }
    }

    private void onMoveFabric(List<FabricPK> fabricPks) {
        if (fabricPks == null || fabricPks.size() < 1) {
            Util.errorMessage((Component)this, new Exception("At least one fabric must be selected."));
        } else if (this._parentWindow instanceof JFrame) {
            MoveFabricDialog d = new MoveFabricDialog((JFrame)this._parentWindow, fabricPks);
            d.setVisible(true);
        } else if (this._parentWindow instanceof JDialog) {
            MoveFabricDialog d = new MoveFabricDialog((JDialog)this._parentWindow, fabricPks);
            d.setVisible(true);
        }
    }

    private void onAdd() {
        Component c = this._tab.getSelectedComponent();
        if (c instanceof UsersPanel) {
            this.onAddUser();
        } else if (c instanceof ViewScopePanel) {
            this.onAddViewScope();
        } else if (c instanceof VirtualCenterServerPanel) {
            this.onAddVirtualCenterServer();
        }
    }

    private void onAddViewScope() {
        if (this._parentWindow instanceof JFrame) {
            EditViewScopeDialog dialog = new EditViewScopeDialog((JFrame)this._parentWindow, null, null, this.usersWithSwitchGroup);
            dialog.setVisible(true);
        } else if (this._parentWindow instanceof JDialog) {
            EditViewScopeDialog dialog = new EditViewScopeDialog((JDialog)this._parentWindow, null, null, this.usersWithSwitchGroup);
            dialog.setVisible(true);
        }
    }

    private void onAddVirtualCenterServer() {
        if (this._parentWindow instanceof JFrame) {
            EditVirtualCenterServerDialog dialog = new EditVirtualCenterServerDialog((JFrame)this._parentWindow);
            dialog.setVisible(true);
        } else if (this._parentWindow instanceof JDialog) {
            EditVirtualCenterServerDialog dialog = new EditVirtualCenterServerDialog((JDialog)this._parentWindow);
            dialog.setVisible(true);
        }
    }

    private void onAddUser() {
        if (this._parentWindow instanceof JFrame) {
            EditFMUserDialog dialog = new EditFMUserDialog((JFrame)this._parentWindow);
            dialog.setVisible(true);
        } else if (this._parentWindow instanceof JDialog) {
            EditFMUserDialog dialog = new EditFMUserDialog((JDialog)this._parentWindow);
            dialog.setVisible(true);
        }
    }

    private void updateApplyButton() {
        Component c = this._tab.getSelectedComponent();
        if (c instanceof FabricsPanel && this._applyButton.isVisible()) {
            this._applyButton.setEnabled(this._fabricChanged);
        } else if (c instanceof VirtualCenterServerPanel && this._applyButton.isVisible()) {
            this._applyButton.setEnabled(this._virtualCenterServerChanged);
        }
    }

    private void onEdit() {
        Object[] objs;
        Component c = this._tab.getSelectedComponent();
        if (c instanceof UsersPanel) {
            Object[] objs2 = ((UsersPanel)c).getSeletedRow();
            if (objs2 != null) {
                if (this._parentWindow instanceof JFrame) {
                    EditFMUserDialog dialog = new EditFMUserDialog((JFrame)this._parentWindow, (String)objs2[0], (String)objs2[2]);
                    dialog.setVisible(true);
                } else if (this._parentWindow instanceof JDialog) {
                    EditFMUserDialog dialog = new EditFMUserDialog((JDialog)this._parentWindow, (String)objs2[0], (String)objs2[2]);
                    dialog.setVisible(true);
                }
            }
        } else if (c instanceof VirtualCenterServerPanel) {
            Object[] objs3 = ((VirtualCenterServerPanel)c).getSeletedRow();
            if (objs3 != null) {
                if (this._parentWindow instanceof JFrame) {
                    EditVirtualCenterServerDialog dialog = new EditVirtualCenterServerDialog((JFrame)this._parentWindow, (String)objs3[0], (String)objs3[1]);
                    dialog.setVisible(true);
                } else if (this._parentWindow instanceof JDialog) {
                    EditVirtualCenterServerDialog dialog = new EditVirtualCenterServerDialog((JDialog)this._parentWindow, (String)objs3[0], (String)objs3[1]);
                    dialog.setVisible(true);
                }
            }
        } else if (c instanceof ViewScopePanel) {
            Object[] objs4 = ((ViewScopePanel)c).getSeletedRow();
            if (objs4 != null) {
                if (this._parentWindow instanceof JFrame) {
                    EditViewScopeDialog dialog = new EditViewScopeDialog((JFrame)this._parentWindow, (String)objs4[0], (String)objs4[2], this.usersWithSwitchGroup);
                    dialog.setVisible(true);
                } else if (this._parentWindow instanceof JDialog) {
                    EditViewScopeDialog dialog = new EditViewScopeDialog((JDialog)this._parentWindow, (String)objs4[0], (String)objs4[2], this.usersWithSwitchGroup);
                    dialog.setVisible(true);
                }
            }
        } else if (c instanceof EthernetsPanel && (objs = ((EthernetsPanel)c).getSeletedRow()) != null) {
            LanPK lanPK = null;
            CdpSeedBase seed = null;
            if (objs[0] != null && objs[0] instanceof LanPK) {
                lanPK = (LanPK)objs[0];
            }
            if (objs[12] != null && objs[12] instanceof CdpSeedBase) {
                seed = (CdpSeedBase)objs[12];
            }
            if (this._parentWindow instanceof JFrame) {
                AddFabricDialog d = new AddFabricDialog((JFrame)this._parentWindow, false, true);
                d.setTitle("Edit LAN CDP Seed");
                d.setCdpSeedBase(lanPK, seed);
                d.setVisible(true);
                try {
                    ((EthernetsPanel)c).refresh(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this._parentWindow instanceof JDialog) {
                AddFabricDialog d = new AddFabricDialog((JDialog)this._parentWindow, false, true);
                d.setTitle("Edit LAN CDP Seed");
                d.setCdpSeedBase(lanPK, seed);
                d.setVisible(true);
                try {
                    ((EthernetsPanel)c).refresh(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void editUser(String name, String role, char[] pass, boolean newUser) throws Exception {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            SessionRif session = ClientController.getInstance().assertSession();
            String encryptPass = ClientController.encrypt(String.valueOf(pass));
            if (newUser) {
                session.createUser(name, encryptPass, role, ClientController.getInstance().getUserName());
            } else {
                session.updateUser(name, encryptPass);
            }
            Component c = this._tab.getSelectedComponent();
            if (c instanceof UsersPanel) {
                ((UsersPanel)c).refresh(false);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.setCursor(null);
        }
    }

    private void updateCells(ArrayList<CellData> cellData) throws Exception {
        this._logger.debug((Object)"Updating Cells");
        if (cellData == null || cellData.size() == 0) {
            return;
        }
        CellData c = null;
        for (int i = 0; i < cellData.size(); ++i) {
            c = cellData.get(i);
            if (c == null) continue;
            this.updateCell(c.getPk(), c.getRow(), c.getCol(), c.getValue());
        }
    }

    private void updateCell(FabricPK pk, int row, int col, Object value) throws Exception {
        switch (col) {
            case 0: {
                String name = value.toString().trim();
                if (name.length() == 0) {
                    throw new Exception("Fabric name can't be empty");
                }
                if (name.contains(" ")) {
                    throw new Exception("Fabric name can't contain spaces.");
                }
                ClientController.getInstance().renameFabric(pk, name);
                break;
            }
            case 10: {
                if (value == null || !(value instanceof String)) break;
                String sValue = (String)value;
                if (ClientController.getInstance().isLocal(pk)) {
                    ModelFacadeRif modelFacade = ClientController.getInstance().assertModelFacade();
                    if (sValue.equalsIgnoreCase("Manage Continuously")) {
                        ClientController.getInstance().setFabricPersisted(pk, true);
                        if (!modelFacade.isManaged(pk)) {
                            this.addFabricToMonitorAndWaitLoop(pk);
                            modelFacade.manageFabric(pk);
                        }
                        this._fabricsPanel._tableModel.setValueAt("Managed", row, 11);
                        break;
                    }
                    if (sValue.equalsIgnoreCase("Manage")) {
                        if (!modelFacade.isManaged(pk)) {
                            this.addFabricToMonitorAndWaitLoop(pk);
                            modelFacade.manageFabric(pk);
                        }
                        ClientController.getInstance().setFabricPersisted(pk, false);
                        this._fabricsPanel._tableModel.setValueAt("Managed", row, 11);
                        break;
                    }
                    if (!sValue.equalsIgnoreCase("Unmanage")) break;
                    if (!modelFacade.isFabricOpened(pk)) {
                        throw new Exception("Fabric has not finished discovery");
                    }
                    boolean fabricInSan = false;
                    if (San.getInstance() != null && San.getInstance().getFabric(pk) != null) {
                        fabricInSan = true;
                    }
                    modelFacade.unmanageFabric(pk);
                    ClientController.getInstance().setFabricPersisted(pk, false);
                    this._fabricsPanel._tableModel.setValueAt("Unmanaged", row, 11);
                    if (!fabricInSan) break;
                    this._needToUpdateFabricSelection = true;
                    break;
                }
                FMServerRif remoteToServerRif = ClientController.getInstance().assertFMSConnection();
                String ssoToken = ClientController.getInstance().getServerSession().getSSOToken();
                ModelFacadeRif modelFacade = ClientController.getInstance().assertModelFacade();
                if (sValue.equalsIgnoreCase("Manage Continuously")) {
                    ClientController.getInstance().setRemoteFabricPersisted(pk, true);
                    if (!modelFacade.isManaged(pk)) {
                        this.addFabricToMonitorAndWaitLoop(pk);
                        remoteToServerRif.manageFabric(pk, ssoToken);
                    }
                    this._fabricsPanel._tableModel.setValueAt("Managed", row, 11);
                    break;
                }
                if (sValue.equalsIgnoreCase("Manage")) {
                    if (!modelFacade.isManaged(pk)) {
                        this.addFabricToMonitorAndWaitLoop(pk);
                        remoteToServerRif.manageFabric(pk, ssoToken);
                    }
                    ClientController.getInstance().setRemoteFabricPersisted(pk, false);
                    this._fabricsPanel._tableModel.setValueAt("Managed", row, 11);
                    break;
                }
                if (!sValue.equalsIgnoreCase("Unmanage")) break;
                if (!modelFacade.isFabricOpened(pk)) {
                    throw new Exception("Fabric has not finished discovery");
                }
                boolean fabricInSan = false;
                if (San.getInstance() != null && San.getInstance().getFabric(pk) != null) {
                    fabricInSan = true;
                }
                remoteToServerRif.unmanageFabric(pk, ssoToken);
                ClientController.getInstance().setRemoteFabricPersisted(pk, false);
                this._fabricsPanel._tableModel.setValueAt("Unmanaged", row, 11);
                if (!fabricInSan) break;
                this._needToUpdateFabricSelection = true;
                break;
            }
            case 1: {
                int pollInterval = Integer.parseInt(value.toString());
                if (pollInterval < 76) {
                    throw new Exception("Polling interval should be at least 76 secs");
                }
                ClientController.getInstance().assertModelFacade().setPollInterval(pk, pollInterval);
                break;
            }
            case 2: {
                int cycles = Integer.parseInt(value.toString());
                if (cycles < 1) {
                    throw new Exception("Cycles must be >= 1");
                }
                ClientController.getInstance().assertModelFacade().setRediscoverInterval(pk, cycles);
                break;
            }
            case 7: {
                ModelFacadeRif modelFacade = ClientController.getInstance().assertModelFacade();
                Fabric fabric = San.getInstance().getFabric(pk);
                boolean oldValue = true;
                oldValue = fabric != null ? fabric.isFcAlias() : modelFacade.useFcAlias(pk);
                if (oldValue == (Boolean)value) break;
                ChangedModelObject devAlias = new ChangedModelObject(pk, 522, Boolean.valueOf(oldValue), (Boolean)value);
                modelFacade.propertyChanged(pk, devAlias);
                if (fabric == null) break;
                fabric.setFcAlias((Boolean)value);
            }
        }
    }

    private void addFabricToMonitorAndWaitLoop(FabricPK pk) {
        if (pk == null) {
            return;
        }
        if (this._manageFabricThread == null || !this._manageFabricThread.isAlive()) {
            this._manageFabricThread = new ManageFabricThread();
            this._manageFabricThread.setListener(this);
            this._manageFabricThread.setComponent(this._parentWindow);
            this._manageFabricThread.start();
        }
        this._manageFabricThread.addFabric(pk);
    }

    private void doneAddingFabricsToMonitorAndWaitLoop() {
        if (this._manageFabricThread != null && this._manageFabricThread.isAlive()) {
            this._manageFabricThread.doneAddingFabrics();
        }
    }

    private void addLanToMonitorAndWaitLoop(LanPK pk) {
        if (pk == null) {
            return;
        }
        if (this._manageLanThread == null || !this._manageLanThread.isAlive()) {
            this._manageLanThread = new ManageLanThread();
            this._manageLanThread.setListener(this);
            this._manageLanThread.setComponent(this._parentWindow);
            this._manageLanThread.start();
        }
        this._manageLanThread.addLan(pk);
    }

    private void doneAddingLansToMonitorAndWaitLoop() {
        if (this._manageLanThread != null && this._manageLanThread.isAlive()) {
            this._manageLanThread.doneAddingLans();
        }
    }

    private void addVirtualCenterToMonitorAndWaitLoop(PKIf pk) {
        if (pk == null) {
            return;
        }
        if (this._manageVirtualCenterServerThread == null || !this._manageVirtualCenterServerThread.isAlive()) {
            this._manageVirtualCenterServerThread = new ManageVirtualCenterThread();
            this._manageVirtualCenterServerThread.setListener(this);
            this._manageVirtualCenterServerThread.setComponent(this._parentWindow);
            this._manageVirtualCenterServerThread.start();
        }
        this._manageVirtualCenterServerThread.addVirtualCenter(pk);
    }

    private void doneAddingVirtualCentersToMonitorAndWaitLoop() {
        if (this._manageVirtualCenterServerThread != null && this._manageVirtualCenterServerThread.isAlive()) {
            this._manageVirtualCenterServerThread.doneAddingVirtualCenters();
        }
    }

    public void handleFabricDeleted() {
        try {
            int selectedTabIndex = this._tab.getSelectedIndex();
            switch (selectedTabIndex) {
                case 0: {
                    if (this._openPanel == null) break;
                    RefreshThread refreshThread = new RefreshThread(this._openPanel, false);
                    refreshThread.start();
                    break;
                }
                case 1: {
                    if (this._fabricsPanel == null) break;
                    RefreshThread refreshThread = new RefreshThread(this._fabricsPanel, false);
                    refreshThread.start();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void handleFinished(PKIf pk) {
        Runnable updateFabricTables = new Runnable(){

            @Override
            public void run() {
                try {
                    ((AdminTableIf)((Object)ControlPanel.this._tab.getSelectedComponent())).refresh(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            updateFabricTables.run();
        } else {
            SwingUtilities.invokeLater(updateFabricTables);
        }
    }

    public JLabel getDiscoveringFabricPleaseWait() {
        return this.discoveringFabricPleaseWait;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component c = this._tab.getSelectedComponent();
        this._deleteButton.setEnabled(false);
        this._deleteButton.setVisible(true);
        this._addLicenseFileButton.setEnabled(false);
        this._reloadLicenseFileButton.setEnabled(false);
        this._rediscoverButton.setEnabled(false);
        this._rediscoverButton.setVisible(false);
        this._purgeButton.setEnabled(false);
        this._purgeButton.setVisible(false);
        if (c instanceof FabricsPanel) {
            this._openButton.setVisible(false);
            this._discoverButton.setVisible(true);
            this._applyButton.setVisible(true);
            this._applyButton.setEnabled(this._fabricChanged);
            this._newButton.setVisible(false);
            this._editButton.setVisible(false);
            this._connectButton.setVisible(false);
            this._manageLanButton.setVisible(false);
            this._unManageLanButton.setVisible(false);
            this._addLicenseFileButton.setVisible(false);
            this._reloadLicenseFileButton.setVisible(false);
            this._unassignLicenseButton.setVisible(false);
            this._assignLicenseButton.setVisible(false);
        } else if (c instanceof ViewScopePanel) {
            this._openButton.setVisible(false);
            this._discoverButton.setVisible(false);
            this._applyButton.setVisible(false);
            this._applyButton.setEnabled(false);
            this._newButton.setVisible(true);
            this._newButton.setEnabled(ClientController.getInstance().isAdmin() && ClientController.getInstance().getNonNetworkAdminUsers().size() > 0);
            this._editButton.setVisible(true);
            this._editButton.setEnabled(false);
            this._connectButton.setVisible(false);
            this._manageLanButton.setVisible(false);
            this._unManageLanButton.setVisible(false);
            this._addLicenseFileButton.setVisible(false);
            this._reloadLicenseFileButton.setVisible(false);
            this._unassignLicenseButton.setVisible(false);
            this._assignLicenseButton.setVisible(false);
        } else if (c instanceof OpenFabricsPanel) {
            this._openButton.setVisible(true);
            this._discoverButton.setVisible(true);
            this._newButton.setVisible(false);
            this._applyButton.setVisible(false);
            this._deleteButton.setVisible(false);
            this._editButton.setVisible(false);
            this._connectButton.setVisible(false);
            this._manageLanButton.setVisible(false);
            this._unManageLanButton.setVisible(false);
            this._addLicenseFileButton.setVisible(false);
            this._reloadLicenseFileButton.setVisible(false);
            this._unassignLicenseButton.setVisible(false);
            this._assignLicenseButton.setVisible(false);
        } else if (c instanceof ServerPanel) {
            this._openButton.setVisible(false);
            this._discoverButton.setVisible(false);
            this._newButton.setVisible(false);
            this._applyButton.setVisible(false);
            this._deleteButton.setVisible(false);
            this._manageLanButton.setVisible(false);
            this._unManageLanButton.setVisible(false);
            this._editButton.setVisible(false);
            this._connectButton.setEnabled(true);
            this._addLicenseFileButton.setVisible(false);
            this._reloadLicenseFileButton.setVisible(false);
            this._unassignLicenseButton.setVisible(false);
            this._assignLicenseButton.setVisible(false);
        } else if (c instanceof LicenseFilePanel) {
            this._openButton.setVisible(false);
            this._discoverButton.setVisible(false);
            this._newButton.setVisible(false);
            this._applyButton.setVisible(false);
            this._deleteButton.setVisible(false);
            this._manageLanButton.setVisible(false);
            this._unManageLanButton.setVisible(false);
            this._editButton.setVisible(false);
            this._connectButton.setEnabled(false);
            boolean isAdmin = ClientController.getInstance().isAdmin();
            this._addLicenseFileButton.setVisible(true);
            this._addLicenseFileButton.setEnabled(isAdmin);
            this._reloadLicenseFileButton.setVisible(true);
            this._reloadLicenseFileButton.setEnabled(isAdmin);
            this._unassignLicenseButton.setVisible(false);
            this._assignLicenseButton.setVisible(false);
        } else if (c instanceof LicensePanel) {
            this._openButton.setVisible(false);
            this._discoverButton.setVisible(false);
            this._newButton.setVisible(false);
            this._applyButton.setVisible(false);
            this._deleteButton.setVisible(false);
            this._manageLanButton.setVisible(false);
            this._unManageLanButton.setVisible(false);
            this._editButton.setVisible(false);
            this._connectButton.setEnabled(false);
            this._addLicenseFileButton.setVisible(false);
            this._reloadLicenseFileButton.setVisible(false);
            this._assignLicenseButton.setVisible(true);
            this._unassignLicenseButton.setVisible(true);
        }
        this._parentWindow.setCursor(Cursor.getPredefinedCursor(3));
        RefreshThread refreshThread = new RefreshThread((AdminTableIf)((Object)c), true);
        refreshThread.start();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Component c = this._tab.getSelectedComponent();
        boolean enable = false;
        int selectedRowIndex = -1;
        if (c instanceof AdminTableIf) {
            enable = ((AdminTableIf)((Object)c)).getTable().getSelectedRowCount() > 0;
            selectedRowIndex = ((AdminTableIf)((Object)c)).getTable().getSelectedRow();
        }
        if (c instanceof EthernetsPanel) {
            this._editButton.setEnabled(enable);
        }
        if (c instanceof UsersPanel || c instanceof ViewScopePanel || c instanceof VirtualCenterServerPanel) {
            if (selectedRowIndex < 0) {
                this._editButton.setEnabled(false);
            } else if (ClientController.getInstance().isAdmin()) {
                this._editButton.setEnabled(true);
            } else {
                try {
                    String selectedUserName = (String)((AdminTableIf)((Object)c)).getTable().getValueAt(selectedRowIndex, 0);
                    if (ClientController.getInstance().getFMUsername().equalsIgnoreCase(selectedUserName)) {
                        this._editButton.setEnabled(true);
                    } else {
                        this._editButton.setEnabled(false);
                    }
                }
                catch (Exception ex) {
                    this._logger.debug((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if (c instanceof UsersPanel || c instanceof ClientsPanel || c instanceof FabricsPanel || c instanceof EthernetsPanel || c instanceof ViewScopePanel || c instanceof VirtualCenterServerPanel) {
            if (selectedRowIndex < 0) {
                this._deleteButton.setEnabled(false);
                this._rediscoverButton.setEnabled(false);
            } else if (ClientController.getInstance().isAdmin()) {
                String status;
                this._deleteButton.setEnabled(true);
                this._rediscoverButton.setEnabled(false);
                if (c instanceof VirtualCenterServerPanel && (status = (String)((AdminTableIf)((Object)c)).getTable().getValueAt(selectedRowIndex, 3)) != null && !status.contains("nmanage")) {
                    this._rediscoverButton.setEnabled(true);
                }
            } else {
                this._deleteButton.setEnabled(false);
                this._rediscoverButton.setEnabled(false);
            }
        }
        if (c instanceof LicensePanel) {
            this.updateLicenseButtonState((LicensePanel)c, selectedRowIndex);
        }
    }

    private void updateLicenseButtonState(LicensePanel licPanel, int selectedRowIndex) {
        if (selectedRowIndex < 0) {
            this._unassignLicenseButton.setEnabled(false);
            this._assignLicenseButton.setEnabled(false);
        } else if (ClientController.getInstance().isAdmin()) {
            String licenseState = (String)licPanel.getTable().getValueAt(selectedRowIndex, licPanel.LIC_STATE_COL);
            String licenseType = (String)licPanel.getTable().getValueAt(selectedRowIndex, licPanel.LIC_TYPE_COL);
            if (licenseType != null && licenseType.length() > 0) {
                if (licenseType.equals("DCNM-Server") && licenseState != null) {
                    this._unassignLicenseButton.setEnabled(true);
                    this._assignLicenseButton.setEnabled(false);
                } else if (licenseType.equals("Switch") && licenseState != null && !licenseState.equals("Permanent")) {
                    this._unassignLicenseButton.setEnabled(false);
                    this._assignLicenseButton.setEnabled(true);
                }
            } else if (licPanel.lic_Not_Support_Strs.contains(licenseState)) {
                this._unassignLicenseButton.setEnabled(false);
                this._assignLicenseButton.setEnabled(false);
            } else {
                this._unassignLicenseButton.setEnabled(false);
                this._assignLicenseButton.setEnabled(true);
            }
        }
    }

    @Override
    public boolean contains(FabricPK fabricPK) {
        if (this._openPanel != null && this._tab.getSelectedComponent() == this._openPanel) {
            return this._openPanel.contains(fabricPK);
        }
        if (this._ethernetsPanel != null && this._tab.getSelectedComponent() == this._ethernetsPanel) {
            return this._ethernetsPanel.contains(fabricPK);
        }
        return false;
    }

    @Override
    public void addFabricItem(FabricPK fabricPK, SnmpUserOpt snmpUserOpt, boolean licensed, boolean evalLicensed) {
        Runnable updateFabricTables = new Runnable(){

            @Override
            public void run() {
                try {
                    ((AdminTableIf)((Object)ControlPanel.this._tab.getSelectedComponent())).refresh(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            updateFabricTables.run();
        } else {
            SwingUtilities.invokeLater(updateFabricTables);
        }
    }

    @Override
    public void addGroup(String userName, GroupPK[] groups) throws Exception {
        ModelFacadeRif modelFacadeRif = ClientController.getInstance().assertModelFacade();
        modelFacadeRif.addGroup(userName, groups);
        Component c = this._tab.getSelectedComponent();
        if (c instanceof ViewScopePanel) {
            ((ViewScopePanel)c).refresh(false);
        }
    }

    @Override
    public void updateGroup(String userName, GroupPK[] groups) throws Exception {
        ModelFacadeRif modelFacadeRif = ClientController.getInstance().assertModelFacade();
        modelFacadeRif.updateGroup(userName, groups);
        Component c = this._tab.getSelectedComponent();
        if (c instanceof ViewScopePanel) {
            ((ViewScopePanel)c).refresh(false);
        }
    }

    @Override
    public VirtualCenterBase addVirtualCenter(InetAddress vcIP, String username, String passwd, boolean discovery, String targetServerIp) throws Exception {
        VirtualCenterBase vcBase = null;
        FMServerRif fmserver = ClientController.getInstance().assertFMSConnection();
        if (targetServerIp != null && targetServerIp.length() > 0) {
            fmserver = ClientController.getInstance().getRemoteFMServer(targetServerIp);
            vcBase = fmserver.addVirtualCenter(vcIP, username, passwd, discovery);
        } else {
            ModelFacadeRif modelFacadeRif = ClientController.getInstance().assertModelFacade();
            vcBase = modelFacadeRif.addVirtualCenter(vcIP, username, passwd, discovery);
        }
        Component c = this._tab.getSelectedComponent();
        if (c instanceof VirtualCenterServerPanel) {
            ((VirtualCenterServerPanel)c).refresh(false);
        }
        if (discovery) {
            this.addVirtualCenterToMonitorAndWaitLoop(vcBase.getPK());
            this.doneAddingVirtualCentersToMonitorAndWaitLoop();
        }
        return vcBase;
    }

    @Override
    public void updateVirtualCenter(InetAddress vcIP, String username, String passwd, boolean discovery, String targetServerIp) throws Exception {
        FMServerRif fmserver = ClientController.getInstance().assertFMSConnection();
        if (targetServerIp != null && targetServerIp.length() > 0) {
            fmserver = ClientController.getInstance().getRemoteFMServer(targetServerIp);
            fmserver.updateVirtualCenter(vcIP, username, passwd, discovery);
        } else {
            ModelFacadeRif modelFacadeRif = ClientController.getInstance().assertModelFacade();
            modelFacadeRif.updateVirtualCenter(vcIP, username, passwd, discovery);
        }
        Component c = this._tab.getSelectedComponent();
        if (c instanceof VirtualCenterServerPanel) {
            ((VirtualCenterServerPanel)c).refresh(false);
        }
    }

    class LicensePanel
    extends JPanel
    implements AdminTableIf {
        public final int LIC_ASSIGN_OBJ_COL = LICENSE_ASSIGN_LABELS.length + 1;
        public final int LIC_STATE_COL = 3;
        public final int LIC_TYPE_COL = 4;
        public final int LIC_EXPIRE_COL = 5;
        KTableModel _tableModel;
        SnmpKTable _table;
        JEditorPane _licInfoLabel = new JEditorPane();
        public List<String> lic_Not_Support_Strs = new ArrayList<String>();
        private List<String> valid_Lic_States = new ArrayList<String>();

        public LicensePanel(ControlPanel adialog) {
            String[] validStates;
            for (String next : validStates = SwitchLicenseDetails.LICENSED_STATE_STRS) {
                this.valid_Lic_States.add(next);
            }
            for (String next : SwitchAssignedLicenseInfo.NO_LICENSE_SUPPORT_STRS) {
                this.valid_Lic_States.add(next);
                this.lic_Not_Support_Strs.add(next);
            }
            this.setLayout(new BorderLayout());
            this._licInfoLabel.setEditable(false);
            this._licInfoLabel.setEnabled(true);
            this._licInfoLabel.setContentType("text/html");
            this._licInfoLabel.setFont(new Font("Arial", 1, 12));
            this.add((Component)this._licInfoLabel, "North");
            this._tableModel = new KTableModel();
            this._tableModel.setHeaders(LICENSE_ASSIGN_LABELS);
            this._table = new SnmpKTable(this._tableModel){

                @Override
                public boolean isCellEditable(int r, int c) {
                    return false;
                }
            };
            this._table.setSelectionMode(0);
            this._table.setRowSelectionAllowed(true);
            this._table.setChangeListener(adialog);
            this._table.getColumnModel().getColumn(3).setCellRenderer(new YellowUnlicensedRenderer(this.valid_Lic_States));
            this._table.getColumnModel().getColumn(5).setCellRenderer(new RedLicenseExpiringRenderer());
            Dimension size = this._table.calcPreferredSize();
            if (size.height > 300) {
                size.height = 300;
            }
            JScrollPane sp = new JScrollPane(this._table);
            sp.setPreferredSize(size);
            this.add((Component)sp, "Center");
            this._table.getTableHeader().addMouseListener(new HeaderListener());
            this._table.setSortable(true);
        }

        @Override
        public void refresh(boolean rememberSelection) throws Exception {
            Array<Object[]> data = new Array<Object[]>();
            FMServerRif fmServerRif = ClientController.getInstance().assertFMSConnection();
            List<SwitchAssignedLicenseInfo> switchLicAssignment = fmServerRif.getLicenseInfoSwitchAssignment();
            for (SwitchAssignedLicenseInfo nextSwitchLicDetail : switchLicAssignment) {
                Object[] cols = new Object[LICENSE_ASSIGN_LABELS.length + 3];
                cols[0] = nextSwitchLicDetail.getFabricOrLanName();
                cols[1] = nextSwitchLicDetail.getSysName();
                cols[2] = nextSwitchLicDetail.getSwitchModel();
                cols[3] = nextSwitchLicDetail.getLicenseState();
                cols[4] = nextSwitchLicDetail.getLicenseType();
                cols[5] = nextSwitchLicDetail.getExpireDateStr();
                cols[this.LIC_ASSIGN_OBJ_COL] = nextSwitchLicDetail;
                data.addElement(cols);
            }
            this._tableModel.setData(data);
            this._tableModel.fireTableDataChanged();
            this.updateLicenseRatioInfo();
        }

        public void updateLicenseRatioInfo() {
            Array data = this._tableModel.getData();
            int switchCount = data.size();
            int totalSwCount = 0;
            int unlicensedCount = 0;
            for (int i = 0; i < switchCount; ++i) {
                Object[] row = (Object[])data.elementAt(i);
                String licState = (String)row[3];
                if (!this.valid_Lic_States.contains(licState)) {
                    ++unlicensedCount;
                }
                ++totalSwCount;
            }
            this._licInfoLabel.setText("Unlicensed/Total Switches: " + unlicensedCount + "/" + totalSwCount);
        }

        @Override
        public KTable getTable() {
            return this._table;
        }

        @Override
        public void removeSelections() throws Exception {
        }

        public void updateLicenseDataAt(int row, SwitchAssignedLicenseInfo switchLicDetail) {
            int col = 3;
            String value = switchLicDetail.getLicenseState();
            this._tableModel.setValueAt(value, row, col);
            col = 4;
            value = switchLicDetail.isLicensed() ? switchLicDetail.getLicenseType() : "";
            this._tableModel.setValueAt(value, row, col);
            col = 5;
            value = switchLicDetail.getExpireDateStr();
            if (value == null) {
                value = "";
            }
            this._tableModel.setValueAt(value, row, col);
            this.updateLicenseRatioInfo();
        }

        public int getSelectedRowNum() {
            return this._table.getSelectedRow();
        }

        @Override
        public Object[] getSeletedRow() {
            int row = this._table.getSelectedRow();
            if (row < 0) {
                return null;
            }
            return (Object[])this._tableModel.getData().elementAt(row);
        }
    }

    class LicenseFilePanel
    extends JPanel
    implements AdminTableIf {
        KTableModel _tableModel;
        SnmpKTable _table;
        JEditorPane _fileLocLabel = new JEditorPane();
        public String evaluationDownloadURL = "https://tools.cisco.com/SWIFT/LicensingUI/loadDemoLicensee?FormId=65";
        public String permanentDownloadURL = "https://tools.cisco.com/SWIFT/LicensingUI/Home";

        public LicenseFilePanel(ControlPanel adialog) {
            this.setLayout(new BorderLayout());
            this._fileLocLabel.setEditable(false);
            this._fileLocLabel.setEnabled(true);
            this._fileLocLabel.setContentType("text/html");
            try {
                ClientController cctrl = ClientController.getInstance();
                FMServerRif localServer = cctrl.assertFMSConnection();
                String licenseHostID = localServer.getLicenseHostID();
                StringBuilder sb = new StringBuilder("");
                sb.append("Use Server ").append(licenseHostID).append(" to fetch ");
                sb.append("<font color='#111111'><u><a href=\"").append(this.evaluationDownloadURL).append("\">evaluation</a></u></font> or ");
                sb.append("<font color='#111111'><u><a href=\"").append(this.permanentDownloadURL).append("\">permanent</a></u></font> license file from CCO.  <br/>(Save license file locally, then select 'Add License File...')");
                sb.append("<br/>Note: you need a CCO account for this.<br/>");
                this._fileLocLabel.setText(sb.toString());
                this._fileLocLabel.addHyperlinkListener(new Hyperactive());
            }
            catch (Exception e) {
                this._fileLocLabel.setText("First installed server in federation is not reachable");
            }
            this._fileLocLabel.setFont(new Font("Arial", 1, 12));
            this.add((Component)this._fileLocLabel, "North");
            this._tableModel = new KTableModel();
            this._tableModel.setHeaders(LICENSE_FILE_LABELS);
            this._table = new SnmpKTable(this._tableModel){

                @Override
                public boolean isCellEditable(int r, int c) {
                    return false;
                }
            };
            this._table.setSelectionMode(0);
            this._table.setRowSelectionAllowed(true);
            this._table.setChangeListener(adialog);
            Dimension size = this._table.calcPreferredSize();
            if (size.height > 300) {
                size.height = 300;
            }
            JScrollPane sp = new JScrollPane(this._table);
            sp.setPreferredSize(size);
            this.add((Component)sp, "Center");
            this._table.getTableHeader().addMouseListener(new HeaderListener());
            this._table.setSortable(true);
            this._table.getColumnModel().getColumn(3).setCellRenderer(new PercentBarCellRenderer());
            this._table.getColumnModel().getColumn(4).setCellRenderer(new PercentBarCellRenderer());
            this._table.getColumnModel().getColumn(5).setCellRenderer(new RedLicenseExpiringRenderer());
        }

        @Override
        public void refresh(boolean rememberSelection) throws Exception {
            Array<Object[]> data = new Array<Object[]>();
            FMServerRif fmServerRif = ClientController.getInstance().assertFMSConnection();
            List<LicenseInfoFlex> licList = fmServerRif.getFileLicenseInfo();
            Map<String, LicenseFileUsage> licUsageMap = fmServerRif.getFileLicenseUsageInfo();
            for (LicenseInfoFlex nextLic : licList) {
                LicenseFileUsage usage = licUsageMap.get(nextLic.getSignature());
                List<Integer> licProductTypes = usage.getProductTypes();
                Object[] cols = new Object[LICENSE_FILE_LABELS.length + 2];
                cols[0] = nextLic.getLicenseFile();
                cols[1] = nextLic.getFeatureName();
                cols[2] = nextLic.getPid();
                Object sanFree = null;
                Object lanFree = null;
                if (usage != null) {
                    if (licProductTypes.contains(1)) {
                        int sanFreeCount = nextLic.getDeviceCount() - usage.getUsedSanCount();
                        sanFree = new PercentBarCellObject(sanFreeCount + " / " + nextLic.getDeviceCount(), sanFreeCount, nextLic.getDeviceCount());
                    } else {
                        sanFree = "";
                    }
                    if (licProductTypes.contains(2)) {
                        int lanFreeCount = nextLic.getDeviceCount() - usage.getUsedLanCount();
                        lanFree = new PercentBarCellObject(lanFreeCount + " / " + nextLic.getDeviceCount(), lanFreeCount, nextLic.getDeviceCount());
                    } else {
                        lanFree = "";
                    }
                }
                cols[3] = sanFree;
                cols[4] = lanFree;
                cols[5] = nextLic.getExpDate() == null ? null : nextLic.getExpDate().getTime();
                cols[7] = nextLic;
                data.addElement(cols);
            }
            this._tableModel.setData(data);
            this._tableModel.fireTableDataChanged();
        }

        @Override
        public KTable getTable() {
            return this._table;
        }

        @Override
        public void removeSelections() throws Exception {
        }

        @Override
        public Object[] getSeletedRow() {
            int row = this._table.getSelectedRow();
            if (row < 0) {
                return null;
            }
            return (Object[])this._tableModel.getData().elementAt(row);
        }

        class Hyperactive
        implements HyperlinkListener {
            Hyperactive() {
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        ExternalTools.openURL(e.getDescription());
                    }
                    catch (Exception ex) {
                        Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                    }
                }
            }
        }
    }

    class ServerPanel
    extends Box
    implements AdminTableIf {
        KTableModel _tableModel;
        SnmpKTable _table;
        ControlPanel _parent;
        public int FABRIC_PK_COLUMN;

        public ServerPanel(ControlPanel adialog) {
            super(1);
            this.FABRIC_PK_COLUMN = SERVER_LABELS.length;
            this._tableModel = new KTableModel();
            this._tableModel.setHeaders(SERVER_LABELS);
            this._table = new SnmpKTable(this._tableModel){

                @Override
                public TableCellRenderer getCellRenderer(int row, int column) {
                    return super.getCellRenderer(row, column);
                }

                @Override
                public boolean isCellEditable(int r, int c) {
                    return false;
                }
            };
            this._table.setSelectionMode(2);
            this._table.setRowSelectionAllowed(true);
            this._table.setChangeListener(adialog);
            Dimension size = this._table.calcPreferredSize();
            if (size.height > 300) {
                size.height = 300;
            }
            JScrollPane sp = new JScrollPane(this._table);
            sp.setPreferredSize(size);
            this.add(sp);
            this._table.getTableHeader().addMouseListener(new HeaderListener());
            this._table.setSortable(true);
        }

        @Override
        public void refresh(boolean rememberSelection) throws Exception {
            int i;
            LanPK[] lanPKs;
            Long fStart = System.currentTimeMillis();
            Array<Object[]> data = new Array<Object[]>();
            ArrayList<FabricPK> pkList = new ArrayList<FabricPK>(10);
            FabricPK[] fabricPKs = ClientController.getInstance().getFabricPKs();
            if (fabricPKs != null && fabricPKs.length > 0) {
                for (FabricPK pk : fabricPKs) {
                    pkList.add(pk);
                }
            }
            if ((lanPKs = ClientController.getInstance().getAllLanPKs()) != null && lanPKs.length > 0) {
                for (LanPK pk : lanPKs) {
                    pkList.add(pk);
                }
            }
            ArrayList<ServerPanelLoadingThread> threadList = new ArrayList<ServerPanelLoadingThread>();
            for (FabricPK pk : pkList) {
                ServerPanelLoadingThread th = new ServerPanelLoadingThread(pk);
                threadList.add(th);
                th.start();
            }
            for (i = 0; i < threadList.size(); ++i) {
                ServerPanelLoadingThread th = (ServerPanelLoadingThread)threadList.get(i);
                try {
                    th.join();
                    continue;
                }
                catch (Throwable e) {
                    ControlPanel.this._logger.error((Object)"LoadServerInfoThread", e);
                }
            }
            for (i = 0; i < threadList.size(); ++i) {
                ServerPanelLoadingThread th = (ServerPanelLoadingThread)threadList.get(i);
                data.addElement(th.getCols());
            }
            this._tableModel.setData(data);
            this._tableModel.fireTableDataChanged();
            if (ControlPanel.this._logger.isInfoEnabled()) {
                Long fStop = System.currentTimeMillis();
                StringBuffer result = new StringBuffer();
                result.append("time in ServerPanel.refresh() - ").append(fStop - fStart).append(" ms");
                ControlPanel.this._logger.info((Object)result.toString());
            }
        }

        @Override
        public KTable getTable() {
            return this._table;
        }

        @Override
        public void removeSelections() throws Exception {
            int row = this._table.getSelectedRow();
            String username = (String)this._table.getValueAt(row, 0);
            ClientController.getInstance().getServerSession().deleteUser(username, ClientController.getInstance().getUserName());
            this.refresh(false);
        }

        @Override
        public Object[] getSeletedRow() {
            int row = this._table.getSelectedRow();
            if (row < 0) {
                return null;
            }
            return (Object[])this._tableModel.getData().elementAt(row);
        }

        class ServerPanelLoadingThread
        extends Thread {
            Object[] cols = null;
            FabricPK pk = null;

            ServerPanelLoadingThread(FabricPK pk) {
                this.pk = pk;
            }

            public Object[] getCols() {
                return this.cols;
            }

            @Override
            public void run() {
                this.cols = new Object[SERVER_LABELS.length + 1];
                try {
                    this.cols[0] = this.pk.getName();
                    String serverName = this.pk.forFabric() ? ClientController.getInstance().getServerForFabric(this.pk) : ClientController.getInstance().getLanServerIp((LanPK)this.pk);
                    this.cols[1] = serverName;
                    int sId = ClientController.getInstance().getServerId(InetAddress.getByName(serverName));
                    this.cols[2] = sId;
                    this.cols[this.cols.length - 1] = this.pk;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class UsersPanel
    extends Box
    implements AdminTableIf {
        KTableModel _tableModel;
        SnmpKTable _table;
        PasswordCellRenderer passwordRenderer;
        JPopupMenu _popupMenu;
        JMenuItem _resetFailedCount;
        public static final int USER_COL = 4;

        public UsersPanel(ControlPanel adialog) {
            super(1);
            this.passwordRenderer = new PasswordCellRenderer();
            this._tableModel = new KTableModel();
            this._tableModel.setHeaders(USER_LABELS);
            this._table = new SnmpKTable(this._tableModel){

                @Override
                public TableCellRenderer getCellRenderer(int row, int column) {
                    if (this.convertColumnIndexToModel(column) == 1) {
                        return UsersPanel.this.passwordRenderer;
                    }
                    return super.getCellRenderer(row, column);
                }

                @Override
                public boolean isCellEditable(int r, int c) {
                    return false;
                }
            };
            this._table.setSelectionMode(0);
            this._table.setRowSelectionAllowed(true);
            this._table.setChangeListener(adialog);
            boolean isUserLockoutEnabled = ClientController.getInstance().getServerSession().isUserLockoutEnabled();
            if (ClientController.getInstance().isAdmin() && isUserLockoutEnabled) {
                this._popupMenu = new JPopupMenu();
                this._resetFailedCount = new JMenuItem("Reset Failed Attempts");
                this._resetFailedCount.setActionCommand("Reset Attempts");
                this._resetFailedCount.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UsersPanel.this.onResetFailed();
                    }
                });
                this._resetFailedCount.setEnabled(true);
                this._popupMenu.add(this._resetFailedCount);
                this.addMouseListener();
            }
            Dimension size = this._table.calcPreferredSize();
            if (size.height > 300) {
                size.height = 300;
            }
            JScrollPane sp = new JScrollPane(this._table);
            sp.setPreferredSize(size);
            this.add(sp);
            this._table.getTableHeader().addMouseListener(new HeaderListener());
            this._table.setSortable(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onResetFailed() {
            SuperSessionRif superSession = ClientController.getInstance().getAdminSession();
            if (superSession == null) {
                Util.errorMessage((Component)this, "Only the user in network-admin role can reset the failed attempts.");
                return;
            }
            String title = null;
            if (ControlPanel.this._parentWindow instanceof JDialog) {
                title = ((JDialog)ControlPanel.this._parentWindow).getTitle();
            } else if (ControlPanel.this._parentWindow instanceof JFrame) {
                title = ((JFrame)ControlPanel.this._parentWindow).getTitle();
            }
            Object[] selectedUser = this.getSeletedRow();
            if (selectedUser == null) {
                Util.errorMessage((Component)this, "Please select a row.");
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Are you sure you want to reset the failed attempts value?", title, 0) == 0) {
                try {
                    FMUserBase user = (FMUserBase)selectedUser[4];
                    if (user != null) {
                        superSession.resetFailedAttempts(user.getUsername());
                        ControlPanel.this._parentWindow.setCursor(Cursor.getPredefinedCursor(3));
                        RefreshThread refreshThread = new RefreshThread(this, false);
                        refreshThread.start();
                    } else {
                        Util.errorMessage((Component)this, "Unable to find the user for the selected row.");
                    }
                }
                catch (Exception e) {
                    Util.errorMessage((Component)this, e);
                }
                finally {
                    try {
                        this.refresh(false);
                    }
                    catch (Exception e) {}
                }
            }
        }

        private void addMouseListener() {
            this._table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.popup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.popup(e);
                }

                private void popup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        Point p = e.getPoint();
                        int rowNumber = UsersPanel.this._table.rowAtPoint(p);
                        ListSelectionModel model = UsersPanel.this._table.getSelectionModel();
                        model.setSelectionInterval(rowNumber, rowNumber);
                        if (UsersPanel.this._popupMenu != null) {
                            FMUserBase user = (FMUserBase)UsersPanel.this._tableModel.getValueAt(rowNumber, 4);
                            if (user.getFailedAttempts() > 0) {
                                UsersPanel.this._resetFailedCount.setEnabled(true);
                                UsersPanel.this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
                            } else {
                                UsersPanel.this._resetFailedCount.setEnabled(false);
                            }
                            UsersPanel.this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                }
            });
        }

        @Override
        public void refresh(boolean rememberSelection) throws Exception {
            Long fStart = System.currentTimeMillis();
            Array<Object[]> data = new Array<Object[]>();
            boolean isUserLockoutEnabled = ClientController.getInstance().isUserLockoutEnabled();
            ArrayList list = ClientController.getInstance().getAllUsers();
            if (list != null) {
                for (FMUserBase user : list) {
                    Object[] cols = new Object[USER_LABELS.length + 1];
                    cols[0] = user.getUsername();
                    cols[1] = ClientController.decrypt(user.getEncryptedPassword());
                    cols[2] = user.getRole();
                    cols[3] = isUserLockoutEnabled ? Integer.valueOf(user.getFailedAttempts()) : "N/A";
                    cols[4] = user;
                    data.addElement(cols);
                }
            }
            this._tableModel.setData(data);
            this._tableModel.fireTableDataChanged();
            if (ControlPanel.this._logger.isInfoEnabled()) {
                Long fStop = System.currentTimeMillis();
                StringBuffer result = new StringBuffer();
                result.append("time in UsersPanel.refresh() - ").append(fStop - fStart).append(" ms");
                ControlPanel.this._logger.info((Object)result.toString());
            }
        }

        @Override
        public KTable getTable() {
            return this._table;
        }

        @Override
        public void removeSelections() throws Exception {
            int row = this._table.getSelectedRow();
            String username = (String)this._table.getValueAt(row, 0);
            ClientController.getInstance().getServerSession().deleteUser(username, ClientController.getInstance().getUserName());
            this.refresh(false);
        }

        @Override
        public Object[] getSeletedRow() {
            int row = this._table.getSelectedRow();
            if (row < 0) {
                return null;
            }
            return (Object[])this._tableModel.getData().elementAt(row);
        }
    }

    class VirtualCenterServerPanel
    extends Box
    implements AdminTableIf {
        KTableModel _tableModel;
        SnmpKTable _table;
        JPopupMenu _popupMenu;

        public VirtualCenterServerPanel(ControlPanel adialog) {
            super(1);
            this._tableModel = new KTableModel();
            this._tableModel.setHeaders(VIRTUAL_CENTER_SERVER_LABELS);
            boolean[] editable = new boolean[VIRTUAL_CENTER_SERVER_LABELS.length];
            for (int i = 0; i < editable.length; ++i) {
                editable[i] = true;
            }
            this._tableModel.setEditable(editable);
            this._table = new SnmpKTable(this._tableModel){

                @Override
                public boolean isCellEditable(int r, int c) {
                    if (c == 3) {
                        return ClientController.getInstance().isAdmin();
                    }
                    if (c == 1 || c == 2) {
                        return !VirtualCenterServerPanel.this.isManaged(r, c);
                    }
                    return false;
                }
            };
            this._table.setSelectionMode(0);
            this._table.setRowSelectionAllowed(true);
            this._table.setChangeListener(adialog);
            this._table.getColumnModel().getColumn(2).setCellEditor(PasswordCellEditor.getEditor());
            this._table.getColumnModel().getColumn(2).setCellRenderer(new PasswordCellRenderer());
            JComboBox<String> adminCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"Manage Continuously", "Unmanage"}));
            adminCombo.setEditable(false);
            this._table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(adminCombo));
            Dimension size = this._table.calcPreferredSize();
            if (size.height > 300) {
                size.height = 300;
            }
            JScrollPane sp = new JScrollPane(this._table);
            sp.setPreferredSize(size);
            this.add(sp);
            this._table.getTableHeader().addMouseListener(new HeaderListener());
            this._table.setSortable(true);
            this._table.getColumnModel().getColumn(0).setPreferredWidth(150);
            this._table.getColumnModel().getColumn(1).setPreferredWidth(150);
            this._table.getColumnModel().getColumn(2).setPreferredWidth(150);
            this._table.getColumnModel().getColumn(3).setPreferredWidth(150);
            this._table.getColumnModel().getColumn(4).setPreferredWidth(400);
            this._table.getColumnModel().getColumn(5).setPreferredWidth(150);
        }

        public boolean isManaged(int r, int c) {
            if (this._tableModel == null) {
                return false;
            }
            String admin = (String)this._tableModel.getValueAt(r, 4);
            return admin != null && admin.equalsIgnoreCase("Managed");
        }

        public void rediscoverSelection() throws Exception {
            int row = this._table.getSelectedRow();
            InetAddress ipAddress = InetAddress.getByName((String)this._table.getValueAt(row, 0));
            String username = (String)this._table.getValueAt(row, 1);
            String passwd = (String)this._table.getValueAt(row, 2);
            ModelFacadeRif modelFacadeRif = ClientController.getInstance().assertModelFacade();
            modelFacadeRif.rediscoverVirtualCenter(ipAddress, username, passwd);
            this.refresh(false);
        }

        @Override
        public Object[] getSeletedRow() {
            int row = this._table.getSelectedRow();
            if (row < 0) {
                return null;
            }
            return (Object[])this._tableModel.getData().elementAt(row);
        }

        @Override
        public KTable getTable() {
            return this._table;
        }

        @Override
        public void refresh(boolean rememberSelection) throws Exception {
            Long fStart = System.currentTimeMillis();
            Array<Object[]> data = new Array<Object[]>();
            VirtualCenterBase[] list = ClientController.getInstance().getVirtualCenters();
            if (list != null) {
                VirtualCenterBase virtualCenterBase = null;
                for (int i = 0; i < list.length; ++i) {
                    virtualCenterBase = list[i];
                    if (virtualCenterBase == null) continue;
                    Object[] cols = new Object[VIRTUAL_CENTER_SERVER_LABELS.length + 2];
                    cols[0] = virtualCenterBase.getVcIP().getHostAddress();
                    cols[1] = virtualCenterBase.getUserName();
                    cols[2] = virtualCenterBase.getPassword();
                    if (virtualCenterBase.getManageState()) {
                        cols[3] = "Manage Continuously";
                        cols[4] = "Managed";
                    } else {
                        long updateTime = virtualCenterBase.getLastUpdateTime();
                        String statusDescription = virtualCenterBase.getStatusDescription();
                        cols[3] = "Unmanage";
                        cols[4] = "Unmanaged" + (statusDescription != null && statusDescription.length() != 0 ? ": " + statusDescription + (updateTime > 0L ? " on " + new Date(updateTime) + ". " : "") : "");
                    }
                    cols[5] = ClientController.getInstance().getVCenterServerIp((VcenterPK)virtualCenterBase.getVcPK());
                    cols[6] = new Object[VIRTUAL_CENTER_SERVER_LABELS.length + 2];
                    cols[7] = virtualCenterBase;
                    data.addElement(cols);
                }
            }
            this._tableModel.setData(data);
            this._tableModel.fireTableDataChanged();
            if (ControlPanel.this._logger.isInfoEnabled()) {
                Long fStop = System.currentTimeMillis();
                StringBuffer result = new StringBuffer();
                result.append("time in VirtualCenterServer.refresh() - ").append(fStop - fStart).append(" ms");
                ControlPanel.this._logger.info((Object)result.toString());
            }
        }

        @Override
        public void removeSelections() throws Exception {
            int row = this._table.getSelectedRow();
            if (row < 0) {
                return;
            }
            InetAddress ipAddress = InetAddress.getByName((String)this._table.getValueAt(row, 0));
            Object[] rowObject = (Object[])this._tableModel.getData().elementAt(row);
            VirtualCenterBase virtualCenterBase = (VirtualCenterBase)rowObject[7];
            PKIf virtualCenterPK = virtualCenterBase.getVcPK();
            String targetServerIp = ClientController.getInstance().assertSession().getVCenterServerIp((VcenterPK)virtualCenterPK);
            FMServerRif fmserver = ClientController.getInstance().getRemoteFMServer(targetServerIp);
            fmserver.removeVirtualCenter(ipAddress);
            this.refresh(false);
        }
    }

    class ViewScopePanel
    extends Box
    implements AdminTableIf {
        KTableModel _tableModel;
        SnmpKTable _table;
        JPopupMenu _popupMenu;

        public ViewScopePanel(ControlPanel adialog) {
            super(1);
            this._tableModel = new KTableModel();
            this._tableModel.setHeaders(VIEW_SCOPE_LABELS);
            this._table = new SnmpKTable(this._tableModel){

                @Override
                public boolean isCellEditable(int r, int c) {
                    return false;
                }
            };
            this._table.setSelectionMode(0);
            this._table.setRowSelectionAllowed(true);
            this._table.setChangeListener(adialog);
            Dimension size = this._table.calcPreferredSize();
            if (size.height > 300) {
                size.height = 300;
            }
            JScrollPane sp = new JScrollPane(this._table);
            sp.setPreferredSize(size);
            this.add(sp);
            this._table.getTableHeader().addMouseListener(new HeaderListener());
            this._table.setSortable(true);
            this._table.getColumnModel().getColumn(1).setPreferredWidth(600);
            this._table.getColumnModel().getColumn(0).setPreferredWidth(150);
        }

        @Override
        public Object[] getSeletedRow() {
            int row = this._table.getSelectedRow();
            if (row < 0) {
                return null;
            }
            return (Object[])this._tableModel.getData().elementAt(row);
        }

        @Override
        public KTable getTable() {
            return this._table;
        }

        private String getUserGroupString(String userName) {
            try {
                GroupBase[] groupBases = ClientController.getInstance().getGroups(userName);
                StringBuffer groupString = new StringBuffer();
                if (groupBases != null && groupBases.length > 0) {
                    for (int i = 0; i < groupBases.length; ++i) {
                        if (groupBases[i] == null) continue;
                        groupString.append(" " + groupBases[i].getFabricPK().getName() + "/" + groupBases[i].getGroupPK().getName());
                        if (i >= groupBases.length - 1) continue;
                        groupString.append(",  ");
                    }
                    return groupString.toString();
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return "";
        }

        @Override
        public void refresh(boolean rememberSelection) throws Exception {
            Long fStart = System.currentTimeMillis();
            Array<Object[]> data = new Array<Object[]>();
            try {
                ClientController.getInstance().syncGroups();
            }
            catch (Exception ex) {
                ControlPanel.this._logger.debug((Object)ex);
            }
            ControlPanel.this.usersWithSwitchGroup.clear();
            ArrayList list = ClientController.getInstance().getAllUsers();
            if (list != null) {
                for (FMUserBase user : list) {
                    Object[] cols = new Object[VIEW_SCOPE_LABELS.length + 1];
                    cols[0] = user.getUsername();
                    cols[1] = this.getUserGroupString(user.getUsername());
                    if (cols[1] == null || ((String)cols[1]).length() <= 0) continue;
                    data.addElement(cols);
                    ControlPanel.this.usersWithSwitchGroup.put(user.getUsername(), user.getUsername());
                }
            }
            this._tableModel.setData(data);
            this._tableModel.fireTableDataChanged();
            if (ControlPanel.this._logger.isInfoEnabled()) {
                Long fStop = System.currentTimeMillis();
                StringBuffer result = new StringBuffer();
                result.append("time in ViewScopePanel.refresh() - ").append(fStop - fStart).append(" ms");
                ControlPanel.this._logger.info((Object)result.toString());
            }
        }

        @Override
        public void removeSelections() throws Exception {
            int row = this._table.getSelectedRow();
            String username = (String)this._table.getValueAt(row, 0);
            ModelFacadeRif modelFacadeRif = ClientController.getInstance().assertModelFacade();
            modelFacadeRif.removeGroup(username);
            this.refresh(false);
        }
    }

    class RemoveFabricsThread
    extends Thread {
        KTableModel _tableModel;
        SnmpKTable _table;
        boolean[] _rowEditable;
        FabricsPanel _component;

        public RemoveFabricsThread(KTableModel tableModel, SnmpKTable table, boolean[] rowEditable, FabricsPanel component) {
            this._tableModel = tableModel;
            this._table = table;
            this._rowEditable = rowEditable;
            this._component = component;
        }

        @Override
        public void run() {
            int[] rows = this._table.getSelectedRows();
            boolean[] rowEditable = null;
            if (rows == null || rows.length == 0) {
                return;
            }
            if (this._rowEditable != null && this._rowEditable.length > rows.length) {
                rowEditable = new boolean[this._rowEditable.length - rows.length];
            }
            int j = 0;
            SwingUtilities.getWindowAncestor(this._component).setCursor(Cursor.getPredefinedCursor(3));
            for (int i = rows.length - 1; i >= 0; --i) {
                try {
                    int row = rows[i];
                    if (rowEditable != null) {
                        try {
                            rowEditable[j++] = this._rowEditable[i + row + 1];
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                    }
                    FabricPK pk = (FabricPK)ControlPanel.this._fabricsPanel._tableModel.getValueAt(row, 14);
                    ClientController.getInstance().closeFabric(pk);
                    Array d = this._tableModel.getData();
                    if (row >= d.size()) continue;
                    d.removeElementAt(row);
                    continue;
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this._component, ex);
                }
            }
            this._rowEditable = rowEditable;
            SwingUtilities.getWindowAncestor(this._component).setCursor(null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (RemoveFabricsThread.this._component != null) {
                            RemoveFabricsThread.this._component.refresh(false);
                        }
                        if (ControlPanel.this._openPanel != null) {
                            ControlPanel.this._openPanel.refresh(false);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    class FabricsPanel
    extends Box
    implements AdminTableIf,
    KeyListener {
        KTableModel _tableModel;
        SnmpKTable _table;
        JPopupMenu _popupMenu;
        private boolean serverColumnAdded;
        boolean[] _rowEditable;
        TableColumn serverColumn;

        public boolean isManaged(int r, int c) {
            if (this._tableModel == null) {
                return false;
            }
            String admin = (String)this._tableModel.getValueAt(r, 11);
            return admin != null && admin.equalsIgnoreCase("Managed");
        }

        public FabricsPanel(ControlPanel adialog) {
            super(1);
            this.serverColumnAdded = true;
            this.serverColumn = null;
            this._tableModel = new KTableModel();
            this._tableModel.setHeaders(FABRIC_LABELS);
            boolean[] editable = new boolean[FABRIC_LABELS.length];
            this._popupMenu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Copy server credentials to all unmanaged fabrics");
            item.setActionCommand("copyCredential");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FabricsPanel.this.copyCredntial2All();
                }
            });
            this._popupMenu.add(item);
            for (int i = 0; i < editable.length; ++i) {
                editable[i] = true;
            }
            this._tableModel.setEditable(editable);
            this._table = new SnmpKTable(this._tableModel){

                @Override
                public boolean isCellEditable(int r, int c) {
                    boolean editable = super.isCellEditable(r, c);
                    if (editable) {
                        try {
                            if (c == 3 || c == 4 || c == 5 || c == 6) {
                                return !FabricsPanel.this.isManaged(r, c);
                            }
                            if (c == 11 || c == 12) {
                                return false;
                            }
                            if (c == 8 || c == 9) {
                                return false;
                            }
                            if (!FabricsPanel.this._rowEditable[r]) {
                                return false;
                            }
                            editable = true;
                        }
                        catch (Exception ex) {
                            editable = false;
                        }
                    }
                    return editable;
                }
            };
            this._table.getColumnModel().getColumn(4).setCellEditor(PasswordCellEditor.getEditor());
            this._table.getColumnModel().getColumn(4).setCellRenderer(new PasswordCellRenderer());
            this.addMouseListener();
            JComboBox<String> snmpCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(SnmpUserOpt.SNMP_V3_PARAMS));
            snmpCombo.setEditable(false);
            this._table.getColumnModel().getColumn(6).setCellEditor(new DefaultCellEditor(snmpCombo));
            DefaultComboBoxModel<String> adminModel = SM._FmStandalone ? new DefaultComboBoxModel<String>(new String[]{"Manage", "Unmanage"}) : new DefaultComboBoxModel<String>(new String[]{"Manage Continuously", "Manage", "Unmanage"});
            JComboBox<String> adminCombo = new JComboBox<String>(adminModel);
            adminCombo.setEditable(false);
            this._table.getColumnModel().getColumn(10).setCellEditor(new DefaultCellEditor(adminCombo));
            Dimension size = this._table.calcPreferredSize();
            if (size.height > 300) {
                size.height = 300;
            }
            JScrollPane sp = new JScrollPane(this._table);
            sp.setPreferredSize(size);
            this.add(sp);
            this._table.addKeyListener(this);
            this._table.setChangeListener(adialog);
            try {
                this._table.getDefaultCellEditor().getComponent().addKeyListener(this);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            this._table.getColumnModel().getColumn(0).setPreferredWidth(125);
            this._table.getColumnModel().getColumn(1).setPreferredWidth(75);
            this._table.getColumnModel().getColumn(2).setPreferredWidth(90);
            this._table.getColumnModel().getColumn(3).setPreferredWidth(110);
            this._table.getColumnModel().getColumn(4).setPreferredWidth(85);
            this._table.getColumnModel().getColumn(5).setPreferredWidth(75);
            this._table.getColumnModel().getColumn(6).setPreferredWidth(65);
            this._table.getColumnModel().getColumn(7).setPreferredWidth(65);
            this._table.getColumnModel().getColumn(8).setPreferredWidth(90);
            this._table.getColumnModel().getColumn(9).setPreferredWidth(90);
            this._table.getColumnModel().getColumn(10).setPreferredWidth(155);
            this._table.getColumnModel().getColumn(11).setPreferredWidth(100);
            this._table.getColumnModel().getColumn(12).setPreferredWidth(110);
            this.serverColumn = this._table.getColumnModel().getColumn(12);
            if (ClientController.getInstance().getServerNodes().size() == 1) {
                this._table.removeColumn(this.serverColumn);
                this.serverColumnAdded = false;
            }
            this._table.getTableHeader().addMouseListener(new HeaderListener());
            this._table.setSortable(true);
        }

        private void copyCredntial2All() {
            int selected = this._table.getSelectedRow();
            if (this._table.isEditing()) {
                this._table.editingStopped(null);
            }
            for (int i = 0; i < this._tableModel.getRowCount(); ++i) {
                String state;
                if (i == selected || (state = (String)this._tableModel.getValueAt(i, 11)).startsWith("Manage")) continue;
                String user = (String)this._tableModel.getValueAt(selected, 3);
                String pass = (String)this._tableModel.getValueAt(selected, 4);
                if (pass == null || pass.equals("")) {
                    Util.errorMessage((Component)this, "Please type in password before copy");
                    return;
                }
                Boolean v3 = (Boolean)this._tableModel.getValueAt(selected, 5);
                String v3param = (String)this._tableModel.getValueAt(selected, 6);
                this._tableModel.setValueAt(new String(user), i, 3);
                this._tableModel.setValueAt(new String(pass), i, 4);
                this._tableModel.setValueAt(new Boolean(v3), i, 5);
                this._tableModel.setValueAt(new String(v3param), i, 6);
            }
            this._tableModel.fireTableDataChanged();
        }

        private void addMouseListener() {
            this._table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.popup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.popup(e);
                }

                private void popup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        Point p = e.getPoint();
                        int rowNumber = FabricsPanel.this._table.rowAtPoint(p);
                        ListSelectionModel model = FabricsPanel.this._table.getSelectionModel();
                        model.setSelectionInterval(rowNumber, rowNumber);
                        FabricsPanel.this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }

        @Override
        public void refresh(boolean rememberSelection) throws Exception {
            Long fStart = System.currentTimeMillis();
            if (ClientController.getInstance().getServerNodes().size() > 1) {
                if (!this.serverColumnAdded) {
                    this._table.addColumn(this.serverColumn);
                    this.serverColumnAdded = true;
                }
            } else if (this.serverColumnAdded) {
                this._table.removeColumn(this.serverColumn);
                this.serverColumnAdded = false;
            }
            Array data = new Array();
            boolean sessionAlive = ClientController.isSessionAlive();
            FabricPK[] fabrics = ClientController.getInstance().getFabricPKs();
            if (fabrics != null && fabrics.length > 0) {
                FabricsPanelLoadingThread th;
                int i;
                this._rowEditable = new boolean[fabrics.length];
                String[][] inExVsans = ClientController.getInstance().getInExVsans(fabrics);
                ArrayList<FabricsPanelLoadingThread> threadList = new ArrayList<FabricsPanelLoadingThread>();
                for (i = 0; i < fabrics.length; ++i) {
                    th = new FabricsPanelLoadingThread(i, data, sessionAlive, fabrics, inExVsans);
                    threadList.add(th);
                    th.start();
                }
                for (i = 0; i < threadList.size(); ++i) {
                    th = (FabricsPanelLoadingThread)threadList.get(i);
                    try {
                        th.join();
                        continue;
                    }
                    catch (Throwable e) {
                        ControlPanel.this._logger.error((Object)"SetDataFabricInfoThread", e);
                    }
                }
            }
            this._tableModel.setData(data);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    FabricsPanel.this._tableModel.fireTableDataChanged();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
            if (ControlPanel.this._logger.isInfoEnabled()) {
                Long fStop = System.currentTimeMillis();
                StringBuffer result = new StringBuffer();
                result.append("time in FabricsPanel.refresh() - ").append(fStop - fStart).append(" ms");
                ControlPanel.this._logger.info((Object)result.toString());
            }
        }

        @Override
        public KTable getTable() {
            return this._table;
        }

        @Override
        public void removeSelections() throws RemoteException {
            RemoveFabricsThread removeFabricsThread = new RemoveFabricsThread(this._tableModel, this._table, this._rowEditable, this);
            removeFabricsThread.start();
        }

        @Override
        public Object[] getSeletedRow() {
            int row = this._table.getSelectedRow();
            if (row < 0) {
                return null;
            }
            return (Object[])this._tableModel.getData().elementAt(row);
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char ch = e.getKeyChar();
            if (!(this._table.getSelectedColumn() != 1 && this._table.getSelectedColumn() != 2 || '\b' == ch || '\u007f' == ch || e.isActionKey() || e.isConsumed() || Character.isDigit(ch))) {
                e.consume();
                return;
            }
            ControlPanel.this._fabricChanged = true;
            ControlPanel.this.updateApplyButton();
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (!visible && this._table.isEditing()) {
                this._table.editingStopped(null);
            }
        }

        public boolean contains(FabricPK fabricPK) {
            return false;
        }

        public void addFabricItem(FabricPK fabricPK, SnmpUserOpt snmpUserOpt, boolean licensed, boolean evalLicensed) {
            try {
                this.refresh(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        class FabricsPanelLoadingThread
        extends Thread {
            int i;
            Array data;
            boolean sessionAlive;
            FabricPK[] fabrics;
            String[][] inExVsans;

            FabricsPanelLoadingThread(int i, Array data, boolean sessionAlive, FabricPK[] fabrics, String[][] inExVsans) {
                this.i = i;
                this.data = data;
                this.sessionAlive = sessionAlive;
                this.fabrics = fabrics;
                this.inExVsans = inExVsans;
            }

            @Override
            public void run() {
                FabricsPanel.this._rowEditable[this.i] = this.sessionAlive;
                Object[] cols = new Object[FABRIC_LABELS.length + 2];
                cols[14] = this.fabrics[this.i];
                this.data.addElement(cols);
                cols[0] = this.fabrics[this.i].getName();
                try {
                    cols[1] = Integer.toString(ClientController.getInstance().getPollInterval(this.fabrics[this.i]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    cols[2] = Integer.toString(ClientController.getInstance().getRediscoverInterval(this.fabrics[this.i]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Object[] cred = null;
                try {
                    cred = ClientController.getInstance().getFabricCredentials(this.fabrics[this.i]);
                }
                catch (Exception ex) {
                    cred = null;
                    ControlPanel.this._logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                cols[5] = cred == null ? Boolean.FALSE : Boolean.TRUE;
                cols[3] = cred != null && cred[0] != null ? cred[0].toString() : "";
                boolean useFcAlias = false;
                try {
                    useFcAlias = ClientController.getInstance().useFcAlias(this.fabrics[this.i]);
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                cols[7] = useFcAlias;
                boolean isManaged = false;
                try {
                    isManaged = ClientController.getInstance().isManaged(this.fabrics[this.i]);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                boolean isPersistent = false;
                try {
                    isPersistent = ClientController.getInstance().isPersistent(this.fabrics[this.i]);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (isManaged) {
                    cols[11] = "Managed";
                    cols[10] = isPersistent ? "Manage Continuously" : "Manage";
                } else {
                    cols[11] = "Unmanaged";
                    cols[10] = "Unmanage";
                }
                cols[12] = "";
                try {
                    cols[12] = ClientController.getInstance().getServerForFabric(this.fabrics[this.i]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                cols[13] = new Object[FABRIC_LABELS.length];
                cols[14] = this.fabrics[this.i];
                SnmpUserOpt snmpUserOpt = null;
                try {
                    snmpUserOpt = ClientController.getInstance().getFabricSnmpUserOpt(this.fabrics[this.i]);
                }
                catch (Exception ex) {
                    snmpUserOpt = null;
                    ControlPanel.this._logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                if (snmpUserOpt != null) {
                    cols[6] = SnmpUserOpt.SNMP_V3_PARAMS[snmpUserOpt.getSnmpV3Security()];
                    cols[4] = snmpUserOpt.isV3() ? snmpUserOpt.getPassword() : snmpUserOpt.getCommunity();
                } else {
                    cols[4] = "";
                }
                if (this.inExVsans[this.i][0] != null) {
                    cols[8] = this.inExVsans[this.i][0];
                }
                if (this.inExVsans[this.i][1] != null) {
                    cols[9] = this.inExVsans[this.i][1];
                }
            }
        }
    }

    class EthernetsPanel
    extends Box
    implements AdminTableIf,
    KeyListener {
        KTableModel _tableModel;
        SnmpKTable _table;
        boolean[] _rowEditable;

        public EthernetsPanel(ControlPanel adialog) {
            super(1);
            this._tableModel = new KTableModel();
            this._tableModel.setHeaders(ETHERNET_LABELS);
            boolean[] editable = new boolean[ETHERNET_LABELS.length];
            for (int i = 0; i < editable.length; ++i) {
                editable[i] = true;
            }
            this._tableModel.setEditable(editable);
            this._table = new SnmpKTable(this._tableModel){

                @Override
                public boolean isCellEditable(int r, int c) {
                    return false;
                }
            };
            this._table.getColumnModel().getColumn(3).setCellEditor(PasswordCellEditor.getEditor());
            this._table.getColumnModel().getColumn(3).setCellRenderer(new PasswordCellRenderer());
            this._table.addKeyListener(this);
            this._table.setChangeListener(adialog);
            try {
                this._table.getDefaultCellEditor().getComponent().addKeyListener(this);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            this._table.getTableHeader().addMouseListener(new HeaderListener());
            this._table.setSelectionMode(0);
            this._table.setSortable(true);
            Dimension size = this._table.calcPreferredSize();
            if (size.height > 300) {
                size.height = 300;
            }
            JScrollPane sp = new JScrollPane(this._table);
            sp.setPreferredSize(size);
            this.add(sp);
        }

        @Override
        public Object[] getSeletedRow() {
            int row = this._table.getSelectedRow();
            if (row < 0) {
                return null;
            }
            return (Object[])this._tableModel.getData().elementAt(row);
        }

        @Override
        public KTable getTable() {
            return this._table;
        }

        @Override
        public void refresh(boolean rememberSelection) throws Exception {
            Long fStart = System.currentTimeMillis();
            Array<Object[]> data = new Array<Object[]>();
            ClientController cc = ClientController.getInstance();
            LanPK[] lanPKs = ClientController.getInstance().getAllLanPKs();
            if (lanPKs != null) {
                try {
                    for (LanPK lanPK : lanPKs) {
                        CdpSeedBase[] seeds = cc.getLanCDPSeeds(lanPK);
                        String svrIp = cc.getLanServerIp(lanPK);
                        if (seeds == null || seeds.length == 0) {
                            ControlPanel.this._logger.error((Object)("No seeds found for " + lanPK.getName()));
                            data.addElement(new Object[]{lanPK, "", "", "", Boolean.TRUE, "", "", "", "", "unknown", svrIp, new Object[ETHERNET_LABELS.length + 2], null});
                            continue;
                        }
                        boolean isManaged = cc.isLanManaged(lanPK);
                        String seedSwitchIP = null;
                        String userName = null;
                        String password = "";
                        Boolean snmpV3 = Boolean.TRUE;
                        String authPrivacy = "";
                        String maxHops = null;
                        String subnetMask = null;
                        String ipRange = null;
                        for (CdpSeedBase seed : seeds) {
                            seedSwitchIP = seed.getSeedIpAddress();
                            SnmpUserOpt cdpSnmpUserOpt = seed.getSnmpUserOpt();
                            if (cdpSnmpUserOpt != null) {
                                userName = cdpSnmpUserOpt.getUsername();
                                snmpV3 = cdpSnmpUserOpt.isV3();
                                password = snmpV3 != false ? cdpSnmpUserOpt.getPassword() : cdpSnmpUserOpt.getCommunity();
                                authPrivacy = SnmpUserOpt.SNMP_V3_PARAMS[cdpSnmpUserOpt.getSnmpV3Security()];
                            }
                            maxHops = Integer.toString(seed.getMaxHop());
                            subnetMask = seed.getSubnetStr() != null ? seed.getSubnetStr() + "/" + seed.getMaskStr() : "";
                            ipRange = seed.getIpRangeStr();
                            data.addElement(new Object[]{lanPK, seedSwitchIP, userName, password, snmpV3, authPrivacy, maxHops, subnetMask, ipRange, isManaged ? "Managed" : "Unmanaged", svrIp, new Object[ETHERNET_LABELS.length + 2], seed});
                        }
                    }
                }
                catch (Exception e) {
                    ControlPanel.this._logger.warn((Object)"Cannot get cdp seed from server", (Throwable)e);
                    ControlPanel.this._manageLanButton.setEnabled(false);
                    ControlPanel.this._unManageLanButton.setEnabled(false);
                }
            }
            this._tableModel.setData(data);
            this._tableModel.fireTableDataChanged();
            if (ControlPanel.this._logger.isInfoEnabled()) {
                Long fStop = System.currentTimeMillis();
                StringBuffer result = new StringBuffer();
                result.append("time in EthernetsPanel.refresh() - ").append(fStop - fStart).append(" ms");
                ControlPanel.this._logger.info((Object)result.toString());
            }
        }

        @Override
        public void removeSelections() throws Exception {
            Object[] objs = this.getSeletedRow();
            if (objs != null) {
                LanPK lanPK = null;
                CdpSeedBase seed = null;
                if (objs[0] != null && objs[0] instanceof LanPK) {
                    lanPK = (LanPK)objs[0];
                }
                if (objs.length > ETHERNET_CDPSEED_IDX && objs[ETHERNET_CDPSEED_IDX] != null && objs[ETHERNET_CDPSEED_IDX] instanceof CdpSeedBase) {
                    seed = (CdpSeedBase)objs[ETHERNET_CDPSEED_IDX];
                }
                ControlPanel.this._logger.info((Object)("EthernetsPanel removeSelections()lanPK=" + lanPK + ", seed=" + seed));
                if (lanPK == null || seed == null) {
                    throw new Exception("Cannot get LanPK or CdpSeed:" + lanPK + ", " + seed);
                }
                ClientController.getInstance().removeCdpSeed(lanPK, seed);
                this.refresh(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        public boolean contains(FabricPK fabricPK) {
            return false;
        }

        public void addFabricItem(FabricPK fabricPK, SnmpUserOpt snmpUserOpt, boolean licensed, boolean evalLicensed) {
            try {
                this.refresh(false);
            }
            catch (Exception ex) {
                ControlPanel.this._logger.error((Object)"Caught exception from LAN tab to addFabricItem", (Throwable)ex);
            }
        }
    }

    class ClientsPanel
    extends Box
    implements AdminTableIf {
        KTableModel _tableModel;
        SnmpKTable _table;
        boolean serverColumnAdded;
        TableColumn serverColumn;

        public ClientsPanel(ControlPanel adialog) {
            super(1);
            this.serverColumnAdded = true;
            this.serverColumn = null;
            this._tableModel = new KTableModel();
            this._tableModel.setHeaders(CLIENT_LABELS);
            this._table = new SnmpKTable(this._tableModel);
            this._table.setChangeListener(adialog);
            this._table.setSelectionMode(0);
            this._table.setRowSelectionAllowed(true);
            Dimension size = this._table.calcPreferredSize();
            if (size.height > 300) {
                size.height = 300;
            }
            JScrollPane sp = new JScrollPane(this._table);
            sp.setPreferredSize(size);
            this.add(sp);
            this._table.getTableHeader().addMouseListener(new HeaderListener());
            this._table.setSortable(true);
            this.serverColumn = this._table.getColumnModel().getColumn(6);
            if (ClientController.getInstance().getServerNodes().size() == 1) {
                this._table.removeColumn(this.serverColumn);
                this.serverColumnAdded = false;
            }
        }

        @Override
        public KTable getTable() {
            return this._table;
        }

        @Override
        public void removeSelections() throws RemoteException {
            int row = this._table.getSelectedRow();
            int id = (Integer)this._table.getValueAt(row, 0);
            ClientController.getInstance().killSession(id);
            Array d = this._tableModel.getData();
            d.removeElementAt(row);
            this._tableModel.fireTableDataChanged();
        }

        @Override
        public Object[] getSeletedRow() {
            int row = this._table.getSelectedRow();
            if (row < 0) {
                return null;
            }
            return (Object[])this._tableModel.getData().elementAt(row);
        }

        @Override
        public void refresh(boolean rememberSelection) throws Exception {
            Long fStart = System.currentTimeMillis();
            SessionDetails[] sessions = ClientController.getInstance().getSessions();
            Array<Object[]> data = new Array<Object[]>();
            if (sessions != null) {
                ClientsPanelLoadingThread th;
                int i;
                ArrayList<ClientsPanelLoadingThread> threadList = new ArrayList<ClientsPanelLoadingThread>();
                for (i = 0; i < sessions.length; ++i) {
                    th = new ClientsPanelLoadingThread(i, sessions);
                    threadList.add(th);
                    th.start();
                }
                for (i = 0; i < threadList.size(); ++i) {
                    th = (ClientsPanelLoadingThread)threadList.get(i);
                    try {
                        th.join();
                        continue;
                    }
                    catch (Throwable e) {
                        ControlPanel.this._logger.error((Object)"ClientsPanelLoadingThread", e);
                    }
                }
                for (i = 0; i < threadList.size(); ++i) {
                    th = (ClientsPanelLoadingThread)threadList.get(i);
                    data.addElement(th.getCols());
                }
            }
            this._tableModel.setData(data);
            this._tableModel.fireTableDataChanged();
            if (ClientController.getInstance().getServerNodes().size() > 1) {
                if (!this.serverColumnAdded) {
                    this._table.addColumn(this.serverColumn);
                    this.serverColumnAdded = true;
                }
            } else if (this.serverColumnAdded) {
                this._table.removeColumn(this.serverColumn);
                this.serverColumnAdded = false;
            }
            if (ControlPanel.this._logger.isInfoEnabled()) {
                Long fStop = System.currentTimeMillis();
                StringBuffer result = new StringBuffer();
                result.append("time in ClientsPanel.refresh() - ").append(fStop - fStart).append(" ms");
                ControlPanel.this._logger.info((Object)result.toString());
            }
        }

        class ClientsPanelLoadingThread
        extends Thread {
            Object[] cols = null;
            SessionDetails[] sessions = null;
            int i = 0;

            ClientsPanelLoadingThread(int i, SessionDetails[] sessions) {
                this.i = i;
                this.sessions = sessions;
            }

            public Object[] getCols() {
                return this.cols;
            }

            @Override
            public void run() {
                this.cols = new Object[CLIENT_LABELS.length];
                this.cols[0] = new Integer(this.sessions[this.i]._sessionId);
                this.cols[1] = this.sessions[this.i]._client;
                this.cols[2] = this.sessions[this.i]._user;
                this.cols[3] = this.sessions[this.i]._roleName;
                this.cols[4] = SnmpTimeticks.getDateFormat().format(new Date(this.sessions[this.i]._loginTime));
                this.cols[5] = SnmpTimeticks.getDateFormat().format(new Date(this.sessions[this.i]._lastAccessTime));
                try {
                    this.cols[6] = ClientController.getInstance().getServerForSessionID(this.sessions[this.i]._sessionId);
                }
                catch (Exception e) {
                    ControlPanel.this._logger.error((Object)"ClientsPanelLoadingThread", (Throwable)e);
                }
            }
        }
    }

    class RefreshThread
    extends Thread {
        AdminTableIf table = null;
        boolean rememberSelection = false;

        public RefreshThread(AdminTableIf table, boolean rememberSelection) {
            this.table = table;
            this.rememberSelection = rememberSelection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ControlPanel.this.addServerPanel();
                this.table.refresh(this.rememberSelection);
            }
            catch (Exception e1) {
                try {
                    e1.printStackTrace();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ControlPanel.this._parentWindow.setCursor(null);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    class CellData {
        private FabricPK pk;
        private int row;
        private int col;
        private Object value;

        CellData(FabricPK pk, int row, int col, Object value) {
            this.setPk(pk);
            this.setRow(row);
            this.setCol(col);
            this.setValue(value);
        }

        public FabricPK getPk() {
            return this.pk;
        }

        public void setPk(FabricPK pk) {
            this.pk = pk;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

