/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.ControlPanel;
import com.cisco.dcbu.sm.client.gui.EditUserIf;
import com.cisco.dcbu.sm.client.gui.EditViewScopeIf;
import com.cisco.dcbu.sm.client.gui.EditVirtualCenterIf;
import com.cisco.dcbu.sm.client.gui.NewOpenDialogIf;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.GroupPK;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.InetAddress;
import java.rmi.RemoteException;
import javax.swing.JApplet;
import javax.swing.JFrame;

public class ControlPanelFrame
extends JFrame
implements NewOpenDialogIf,
EditUserIf,
EditViewScopeIf,
EditVirtualCenterIf {
    public static String _Icon = "icons/LogoIcon.gif";
    private static ControlPanelFrame frameInstance = null;
    private static ControlPanel controlPanelInstance = null;
    private WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            ControlPanelFrame.this.onCancel();
        }
    };
    private JApplet _applet;

    public static ControlPanelFrame getExistingInstance() {
        return frameInstance;
    }

    public static void handleFabricDeleted() {
        if (frameInstance != null && controlPanelInstance != null) {
            controlPanelInstance.handleFabricDeleted();
        }
    }

    protected void onCancel() {
        if (controlPanelInstance == null) {
            return;
        }
        controlPanelInstance.onClose();
    }

    public static ControlPanelFrame getInstance(boolean handleNoFabrics) {
        if (frameInstance == null) {
            frameInstance = new ControlPanelFrame("Control Panel - " + ClientController.getInstance().getFMUsername() + "@" + ClientController.getInstance().getServer() + " (session " + System.getProperty("fm.sessionid") + ") - " + "DCNM-SAN");
            controlPanelInstance = new ControlPanel(frameInstance);
            frameInstance.getContentPane().add(controlPanelInstance);
            frameInstance.pack();
            frameInstance.setDefaultCloseOperation(2);
            if (handleNoFabrics) {
                controlPanelInstance.handleNoFabrics();
            }
        }
        return frameInstance;
    }

    public static ControlPanelFrame getInstance() {
        return ControlPanelFrame.getInstance(true);
    }

    private ControlPanelFrame(String title) {
        super(title);
        this.setIconImage(Util.loadIcon(_Icon).getImage());
        this.addWindowListener(this.windowListener);
    }

    @Override
    public void setCursor(Cursor cursor) {
        boolean wantBusyCursor = cursor != null && cursor.getType() == 3;
        this.getGlassPane().setVisible(wantBusyCursor);
        this.getGlassPane().setCursor(wantBusyCursor ? Cursor.getPredefinedCursor(3) : null);
    }

    public void showTab(String tabName) {
        if (controlPanelInstance == null) {
            return;
        }
        controlPanelInstance.showTab(tabName);
    }

    @Override
    public boolean contains(FabricPK fabricPK) {
        if (controlPanelInstance == null) {
            return false;
        }
        return controlPanelInstance.contains(fabricPK);
    }

    @Override
    public void addFabricItem(FabricPK fabricPK, SnmpUserOpt snmpUserOpt, boolean licensed, boolean evalLicensed) {
        if (controlPanelInstance == null) {
            return;
        }
        controlPanelInstance.addFabricItem(fabricPK, snmpUserOpt, licensed, evalLicensed);
    }

    @Override
    public void editUser(String name, String role, char[] pass, boolean newUser) throws Exception {
        controlPanelInstance.editUser(name, role, pass, newUser);
    }

    public void updateTitle() {
        this.setTitle("Control Panel - " + ClientController.getInstance().getFMUsername() + "@" + ClientController.getInstance().getServer() + " (session " + System.getProperty("fm.sessionid") + ") - " + "DCNM-SAN" + " " + "6.3(1)");
    }

    public void setApplet(JApplet applet) {
        this._applet = applet;
    }

    @Override
    public void setVisible(boolean b) {
        if (this._applet == null) {
            super.setVisible(b);
        } else {
            this._applet.setContentPane(this.getContentPane());
            this._applet.validate();
        }
        if (b) {
            this.updateTitle();
        }
    }

    @Override
    public void addGroup(String userName, GroupPK[] groups) throws Exception {
        controlPanelInstance.addGroup(userName, groups);
    }

    @Override
    public void updateGroup(String userName, GroupPK[] groups) throws Exception {
        controlPanelInstance.updateGroup(userName, groups);
    }

    @Override
    public VirtualCenterBase addVirtualCenter(InetAddress vcIP, String username, String passwd, boolean discovery, String targetServerIp) throws RemoteException, Exception {
        return controlPanelInstance.addVirtualCenter(vcIP, username, passwd, discovery, targetServerIp);
    }

    @Override
    public void updateVirtualCenter(InetAddress vcIP, String username, String passwd, boolean discovery, String targetServerIp) throws RemoteException, Exception {
        controlPanelInstance.updateVirtualCenter(vcIP, username, passwd, discovery, targetServerIp);
    }
}

