/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.UIActions;
import com.cisco.dcbu.sm.client.map.SmMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LoginFrame
extends JFrame
implements ActionListener,
KeyListener {
    private static final int SERVER_NAME = 0;
    private static final int USERNAME = 1;
    private static final int PASSWORD = 2;
    private static final int USEPROXY = 3;
    private static final String[] LABELS = new String[]{"DCNM Server:", "Username:", "Password:", ""};
    static final int MAX_HISTORY = 30;
    private static LoginFrame _Instance;
    private JComponent[] _values;
    private JLabel[] _labels;
    private JLabel _status;
    private boolean opened = false;
    private JButton _loginButton;
    private boolean _useSSL = false;
    private boolean _isLocal;
    boolean isStandAlone = false;
    public static Logger _Logger;

    public static LoginFrame getInstance() {
        if (_Instance == null) {
            _Instance = new LoginFrame();
        }
        if (LoginFrame._Instance.opened) {
            ((JComboBox)LoginFrame._Instance._values[0]).setEditable(false);
        }
        return _Instance;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        Thread mapInitializer = new Thread(new Runnable(){

            @Override
            public void run() {
                SmMap.getInstance();
            }
        });
        mapInitializer.setPriority(1);
        mapInitializer.start();
    }

    private LoginFrame() {
        String userName;
        this.setTitle(this.getDialogTitle());
        this.setIconImage(Util.loadIcon("icons/LogoIcon.gif").getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoginFrame.this.onClose();
            }
        });
        if ("true".equalsIgnoreCase(System.getProperty("fm.standalone"))) {
            this.isStandAlone = true;
        }
        if ((userName = ClientController.getInstance().getClientProperty("User")) == null || userName.length() == 0) {
            userName = "admin";
        }
        final Vector snmpProxyHistory = ClientController.getInstance().getSNMPProxyHistory();
        final Vector userHistory = ClientController.getInstance().getUserHistory();
        Vector serverHistory = ClientController.getInstance().getServerHistory();
        final JComboBox server = new JComboBox(serverHistory);
        server.setEditable(true);
        if (this.isStandAlone) {
            server.setSelectedItem("localhost");
        }
        this._values = new JComponent[LABELS.length];
        this._values[0] = server;
        this._values[1] = new KTextField(userName);
        final KTextField userNameField = this._values[1];
        this._values[2] = new JPasswordField("");
        String useProxy = ClientController.getInstance().getClientProperty("UseSNMPProxy");
        boolean b = false;
        if (useProxy != null) {
            try {
                b = Boolean.parseBoolean(useProxy);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this._values[3] = new JCheckBox("Proxy SNMP via server if fabric unreachable locally", b);
        final JCheckBox useProxyField = this._values[3];
        if (!this.isStandAlone) {
            if (serverHistory == null || serverHistory.size() == 0) {
                try {
                    server.setSelectedItem(InetAddress.getLocalHost().getHostAddress());
                }
                catch (UnknownHostException e) {
                    _Logger.debug((Object)e);
                }
            } else if (serverHistory.size() > 0) {
                if (serverHistory.size() == userHistory.size() && serverHistory.size() == snmpProxyHistory.size()) {
                    server.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int i = server.getSelectedIndex();
                            if (i >= 0) {
                                Object snmpProxyHistoryObject;
                                Object userHistoryObject = userHistory.elementAt(i);
                                if (userHistoryObject != null && userHistoryObject instanceof String) {
                                    ((KTextField)userNameField).setText((String)userHistoryObject);
                                }
                                if ((snmpProxyHistoryObject = snmpProxyHistory.elementAt(i)) != null && snmpProxyHistoryObject instanceof String) {
                                    ((JCheckBox)useProxyField).setSelected(Boolean.parseBoolean((String)snmpProxyHistoryObject));
                                }
                            }
                        }
                    });
                }
                server.setSelectedIndex(0);
            }
        }
        this._labels = DialogUtil.buildLabels(LABELS);
        for (int i = 0; i < LABELS.length; ++i) {
            this._labels[i].setHorizontalAlignment(10);
            this._labels[i].setBorder(BorderFactory.createEmptyBorder(5, 50, 5, 5));
        }
        JPanel main = DialogUtil.buildPanel(this._labels, this._values);
        if (this.isStandAlone) {
            ClientController.createStandAloneLockFile();
            server.setVisible(false);
            this._labels[0].setVisible(false);
            this._values[3].setVisible(false);
            this._labels[3].setVisible(false);
        }
        JLabel logo = new JLabel(Util.loadIcon("icons/Logindialog.gif"));
        logo.setOpaque(true);
        logo.setBackground(Color.WHITE);
        logo.setBorder(BorderFactory.createEtchedBorder(1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 0, 5, 0);
        DialogUtil.extend(gbc, main, logo);
        gbc.gridy = 1;
        gbc.gridx = 1;
        gbc.insets = DialogUtil.getInsets();
        DialogUtil.extend(gbc, main, server);
        this._status = new JLabel(" ");
        JButton[] buttons = DialogUtil.buildButtons(new String[]{"Login", "Cancel"}, (ActionListener)this);
        this._loginButton = buttons[0];
        this.getRootPane().setDefaultButton(buttons[0]);
        JPanel south = DialogUtil.buildStatusPanel(buttons, this._status);
        DialogUtil.buildDialog((JFrame)this, null, (Container)main, south);
        this.toFront();
        this._values[server.getItemCount() == 0 ? 0 : 2].requestFocus();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setStatus(String s, Icon icon) {
        if (s == null) {
            s = "";
        }
        this._status.setText(s);
        this._status.setIcon(icon);
    }

    public void setServer(String server) {
        if (server != null) {
            ((JComboBox)this._values[0]).setSelectedItem(server);
        }
    }

    public String getUsername() {
        return ((JTextField)this._values[1]).getText().trim();
    }

    public void setUserName(String user) {
        if (user != null) {
            ((JTextField)this._values[1]).setText(user);
        }
    }

    public void setPassword(String authPassword) {
        ((JPasswordField)this._values[2]).setText(authPassword);
    }

    public char[] getPassword() {
        char[] chars = ((JPasswordField)this._values[2]).getPassword();
        if (chars == null || chars.length == 0) {
            return chars;
        }
        return String.valueOf(chars).trim().toCharArray();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'C': {
                this.onClose();
                break;
            }
            case 'L': {
                try {
                    this._loginButton.setEnabled(false);
                    if (this.isStandAlone) {
                        if (ClientController.getInstance().isStandAloneRunning()) {
                            JOptionPane.showMessageDialog(this, "DCNM-SAN standalone is already running", "ERROR ", 0);
                            LogManager.shutdown();
                            System.exit(0);
                        } else if (ClientController.getInstance().wasSyslogPortInUse()) {
                            JOptionPane.showMessageDialog(this, "DCNM-SAN standalone was unable to bind to Syslog port as it was already in use, \nthis may mean another instance of the application is already running.", "Warning ", 2);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            long fStart = System.currentTimeMillis();
                            LoginFrame.this.onLogin();
                            if (_Logger.isInfoEnabled()) {
                                _Logger.info((Object)("time in LoginFrame.onLogin() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
                            }
                        }
                    });
                    break;
                }
                catch (Exception ex) {
                    this._loginButton.setEnabled(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onLogin() {
        long fStart = System.currentTimeMillis();
        String username = this.getUsername();
        if (username == null || username.trim().equals("")) {
            Util.errorMessage((Component)this, "Please enter " + LABELS[1]);
            this._loginButton.setEnabled(true);
            return;
        }
        char[] password = this.getPassword();
        if (password == null || password.length == 0) {
            Util.errorMessage((Component)this, "Please enter " + LABELS[2]);
            this._loginButton.setEnabled(true);
            return;
        }
        String server = (String)((JComboBox)this._values[0]).getSelectedItem();
        server = server.trim();
        this._isLocal = false;
        String portNbr = null;
        String serverName = server;
        String serverNamePort = null;
        try {
            if (server.indexOf(":") > 0) {
                serverName = server.substring(0, server.indexOf(":"));
                portNbr = server.substring(server.indexOf(":") + 1);
            }
            fStart = System.currentTimeMillis();
            InetAddress addr = InetAddress.getByName(serverName);
            if (_Logger.isInfoEnabled()) {
                _Logger.info((Object)("time in InetAddress.getByName() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
            }
            fStart = System.currentTimeMillis();
            NetworkInterface net = NetworkInterface.getByInetAddress(addr);
            if (_Logger.isInfoEnabled()) {
                _Logger.info((Object)("time in NetworkInterface.getByInetAddress() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
            }
            this._isLocal = net != null;
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            Util.errorMessage((Component)this, "Unknown server name: " + server);
            this._loginButton.setEnabled(true);
            return;
        }
        if (this._isLocal) {
            server = portNbr == null ? serverName : serverName + ":" + portNbr;
        }
        serverNamePort = portNbr == null ? serverName + ":" + 4447 : serverName + ":" + portNbr;
        boolean useProxy = ((JCheckBox)this._values[3]).isSelected();
        try {
            if (!this.isVisible()) {
                _Logger.warn((Object)"Double-click on Login button ignored.");
                return;
            }
            this.login(this, server, username, password, useProxy);
            _Logger.info((Object)("login to server=" + server + " user=" + username));
            this.opened = true;
            this.saveHistories(server, username);
        }
        catch (IllegalThreadStateException ex) {
            _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            String msg = "Unable to connect to server! \nPlease restart the DCNM-SAN Client.";
            Util.errorMessage((Component)this, msg);
        }
        catch (CommunicationException ex) {
            _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            String msg = "Unable to connect to DCNM-SAN server on " + serverName + "\n(Root cause: failed to connect to " + serverNamePort + ")\nPlease verify that DCNM-SAN server is listening on " + serverNamePort + "\nand this local host is able to connect to required server ports.";
            Util.errorMessage((Component)this, msg);
            return;
        }
        catch (NameNotFoundException ex) {
            _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            String msg = "Unable to connect to DCNM-SAN server on " + serverName + "\n(Root cause: failed to connect to " + serverNamePort + ")\nPlease verify that DCNM-SAN server is listening on " + serverNamePort + "\nand this local host is able to connect to required server ports.";
            Util.errorMessage((Component)this, msg);
            return;
        }
        catch (RemoteException ex) {
            _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            Throwable t = ex;
            while (((Throwable)t).getCause() != null) {
                t = ((Throwable)t).getCause();
            }
            String msg = ((Throwable)t).getMessage();
            if (msg != null && msg.startsWith("Connect")) {
                Util.errorMessage((Component)this, "Unable to connect to DCNM-SAN server.");
            } else {
                msg = "Unable to connect to DCNM-SAN server. \n " + (msg == null ? "Please ensure that a DCNM-SAN Server is running on " + server + "." : msg);
                Util.errorMessage((Component)this, msg);
            }
        }
        catch (NotBoundException ex) {
            _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            String msg = "Unable to connect to DCNM-SAN server. \nPlease ensure that a DCNM-SAN Server is running on \"" + server + "\"\nand correct port number is entered (if non-default port is used by the server)";
            Util.errorMessage((Component)this, msg);
        }
        catch (IllegalStateException ex) {
            String msg = "Unable to connect to DCNM-SAN server. \nPlease ensure that a DCNM-SAN Server is running on " + server + ".";
            Util.errorMessage((Component)this, msg);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            Util.errorMessage((Component)this, ex);
        }
        finally {
            this._loginButton.setEnabled(true);
        }
    }

    private void login(LoginFrame frame, String server, String username, char[] password, boolean useProxy) throws Exception {
        try {
            this.setStatus("Login " + server, null);
            this.setCursor(Cursor.getPredefinedCursor(3));
            ClientController.getInstance().login(server, username, password, useProxy, this._useSSL, this._isLocal, false);
            this.setStatus("Login OK.  Initializing UI...", null);
            Thread loadOuiThread = new Thread("Load New OUI Thread"){

                @Override
                public void run() {
                    ClientController.getInstance().loadNewOUIs();
                }
            };
            loadOuiThread.start();
            SwingUtilities.invokeLater(new ControlPanelRunnable(frame));
        }
        catch (Exception ex) {
            this.setCursor(null);
            throw ex;
        }
        finally {
            this._loginButton.setEnabled(true);
        }
    }

    private void saveHistories(String server, String username) {
        Vector serverHistory = ClientController.getInstance().getServerHistory();
        Vector userHistory = ClientController.getInstance().getUserHistory();
        Vector snmpProxyHistory = ClientController.getInstance().getSNMPProxyHistory();
        if (!serverHistory.contains(server)) {
            if (serverHistory.size() == 30) {
                serverHistory.removeElementAt(29);
                userHistory.removeElementAt(29);
                snmpProxyHistory.removeElementAt(29);
            }
        } else {
            int i = serverHistory.indexOf(server);
            serverHistory.remove(server);
            if (userHistory.size() != serverHistory.size()) {
                userHistory.removeElementAt(i);
            }
            if (snmpProxyHistory.size() != serverHistory.size()) {
                snmpProxyHistory.removeElementAt(i);
            }
        }
        if (server.contains(":")) {
            server = server.replace(':', '@');
        }
        serverHistory.add(0, server);
        userHistory.add(0, username);
        snmpProxyHistory.add(0, Boolean.toString(((JCheckBox)this._values[3]).isSelected()));
        try {
            ClientController.getInstance().saveServerHistory(serverHistory, userHistory, snmpProxyHistory);
        }
        catch (IOException ex) {
            // empty catch block
        }
        ClientController.getInstance().setClientProperty("User", username);
        ClientController.getInstance().setClientProperty("FMVersion", "6.3(1)");
        ClientController.getInstance().setClientProperty("UseSNMPProxy", Boolean.toString(((JCheckBox)this._values[3]).isSelected()));
        try {
            ClientController.getInstance().saveClientProperties();
        }
        catch (IOException ex2) {
            // empty catch block
        }
    }

    private void startServer(String server) {
        if (!NetUtil.isLocalHost(server)) {
            return;
        }
        try {
            Service.isInstalled((String)"SAN Server");
            if (!Service.isRunning((String)"SAN Server")) {
                String askMsg = "Could not connect to local DCNM-SAN Server.\nShould it be started?\nIf yes please wait for the server to start.\n";
                int opt = JOptionPane.showConfirmDialog(this.getContainer(), askMsg, this.getTitle(), 0);
                if (opt == 0) {
                    new RestartServer(this).start();
                }
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public Window getContainer() {
        return this.getOwner();
    }

    private void onClose() {
        UIActions.getInstance().closeAction();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.onClose();
    }

    public void saveHistory() {
    }

    private String getDialogTitle() {
        return "Data Center Network Manager - SAN 6.3(1)";
    }

    public static void main(String[] args) {
        new LoginFrame();
    }

    public void setUseSSL(boolean useSSL) {
        this._useSSL = useSSL;
    }

    public void focus() {
        JComboBox server;
        if (!this.isStandAlone && (server = (JComboBox)this._values[0]).getItemCount() == 0 && server.getSelectedItem() == null) {
            server.requestFocus();
            return;
        }
        KTextField user = (KTextField)this._values[1];
        if ("".equals(user.getText().trim())) {
            user.requestFocus();
            return;
        }
        JPasswordField pass = (JPasswordField)this._values[2];
        if (pass.getPassword().length == 0) {
            pass.requestFocus();
            return;
        }
        this._loginButton.requestFocus();
    }

    public void checkMemory() {
    }

    static {
        _Logger = Logger.getLogger(LoginFrame.class);
    }

    class RestartServer
    extends Thread {
        LoginFrame _loginFrame;

        RestartServer(LoginFrame dialog) {
            this._loginFrame = dialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this._loginFrame.setCursor(Cursor.getPredefinedCursor(3));
                this._loginFrame.setStatus("Starting Server...", null);
                Service.start((String)"SAN Server");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                for (int i = 0; i < 60; ++i) {
                    try {
                        Thread.sleep(1000L);
                        if (!Service.isRunning((String)"SAN Server")) continue;
                        this._loginFrame.setStatus("Started Local Server, please wait...", null);
                        this._loginFrame.onLogin();
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this._loginFrame.setStatus("Cannot start local server", null);
                this._loginFrame.setStatus("Timeout: Cannot start local server!", null);
                Util.errorMessage((Component)this._loginFrame.getContainer(), "WARNING: Timeout: Couldn't start local server!");
            }
            catch (Exception exception) {
            }
            finally {
                this._loginFrame.setCursor(null);
            }
        }
    }

    class ControlPanelRunnable
    implements Runnable {
        private LoginFrame _frame = null;

        public ControlPanelRunnable(LoginFrame frame) {
            this._frame = frame;
        }

        @Override
        public void run() {
            if (this._frame != null) {
                this._frame.setCursor(Cursor.getDefaultCursor());
                this._frame.setVisible(false);
            }
            ClientController.getInstance().showOpenDialog();
        }
    }
}

