/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.ManageFabricThreadListenerIf;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import java.awt.Component;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ManageFabricThread
extends Thread {
    private List<FabricPK> _fabricList = new ArrayList<FabricPK>();
    private boolean _keepWaiting = true;
    private boolean _doneAddingFabrics = false;
    private Component _component = null;
    private ManageFabricThreadListenerIf _listener = null;
    private Logger _logger = Logger.getLogger(this.getClass());

    public void addFabric(FabricPK pk) {
        this._logger.debug((Object)("ManageFabricThread addFabric() " + pk));
        this._fabricList.add(pk);
    }

    public void removeFabric(FabricPK pk) {
        this._logger.debug((Object)("ManageFabricThread removeFabric() " + pk));
        this._fabricList.remove(pk);
    }

    public void removeAllFabrics() {
        this._logger.debug((Object)"ManageFabricThread removeAllFabrics() ");
        this._fabricList.clear();
    }

    public void setComponent(Component component) {
        this._logger.debug((Object)"ManageFabricThread setComponent()");
        this._component = component;
    }

    public void setListener(ManageFabricThreadListenerIf listener) {
        this._listener = listener;
    }

    public void doneAddingFabrics() {
        this._logger.debug((Object)"ManageFabricThread doneAddingFabrics()");
        this._doneAddingFabrics = true;
    }

    @Override
    public void run() {
        this._logger.debug((Object)"ManageFabricThread run()");
        this._keepWaiting = true;
        if (this._component != null) {
            this._logger.debug((Object)"ManageFabricThread run() setCursor WAIT_CURSOR");
            this._component.setCursor(Cursor.getPredefinedCursor(3));
        }
        long time = System.currentTimeMillis();
        int j = 0;
        while (this._keepWaiting || !this._doneAddingFabrics) {
            try {
                ManageFabricThread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this._logger.debug((Object)("ManageFabricThread run() " + ++j));
            if (this._fabricList.isEmpty()) {
                this._keepWaiting = false;
                continue;
            }
            ModelFacadeRif modelFacade = null;
            try {
                modelFacade = ClientController.getInstance().assertModelFacade();
            }
            catch (Exception e) {
                this._logger.error((Object)e.getMessage(), (Throwable)e);
                this._keepWaiting = false;
                continue;
            }
            for (int i = this._fabricList.size() - 1; i >= 0; --i) {
                FabricPK pk = this._fabricList.get(i);
                if (pk == null) continue;
                try {
                    if (!modelFacade.isFabricOpened(pk)) continue;
                    this.removeFabric(pk);
                    if (this._listener == null) continue;
                    this._logger.debug((Object)"ManageFabricThread run() handleFinished");
                    this._listener.handleFinished(pk);
                    continue;
                }
                catch (RemoteException e) {
                    this._logger.error((Object)e.getMessage(), (Throwable)e);
                    this.removeFabric(pk);
                    if (this._listener == null) continue;
                    this._logger.debug((Object)"ManageFabricThread run() handleFinished");
                    this._listener.handleFinished(pk);
                }
            }
            if (this._fabricList.isEmpty()) {
                this._keepWaiting = false;
                continue;
            }
            if (System.currentTimeMillis() - time <= 60000L) continue;
            int retVal = JOptionPane.showConfirmDialog(this._component, "Fabric discovery has not finished. Keep waiting?", "Keep waiting?", 0);
            if (retVal == 0) {
                time = System.currentTimeMillis();
                continue;
            }
            this._keepWaiting = false;
        }
        if (this._component != null) {
            this._logger.debug((Object)"ManageFabricThread run() setCursor null");
            this._component.setCursor(null);
        }
    }
}

