/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui;

import com.cisco.dcbu.lib.ui.MnemonicTabbedPane;
import com.cisco.dcbu.lib.ui.PerspectiveIf;
import com.cisco.dcbu.lib.ui.PerspectiveManager;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmCommandDispatcher;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import java.awt.BorderLayout;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SmGenericTab
extends MnemonicTabbedPane
implements ChangeListener {
    protected String[][] _categories;
    protected String _title;
    protected String _startSubMethod;
    protected Object _userData;
    protected DataView _dataView;
    public boolean _setClearViewFilterOnTabChange = false;
    HashMap _tabPairs = null;

    public SmGenericTab() {
    }

    public SmGenericTab(String[][] categories) {
        this();
        this.loadTabs(categories);
    }

    protected void loadTabs(String[][] categories) {
        int i;
        ArrayList<String[]> newTabs = new ArrayList<String[]>();
        PerspectiveIf view = PerspectiveManager.getInstance().getView();
        for (i = 0; i < categories.length; ++i) {
            if (view == null || !view.isVisible("panel", categories[i][0] + "/" + categories[i][1])) continue;
            String[] tab = new String[]{categories[i][0], categories[i][1]};
            newTabs.add(tab);
        }
        this._categories = (String[][])newTabs.toArray((T[])new String[newTabs.size()][2]);
        for (i = 0; i < this._categories.length; ++i) {
            this.add(this._categories[i][0], new JPanel(new BorderLayout()));
        }
        this.addChangeListener(this);
        this.setTabLayoutPolicy(1);
    }

    public void refresh(DataView view, String title, MgmtDomainIf mgmtDomain, SmFilter[] filter, String startSubMethod, Object userData) {
        this._title = title;
        this._startSubMethod = startSubMethod;
        this._userData = userData;
        this._dataView = view;
        view._filter = filter;
        view._mgmtDomain = mgmtDomain;
        view.replaceTablePanel((Container)((Object)this));
        view.updateView(title, false);
        this.setStartTab(startSubMethod);
        this.stateChanged(new ChangeEvent(this));
    }

    public void setStartTab(String startSubMethod) {
        int startIndex;
        String tabTitle = this.getTabTitle(startSubMethod);
        int n = startIndex = tabTitle != null ? this.indexOfTab(tabTitle) : this.getDefaultTabIndex();
        if (startIndex == -1 || !this.isEnabledAt(startIndex)) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex(startIndex);
        }
    }

    protected int getDefaultTabIndex() {
        return 0;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JPanel p = (JPanel)this.getSelectedComponent();
        this._dataView.cleanup(true);
        p.add("Center", this._dataView._tablePane);
        p.invalidate();
        if (this._setClearViewFilterOnTabChange) {
            this._dataView._filter = null;
        }
        this.invokeTab();
    }

    protected void invokeTab() {
        int selectedTab = this.getSelectedIndex();
        if (this._tabPairs != null) {
            for (int[] sourceTabs : this._tabPairs.keySet()) {
                if (sourceTabs == null) continue;
                for (int i = 0; i < sourceTabs.length; ++i) {
                    int[] targetTabs;
                    if (selectedTab != sourceTabs[i] || (targetTabs = (int[])this._tabPairs.get(sourceTabs)) == null) continue;
                    for (int j = 0; j < targetTabs.length; ++j) {
                        this.setEnabledAt(targetTabs[j], true);
                    }
                }
            }
        }
        SmCommandDispatcher.invoke(this._categories[selectedTab][1], this._dataView, this._dataView._mgmtDomain, this._dataView._filter, this._title, this._startSubMethod, this._userData);
    }

    protected void updateViewFilter() {
    }

    private String getTabTitle(String tabMethod) {
        for (int i = 0; i < this._categories.length; ++i) {
            if (!this._categories[i][1].equals(tabMethod)) continue;
            return this._categories[i][0];
        }
        return null;
    }

    public void setTabPairs(HashMap tabPairs) {
        this._tabPairs = tabPairs;
    }

    public void setEnabledAt(int index, boolean enabled) {
        if (index == -1 || index > this.getTabCount()) {
            return;
        }
        super.setEnabledAt(index, enabled);
    }
}

