/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui.renderers;

import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.sm.client.gui.PercentBarInterface;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.table.TableCellRenderer;

public class PercentBarCellRenderer
extends BorderCellRenderer
implements TableCellRenderer {
    JProgressBar bar = new JProgressBar(0, 0, 100);

    public PercentBarCellRenderer() {
        this.bar.setBorderPainted(false);
        this.bar.setForeground(new Color(9152546));
        this.bar.setStringPainted(true);
        this.bar.setUI(new BasicProgressBarUI(){

            @Override
            protected Color getSelectionBackground() {
                return Color.black;
            }

            @Override
            protected Color getSelectionForeground() {
                return Color.white;
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof PercentBarInterface) {
            PercentBarInterface pValue = (PercentBarInterface)value;
            Float percent = Float.valueOf(new Float(pValue.getValue()).floatValue() / (float)pValue.getMax() * 100.0f);
            this.bar.setValue(percent.intValue());
            this.bar.setString(pValue.getDisplayText());
            return this.bar;
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

