/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui.renderers;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.IndexCellRenderer;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class PortSfpDiagnosticRenderer
extends IndexCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int ficonAddr;
        FcPortBase fcPort;
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            return null;
        }
        int[] index = ((SnmpOID)value).getValue();
        SnmpPeer node = (SnmpPeer)table.getValueAt(row, 0);
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        boolean is6_1_0_above = sw.getVersion().compareTo("6.1(0)") >= 0;
        int slotNum = SharedUtil.getSensorSlot(is6_1_0_above, index[0]);
        int port = SharedUtil.getSensorPort(is6_1_0_above, index[0], slotNum);
        int cardType = sw.getCard(slotNum + 1).getType();
        int ifPort = IfIndexUtil.getPortEntity2If(port, cardType);
        int ifType = FRUConstants.getPortIfType(cardType, port);
        int lane = SharedUtil.getSensorLane(is6_1_0_above, index[0], slotNum, port);
        int sens_type = SharedUtil.getSensorType(is6_1_0_above, index[0], slotNum, port, lane);
        String sens_string = MibEnum.getLabel(SharedUtil.SensorType, sens_type);
        int ifIndex = IfIndexUtil.nameToIfIndex(slotNum + 1, ifPort + 1, ifType);
        String ifName = sw.ifIndexToName(ifIndex);
        StringBuffer sb = new StringBuffer();
        sb.append(ifName);
        if (sw.hasFiconVsan() && (fcPort = sw.findFCPort(ifIndex)) != null && (ficonAddr = fcPort.getFiconAddress()) != -1) {
            sb.append(" (");
            sb.append(SnmpFiconPort.toString(ficonAddr));
            sb.append(')');
        }
        if (lane > -1) {
            sb.append(" lane ");
            sb.append(lane + 1);
        }
        sb.append(", ");
        sb.append(sens_string);
        label.setText(sb.toString());
        return label;
    }
}

