/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.hostcom;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.MultiRowTable;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.hostcom.HCWStoragePortsTableModel;
import com.cisco.dcbu.sm.client.hostcom.HostCommisioningWizard;
import com.cisco.dcbu.sm.client.hostcom.VshActionHandlerPanel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.EndPortsAddRemoveTable;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class StoragePortsPanel
extends VshActionHandlerPanel {
    private EndPortsAddRemoveTable _pnl;
    private MultiRowTable _portsTable = new MultiRowTable(new HCWStoragePortsTableModel((Vsan)this.getModelValue("VSAN"), null));
    private MultiRowTable _selPortsTable;

    public StoragePortsPanel(JWizard wiz) {
        super("2 of 3: Select Storage", "Select storage to be associated with a host", wiz, HostCommisioningWizard._ImagePc);
        this._portsTable.setAutoResizeMode(0);
        this._selPortsTable = new MultiRowTable(new HCWStoragePortsTableModel(null, null));
        this._selPortsTable.setAutoResizeMode(0);
        this._pnl = new EndPortsAddRemoveTable(this._portsTable, this._selPortsTable);
        JPanel mainPnl = new JPanel(new BorderLayout());
        mainPnl.add((Component)this._pnl, "Center");
        this.add((Component)mainPnl, "Center");
    }

    @Override
    public boolean refresh() {
        ((HCWStoragePortsTableModel)this._selPortsTable.getModel()).setData(new Array());
        ((HCWStoragePortsTableModel)this._selPortsTable.getModel()).fireTableDataChanged();
        Vsan vv = (Vsan)this.getModelValue("VSAN");
        HCWStoragePortsTableModel tblMdl = new HCWStoragePortsTableModel((Vsan)this.getModelValue("VSAN"), null);
        tblMdl.updateData();
        this._portsTable.setModel(tblMdl);
        tblMdl.fireTableDataChanged();
        this._portsTable.calcPreferredSize();
        return true;
    }

    @Override
    public void doNext() {
        Array selMem = this._pnl.getSelectedMembers();
        if (selMem.size() == 0) {
            Util.errorMessage((Component)this.getWizard(), "Please select a storage port.");
            return;
        }
        this.setDataValid(!((HostCommisioningWizard)this.getWizard()).isVsanSwitchChanged());
        this.setModelValue("SELECTED_HS_END_PORTS", this._pnl.getSelectedMembers());
        super.doNext();
    }

    private void setDirty(Array selMem) {
        Array cachedPorts = (Array)this.getModelValue("SELECTED_HS_END_PORTS");
        if (cachedPorts == null || cachedPorts.size() != selMem.size()) {
            this.setDataValid(false);
            return;
        }
        for (int i = 0; i < cachedPorts.size(); ++i) {
            EndPort prt = (EndPort)cachedPorts.elementAt(i);
            boolean match = false;
            for (int j = 0; j < selMem.size(); ++j) {
                if (prt != selMem.elementAt(i)) continue;
                match = true;
                break;
            }
            if (match) continue;
            this.setDataValid(false);
            return;
        }
    }
}

