/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AddFlowConfigDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 1L;
    private JButton[] _buttons;
    private JCheckBox _compressionChkBox;
    private JCheckBox _taChkBox;
    private String _flowGroupName = null;
    private JComboBox _fgComboBox;
    private boolean _isCancelled = false;

    public AddFlowConfigDialog(JFrame parent, ArrayList<String> fgList) {
        super(parent);
        this.buildSaveConfigDialog(parent, fgList);
    }

    private void buildSaveConfigDialog(JFrame parent, ArrayList<String> fgList) {
        this.setTitle("Add Flow");
        JComponent[] values1 = new JComponent[2];
        JComponent[] labels1 = new JComponent[2];
        JComponent[] values2 = new JComponent[2];
        JComponent[] labels2 = new JComponent[2];
        values1[0] = new DialogSeparator("Flow Configuration");
        labels1[1] = new JLabel("Flow Group Name:");
        String[] fgListArray = new String[fgList.size() + 1];
        if (!fgList.isEmpty()) {
            for (int ii = 0; ii < fgList.size(); ++ii) {
                fgListArray[ii] = fgList.get(ii);
            }
        }
        fgListArray[fgList.size()] = "<new flow group>";
        this._fgComboBox = new JComboBox<String>(fgListArray);
        this._fgComboBox.setSelectedItem(fgListArray[0]);
        values1[1] = this._fgComboBox;
        this._compressionChkBox = new JCheckBox("Enable Compression");
        values2[0] = this._compressionChkBox;
        this._taChkBox = new JCheckBox("Enable Tape Acceleration                     ");
        values2[1] = this._taChkBox;
        String[] btnLbl = new String[]{"Add Flow", "Cancel"};
        this._buttons = DialogUtil.buildButtons(btnLbl, (ActionListener)this);
        this._buttons[0].setActionCommand("Add_Flow");
        this._buttons[1].setActionCommand("Cancel");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < this._buttons.length; ++i) {
            buttonPanel.add(this._buttons[i]);
        }
        JPanel mainPnl = new JPanel(new BorderLayout());
        mainPnl.add((Component)DialogUtil.buildPanel(labels1, values1), "North");
        mainPnl.add((Component)DialogUtil.buildPanel(labels2, values2), "South");
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)mainPnl, buttonPanel);
        this.getRootPane().setDefaultButton(this._buttons[0]);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setSize(350, 175);
        this.setModal(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this._isCancelled = true;
            this.dispose();
        } else if (e.getActionCommand().equals("Add_Flow")) {
            this._isCancelled = false;
            this.dispose();
        }
    }

    public boolean getCompression() {
        return this._compressionChkBox.isSelected();
    }

    public boolean getTa() {
        return this._taChkBox.isSelected();
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public void manuallyCancel() {
        this._isCancelled = true;
    }

    public void setFlowGroupName(String fgn) {
        this._flowGroupName = fgn;
    }

    public String getFlowGroupName() {
        if (this._flowGroupName == null) {
            return (String)this._fgComboBox.getSelectedItem();
        }
        return this._flowGroupName;
    }
}

