/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Filler;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.sm.client.ioa.IOACache;
import com.cisco.dcbu.sm.client.ioa.IOAChartModel;
import com.cisco.dcbu.sm.common.model.ioa.InterfaceStats;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import jclass.chart.ChartDataModelUpdate;
import jclass.chart.ChartDataView;
import jclass.chart.Chartable;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartArea;
import jclass.chart.JCLabelGenerator;

public class IOAChartDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 1L;
    static final int LINE = 0;
    static final int AREA = 8;
    static final int BAR = 9;
    static final int PIE = 11;
    public static final Font _AxisFont = new Font(ChangedCellRenderer.getNormalFont().getName(), 0, ChangedCellRenderer.getNormalFont().getSize() - 2);
    static final String[][] _ButtonAttr = new String[][]{{"icons/LineGraph.gif", "Line Chart", "L"}, {"icons/BarGraph.gif", "Bar Chart", "B"}};
    static final int STACKED_BUTTON = 0;
    static final int HORIZONTAL_BUTTON = 1;
    static final int LOG_BUTTON = 2;
    static final int LINE_BUTTON = 3;
    static final int AREA_BUTTON = 4;
    static final int BAR_BUTTON = 5;
    static final int PRINT_BUTTON = 6;
    static final int EXPORT_BUTTON = 7;
    Timer _timer;
    protected AbstractButton[] _controls;
    protected JCChart _chart;
    protected IOAChartModel _chartModel;
    protected JComboBox _maxHistory;
    protected NumberGenerator _numberGenerator;
    InterfaceStats _stats;
    IOACache _ioaCache;

    public IOAChartDialog(JFrame frame, int type, InterfaceStats stats, IOACache ioaCache) throws Exception {
        super((Frame)frame, true);
        this.setIconImage(Util.loadIcon("icons/AreaGraph.gif").getImage());
        this._chartModel = new IOAChartModel(type);
        this._chartModel.addRow(type, stats);
        this._stats = stats;
        this._ioaCache = ioaCache;
        this._chart = new JCChart(type);
        JCChartArea ca = this._chart.getChartArea();
        ca.setForeground(Color.white);
        ca.setBackground(Color.black);
        ca.setFont(_AxisFont);
        ca.setBorderWidth(2);
        ChartDataView dataView = this._chart.getDataView(0);
        dataView.setFastUpdate(true);
        JCAxis xaxis = dataView.getXAxis();
        xaxis.setAnnotationMethod(2);
        xaxis.getGridStyle().getLineStyle().setColor(Color.lightGray);
        xaxis.setGridIsShowing(true);
        JCAxis yaxis = dataView.getYAxis();
        yaxis.setGridIsShowing(true);
        yaxis.getGridStyle().getLineStyle().setColor(Color.lightGray);
        this._numberGenerator = new NumberGenerator();
        yaxis.setLabelGenerator((JCLabelGenerator)this._numberGenerator);
        dataView.setAutoLabel(true);
        this._chart.getLegend().setIsShowing(true);
        this._chart.getLegend().setAnchor(32);
        this._chart.getLegend().setOrientation(0);
        dataView.setDataSource((Chartable)this._chartModel);
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(DialogUtil._Margin);
        main.add("Center", (Component)this._chart);
        main.add("North", this.buildControls(type));
        this.getContentPane().add(main);
        this.setSize(new Dimension(700, 400));
        this.setDefaultCloseOperation(2);
        this.setTitle("Real-time interface stats for " + stats.getHostname() + " : " + stats.getIfName());
        this._timer = new Timer(5000, this);
        this._timer.start();
    }

    protected JPanel buildControls(int type) {
        JPanel controls = new JPanel(new FlowLayout(0, 0, 0));
        this._controls = new AbstractButton[_ButtonAttr.length];
        controls.add(new Filler(new Dimension(5, 10)));
        ButtonGroup bg = new ButtonGroup();
        controls.add(new Filler(new Dimension(5, 10)));
        controls.add(new JLabel(" Max History:"));
        this._maxHistory = new JComboBox<String>(new String[]{"20", "30", "40", "50"});
        this._maxHistory.addActionListener(this);
        controls.add(this._maxHistory);
        controls.add(new Filler(new Dimension(5, 10)));
        JCheckBox fyA = new JCheckBox("Fix YAxis");
        fyA.addActionListener(this);
        return controls;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._maxHistory) {
            this._chartModel._maxElements = Integer.parseInt(this._maxHistory.getSelectedItem().toString());
            return;
        }
        InterfaceStats newStats = this._ioaCache.getStatsForInterface(this._stats.getIpAddress(), this._stats.getIfIndex());
        try {
            this.addRow(newStats);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addRow(InterfaceStats stats) throws Exception {
        this._chartModel.addRow(this._chart.getDataView(0).getChartType(), stats);
        this._chartModel.notifyObservers(new ChartDataModelUpdate(14, 0, 0));
    }

    @Override
    public void dispose() {
        this._timer.stop();
        super.dispose();
    }

    static class NumberGenerator
    implements JCLabelGenerator {
        NumberGenerator() {
        }

        public Object makeLabel(double d, int precision) {
            if (precision != 0) {
                if (d >= 1.0E9) {
                    return d / 1.0E9 + "G";
                }
                if (d >= 1000000.0) {
                    return d / 1000000.0 + "M";
                }
                if (d >= 1000.0) {
                    return d / 1000.0 + "K";
                }
            }
            return Double.toString(d);
        }
    }
}

