/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.sm.client.ioa.FlowTableModel;
import com.cisco.dcbu.sm.client.ioa.InterfaceTableModel;
import com.cisco.dcbu.sm.client.ioa.SwitchTableModel;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public abstract class IOATableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames;
    private ArrayList<Object[]> data;

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getObjectArraySize() {
        return this.columnNames.length + 2;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.data == null || row >= this.getRowCount()) {
            return null;
        }
        return this.data.get(row)[col];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        Object o = this.getValueAt(0, c);
        if (o != null) {
            return o.getClass();
        }
        return null;
    }

    public boolean isModified(int row) {
        Object[] rowData = this.getRow(row);
        int theModifiedRow = -1;
        if (this instanceof SwitchTableModel) {
            theModifiedRow = 6;
        } else if (this instanceof InterfaceTableModel) {
            theModifiedRow = 8;
        } else if (this instanceof FlowTableModel) {
            theModifiedRow = 9;
        }
        if (theModifiedRow == -1) {
            return false;
        }
        return (Boolean)rowData[theModifiedRow];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Object[] values = this.data.get(row);
        if (value == null) {
            return;
        }
        if (values[col] != null && (value == values[col] || value.toString().equals(values[col].toString()))) {
            return;
        }
        this.data.get((int)row)[col] = value;
        this.fireTableChanged(new TableModelEvent(this, row, row, col, 0));
    }

    public void setHeaders(String[] columnHeaders) {
        this.columnNames = columnHeaders;
    }

    public ArrayList<Object[]> getData() {
        return this.data;
    }

    public void setData(ArrayList<Object[]> data) {
        this.data = data;
    }

    public void updateData(ArrayList memberList) {
    }

    public Object[] removeRow(int row) {
        return this.data.remove(row);
    }

    public void addRow(Object[] member) {
        this.data.add(member);
    }

    public Object[] getRow(int row) {
        return this.data.get(row);
    }

    public ArrayList<Object> getObjectData() {
        ArrayList<Object> objectList = new ArrayList<Object>();
        if (this.data != null) {
            for (Object[] modelData : this.data) {
                Object o = modelData[this.getObjectIndex()];
                objectList.add(o);
            }
        }
        return objectList;
    }

    public abstract int getObjectIndex();
}

