/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.lib.ui.tree.Tree;
import com.cisco.dcbu.sm.client.ioa.IOACache;
import com.cisco.dcbu.sm.client.ioa.IOAControls;
import com.cisco.dcbu.sm.client.ioa.IOADialogAction;
import com.cisco.dcbu.sm.client.ioa.IOATreeCellRenderer;
import com.cisco.dcbu.sm.client.ioa.IOATreeNode;
import com.cisco.dcbu.sm.client.map.actions.HighlightAction;
import com.cisco.dcbu.sm.common.model.ioa.Cluster;
import com.cisco.dcbu.sm.common.model.ioa.Site;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class IOATree
extends Tree
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    static final String IOA = "IOA";
    static final String SITES = "Sites";
    static final String CLUSTERS = "Clusters";
    static final String FLOWS = "Flows";
    static final String INTERFACES = "Interfaces";
    private IOADialogAction _ioaAction;
    private IOAControls _control;
    private JPopupMenu _popup;
    private boolean _loaded;

    IOATree(TreeModel tm, IOADialogAction action, IOAControls control, IOATreeCellRenderer treeRenderer) {
        super(tm);
        this.setRootVisible(false);
        this._ioaAction = action;
        this._control = control;
        this._loaded = false;
        this.getSelectionModel().addTreeSelectionListener(this);
        this.setShowsRootHandles(true);
        this.setCellRenderer(treeRenderer);
        this.setCellEditor(new MyDefaultTreeCellEditor(this, treeRenderer));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TreePath path;
                if ((e.getKeyCode() == 38 || e.getKeyCode() == 37 || e.getKeyCode() == 40 || e.getKeyCode() == 39) && (path = IOATree.this.getSelectionPath()) != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    IOATree.this._ioaAction.showTreeNodeData(node.getUserObject(), path, true);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                IOATree.this.checkMouseEvent(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                IOATree.this.checkMouseEvent(me);
            }
        });
    }

    public void refresh(IOACache cache) {
        TreeModel tm = this.getModel();
        DefaultMutableTreeNode _root = (DefaultMutableTreeNode)tm.getRoot();
        Boolean sitesED = null;
        Boolean clustersES = null;
        Enumeration<TreePath> clustersED = null;
        ArrayList<TreePath> clustersEDAL = null;
        if (this._loaded) {
            DefaultMutableTreeNode cdNode;
            DefaultMutableTreeNode cNode;
            DefaultMutableTreeNode sNode = this.getTreeNodeForUserObject(SITES);
            if (sNode != null) {
                sitesED = this.isExpanded(new TreePath(sNode.getPath()));
            }
            if ((cNode = this.getTreeNodeForUserObject(CLUSTERS)) != null) {
                clustersES = this.isExpanded(new TreePath(cNode.getPath()));
            }
            if ((cdNode = this.getTreeNodeForUserObject(CLUSTERS)) != null) {
                clustersED = this.getExpandedDescendants(new TreePath(cdNode.getPath()));
            }
            if (clustersED != null) {
                clustersEDAL = Collections.list(clustersED);
            }
        }
        _root.removeAllChildren();
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode sitesNode = new DefaultMutableTreeNode(SITES, true);
        DefaultMutableTreeNode clustersNode = new DefaultMutableTreeNode(CLUSTERS, true);
        Object[] sites = cache.getSitesList().toArray();
        Object[] clusters = cache.getClusterList().toArray();
        model.insertNodeInto(sitesNode, _root, 0);
        model.insertNodeInto(clustersNode, _root, 1);
        int i = 0;
        for (Object site : sites) {
            model.insertNodeInto(new DefaultMutableTreeNode(site, true), sitesNode, i++);
        }
        i = 0;
        for (Object thecluster : clusters) {
            DefaultMutableTreeNode cluster = new DefaultMutableTreeNode(thecluster, true);
            model.insertNodeInto(cluster, clustersNode, i++);
            IOATreeNode intfNode = new IOATreeNode();
            intfNode.setCluster((Cluster)thecluster);
            intfNode.setName(INTERFACES);
            DefaultMutableTreeNode interfaces = new DefaultMutableTreeNode(intfNode);
            model.insertNodeInto(interfaces, cluster, 0);
            IOATreeNode flowNode = new IOATreeNode();
            flowNode.setCluster((Cluster)thecluster);
            flowNode.setName(FLOWS);
            DefaultMutableTreeNode flows = new DefaultMutableTreeNode(flowNode);
            model.insertNodeInto(flows, cluster, 1);
        }
        ((DefaultTreeModel)this.getModel()).reload();
        if (sitesED != null && sitesED.booleanValue()) {
            this.expandPath(new TreePath(this.getTreeNodeForUserObject(SITES).getPath()));
        }
        if (clustersES != null && clustersES.booleanValue()) {
            this.expandPath(new TreePath(this.getTreeNodeForUserObject(CLUSTERS).getPath()));
        }
        if (clustersEDAL != null) {
            for (TreePath tp : clustersEDAL) {
                if (tp.getLastPathComponent() == null || this.getModel().isLeaf(tp.getLastPathComponent()) || tp.getLastPathComponent().toString().equals(CLUSTERS)) continue;
                TreePath currentPath = this.getNextMatch(tp.getLastPathComponent().toString(), 0, Position.Bias.Forward);
                this.expandPath(currentPath);
            }
        }
        this._loaded = true;
        this.setEditable(false);
    }

    void update(IOACache cache, Object userObject) {
        this.refresh(cache);
        DefaultMutableTreeNode node = this.getTreeNodeForUserObject(userObject);
        if (node != null) {
            this.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    void selectTreePaths(TreePath[] paths) {
        HighlightAction.getInstance().clearHighlight();
        if (paths.length > 1) {
            return;
        }
        TreePath path = paths[0];
        Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
    }

    public void checkMouseEvent(MouseEvent e) {
        TreePath menuPath;
        if (e.isPopupTrigger()) {
            boolean rowAlreadySelected;
            TreePath menuPath2 = this.getPathForLocation(e.getX(), e.getY());
            if (menuPath2 != null && !(rowAlreadySelected = this.isRowSelected(this.getRowForPath(menuPath2)))) {
                this.setSelectionPath(menuPath2);
            }
        } else if (e.getID() == 501 && e.getButton() == 1 && (menuPath = this.getPathForLocation(e.getX(), e.getY())) != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)menuPath.getLastPathComponent();
            this._ioaAction.showTreeNodeData(node.getUserObject(), this.getSelectionPath(), true);
        }
    }

    private void insertNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        if (parent == null) {
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        if (parent.getChildCount() == 0) {
            model.insertNodeInto(child, parent, 0);
        } else {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(i);
            }
            model.insertNodeInto(child, parent, parent.getChildCount());
        }
    }

    DefaultMutableTreeNode getTreeNodeForUserObject(Object userObject) {
        if (userObject == null) {
            return null;
        }
        DefaultMutableTreeNode parent = null;
        TreeModel tm = this.getModel();
        DefaultMutableTreeNode _root = (DefaultMutableTreeNode)tm.getRoot();
        if (userObject.equals(SITES)) {
            return (DefaultMutableTreeNode)_root.getChildAt(0);
        }
        if (userObject.equals(CLUSTERS)) {
            return (DefaultMutableTreeNode)_root.getChildAt(1);
        }
        if (userObject instanceof Site) {
            parent = (DefaultMutableTreeNode)_root.getChildAt(0);
        } else if (userObject instanceof Cluster) {
            parent = (DefaultMutableTreeNode)_root.getChildAt(1);
        } else if (userObject instanceof IOATreeNode) {
            parent = (DefaultMutableTreeNode)_root.getChildAt(1);
        }
        boolean exists = false;
        DefaultMutableTreeNode retNode = new DefaultMutableTreeNode();
        if (parent != null) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (userObject instanceof IOATreeNode) {
                    IOATreeNode itn = (IOATreeNode)userObject;
                    if (!itn.getCluster().equals(node.getUserObject())) continue;
                    if (itn.getName().equals(INTERFACES)) {
                        DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)node.getChildAt(0);
                        return cNode;
                    }
                    if (!itn.getName().equals(FLOWS)) continue;
                    DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)node.getChildAt(1);
                    return cNode;
                }
                if (!userObject.equals(node.getUserObject())) continue;
                exists = true;
                retNode = node;
            }
        }
        if (exists) {
            return retNode;
        }
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        super.getToolTipText(event);
        if (event != null) {
            TreePath path;
            Point p = event.getPoint();
            int selRow = this.getRowForLocation(p.x, p.y);
            if (selRow != -1 && (path = this.getPathForRow(selRow)) != null) {
                Object ob = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            }
        }
        return null;
    }

    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    public DefaultMutableTreeNode getRootNode() {
        TreeModel tm = this.getModel();
        DefaultMutableTreeNode _root = (DefaultMutableTreeNode)tm.getRoot();
        return _root;
    }

    class MyDefaultTreeCellEditor
    extends DefaultTreeCellEditor
    implements CellEditorListener {
        Object _userObjectEdited;

        public MyDefaultTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
            this.addCellEditorListener(this);
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            if (event != null && event instanceof MouseEvent) {
                Point p = ((MouseEvent)event).getPoint();
                int selRow = IOATree.this.getRowForLocation(p.x, p.y);
                if (selRow != -1) {
                    TreePath path = IOATree.this.getPathForRow(selRow);
                    this._userObjectEdited = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    return false;
                }
            }
            return super.isCellEditable(event);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            Object obb = this.getCellEditorValue();
            TreePath path = this.tree.getSelectionPath();
            DefaultMutableTreeNode node = null;
            if (path != null) {
                node = (DefaultMutableTreeNode)path.getLastPathComponent();
            }
            if (node != null) {
                node.setUserObject(this._userObjectEdited);
                if (IOATree.this._ioaAction != null) {
                    // empty if block
                }
                IOATree.this._ioaAction.showTreeNodeData(this._userObjectEdited, path, true);
            }
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
        }
    }
}

