/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.sm.client.ioa.FlowTableModel;
import com.cisco.dcbu.sm.client.ioa.IOACache;
import com.cisco.dcbu.sm.client.ioa.IOADialog;
import com.cisco.dcbu.sm.client.ioa.IOATableModel;
import com.cisco.dcbu.sm.client.ioa.IOATreeNode;
import com.cisco.dcbu.sm.client.ioa.InterfaceTableModel;
import com.cisco.dcbu.sm.client.ioa.OperationStatus;
import com.cisco.dcbu.sm.client.ioa.OperationStatusEnum;
import com.cisco.dcbu.sm.client.ioa.SwitchTableModel;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.ioa.Cluster;
import com.cisco.dcbu.sm.common.model.ioa.Flow;
import com.cisco.dcbu.sm.common.model.ioa.IOAInterface;
import com.cisco.dcbu.sm.common.model.ioa.Site;
import com.cisco.dcbu.sm.common.model.ioa.Switch;
import com.jidesoft.utils.SwingWorker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class IOAWorkerApply
extends SwingWorker<IOACache, String>
implements ActionListener {
    private IOACache cache;
    private IOADialog parent;
    private int currentProgress;
    private int increment = 10;
    private IOATableModel tableModel;
    private boolean reallyDone = false;
    public static Logger _Logger = Logger.getLogger((String)"IOA");

    public IOAWorkerApply() {
    }

    public IOAWorkerApply(IOADialog parent, IOACache cache, IOATableModel table) {
        this.parent = parent;
        this.cache = cache;
        this.currentProgress = 10;
        this.tableModel = table;
        this.reallyDone = false;
    }

    protected void done() {
        _Logger.info((Object)"IOAWorkerApply::done() - entering...");
        try {
            this.cache = (IOACache)this.get();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
        }
        catch (CancellationException e) {
            _Logger.warn((Object)"IOAWorkerApply::done() - CancellationException caught");
            int count = 0;
            while (!this.reallyDone) {
                _Logger.warn((Object)("while: reallyDone=" + this.reallyDone));
                try {
                    Thread.sleep(2000L);
                    if (++count <= 30) continue;
                    this.reallyDone = true;
                    _Logger.warn((Object)"timeout...");
                }
                catch (InterruptedException e2) {
                    _Logger.warn((Object)("timer interrupted..." + e2.getMessage()));
                    return;
                }
            }
        }
        _Logger.info((Object)"IOAWorkerApply::done() - exiting...");
    }

    /*
     * WARNING - void declaration
     */
    protected IOACache doInBackground() throws Exception {
        try {
            ArrayList<Serializable> removes;
            ArrayList<Serializable> adds;
            OperationStatus opE;
            _Logger.info((Object)"IOAWorkerApply::doInBackground() - Entering...");
            Object lastNode = this.cache.getLastSelectedNode();
            ArrayList<OperationStatus> opStatusList = new ArrayList<OperationStatus>();
            boolean didOps = false;
            this.updateStatus("Processing updates");
            if (this.tableModel instanceof SwitchTableModel) {
                _Logger.info((Object)"IOAWorkerApply::doInBackground() - SwitchTableModel...");
                didOps = true;
                if (!(lastNode instanceof Site)) {
                    opE = new OperationStatus();
                    opE.set(OperationStatusEnum.Failure, "Invalid state - sites");
                    opStatusList.add(opE);
                } else {
                    OperationStatus status;
                    adds = new ArrayList<Serializable>();
                    removes = new ArrayList<Serializable>();
                    Site site = (Site)lastNode;
                    ArrayList<Switch> memberList = site.getMemberList();
                    SwitchTableModel stm = (SwitchTableModel)this.tableModel;
                    ArrayList<Object> compList = stm.getObjectData();
                    for (Object o : compList) {
                        if (memberList.contains(o)) continue;
                        adds.add((Switch)o);
                    }
                    for (Switch s : memberList) {
                        if (compList.contains(s)) continue;
                        removes.add(s);
                    }
                    String string = site.getName();
                    if (adds.isEmpty() && removes.isEmpty()) {
                        this.currentProgress = 90;
                        this.updateStatus("No adds or removes detected.");
                    } else {
                        this.increment = 100 / (adds.size() + removes.size());
                    }
                    for (Switch switch_ : adds) {
                        if (this.isCancelled()) {
                            status = new OperationStatus();
                            status.set(OperationStatusEnum.Failure, "Skipped adding site label " + string + " to switch " + switch_.getName());
                        } else {
                            this.updateStatus("Adding site label " + string + " to switch " + switch_.getName());
                            status = this.cache.addSiteToSwitch(string, switch_);
                        }
                        if (status.getStatus().equals(OperationStatusEnum.Success)) continue;
                        opStatusList.add(status);
                    }
                    for (Switch switch_ : removes) {
                        if (this.isCancelled()) {
                            status = new OperationStatus();
                            status.set(OperationStatusEnum.Failure, "Skipped removing site label " + string + " from switch " + switch_.getName());
                        } else {
                            this.updateStatus("Removing site label " + string + " from switch " + switch_.getName());
                            status = this.cache.removeSiteFromSwitch(switch_);
                        }
                        if (status.getStatus().equals(OperationStatusEnum.Success)) continue;
                        opStatusList.add(status);
                    }
                }
            } else if (this.tableModel instanceof InterfaceTableModel) {
                _Logger.info((Object)"IOAWorkerApply::doInBackground() - InterfaceTableModel...");
                didOps = true;
                if (!(lastNode instanceof IOATreeNode)) {
                    opE = new OperationStatus();
                    opE.set(OperationStatusEnum.Failure, "Invalid state - interface");
                    opStatusList.add(opE);
                } else {
                    OperationStatus status;
                    void var12_31;
                    IOAInterface intf;
                    IOAInterface oIntf;
                    IOATreeNode tn = (IOATreeNode)lastNode;
                    Cluster c = tn.getCluster();
                    ArrayList<IOAInterface> adds2 = new ArrayList<IOAInterface>();
                    ArrayList<IOAInterface> removes2 = new ArrayList<IOAInterface>();
                    ArrayList<IOAInterface> memberList = c.getInterfaceList();
                    InterfaceTableModel itm = (InterfaceTableModel)this.tableModel;
                    ArrayList<Object> arrayList = itm.getObjectData();
                    ArrayList<Object[]> rowData = itm.getData();
                    for (Object o : arrayList) {
                        if (memberList.contains(o)) continue;
                        adds2.add((IOAInterface)o);
                    }
                    for (IOAInterface s : memberList) {
                        if (arrayList.contains(s)) continue;
                        removes2.add(s);
                    }
                    boolean bl = false;
                    for (Object[] oL : rowData) {
                        if (!memberList.contains(oL[7])) continue;
                        oIntf = (IOAInterface)oL[7];
                        intf = memberList.get(memberList.indexOf(oIntf));
                        if (oL[6].equals("down")) {
                            if (intf.getStatus() != 4) continue;
                            ++var12_31;
                            continue;
                        }
                        if (!oL[6].equals("up") || oIntf.getStatus() == 4) continue;
                        ++var12_31;
                    }
                    if (adds2.isEmpty() && removes2.isEmpty() && var12_31 == false) {
                        this.currentProgress = 90;
                        this.updateStatus("No changes detected.");
                    } else {
                        this.increment = 100 / (adds2.size() + removes2.size() + var12_31);
                    }
                    for (IOAInterface s : adds2) {
                        OperationStatus status2;
                        OperationStatus status3;
                        String errorDlg;
                        if (this.isCancelled()) {
                            status = new OperationStatus();
                            status.set(OperationStatusEnum.Failure, "Skipped adding " + s.getSwitchInfo().getName() + " interface " + s.getInterfaceId());
                            opStatusList.add(status);
                            continue;
                        }
                        String intfName = "ioa " + s.getSlot() + " / " + s.getPort();
                        if (s.getStatus() == 0 || s.getStatus() == 1) {
                            intfName = "unconfigured " + s.getSlot() + " / " + s.getPort();
                        }
                        this.updateStatus("Adding interface: " + intfName);
                        LicenseInfo license = s.getSwitchInfo().getBestAvailableLicense();
                        if (license == null) {
                            errorDlg = "Warning!  No IOA license for switch " + s.getSwitchInfo().getName() + ", interface ioa " + s.getSlot() + "/" + s.getPort() + " will be inoperable";
                            JOptionPane.showMessageDialog(this.parent.progressDialog, errorDlg);
                        } else if (!license.isPermanent()) {
                            StringBuilder stringBuilder = new StringBuilder().append("Warning!  Best IOA license available for switch ").append(s.getSwitchInfo().getName()).append(" is ");
                            s.getSwitchInfo();
                            errorDlg = stringBuilder.append(Switch.getLicenseString(license)).toString();
                            JOptionPane.showMessageDialog(this.parent.progressDialog, errorDlg);
                        }
                        String siteName = s.getSwitchInfo().getSiteName();
                        Site site = this.cache.getSite(siteName);
                        if (site == null && !(status3 = this.cache.addSiteToSwitch(siteName, s.getSwitchInfo())).getStatus().equals(OperationStatusEnum.Success)) {
                            status3.description = "Failed to add site label " + siteName + " for switch " + s.getSwitchInfo().getName() + ".  Try adding site via Sites view.";
                            opStatusList.add(status3);
                        }
                        if (!(status2 = this.cache.addClusterSite(s.getSwitchInfo())).getStatus().equals(OperationStatusEnum.Success)) {
                            status2.description = "Failed to set ioa site-local for switch " + s.getSwitchInfo().getName() + ".";
                            opStatusList.add(status2);
                            continue;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if ((status2 = this.cache.addClusterInterface(s)).getStatus().equals(OperationStatusEnum.Success)) continue;
                        opStatusList.add(status2);
                    }
                    for (IOAInterface s : removes2) {
                        if (this.isCancelled()) {
                            status = new OperationStatus();
                            status.set(OperationStatusEnum.Failure, "Skipped removing " + s.getSwitchInfo().getName() + " interface " + s.getInterfaceId());
                        } else {
                            this.updateStatus("Removing interface " + s.getInterfaceId());
                            status = this.cache.removeClusterInterface(s);
                        }
                        if (status.getStatus().equals(OperationStatusEnum.Success)) continue;
                        opStatusList.add(status);
                    }
                    for (Object[] oL : rowData) {
                        OperationStatus status4;
                        if (!memberList.contains(oL[7])) continue;
                        oIntf = (IOAInterface)oL[7];
                        intf = memberList.get(memberList.indexOf(oIntf));
                        if (oL[6] == null) continue;
                        if (oL[6].equals("down")) {
                            if (intf.getStatus() != 4) continue;
                            if (this.isCancelled()) {
                                OperationStatus status3 = new OperationStatus();
                                status3.set(OperationStatusEnum.Failure, "Skipped bringing down " + intf.getSwitchInfo().getName() + " interface " + intf.getInterfaceId());
                            } else {
                                this.updateStatus("Bringing down interface " + intf.getInterfaceId());
                                status4 = this.cache.ioaInterfaceAdminShut(intf);
                            }
                            if (status4.getStatus().equals(OperationStatusEnum.Success)) continue;
                            opStatusList.add(status4);
                            continue;
                        }
                        if (!oL[6].equals("up") || oIntf.getStatus() == 4) continue;
                        if (this.isCancelled()) {
                            status4 = new OperationStatus();
                            status4.set(OperationStatusEnum.Failure, "Skipped bring up " + intf.getSwitchInfo().getName() + " interface " + intf.getInterfaceId());
                        } else {
                            this.updateStatus("Bringing up interface " + intf.getInterfaceId());
                            status4 = this.cache.ioaInterfaceAdminNoShut(intf);
                        }
                        if (status4.getStatus().equals(OperationStatusEnum.Success)) continue;
                        opStatusList.add(status4);
                    }
                }
            } else if (this.tableModel instanceof FlowTableModel) {
                _Logger.info((Object)"IOAWorkerApply::doInBackground() - FlowTableModel...");
                didOps = true;
                if (!(lastNode instanceof IOATreeNode)) {
                    opE = new OperationStatus();
                    opE.set(OperationStatusEnum.Failure, "Invalid state - flow");
                    opStatusList.add(opE);
                } else {
                    OperationStatus status;
                    adds = new ArrayList();
                    removes = new ArrayList();
                    ArrayList<Flow> memberList = this.cache.getFlowList();
                    FlowTableModel itm = (FlowTableModel)this.tableModel;
                    ArrayList<Object> compList = itm.getObjectData();
                    for (Object object : compList) {
                        if (memberList.contains(object)) continue;
                        adds.add((Flow)object);
                    }
                    for (Flow flow : memberList) {
                        if (compList.contains(flow)) continue;
                        removes.add(flow);
                    }
                    if (adds.isEmpty() && removes.isEmpty()) {
                        this.currentProgress = 90;
                        this.updateStatus("No adds or removes detected.");
                    } else {
                        this.increment = 100 / (adds.size() + removes.size());
                    }
                    for (Flow flow : adds) {
                        if (this.isCancelled()) {
                            status = new OperationStatus();
                            status.set(OperationStatusEnum.Failure, "Skipped adding flow " + flow.getInitiator().getWwnBrief() + " : " + flow.getTarget().getWwnBrief());
                        } else {
                            this.updateStatus("Adding flow " + flow.getInitiator().getWwnBrief() + " : " + flow.getTarget().getWwnBrief());
                            status = this.cache.addFlow(flow);
                        }
                        if (status.getStatus().equals(OperationStatusEnum.Success)) continue;
                        opStatusList.add(status);
                    }
                    for (Flow flow : removes) {
                        if (this.isCancelled()) {
                            status = new OperationStatus();
                            status.set(OperationStatusEnum.Failure, "Skipped removing flow " + flow.getInitiator().getWwnBrief() + " : " + flow.getTarget().getWwnBrief());
                            _Logger.warn((Object)("Skipped removing flow " + flow.getInitiator().getWwnBrief() + " : " + flow.getTarget().getWwnBrief()));
                        } else {
                            this.updateStatus("Removing flow " + flow.getInitiator().getWwnBrief() + " : " + flow.getTarget().getWwnBrief());
                            _Logger.warn((Object)("Removing flow " + flow.getInitiator().getWwnBrief() + " : " + flow.getTarget().getWwnBrief()));
                            status = this.cache.removeFlow(flow);
                        }
                        if (status.getStatus().equals(OperationStatusEnum.Success)) continue;
                        opStatusList.add(status);
                    }
                }
            }
            if (didOps) {
                if (opStatusList.isEmpty()) {
                    this.parent.setStatus("Changes applied successfully.");
                } else {
                    for (OperationStatus op : opStatusList) {
                        _Logger.warn((Object)(op.getStatus().toString() + " " + op.getDescription()));
                    }
                    this.cache.setSwingWorkerOps(opStatusList);
                    this.parent.setStatus("Changes generated errors.");
                }
            }
            this.reallyDone = true;
            _Logger.info((Object)("IOAWorkerApply::doInBackground() - Exiting... reallyDone=" + this.reallyDone));
            return this.cache;
        }
        catch (Exception e) {
            _Logger.error((Object)"IOAWorkerApply: unexpected exception", (Throwable)e);
            OperationStatus exceptionStatus = new OperationStatus();
            exceptionStatus.setStatus(OperationStatusEnum.Failure);
            exceptionStatus.setDescription("An unexpected error occurred, see log for details.");
            this.cache.setSwingWorkerStatus(exceptionStatus);
            this.cache.setCustomDescription(true);
            this.reallyDone = true;
            _Logger.warn((Object)("IOAWorkerApply::doInBackground() - Exiting... reallyDone=" + this.reallyDone));
            return this.cache;
        }
    }

    private void updateStatus(String message) {
        this.currentProgress += this.increment;
        if (this.currentProgress > 100) {
            this.currentProgress = 100;
        }
        this.setProgress(this.currentProgress);
        this.publish(new String[]{message});
    }

    protected void process(List<String> chunks) {
        int sz = chunks.size();
        if (sz >= 1) {
            String last = chunks.get(sz - 1);
            this.parent.progressDialog._label.setText(last);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        _Logger.info((Object)("IOAWorkerApply::actionPerformed() - command=" + e.getActionCommand()));
        this.cancel(true);
        _Logger.info((Object)"IOAWorkerApply::actionPerformed() - exiting...");
    }
}

