/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.sm.client.ioa.IOACache;
import com.cisco.dcbu.sm.client.ioa.IOADialog;
import com.cisco.dcbu.sm.client.ioa.OperationStatus;
import com.cisco.dcbu.sm.client.ioa.OperationStatusEnum;
import com.cisco.dcbu.sm.common.model.ioa.Cluster;
import com.cisco.dcbu.sm.common.rif.IOARif;
import com.jidesoft.utils.SwingWorker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class IOAWorkerCluster
extends SwingWorker<IOACache, String>
implements ActionListener {
    private IOACache cache;
    private int currentProgress;
    private Cluster cluster;
    private IOADialog parent;
    private boolean isRemove = false;
    public static Logger _Logger = Logger.getLogger((String)"IOA");

    public IOAWorkerCluster() {
    }

    public IOAWorkerCluster(IOADialog parent, IOACache cache) {
        this.parent = parent;
        this.cache = cache;
        this.currentProgress = 0;
    }

    public IOAWorkerCluster(IOADialog parent, IOACache cache, Cluster cluster) {
        this.parent = parent;
        this.cache = cache;
        this.currentProgress = 0;
        this.cluster = cluster;
        this.isRemove = true;
    }

    protected IOACache doInBackground() throws Exception {
        try {
            IOARif ioa = this.cache.getIoa();
            if (ioa == null) {
                this.currentProgress = 90;
                this.updateStatus("Unable to reach DCNM-SAN Server");
                return this.cache;
            }
            if (this.isCancelled()) {
                return this.cache;
            }
            if (this.isRemove) {
                this.cache.getContext().clusterName = this.cluster.getName();
                this.cache.getContext().masterSwitch = this.cluster.getMasterSwitch();
                this.updateStatus("Removing cluster " + this.cluster.getName() + "...");
                try {
                    ioa.deleteCluster(this.cache.getContext());
                    this.cache.getClusterList().remove(this.cluster);
                    this.cache.getContext().clusterName = null;
                    this.cache.getContext().masterSwitch = null;
                    if (this.cache.getActiveCluster() != null && this.cache.getActiveCluster().equals(this.cluster)) {
                        this.cache.setActiveCluster(null);
                    }
                    OperationStatus successStatus = new OperationStatus();
                    successStatus.setStatus(OperationStatusEnum.Success);
                    successStatus.setDescription("Successfully removed cluster " + this.cluster.getName());
                    this.showComplete();
                    this.cache.setSwingWorkerStatus(successStatus);
                    this.cache.setCustomDescription(true);
                    return this.cache;
                }
                catch (RemoteException e) {
                    _Logger.error((Object)("Exception removing cluster " + this.cluster.getName()), (Throwable)e);
                    OperationStatus errorStatus = new OperationStatus();
                    errorStatus.setStatus(OperationStatusEnum.Failure);
                    String e3 = e.detail.getMessage();
                    errorStatus.setDescription("Exception removing cluster: " + e3);
                    this.showComplete();
                    this.cache.setSwingWorkerStatus(errorStatus);
                    this.cache.setCustomDescription(true);
                    return this.cache;
                }
            }
            if (this.cache.getSwingWorkerSwitch() != null && this.cache.getSwingWorkerSiteName() != null) {
                this.updateStatus("Adding site " + this.cache.getSwingWorkerSiteName() + " to switch " + this.cache.getSwingWorkerSwitch().getName() + "...");
                OperationStatus status = this.cache.addSiteToSwitch(this.cache.getSwingWorkerSiteName(), this.cache.getSwingWorkerSwitch());
                if (status.getStatus().equals(OperationStatusEnum.Failure)) {
                    this.showErrorDialog(status.getDescription());
                    return this.cache;
                }
            } else {
                this.showErrorDialog("Error selecting master switch, operation cancelled.");
                return this.cache;
            }
            this.cache.getSwingWorkerSwitch().setSiteName(this.cache.getSwingWorkerSiteName());
            this.cache.getContext().masterSwitch = this.cache.getSwingWorkerSwitch();
            this.cache.getContext().clusterName = this.cache.getSwingWorkerClusterName();
            try {
                this.updateStatus("Creating cluster " + this.cache.getSwingWorkerClusterName() + "...");
                ioa.addClusterSite(this.cache.getContext(), this.cache.getSwingWorkerSiteName(), this.cache.getSwingWorkerSwitch());
                ioa.createCluster(this.cache.getContext());
                OperationStatus successStatus = new OperationStatus();
                successStatus.setStatus(OperationStatusEnum.Success);
                successStatus.setDescription("Successfully created cluster " + this.cache.getSwingWorkerClusterName());
                this.showComplete();
                this.cache.setSwingWorkerStatus(successStatus);
                this.cache.setCustomDescription(true);
            }
            catch (RemoteException e) {
                _Logger.error((Object)"IOAWorkerApply: RemoteException", (Throwable)e);
                OperationStatus failureStatus = new OperationStatus();
                failureStatus.setStatus(OperationStatusEnum.Failure);
                failureStatus.setDescription(e.getMessage());
                this.showComplete();
                this.cache.setSwingWorkerStatus(failureStatus);
                this.cache.setCustomDescription(true);
            }
            return this.cache;
        }
        catch (Exception e) {
            _Logger.error((Object)"IOAWorkerCluster: unexpected exception", (Throwable)e);
            OperationStatus failureStatus = new OperationStatus();
            failureStatus.setStatus(OperationStatusEnum.Failure);
            failureStatus.setDescription("An unexpected error occurred, see log for details.");
            this.showComplete();
            this.cache.setSwingWorkerStatus(failureStatus);
            this.cache.setCustomDescription(true);
            return this.cache;
        }
    }

    private void updateStatus(String message) {
        this.currentProgress += 33;
        if (this.currentProgress > 100) {
            this.currentProgress = 100;
        }
        this.setProgress(this.currentProgress);
        this.publish(new String[]{message});
    }

    protected void process(List<String> chunks) {
        int sz = chunks.size();
        String last = chunks.get(sz - 1);
        this.parent.progressDialog._label.setText(last);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cancel(true);
    }

    public void showComplete() {
        this.currentProgress = 100;
        this.setProgress(this.currentProgress);
    }

    String showInputDialog(String label, String defVal) {
        JOptionPane pane = new JOptionPane(label, 3, 2, null, null, null);
        pane.setWantsInput(true);
        pane.setInitialSelectionValue(defVal);
        JDialog dialog = pane.createDialog(this.parent.progressDialog, label);
        pane.selectInitialValue();
        dialog.setVisible(true);
        Object value = pane.getInputValue();
        if (value == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return value.toString();
    }

    private String showListSingleSelectDialog(String label, String[] list) {
        Object selectedValue = JOptionPane.showInputDialog(this.parent.progressDialog, label, "Select One", 1, null, list, list[0]);
        return (String)selectedValue;
    }

    private boolean showQueryDialog(String label) {
        int ret = JOptionPane.showConfirmDialog(this.parent.progressDialog, label, "", 0);
        return ret == 0;
    }

    private void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this.parent.progressDialog, message);
    }
}

