/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.iscsi;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.iscsi.IscsiDevice;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class InitiatorDialog
extends JDialog
implements ActionListener {
    private static String[] HEADER = new String[]{"Name", "IP Address", "VSAN List", "WWN"};
    private KTable _table;
    private IscsiDevice _initiator;

    public InitiatorDialog(JDialog parent, ArrayList data) {
        super(parent);
        KTableModel model = new KTableModel();
        model.setHeaders(HEADER);
        this._table = new KTable(model);
        this._table.setSelectionMode(0);
        this.setIscsiData(data);
        this._table.calcPreferredSize();
        this.setTitle("Select ISCSI Initiator" + ClientController.getInstance().getDialogFabricTitlePostfix());
        JPanel pnl = new JPanel(new BorderLayout());
        JScrollPane scp = new JScrollPane(this._table);
        pnl.add((Component)scp, "Center");
        Dimension dm = this._table.getPreferredSize();
        scp.setPreferredSize(new Dimension(dm.height > 400 ? dm.width + scp.getVerticalScrollBar().getWidth() + 5 : dm.width + 5, dm.height > 400 ? 400 : dm.height + this._table.getRowHeight() + 5));
        DialogUtil.buildDialog(this, parent, pnl);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setModal(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selRow;
        if (e.getActionCommand().charAt(0) == 'O' && (selRow = this._table.getSelectedRow()) >= 0 && selRow < this._table.getRowCount()) {
            this._initiator = (IscsiDevice)this._table.getValueAt(selRow, 0);
        }
        this.dispose();
    }

    private void setIscsiData(ArrayList data) {
        Array<Object[]> theData = new Array<Object[]>();
        for (int i = 0; i < data.size(); ++i) {
            Object[] ob = new Object[4];
            IscsiDevice init = (IscsiDevice)data.get(i);
            ob[0] = init;
            ob[1] = init._address;
            ob[2] = SnmpBitmap.toString(init._vsanList);
            ob[3] = init._ep != null ? init._ep.toString() : WwnDictionary.get(init._pWWN);
            theData.addElement(ob);
        }
        ((KTableModel)this._table.getModel()).setData(theData);
    }

    IscsiDevice getSelectedInitiator() {
        return this._initiator;
    }
}

