/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.iscsi;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.iscsi.IscsiController;
import com.cisco.dcbu.sm.client.iscsi.IscsiDevice;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.IscsiProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class InitiatorPanel
extends WizardPanel
implements ActionListener,
ListSelectionListener {
    private static String[] _labels = new String[]{"Name or IP Address:", "On Switch:"};
    private static String[] HEADER_INITIATOR = new String[]{"Name", "IP Address", "VSAN List", "WWN"};
    private static String[] HEADER_PROXY = new String[]{"WWN", "Interface"};
    private static String SEL_INITIATOR_DESC = "Select an existing iSCSI initiator or configure a new initiator on a switch.";
    private static String SEL_PROXY_DESC = "Select an iSCSI proxy initiator.  The Proxy initiator allows all iSCSI initiators to connect through one IPS port making it appear as one Fibre Channel port.";
    private static String TITLE_INIT = "1 of 3: Configure Initiator";
    private static String TITLE_PROXY = "1 of 3: Configure iSCSI Proxy Initiator";
    private KTable _table;
    private FieldPanel _initiator;
    private JComboBox _switchCb;
    private SnmpPeer[] _peers;
    private ArrayList _initiatorData;
    private IscsiDevice _selectedInitiator;
    private JCheckBox _iscsiProxy;
    private IscsiController _iscsiController = (IscsiController)this.getModelValue("ISCSI_CONTROLLER");

    public InitiatorPanel(JWizard wiz) {
        super(TITLE_INIT, SEL_INITIATOR_DESC, wiz, IscsiController.ISCSI_HOST);
        this._switchCb = new JComboBox();
        this._initiator = new FieldPanel(30);
        KTableModel model = new KTableModel();
        model.setHeaders(HEADER_INITIATOR);
        this._table = new KTable(model);
        this._table.setSelectionMode(0);
        this._table.setAutoResizeMode(0);
        this._table.getSelectionModel().addListSelectionListener(this);
        this._table.getTableHeader().addMouseListener(new HeaderListener());
        this._table.setSortable(true);
        this._table.addPopupMenu();
        this._iscsiProxy = new JCheckBox("iSCSI Proxy");
        this._iscsiProxy.addActionListener(this);
        this._iscsiProxy.setVisible(false);
        JPanel mainPnl = new JPanel(new BorderLayout());
        JScrollPane scp = new JScrollPane(this._table);
        mainPnl.add((Component)this._iscsiProxy, "North");
        mainPnl.add((Component)scp, "Center");
        mainPnl.add((Component)DialogUtil.buildPanel(DialogUtil.buildLabels(_labels), new JComponent[]{this._initiator, this._switchCb}), "South");
        this.add((Component)mainPnl, "Center");
    }

    @Override
    public boolean refresh() {
        Switch[] sw = ClientController.getInstance().getFabric().getSwitches();
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        this._switchCb.removeAllItems();
        for (int i = 0; i < sw.length; ++i) {
            if (sw[i].getPeer() == null || !sw[i].hasIPSCard() || sw[i].isN7K()) continue;
            peers.add(sw[i].getPeer());
        }
        this._peers = new SnmpPeer[peers.size()];
        System.arraycopy(peers.toArray(), 0, this._peers, 0, this._peers.length);
        Arrays.sort(this._peers);
        this._switchCb.setModel(new DefaultComboBoxModel<SnmpPeer>(this._peers));
        try {
            this.fetchIscsiInitiators();
            this.setTableData();
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this.getWizard(), ex);
        }
        return true;
    }

    @Override
    public void doNext() {
        try {
            Switch sw;
            Object init = null;
            if (this._iscsiProxy.isSelected()) {
                int row = this._table.getSelectedRow();
                if (row == -1) {
                    Util.errorMessage((Component)this.getWizard(), "Please select an iSCSI proxy from table.");
                    return;
                }
                init = this._table.getValueAt(row, 0);
            } else {
                init = this.getInitiator();
            }
            if (init == null) {
                return;
            }
            if (this.getModelValue("INITIATOR") == null || !init.equals((IscsiDevice)this.getModelValue("INITIATOR")) || this._switchCb.getSelectedItem() != this.getModelValue("INITIATOR_SWITCH")) {
                this.setDataValid(false);
            }
            this.setModelValue("INITIATOR_SWITCH", this._switchCb.getSelectedItem());
            Switch switch_ = sw = this._switchCb.getSelectedItem() == null ? null : ClientController.getInstance().getFabric().findSwitchByIpAddress(((SnmpPeer)this._switchCb.getSelectedItem()).getAddress());
            if (sw == null) {
                throw new Exception("Can't find switch with IP Address: " + ((SnmpPeer)this._switchCb.getSelectedItem()).getAddress());
            }
            this.setModelValue("ZONE_PEER", sw);
            byte[] pWWN = this._iscsiProxy.isSelected() ? ((IscsiProxy)init)._pWWN : ((IscsiDevice)init)._pWWN;
            this.setModelValue("NEW_INITIATOR", pWWN == null);
            this.setModelValue("INITIATOR_LIST", this._initiatorData);
            this.setModelValue("INITIATOR", init);
            super.doNext();
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this.getWizard(), ex);
        }
    }

    private IscsiDevice getInitiator() throws SnmpException {
        try {
            String initiatorName = this._initiator.getText().trim();
            if (initiatorName == null || initiatorName.length() == 0) {
                Util.errorMessage((Component)this.getWizard(), "Please type a valid iSCSI name or IP Address.");
                return null;
            }
            if (this._selectedInitiator != null && this._selectedInitiator._name.equals(initiatorName) && this._selectedInitiator._switchAdd.equals(((SnmpPeer)this._switchCb.getSelectedItem()).getAddress())) {
                return this._selectedInitiator;
            }
            boolean isIpAddress = true;
            try {
                SnmpIpAddress.parse(initiatorName);
            }
            catch (SnmpException ex) {
                isIpAddress = false;
            }
            if (this._initiatorData != null) {
                for (int i = 0; i < this._initiatorData.size(); ++i) {
                    IscsiDevice init = (IscsiDevice)this._initiatorData.get(i);
                    if (!init._switchAdd.equals(((SnmpPeer)this._switchCb.getSelectedItem()).getAddress())) continue;
                    if (isIpAddress && init._address.compareTo(initiatorName) == 0) {
                        return init;
                    }
                    if (init._name.compareTo(initiatorName) != 0) continue;
                    return init;
                }
            }
            IscsiDevice initNew = new IscsiDevice();
            if (isIpAddress) {
                initNew._address = initNew._name = initiatorName;
            } else {
                if (initiatorName.length() < 16) {
                    Util.errorMessage((Component)this.getWizard(), "The initiator name should be at least 16 characters.");
                    return null;
                }
                initNew._name = initiatorName;
            }
            return initNew;
        }
        catch (NumberFormatException ex) {
            throw new SnmpException("Invalid initiator " + this._initiator.getText().trim() + ".");
        }
    }

    private void fetchIscsiInitiators() throws SnmpException {
        if (this._initiatorData == null) {
            this._iscsiController.clearCachedData();
            this._initiatorData = this._iscsiController.getInitiators(this._peers);
        }
    }

    private void setIscsiData(ArrayList data) {
        this.setTitle(TITLE_INIT);
        this.setDescription(SEL_INITIATOR_DESC);
        Array<Object[]> theData = new Array<Object[]>();
        for (int i = 0; i < data.size(); ++i) {
            IscsiDevice init = (IscsiDevice)data.get(i);
            if (init._pWWN == null || init._pWWN.length != 8) continue;
            Object[] ob = new Object[]{init, init._address, SnmpBitmap.toString(init._vsanList), SnmpString.toHexString(init._pWWN)};
            theData.addElement(ob);
        }
        ((KTableModel)this._table.getModel()).setData(theData);
        ((KTableModel)this._table.getModel()).fireTableDataChanged();
        this._table.calcPreferredSize();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this._table.getSelectedRow();
        if (row != -1) {
            Object selRow = ((KTableModel)this._table.getModel()).getValueAt(row, 0);
            if (!this._iscsiProxy.isSelected()) {
                this._selectedInitiator = (IscsiDevice)selRow;
                if (this._selectedInitiator != null) {
                    this._initiator.setText(this._selectedInitiator._name);
                    Switch sw = ClientController.getInstance().getFabric().findSwitchByIpAddress(this._selectedInitiator._switchAdd);
                    if (sw != null) {
                        this._switchCb.setSelectedItem(sw.getPeer());
                    }
                }
            } else {
                IscsiProxy selProxy = (IscsiProxy)selRow;
                this._initiator.setText(SnmpString.toHexString(selProxy._pWWN));
                Switch sw = ClientController.getInstance().getFabric().findSwitchByIpAddress(selProxy._switchAdd);
                if (sw != null) {
                    this._switchCb.setSelectedItem(sw.getPeer());
                }
            }
        }
    }

    private void setTableData() {
        this.setModelValue("INITIATOR", null);
        ((KTableModel)this._table.getModel()).setHeaders(this._iscsiProxy.isSelected() ? HEADER_PROXY : HEADER_INITIATOR);
        ((KTableModel)this._table.getModel()).fireTableStructureChanged();
        this.setIscsiData(this._initiatorData);
        this._initiator.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setTableData();
        this._switchCb.setEnabled(!this._iscsiProxy.isSelected());
        this._initiator.getField().setEditable(!this._iscsiProxy.isSelected());
    }
}

