/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.iscsi;

import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.ZoneAction;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.iscsi.InitiatorPanel;
import com.cisco.dcbu.sm.client.iscsi.IscsiController;
import com.cisco.dcbu.sm.client.iscsi.IscsiZoneSetPanel;
import com.cisco.dcbu.sm.client.iscsi.PortsPanel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.SmZoneAction;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import java.awt.Component;
import javax.swing.JFrame;

public class IscsiWizard
extends JWizard
implements StatusIf {
    private ZoneAction _zoneAction;

    public IscsiWizard(JFrame parent) throws SnmpException {
        super(parent);
        this.setTitle("iSCSI Wizard" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.setModelValue("ISCSI_CONTROLLER", new IscsiController());
        this.setZoneAction();
        this.createIscsiWizard();
        this.setSize(625, 500);
        this.setLocationRelativeTo(this.getParent());
    }

    private void setZoneAction() {
        this._zoneAction = new SmZoneAction(this, null, -1);
        this.setModelValue("ZONE_DATA", this._zoneAction);
    }

    void createIscsiWizard() throws SnmpException {
        Switch[] sw = ClientController.getInstance().getFabric().getSwitches();
        boolean hasIps = false;
        for (int i = 0; i < sw.length; ++i) {
            if (!sw[i].hasIPSCard() || sw[i].isN7K()) continue;
            hasIps = true;
            break;
        }
        if (!hasIps) {
            throw new SnmpException("There are no iSCSI capable switches in Fabric.");
        }
        this.addPanel("select initiator", new InitiatorPanel(this));
        this.addPanel("select ports", new PortsPanel(this));
        this.addPanel("create zone", new IscsiZoneSetPanel(this));
        this.first();
    }

    @Override
    public void handleError(Exception[] ex) {
        Util.errorMessage((Component)this, SmZoneUtil.buildErrorMessage(ex).toString());
        try {
            this.getNavigator().getNextBtn().setEnabled(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionFinished() {
        try {
            this.getNavigator().getNextBtn().setText("Finish");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setStatus(String status) {
        if (status.equals("Success")) {
            try {
                this.getNavigator().getNextBtn().setEnabled(false);
                this.getNavigator().getBackBtn().setEnabled(false);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            super.setStatus(status);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

