/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.lic;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.lic.DCNMActionManager;
import com.cisco.dcbu.sm.client.lic.LICClient;
import com.cisco.dcbu.sm.client.lic.Logger;
import com.cisco.dcbu.sm.client.lic.RestRequestHelper;
import java.awt.Component;
import javax.xml.parsers.DocumentBuilderFactory;
import org.restlet.Client;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.DomRepresentation;
import org.restlet.resource.Representation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NotifyFMClientRestlet
extends Restlet {
    public void handle(Request request, Response response) {
        super.handle(request, response);
        LICClient.getInstance().setDcnmInstanceId();
        DomRepresentation dom = request.getEntityAsDom();
        Node node_port = dom.getNode("/root/port/text()");
        String dcnmPort = node_port.getNodeValue();
        LICClient.getInstance().setRemotePort(dcnmPort);
        Node node_token = dom.getNode("/root/token/text()");
        String tempToken = node_token.getNodeValue();
        String url = "http://localhost:" + dcnmPort + "/login";
        Client client = new Client(Protocol.HTTP);
        Request req = new Request(Method.POST, url);
        RestRequestHelper helper = new RestRequestHelper(client);
        req.setEntity(NotifyFMClientRestlet.generateLoginResponse(tempToken));
        try {
            Response res = helper.handle(req);
            if (res.getStatus().isSuccess()) {
                Logger.debug("Passphrase login: Success");
                Logger.trace("Passphrase login response code: " + res.getStatus().toString());
            }
            if (res.getStatus().isError()) {
                Logger.debug("Passphrase login: Failed");
                Logger.trace("Passphrase login response code: " + res.getStatus().toString());
                String msg = res.getStatus().equals((Object)Status.CLIENT_ERROR_UNAUTHORIZED) ? "You are not authorized to use this service" : "An error has occurred: " + res.getStatus();
                Util.errorMessage((Component)BrowserFrame.getInstance(), msg, true);
                DCNMActionManager.getInstance().cancel();
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Unable to send login: " + ex.getMessage(), true);
        }
    }

    private static Representation generateLoginResponse(String _token) {
        DomRepresentation rep = null;
        try {
            Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = d.createElement("root");
            d.appendChild(root);
            Element port = d.createElement("token");
            port.appendChild(d.createTextNode(_token));
            root.appendChild(port);
            Element token = d.createElement("passphrase");
            token.appendChild(d.createTextNode(StringEncrypter.DESedeEncrypt(NotifyFMClientRestlet.getPassPhrase())));
            root.appendChild(token);
            d.normalizeDocument();
            rep = new DomRepresentation(MediaType.TEXT_XML, d);
            return rep;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return null;
        }
    }

    public static String getPassPhrase() {
        return "FM.0." + LICClient.getInstance().getUser() + ".0." + LICClient.getInstance().getPassword();
    }
}

