/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.lic.discovery;

import com.cisco.dcbu.sm.client.lic.LICClient;
import com.cisco.dcbu.sm.client.lic.Logger;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

public class FMSender {
    private long instanceId = System.currentTimeMillis();
    private static FMSender instance = null;
    private InetAddress group = null;
    private MulticastSocket sender = null;
    public static int MCASTPORT = 11010;
    public static String MCASTGROUP = "225.10.10.15";
    public static InetAddress MCASTADDR = null;

    public static synchronized FMSender getInstance() {
        if (instance == null) {
            instance = new FMSender();
        }
        return instance;
    }

    public FMSender() {
        try {
            MCASTADDR = InetAddress.getLocalHost();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.sender = new MulticastSocket(MCASTPORT);
            this.group = InetAddress.getByName(MCASTGROUP);
            this.sender.setTimeToLive(0);
            this.sender.setLoopbackMode(true);
            this.sender.setNetworkInterface(NetworkInterface.getByInetAddress(MCASTADDR));
            this.sender.joinGroup(this.group);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void send() {
        try {
            String replyPort = String.valueOf(LICClient.getInstance().getRestPort());
            String tmpToken = LICClient.getInstance().issueTmpToken();
            String str = this.instanceId + "#" + LICClient.getInstance().getServer() + "#" + replyPort + "#" + tmpToken;
            DatagramPacket pkt = new DatagramPacket(str.getBytes(), str.getBytes().length, this.group, 11010);
            if (this.sender != null) {
                this.sender.send(pkt);
            } else {
                Logger.error("Sender is not initialized");
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String ... strings) throws Exception {
        FMSender.getInstance().send();
    }
}

