/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.linksecurity;

import com.cisco.dcbu.lib.util.TimeWatch;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.wizardTask.BulkActionTableModel;
import com.cisco.dcbu.sm.client.wizardTask.ObjectActionTracker;
import com.cisco.dcbu.sm.client.wizardTask.ProgressPanel;
import com.cisco.dcbu.sm.common.event.PtoPEventFactory;
import com.cisco.dcbu.sm.common.event.PtoPEventHandler;
import com.cisco.dcbu.sm.common.event.QueueListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class AbstractAsyncObjectTask
implements Runnable,
QueueListener {
    public static final Logger _Logger = Logger.getLogger(AbstractAsyncObjectTask.class);
    public static final String Snmp_Timeout_Msg = "timeout";
    public static final String Snmp_Unauth_Msg = "Privacy unsupported for this user";
    public static final String Snmp_InvalidCredential_msg = "Invalid Credentials";
    protected Integer type;
    protected List<Object> objList = new ArrayList<Object>();
    protected TimeWatch timer = new TimeWatch();
    protected long taskTimeout = 60000L;
    protected long messageTimeout = 30000L;
    protected State state = State.Init;
    protected Set<Object> allSet = Collections.synchronizedSet(new HashSet());
    protected Set<Object> succSet = Collections.synchronizedSet(new HashSet());
    protected Set<Object> failedSet = Collections.synchronizedSet(new HashSet());
    protected PtoPEventHandler p2pHandler;
    protected ProgressPanel progress;
    protected BulkActionTableModel tm;
    protected String typeDisplayString = "";
    protected long requestId = -1L;

    public Integer getType() {
        return this.type;
    }

    public String getTypeDisplayString() {
        return this.typeDisplayString;
    }

    public long getTaskTimeout() {
        return this.taskTimeout;
    }

    public void setTaskTimeout(long taskTimeout) {
        this.taskTimeout = taskTimeout;
    }

    public long getMessageTimeout() {
        return this.messageTimeout;
    }

    public void setMessageTimeout(long messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    public void setNoTaskTimeout() {
        this.taskTimeout = -1L;
    }

    public boolean isTaskInit() {
        return this.getState() == State.Init;
    }

    public boolean isTaskRunning() {
        return this.getState() == State.Running;
    }

    public boolean isTaskEnd() {
        return this.getState() == State.End;
    }

    public boolean isTaskClosed() {
        return this.getState() == State.Close;
    }

    public boolean isTaskSuccess() {
        return this.isTaskEnd() && this.succSet.size() == this.allSet.size();
    }

    public boolean isTaskFailed() {
        return this.isTaskEnd() && this.failedSet.size() > 0;
    }

    public boolean isTaskInterrupted() {
        return this.isTaskEnd() && this.failedSet.size() + this.succSet.size() < this.allSet.size();
    }

    protected void setState(State state) {
        if (this.state != state) {
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " : state changed from " + (Object)((Object)this.state) + " to " + (Object)((Object)state)));
            }
            this.state = state;
        }
    }

    protected State getState() {
        return this.state;
    }

    public Set<Object> getFailedSet() {
        return this.failedSet;
    }

    public Set<Object> getSuccSet() {
        return this.succSet;
    }

    public Set<Object> getAllSet() {
        return this.allSet;
    }

    public List<Object> getObjList() {
        return this.objList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            AbstractAsyncObjectTask abstractAsyncObjectTask = this;
            synchronized (abstractAsyncObjectTask) {
                this.timer.start();
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)(this + " to run"));
                }
                this.startTask();
                while (this.isTaskRunning()) {
                    block17: {
                        try {
                            if (_Logger.isTraceEnabled()) {
                                _Logger.trace((Object)(this + " waited at time:" + this.timer.getTimeDisplay()));
                            }
                            if (this.messageTimeout > 0L) {
                                this.wait(this.messageTimeout);
                            } else {
                                this.wait();
                            }
                            if (_Logger.isTraceEnabled()) {
                                _Logger.trace((Object)(this + " woke up at time:" + this.timer.getTimeDisplay()));
                            }
                        }
                        catch (InterruptedException e) {
                            if (!_Logger.isTraceEnabled()) break block17;
                            _Logger.trace((Object)(this + " got interrupted at time:" + this.timer.getTimeDisplay()));
                        }
                    }
                    if (this.taskTimeout <= 0L || this.timer.getTime() <= this.taskTimeout) continue;
                    throw new Exception(this + " used time: " + this.timer.getTimeDisplay() + " passed maximum time" + TimeWatch.getDisplayedTime(this.taskTimeout) + "\nTask is timeout");
                }
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)(this + " cannot complete with exception at time:" + this.timer.getTimeDisplay()));
            _Logger.warn((Object)e);
            this.handleException(e);
        }
        finally {
            this.timer.stop();
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " ended at time:" + this.timer.getTimeDisplay()));
            }
            this.endTask();
        }
    }

    protected void startTask() throws Exception {
        try {
            if (!this.isTaskInit()) {
                throw new IllegalStateException(this + " is in illegal state to start task:" + this.state.getName());
            }
            this.setState(State.Running);
            this.updateStartStatus();
            this.p2pHandler = PtoPEventFactory.getInstance().getPtoPHandler("jms/queue/ESP", this);
            if (this.p2pHandler == null) {
                throw new Exception(this + " cannot communicate to remote");
            }
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " got PtoEventHandler: " + this.p2pHandler + ", with QueueListener:" + this + ", with CommObj:" + this.p2pHandler.getCommunicationObject()));
            }
            this.requestId = this.sendRequest();
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)">>>>>>>>> AsyncObjectTask started a request >>>>>>>>>");
                _Logger.trace((Object)(">>>>" + this + " with reqId->" + this.requestId + ", p2pHandler->" + this.p2pHandler + ", queueListener->" + this));
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)(this + " failed to start: "), (Throwable)e);
            throw e;
        }
    }

    protected void endTask() {
        try {
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " reached to endTask"));
            }
            this.setState(State.End);
            this.destroyPtoPQueue();
            this.updataEndStatus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void destroyPtoPQueue() {
        if (this.p2pHandler != null) {
            try {
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)(this + " close P2P queue:" + this.p2pHandler));
                }
                try {
                    ClientController.getInstance().assertESP().destroyPtoPQueue(this.p2pHandler.getCommunicationObject());
                }
                catch (Exception re) {
                    _Logger.error((Object)"error cleaning up P to P Queue on Server", (Throwable)re);
                }
                this.p2pHandler.stop();
                this.p2pHandler.dispose();
            }
            catch (Exception e) {
                _Logger.debug((Object)"Exception from close P2P queue", (Throwable)e);
            }
        }
        this.p2pHandler = null;
    }

    protected void handleException(Exception e) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " failed task with exception:" + e));
        }
        this.setState(State.End);
        this.updateFailStatus(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask() {
        AbstractAsyncObjectTask abstractAsyncObjectTask = this;
        synchronized (abstractAsyncObjectTask) {
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " is cancelled with reqId: " + this.requestId));
            }
            if (this.isTaskRunning()) {
                this.setState(State.End);
                this.updateCancelStatus();
                this.notifyAll();
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)(this + "- onMessage: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + ": notifyAll"));
                }
            }
        }
    }

    public void resetTask(boolean all) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " is reset"));
        }
        if (this.isTaskRunning() || this.isTaskClosed()) {
            throw new IllegalStateException(this + " cannot be reset: " + this.getState().getName());
        }
        this.destroyPtoPQueue();
        this.timer.reset();
        this.requestId = -1L;
        this.failedSet.clear();
        if (all) {
            this.succSet.clear();
        } else {
            this.adjustComponents();
        }
        this.setState(State.Init);
    }

    public void closeTask() {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " is closed and cleaned up"));
        }
        if (this.isTaskRunning()) {
            throw new IllegalStateException(this + " cannot be reset: " + this.getState().getName());
        }
        this.setState(State.Close);
        this.destroyPtoPQueue();
        this.allSet.clear();
        this.succSet.clear();
        this.failedSet.clear();
        this.timer.reset();
        this.requestId = -1L;
        this.objList.clear();
    }

    protected abstract long sendRequest() throws Exception;

    protected abstract void adjustComponents();

    protected void updateStartStatus() {
        if (this.progress != null) {
            this.progress.setStatus(this.typeDisplayString);
            this.progress.increaseProgress();
        }
    }

    protected void updateFailStatus(Exception error) {
        for (Object obj : this.objList) {
            if (this.succSet.contains(obj)) continue;
            this.updateObjectTaskStatus(obj, ObjectActionTracker.FAILED, "Got exception", error);
        }
    }

    protected void updateObjectTaskStatus(Object obj, ObjectActionTracker.Status status, String message, Exception error) {
        if (this.tm != null) {
            List<ObjectActionTracker> actions = this.tm.findActionByTarget(obj);
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)("update status ==>" + obj + ", " + message + ", " + (Object)((Object)status) + ", " + actions));
            }
            if (actions != null) {
                for (int k = 0; k < actions.size(); ++k) {
                    final ObjectActionTracker action = actions.get(k);
                    if (action.getType() != this.type) continue;
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)("update action==>" + action + ", " + (Object)((Object)status)));
                    }
                    if (action.getStatus() == ObjectActionTracker.SUCCESS || action.getStatus() == ObjectActionTracker.FAILED) {
                        return;
                    }
                    action.setStatus(status, message, error);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractAsyncObjectTask.this.tm.updateAction(action);
                        }
                    });
                }
            }
        }
        if (this.progress != null) {
            if (status == ObjectActionTracker.INPROGRESS || status == ObjectActionTracker.WARNING) {
                this.progress.setStatus(this.typeDisplayString + " on switch " + obj + " is in progress");
            } else if (status == ObjectActionTracker.ERROR) {
                this.progress.setStatus(this.typeDisplayString + " on switch " + obj + " got error");
                this.progress.increaseProgress();
            } else if (status == ObjectActionTracker.FAILED) {
                this.progress.setStatus(this.typeDisplayString + " on switch " + obj + " failed");
                this.progress.increaseProgress();
            } else if (status == ObjectActionTracker.SUCCESS) {
                this.progress.setStatus(this.typeDisplayString + " on switch " + obj + " is successful");
                this.progress.increaseProgress();
            }
        }
        if (status == ObjectActionTracker.ERROR || status == ObjectActionTracker.FAILED) {
            this.failedSet.add(obj);
        } else if (status == ObjectActionTracker.SUCCESS) {
            this.succSet.add(obj);
        }
        if (this.succSet.size() + this.failedSet.size() >= this.objList.size()) {
            this.setState(State.End);
            this.destroyPtoPQueue();
        }
    }

    protected void updataEndStatus() {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("Task Succ sw==>" + this.succSet.size() + "--" + this.succSet));
            _Logger.trace((Object)("Task Failed sw==>" + this.failedSet.size() + "--" + this.failedSet));
            _Logger.trace((Object)("Task All Sw==>" + this.objList.size() + "--" + this.objList));
        }
        if (this.progress != null) {
            if (this.isTaskSuccess()) {
                this.progress.setStatus(this.typeDisplayString + " finished");
            } else if (this.isTaskInterrupted()) {
                this.progress.setStatus(this.typeDisplayString + " did not complete");
            } else if (this.isTaskFailed()) {
                this.progress.setStatus(this.typeDisplayString + " is failed");
            }
        }
    }

    protected void updateCancelStatus() {
        if (this.progress != null) {
            this.progress.setStatus(this.typeDisplayString + " is cancelled");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("[type=");
        sb.append(this.getType());
        sb.append("]");
        return sb.toString();
    }

    protected void finalize() throws Throwable {
        this.closeTask();
        super.finalize();
    }

    public static enum State {
        Init("Init"),
        Running("Running"),
        End("End"),
        Close("Close");

        private String name;

        private State(String typeName) {
            this.name = typeName;
        }

        public String getName() {
            return this.name;
        }
    }
}

