/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.linksecurity;

import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.linksecurity.SASwitchPair;
import java.util.ArrayList;
import java.util.Arrays;

public class SASwithPairTableModel
extends KTableModel {
    public final int ColumnSize = Column.values().length;

    public SASwithPairTableModel(String[] headers) {
        this.setHeaders(headers);
        Array data = new Array();
        this.setData(data);
    }

    public synchronized void deleteRows(int[] rowIndexes) {
        if (rowIndexes == null) {
            return;
        }
        Array data = this.getData();
        Arrays.sort(rowIndexes);
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            this.deleteRow(rowIndexes[i], false);
        }
        this.fireTableDataChanged();
    }

    public synchronized void deleteRow(int rowIndex) {
        this.deleteRow(rowIndex, true);
    }

    private synchronized void deleteRow(int rowIndex, boolean fireDataChanged) {
        Array data = this.getData();
        Object[] row = (Object[])data.elementAt(rowIndex);
        SASwitchPair pair = (SASwitchPair)row[Column.SWITCHPAIR.ordinal()];
        Integer spi = (Integer)row[Column.SPI.ordinal()];
        pair.deleteUserCreatedSa(spi);
        this.getData().removeElementAt(rowIndex);
        if (fireDataChanged) {
            this.fireTableDataChanged();
        }
    }

    public synchronized void clearAll() {
        Array data = this.getData();
        for (int index = 0; index < data.size(); ++index) {
            Object[] row = (Object[])data.elementAt(index);
            SASwitchPair pair = (SASwitchPair)row[Column.SWITCHPAIR.ordinal()];
            pair.deleteAllUserCreatedSa();
        }
        this.getData().clear();
        this.fireTableDataChanged();
    }

    public synchronized void deleteAllEntriesFor(SASwitchPair pair) {
        Array data = this.getData();
        ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
        for (int index = 0; index < data.size(); ++index) {
            Object[] row = (Object[])data.elementAt(index);
            if (!pair.equals(row[Column.SWITCHPAIR.ordinal()])) continue;
            pair.deleteAllUserCreatedSa();
            indexesToRemove.add(index);
        }
        for (Integer nextIndex : indexesToRemove) {
            data.removeElementAt(nextIndex);
        }
        this.fireTableDataChanged();
    }

    public synchronized void addEntry(SASwitchPair pair, Integer spi, Long salt, String key) throws Exception {
        Object[] row = new Object[this.ColumnSize];
        row[Column.SWITCHPAIR.ordinal()] = pair;
        row[Column.SPI.ordinal()] = spi;
        row[Column.SALT.ordinal()] = salt;
        row[Column.KEY.ordinal()] = key;
        int index = this.getData().findEquals(row);
        if (index != -1) {
            throw new Exception("Entry already exists");
        }
        this.getData().addElement(row);
        pair.addUserCreatedSa(spi, salt, key);
        this.fireTableDataChanged();
    }

    @Override
    public int compare(Object first, Object second) {
        if (first == second) {
            return 0;
        }
        if (first == null) {
            return -1;
        }
        if (second == null) {
            return 1;
        }
        if (first instanceof Comparable && second instanceof Comparable) {
            return ((Comparable)first).compareTo(second);
        }
        if (first.toString().equals(second.toString())) {
            return 0;
        }
        if (first.toString() == null) {
            return -1;
        }
        if (second.toString() == null) {
            return 1;
        }
        return first.toString().compareTo(second.toString());
    }

    public static enum Column {
        SWITCHPAIR,
        SPI,
        SALT,
        KEY;

    }
}

