/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.logicaltree;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.logicaltree.SegmentedVsanTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.VsanTree;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeCommand;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeNode;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Lan;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.UserDefinedGroup;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class MyRenderer
extends DefaultTreeCellRenderer {
    public MyRenderer() {
        this.setBackground(null);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof SegmentedVsanTreeNode) {
            this.setIcon(Util.loadIcon("icons/segFolder.gif"));
        } else if (value instanceof VsanTreeNode) {
            VsanTreeNode vsanTreeNode = (VsanTreeNode)value;
            if (((VsanTreeCommand)vsanTreeNode.getUserObject())._vsan.isSegmented()) {
                this.setIcon(Util.loadIcon("icons/segFolder.gif"));
            }
        } else if (leaf) {
            this.setIcon(this.getLeafNodeIcon(value));
        } else {
            Icon icon = MyRenderer.getFolderNodeIcon(value);
            if (icon != null) {
                this.setIcon(icon);
            }
        }
        return this;
    }

    protected Icon getLeafNodeIcon(Object value) {
        Icon icon = null;
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj != null && obj instanceof UserDefinedGroup) {
                if ((((UserDefinedGroup)obj).getType() & 1) != 0) {
                    return VsanTree._switchIcon;
                }
                return VsanTree._endPortIcon;
            }
            if (!VsanTree.USE_OLD_FOLDER_ICONS) {
                if (obj != null && obj instanceof DataCenter) {
                    return VsanTree._dataCenterIcon;
                }
                if (obj != null && obj instanceof Lan) {
                    return VsanTree._lanIcon;
                }
                if (obj != null && obj instanceof San) {
                    return VsanTree._sanIcon;
                }
                if (obj != null && obj instanceof Fabric) {
                    return VsanTree._fabricIcon;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    public static Icon getFolderNodeIcon(Object value) {
        Icon icon = null;
        if (VsanTree.USE_OLD_FOLDER_ICONS) {
            return icon;
        }
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj != null && obj instanceof DataCenter) {
                return VsanTree._dataCenterIcon;
            }
            if (obj != null && obj instanceof Lan) {
                return VsanTree._lanIcon;
            }
            if (obj != null && obj instanceof San) {
                return VsanTree._sanIcon;
            }
            if (obj != null && obj instanceof Fabric) {
                return VsanTree._fabricIcon;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        retDimension.width += 10;
        return retDimension;
    }
}

