/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.logicaltree;

import com.cisco.dcbu.lib.ui.PerspectiveIf;
import com.cisco.dcbu.lib.ui.PerspectiveManager;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeCommandNode;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeNode;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Vsan;

class VsanTreeCommand {
    String _method;
    String _label;
    Vsan _vsan;
    Fabric _fabric;

    public VsanTreeCommand(Vsan vsan, String label, String method) {
        this._vsan = vsan;
        this._method = method;
        this._label = label;
    }

    public VsanTreeCommand(Fabric f, String label, String method) {
        this._fabric = f;
        this._method = method;
        this._label = label;
    }

    public static void load(VsanTreeNode top, Vsan vsan, int nDirectVsanChild) {
        if (vsan != null) {
            top.insert(new VsanTreeCommandNode(new VsanTreeCommand(vsan, "VSAN Attributes", "logicalVsanTab")), nDirectVsanChild++);
            PerspectiveIf perspectiveView = PerspectiveManager.getInstance().getView();
            if (perspectiveView != null) {
                if (perspectiveView.isVisible("tree", "Domain Manager")) {
                    VsanTreeCommandNode db = new VsanTreeCommandNode(new VsanTreeCommand(vsan, "Domain Manager", "dmTab"));
                    top.insert(db, nDirectVsanChild++);
                    db.insert(new VsanTreeCommandNode(new VsanTreeCommand(vsan, "Allowed", "dmAllowedTab")), 0);
                }
                if (perspectiveView.isVisible("tree", "Port Security")) {
                    top.insert(new VsanTreeCommandNode(new VsanTreeCommand(vsan, "Port Security", "portSecurityManagerTab")), nDirectVsanChild++);
                }
                if (perspectiveView.isVisible("tree", "Fabric Binding")) {
                    top.insert(new VsanTreeCommandNode(new VsanTreeCommand(vsan, "Fabric Binding", "fabricSecurityManagerTab")), nDirectVsanChild++);
                }
                if (perspectiveView.isVisible("tree", "FICON")) {
                    top.insert(new VsanTreeCommandNode(new VsanTreeCommand(vsan, "FICON", "ficonTab")), nDirectVsanChild++);
                }
                if (perspectiveView.isVisible("tree", "FSPF")) {
                    top.insert(new VsanTreeCommandNode(new VsanTreeCommand(vsan, "FSPF", "fspfTab")), nDirectVsanChild++);
                }
                if (perspectiveView.isVisible("tree", "SDV")) {
                    top.insert(new VsanTreeCommandNode(new VsanTreeCommand(vsan, "SDV", "sdvTab")), nDirectVsanChild++);
                }
                if (perspectiveView.isVisible("tree", "Advanced")) {
                    top.insert(new VsanTreeCommandNode(new VsanTreeCommand(vsan, "Advanced", "fcAdvTab")), nDirectVsanChild++);
                }
            }
        }
    }

    public String toString() {
        return this._label;
    }
}

