/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyNodePainter;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.model.Fabric;
import java.awt.Image;
import javax.swing.GrayFilter;

public class FabricNode
extends MapNode {
    private static final String ICON_NAME = "Cloud.gif";
    private static final String KUBRICK_ICON_NAME = "Device_cloud_white_3041_";
    private static TopologyNodePainter _Painter = null;
    private static TopologyNodePainter _DimPainter = null;

    public FabricNode(Fabric fabric) {
        super(fabric.getPK().hashCode(), fabric.getName() == null ? fabric.getSeedSwitch().getIpAddress() : fabric.getName());
        this.setModel(fabric);
        TopologyNodePainter painter = this.getRenderer();
        this.setIconSize(painter.getImageWidth(), painter.getImageWidth());
        fabric.setUserObject(this);
    }

    @Override
    public boolean isManageable() {
        return ((Fabric)this.getModel()).isManagedByServer();
    }

    @Override
    public int getDefaultIconHeight() {
        if (SmMap.isClassUseKubrickIcons()) {
            return FabricNode.getKubrickSize();
        }
        return 24;
    }

    public String getIconName() {
        return ICON_NAME;
    }

    public String getKubrickIconName() {
        return KUBRICK_ICON_NAME;
    }

    @Override
    public TopologyNodePainter getRenderer() {
        Image image = null;
        String path = null;
        if (_Painter == null) {
            if (SmMap.isClassUseKubrickIcons()) {
                path = "icons/" + this.getKubrickIconName() + "default_" + MapNode.getKubrickSizeAsString() + ".png";
                image = Util.getIconImage(path, this.getDefaultIconHeight());
            } else {
                path = "icons/" + this.getIconName();
                image = Util.getIconImage(path, this.getDefaultIconHeight());
            }
            _Painter = new TopologyNodePainter(image);
            image = GrayFilter.createDisabledImage(image);
            _DimPainter = new TopologyNodePainter(image);
        }
        if (this.isDimmed()) {
            return _DimPainter;
        }
        return _Painter;
    }

    @Override
    public Image getKubricIconImage(String sizeAsString) {
        Image image = null;
        String path = null;
        if (SmMap.isClassUseKubrickIcons()) {
            String kubrickIconName = this.getKubrickIconName();
            path = !this.isPresent() ? "icons/" + kubrickIconName + "unreachable_" + sizeAsString + ".png" : (!this.isManageable() ? "icons/" + kubrickIconName + "unmanaged_" + sizeAsString + ".png" : (this.hasMinorFault() ? "icons/" + kubrickIconName + "minor_" + sizeAsString + ".png" : "icons/" + kubrickIconName + "default_" + sizeAsString + ".png"));
            image = Util.getIconImage(path);
        } else {
            path = "icons/" + this.getIconName();
            image = Util.getIconImage(path, this.getDefaultIconHeight());
        }
        return image;
    }

    public String getDeviceType() {
        return "Fabric";
    }

    @Override
    public void actionDoubleClick() {
        BrowserFrame.getInstance().showFabricTab((Fabric)this.getModel());
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean hasMinorFault() {
        try {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public String getTooltip() {
        Fabric model = (Fabric)this.getModel();
        if (model != null) {
            return model.getName();
        }
        return this.getText();
    }

    @Override
    public void update() {
        Fabric obj = (Fabric)this.getModel();
        if (obj == null) {
            return;
        }
        String name = obj.getName();
        this.setFormattedTooltip(null);
        if (name != null && !name.equals(this.getNodeLabelString())) {
            this.nameChanged(this, name);
        }
        if (this._hashCode != 0) {
            this._prevHashCode = this._hashCode;
        }
        this._hashCode = 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof FabricNode) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this._hashCode != 0) {
            return this._hashCode;
        }
        try {
            Fabric o = (Fabric)this.getModel();
            this._hashCode = o.hashCode();
            if (this._prevHashCode != 0 && this._prevHashCode != this._hashCode) {
                ((TopologyGraph)this.getOwner()).updateLinkHash(this, this._prevHashCode, this._hashCode);
            }
            return this._hashCode;
        }
        catch (Exception e) {
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)("FabricNode.hashCode() " + e.getMessage()), (Throwable)e);
            }
            this._hashCode = super.hashCode();
            return this._hashCode;
        }
    }

    @Override
    public void destroy() {
        Fabric obj = (Fabric)this.getModel();
        obj.setUserObject(null);
        this.setModel(null);
    }
}

