/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.actions.AttributesAction;
import com.cisco.dcbu.sm.client.model.Hub;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import javax.swing.JMenuItem;

public class LoopLink
extends MapLink {
    public LoopLink(MapNode switchNode, MapNode loop, Hub hub) {
        super(switchNode, loop, 0);
        this.setModel(hub);
    }

    @Override
    public boolean isDashed() {
        Hub hub = (Hub)this.getModel();
        return hub.isCloud();
    }

    @Override
    public boolean isDotDashed() {
        Hub h = (Hub)this.getModel();
        if (h == null) {
            return false;
        }
        Switch sw = h.getSwitch();
        if (sw == null) {
            return false;
        }
        return sw.isFeatureEnabled(AbstractSwitchBase.Feature.NPV.flag());
    }

    @Override
    public boolean isVisible() {
        boolean b = super.isVisible();
        if (!b) {
            return b;
        }
        return true;
    }

    @Override
    public String getClassName() {
        return "Loop";
    }

    public static JMenuItem[] getMenuItems(JMenuItem[] _menuItems) {
        if (_menuItems != null) {
            return _menuItems;
        }
        JMenuItem[] mi = MapLink.getMenuItems(_menuItems);
        _menuItems = new JMenuItem[mi.length + 1];
        int l = 0;
        _menuItems[l++] = Util.createMenuItem("Device Attributes", "attributes", "Device Attributes", AttributesAction.getInstance());
        try {
            System.arraycopy(mi, 0, _menuItems, l, mi.length);
        }
        catch (Exception e) {
            _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
        }
        return _menuItems;
    }
}

