/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.MapFactoryIf;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.actions.AttributesAction;
import com.cisco.dcbu.sm.client.map.actions.DMMapAction;
import com.cisco.dcbu.sm.client.map.actions.MiscMapActions;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import javax.swing.JMenuItem;

public class NpvMapLink
extends MapLink {
    public NpvMapLink(NpvLink link) {
        super(MapFactory.getInstance().getNode(link.getCoreSwitch()), MapFactory.getInstance().getNode(link.getEdgeSwitch()), link.hashCode());
        this.setModel(link);
        link.setUserObject(this);
    }

    public NpvMapLink(NpvLink link, MapFactoryIf mapFactory) {
        super(mapFactory.getNode(link.getCoreSwitch()), mapFactory.getNode(link.getEdgeSwitch()), link.hashCode());
        this.setModel(link);
        link.setUserObject(this);
    }

    public NpvMapLink(MapNode n1, MapNode n2, NpvLink model) {
        super(n1, n2, model.hashCode());
        this.setModel(model);
        model.setUserObject(this);
    }

    @Override
    public String getClassName() {
        return "NP Link";
    }

    @Override
    public boolean purge() throws Exception {
        NpvLink npvLink = (NpvLink)this.getModel();
        if (npvLink == null || npvLink.isPresent()) {
            return false;
        }
        ClientController.getInstance().assertModelFacade().purgeNpvLink(((NpvLinkBase)npvLink.getBaseModelObject()).getFPortPK());
        return true;
    }

    @Override
    public long getSpeed() {
        NpvLink npvLink = (NpvLink)this.getModel();
        return npvLink.getSpeed();
    }

    public static JMenuItem[] getMenuItems(JMenuItem[] _menuItems) {
        if (_menuItems != null) {
            return _menuItems;
        }
        JMenuItem[] mi = MapLink.getMenuItems(_menuItems);
        int number = 9;
        _menuItems = new JMenuItem[mi.length + ++number];
        int l = mi.length;
        try {
            System.arraycopy(mi, 0, _menuItems, 0, l);
        }
        catch (Exception e) {
            l = 0;
        }
        _menuItems[l++] = Util.createMenuItem("Element Manager", "linkElementManager", "Element Manager", DMMapAction.getInstance());
        _menuItems[l++] = Util.createMenuItem("FCIP Tunnel Attributes", "fcipAttribute", "FCIP Tunnel Attributes", AttributesAction.getInstance());
        _menuItems[l++] = null;
        _menuItems[l++] = Util.createMenuItem("Create Port Channel...", "createPortChannel", "Create Port Channel...", AttributesAction.getInstance());
        _menuItems[l++] = null;
        _menuItems[l++] = Util.createMenuItem("Re-enable", "reenableNpvLink", "Re-enable", AttributesAction.getInstance());
        _menuItems[l++] = Util.createMenuItem("Enable FC-SP", "enableFSCP", "Enable FC-SP", AttributesAction.getInstance());
        _menuItems[l++] = Util.createMenuItem("SAN Extension Tuner...", "sanExtTuner", "SAN Extension Tuner...", AttributesAction.getInstance());
        _menuItems[l++] = null;
        _menuItems[l++] = Util.createMenuItem("Purge", "purge", "Purge", MiscMapActions.getInstance());
        return _menuItems;
    }

    @Override
    public boolean isDotDashed() {
        return true;
    }
}

