/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Filter;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientContext;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.map.DataCenterMapFactory;
import com.cisco.dcbu.sm.client.map.EdgeMapLink;
import com.cisco.dcbu.sm.client.map.LanMapFactory;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.MapFactoryIf;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.SelectionAction;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.DeviceAlias;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Lan;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.dto.Lun;
import com.cisco.dcbu.sm.common.type.FabricPK;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class SmFindDialog
extends JDialog
implements ActionListener,
KeyListener,
ListSelectionListener,
MouseListener {
    public static Logger _Logger = Logger.getLogger(SmFindDialog.class);
    static final String STRING_VSAN_WWN = "VSAN WWN";
    static final String[] _BUTTONS = new String[]{"Find", "Close"};
    private static final int END_DEVICE = 0;
    private static final int SWITCH = 1;
    private static final int LUN = 2;
    public static final int NAME = 0;
    public static final int IP_ADDRESS = 1;
    public static final int nWWN = 2;
    public static final int VSAN_WWN = 3;
    public static final int VENDOR = 4;
    public static final int MODEL = 5;
    public static final int RELEASE = 6;
    public static final int LOCATION = 7;
    private static final String[] _findDeviceType = new String[]{"End Device", "Switch"};
    private static final String[][] _findType = new String[][]{{"Device Alias", "Port WWN", "Enclosure Name"}, {"Logical Name", "IP Address", "WWN", "VSAN WWN", "Vendor", "Model", "Release", "Location"}, {"Serial Number", "Capacity", "FCID"}};
    MapFactoryIf mapFactory = null;
    ArrayList nodes = new HashedArrayList();
    ArrayList links = new HashedArrayList();
    String domain = "";
    static final String[] _SELECT_MAP_BUTTONS = new String[]{"Show in Selected Map", "Close"};
    private HashMap<Fabric, Fabric> fabricsMap = new HashMap();
    private static Filter _filter = null;
    private ListCellRenderer _defaultListCellRenderer = null;
    private JLabel _status = null;
    private JButton _findButton = null;
    static SmFindDialog fd = null;
    private static MgmtDomainIf mgmtDomain = null;
    private static SmFindDialog _Instance = null;
    static JComboBox _findDeviceTypeBox = null;
    static JComboBox _findTypeBox = null;
    static int _findDeviceTypeIndex = 0;
    static String _findDeviceTypeString = null;
    static int _findTypeIndex = 0;
    static String _findTypeString = null;

    public static SmFindDialog getInstance() {
        if (_Instance != null) {
            return _Instance;
        }
        JPanel findOptions = new JPanel();
        int insets = Filter._IsMetal ? 3 : 5;
        findOptions.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        findOptions.setLayout(new BorderLayout(insets, insets));
        _findDeviceTypeBox = new JComboBox<Object>((Object[])_findDeviceType);
        _findDeviceTypeBox.setEditable(false);
        _findDeviceTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String oldDeviceTypeString = _findDeviceTypeString;
                _findDeviceTypeString = (String)_findDeviceTypeBox.getSelectedItem();
                if (!_findDeviceTypeString.equals(oldDeviceTypeString)) {
                    _findTypeBox.removeAllItems();
                    if (_findDeviceTypeString.equals("End Device")) {
                        _findDeviceTypeIndex = 0;
                    } else if (_findDeviceTypeString.equals("Switch")) {
                        _findDeviceTypeIndex = 1;
                    }
                    for (int i = 0; i < _findType[_findDeviceTypeIndex].length; ++i) {
                        _findTypeBox.addItem(_findType[_findDeviceTypeIndex][i]);
                    }
                    _findTypeIndex = 0;
                    SmFindDialog.updateFindList();
                }
            }
        });
        findOptions.add((Component)_findDeviceTypeBox, "West");
        _findTypeBox = new JComboBox<Object>((Object[])_findType[0]);
        _findTypeBox.setEditable(false);
        _findTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (_findTypeBox.getItemCount() == 0 || _findTypeIndex == _findTypeBox.getSelectedIndex()) {
                    return;
                }
                _findTypeIndex = _findTypeBox.getSelectedIndex();
                if (_findTypeIndex < 0) {
                    _findTypeIndex = 0;
                }
                SmFindDialog.updateFindList();
            }
        });
        findOptions.add((Component)_findTypeBox, "Center");
        _Instance = new SmFindDialog(null, findOptions);
        return _Instance;
    }

    public static EndPort[] getAllEndPorts() {
        Fabric[] fabrics = null;
        if (mgmtDomain != null) {
            if (mgmtDomain.isSan()) {
                fabrics = San.getInstance().getFabrics();
            } else if (mgmtDomain.isDataCenter()) {
                fabrics = DataCenter.getInstance().getFabrics();
            } else if (mgmtDomain.isLAN()) {
                fabrics = Lan.getInstance().getFabrics();
            } else if (mgmtDomain.isFabric()) {
                fabrics = new Fabric[]{(Fabric)mgmtDomain};
            } else {
                fabrics = null;
                EndPort[] eps = mgmtDomain.getEndPorts();
                if (eps == null) {
                    return new EndPort[0];
                }
                return eps;
            }
        }
        if (fabrics == null) {
            return null;
        }
        int size = 0;
        for (int i = 0; i < fabrics.length; ++i) {
            size += fabrics[i].getNumEndPorts();
        }
        EndPort[] eps = new EndPort[size];
        size = 0;
        for (int i = 0; i < fabrics.length; ++i) {
            EndPort[] tmp = fabrics[i].getEndPorts();
            if (tmp == null || tmp.length == 0) continue;
            for (int j = 0; j < tmp.length; ++j) {
                eps[j + size] = tmp[j];
            }
            size += tmp.length;
        }
        return eps;
    }

    public static AbstractSwitch[] getAllSwitches() {
        AbstractSwitch[] sws = new AbstractSwitch[]{};
        if (mgmtDomain == null) {
            return sws;
        }
        if (mgmtDomain.isSan()) {
            return San.getInstance().getSwitches();
        }
        if (mgmtDomain.isDataCenter()) {
            return DataCenter.getInstance().getAbstractSwitches();
        }
        if (mgmtDomain.isLAN()) {
            return Lan.getInstance().getAbstractSwitches();
        }
        sws = mgmtDomain.isFabric() ? mgmtDomain.getFabric().getSwitches() : mgmtDomain.getAbstractSwitches();
        return sws;
    }

    public static void findSwitchesByIpAddresses(ArrayList switchIpAddresses) {
        if (switchIpAddresses == null || switchIpAddresses.size() == 0) {
            return;
        }
        MapFactoryIf mapFactory = null;
        String ipAddress = null;
        HashedArrayList<MapNode> nodes = new HashedArrayList<MapNode>();
        HashedArrayList links = new HashedArrayList();
        AbstractSwitch sw = null;
        if (mgmtDomain == null) {
            mgmtDomain = ClientController.getInstance().getSelectedDomain();
        }
        mapFactory = mgmtDomain.isDataCenter() ? DataCenterMapFactory.getInstance() : (mgmtDomain.isLAN() ? LanMapFactory.getInstance() : MapFactory.getInstance());
        for (int i = 0; i < switchIpAddresses.size(); ++i) {
            MapNode n;
            ipAddress = (String)switchIpAddresses.get(i);
            try {
                sw = mgmtDomain.isDataCenter() ? DataCenter.getInstance().findSwitchByIpAddress(InetAddress.getByName(ipAddress)) : (mgmtDomain.isLAN() ? Lan.getInstance().findSwitchByIpAddress(InetAddress.getByName(ipAddress)) : ClientController.findFabricSwitchByIpAddress(InetAddress.getByName(ipAddress)));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (sw == null || (n = mapFactory.getNode(sw)) == null || ((ArrayList)nodes).contains(n)) continue;
            ((ArrayList)nodes).add(n);
        }
        if (nodes.size() == 0 && links.size() == 0) {
            return;
        }
        SelectionAction.getInstance().setObjects(nodes, links);
        SelectionAction.getInstance().execute();
    }

    private static void updateDeviceType(MgmtDomainIf oldMgmtDomain, MgmtDomainIf newMgmtDomain) {
        if (newMgmtDomain != null && newMgmtDomain.isLAN()) {
            _findDeviceTypeBox.removeItem("End Device");
            return;
        }
        if (oldMgmtDomain != null && newMgmtDomain != null && oldMgmtDomain.isLAN() && !newMgmtDomain.isLAN()) {
            _findDeviceTypeBox.removeItem("End Device");
            _findDeviceTypeBox.insertItemAt("End Device", 0);
        }
    }

    private static void updateFindList() {
        _Instance.setText("");
        Object[] devices = null;
        switch (_findDeviceTypeIndex) {
            case 1: {
                devices = SmFindDialog.getData(SmFindDialog.getAllSwitches(), _findType[_findDeviceTypeIndex][_findTypeIndex]);
                break;
            }
            case 0: {
                devices = SmFindDialog.getData(SmFindDialog.getAllEndPorts(), _findType[_findDeviceTypeIndex][_findTypeIndex]);
                break;
            }
            case 2: {
                devices = SmFindDialog.getLunData(SmFindDialog.getAllEndPorts(), _findType[_findDeviceTypeIndex][_findTypeIndex]);
            }
        }
        if (devices != null && devices.length > 0) {
            try {
                Arrays.sort(devices, new Comparator(){

                    public int compare(Object object, Object object1) {
                        if (object == object1) {
                            return 0;
                        }
                        if (object == null) {
                            return 1;
                        }
                        if (object1 == null) {
                            return -1;
                        }
                        try {
                            return object.toString().compareTo(object1.toString());
                        }
                        catch (Exception ex) {
                            return 0;
                        }
                    }

                    @Override
                    public boolean equals(Object object) {
                        return this == object;
                    }
                });
            }
            catch (Exception ex) {
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
            }
        }
        _Instance.setListData(devices);
        _Instance.updateListSelection();
        if (devices == null || devices.length == 0) {
            _Instance.setStatus("No data found");
        } else {
            _Instance.setStatus("" + devices.length + " total entries");
        }
        _Instance.pack();
    }

    public static Object[] getData(AbstractSwitch[] sws, String dataType) {
        HashedArrayList<Object> data;
        block16: {
            String s;
            int i;
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block15: {
                                    if (sws == null || sws.length == 0 || dataType == null || "".equals(dataType)) {
                                        return null;
                                    }
                                    if (_filter != null) {
                                        _filter.setHandlePWWN(false);
                                    }
                                    data = new HashedArrayList<Object>();
                                    if (dataType.equals("Logical Name")) {
                                        for (i = 0; i < sws.length; ++i) {
                                            s = sws[i].getSysName();
                                            if (s == null || s.length() == 0) {
                                                s = sws[i].getName();
                                            }
                                            if (((ArrayList)data).contains(s)) continue;
                                            ((ArrayList)data).add(s);
                                        }
                                    }
                                    if (!dataType.equals("WWN")) break block15;
                                    if (_filter != null) {
                                        _filter.setHandlePWWN(true);
                                    }
                                    for (i = 0; i < sws.length; ++i) {
                                        if (!(sws[i] instanceof Switch) || ((ArrayList)data).contains(((Switch)sws[i]).getWwn())) continue;
                                        ((ArrayList)data).add(((Switch)sws[i]).getWwn());
                                    }
                                    break block16;
                                }
                                if (!dataType.equals(STRING_VSAN_WWN)) break block17;
                                if (_filter != null) {
                                    _filter.setHandlePWWN(true);
                                }
                                for (i = 0; i < sws.length; ++i) {
                                    short[] vsans;
                                    if (!(sws[i] instanceof Switch) || (vsans = ((Switch)sws[i]).getVsanIds()) == null || vsans.length == 0) continue;
                                    for (int j = 0; j < vsans.length; ++j) {
                                        if (((ArrayList)data).contains(((Switch)sws[i]).getVsanWwn(vsans[j]))) continue;
                                        ((ArrayList)data).add(((Switch)sws[i]).getVsanWwn(vsans[j]));
                                    }
                                }
                                break block16;
                            }
                            if (!dataType.equals("IP Address")) break block18;
                            for (i = 0; i < sws.length; ++i) {
                                s = sws[i].getIpAddress();
                                if (s == null || "".equals(s) || ((ArrayList)data).contains(s)) continue;
                                ((ArrayList)data).add(s);
                            }
                            break block16;
                        }
                        if (!dataType.equals("Vendor")) break block19;
                        for (i = 0; i < sws.length; ++i) {
                            s = sws[i].getVendor();
                            if (s == null || "".equals(s) || ((ArrayList)data).contains(s)) continue;
                            ((ArrayList)data).add(s);
                        }
                        break block16;
                    }
                    if (!dataType.equals("Model")) break block20;
                    for (i = 0; i < sws.length; ++i) {
                        s = sws[i].getModel();
                        if (s == null || "".equals(s) || ((ArrayList)data).contains(s)) continue;
                        ((ArrayList)data).add(s);
                    }
                    break block16;
                }
                if (!dataType.equals("Release")) break block21;
                for (i = 0; i < sws.length; ++i) {
                    s = sws[i].getVersion();
                    if (s == null || "".equals(s) || ((ArrayList)data).contains(s)) continue;
                    ((ArrayList)data).add(s);
                }
                break block16;
            }
            if (!dataType.equals("Location")) break block16;
            for (i = 0; i < sws.length; ++i) {
                s = sws[i].getSysLocation();
                if (s == null || "".equals(s) || ((ArrayList)data).contains(s)) continue;
                ((ArrayList)data).add(s);
            }
        }
        return data.toArray();
    }

    public static Object[] getData(EndPort[] eps, String dataType) {
        HashedArrayList<Comparable> data;
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (eps == null || eps.length == 0) {
                            return null;
                        }
                        if (_filter != null) {
                            _filter.setHandlePWWN(false);
                        }
                        data = new HashedArrayList<Comparable>();
                        if (!dataType.equals("Enclosure Name")) break block8;
                        for (int i = 0; i < eps.length; ++i) {
                            if (eps[i] == null || eps[i].getEnclosure() == null || ((ArrayList)data).contains(eps[i].getEnclosure())) continue;
                            ((ArrayList)data).add(eps[i].getEnclosure());
                        }
                        break block9;
                    }
                    if (!dataType.equals("Port WWN")) break block10;
                    if (_filter != null) {
                        _filter.setHandlePWWN(true);
                    }
                    for (int i = 0; i < eps.length; ++i) {
                        Wwn s = eps[i].getPortWwn();
                        if (s == null || ((ArrayList)data).contains(s)) continue;
                        ((ArrayList)data).add(s);
                    }
                    break block9;
                }
                if (!dataType.equals("Node WWN")) break block11;
                if (_filter != null) {
                    _filter.setHandlePWWN(true);
                }
                for (int i = 0; i < eps.length; ++i) {
                    Wwn s = eps[i].getNodeWwn();
                    if (s == null || ((ArrayList)data).contains(s)) continue;
                    ((ArrayList)data).add(s);
                }
                break block9;
            }
            if (!dataType.equals("Device Alias")) break block9;
            for (int i = 0; i < eps.length; ++i) {
                DeviceAlias s = eps[i].getDeviceAlias();
                if (s == null || ((ArrayList)data).contains(s)) continue;
                ((ArrayList)data).add(s);
            }
        }
        return data.toArray();
    }

    public static Object[] getLunData(EndPort[] eps, String dataType) {
        if (eps == null || eps.length == 0) {
            return null;
        }
        HashedArrayList<String> data = new HashedArrayList<String>();
        for (int i = 0; i < eps.length; ++i) {
            int j;
            if (!eps[i].isTarget()) continue;
            if (dataType.equals("FCID")) {
                if (((ArrayList)data).contains(eps[i].getFcIdAsString())) continue;
                ((ArrayList)data).add(eps[i].getFcIdAsString());
                continue;
            }
            Lun[] luns = eps[i].getFabric().getLuns();
            if (luns == null || luns.length == 0) continue;
            if (dataType.equals("Serial Number")) {
                for (j = 0; j < luns.length; ++j) {
                    if (((ArrayList)data).contains(luns[j].getSerialNum())) continue;
                    ((ArrayList)data).add(luns[j].getSerialNum());
                }
                continue;
            }
            if (!dataType.equals("Capacity")) continue;
            for (j = 0; j < luns.length; ++j) {
                if (((ArrayList)data).contains("" + luns[j].getCapacity())) continue;
                ((ArrayList)data).add("" + luns[j].getCapacity());
            }
        }
        return data.toArray();
    }

    public SmFindDialog(Object[] list, JComponent options) {
        super((Frame)BrowserFrame.getInstance(), "DCNM-SAN - Find");
        this.setModal(false);
        _filter = list == null ? new Filter("Filter", true) : new Filter(list, "Filter", true);
        this._defaultListCellRenderer = _filter.getCellRenderer();
        _filter.setCellRenderer(new PWWNListCellRenderer());
        _filter.setMatchCase(false);
        _filter.addListSelelectionListener(this);
        _filter.addMouseListener(this);
        JPanel panel = new JPanel();
        int insets = Filter._IsMetal ? 3 : 5;
        panel.setLayout(new BorderLayout(insets, insets));
        if (options != null) {
            panel.add((Component)options, "North");
        }
        panel.add((Component)_filter, "Center");
        this._status = new JLabel(" ");
        this._status.setBorder(new EmptyBorder(0, 8, 8, 0));
        AbstractButton[] b = DialogUtil.buildButtons(_BUTTONS, (ActionListener)this);
        this._findButton = DialogUtil.getButton(_BUTTONS[0], (JButton[])b);
        this._findButton.setEnabled(false);
        DialogUtil.buildDialog((JDialog)this, (Container)BrowserFrame.getInstance(), (Container)panel, b);
        JPanel dmain = (JPanel)this.getContentPane().getComponent(0);
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)dmain, "Center");
        main.add((Component)this._status, "South");
        this.getContentPane().add(main);
        this.setResizable(true);
        this.pack();
    }

    public SmFindDialog(Object[] list, String[] findBy, ActionListener findByAL) {
        super((Frame)BrowserFrame.getInstance(), "DCNM-SAN - Find");
        this.setModal(false);
        _filter = list == null ? new Filter() : new Filter(list);
        this._defaultListCellRenderer = _filter.getCellRenderer();
        _filter.setCellRenderer(new PWWNListCellRenderer());
        _filter.setMatchCase(false);
        _filter.addListSelelectionListener(this);
        int insets = Filter._IsMetal ? 3 : 5;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(insets, insets));
        if (findBy != null) {
            JComboBox<Object> comboBox = new JComboBox<Object>((Object[])findBy);
            comboBox.setEditable(false);
            if (findByAL != null) {
                comboBox.addActionListener(findByAL);
            }
            panel.add(comboBox, "North");
        }
        panel.add((Component)_filter, "Center");
        AbstractButton[] b = DialogUtil.buildButtons(_BUTTONS, (ActionListener)this);
        this._findButton = DialogUtil.getButton(_BUTTONS[0], (JButton[])b);
        this._findButton.setEnabled(false);
        DialogUtil.buildDialog((JDialog)this, (Container)BrowserFrame.getInstance(), (Container)panel, b);
        this.setResizable(true);
        this.pack();
    }

    public void setListData(Object[] list) {
        _filter.setListData(list);
    }

    public void updateListSelection() {
        _filter.updateListSelection(true, false);
    }

    public void setText(String text) {
        _filter.setText(text);
    }

    public String getText() {
        return _filter.getText();
    }

    public void setStatus(String s) {
        this._status.setText(s);
    }

    @Override
    public void setVisible(boolean isVisible) {
        MgmtDomainIf oldMgmtDomain = mgmtDomain;
        mgmtDomain = ClientController.getInstance().getSelectedDomain();
        if (isVisible) {
            SmFindDialog.updateDeviceType(oldMgmtDomain, mgmtDomain);
            SmFindDialog.updateFindList();
            if (mgmtDomain != null) {
                if (mgmtDomain.isDataCenter()) {
                    this.domain = "DataCenter";
                    this.mapFactory = DataCenterMapFactory.getInstance();
                } else if (mgmtDomain.isLAN()) {
                    this.domain = "LAN";
                    this.mapFactory = LanMapFactory.getInstance();
                } else if (mgmtDomain.isFabric()) {
                    this.domain = mgmtDomain.getFabric().toString();
                    this.mapFactory = MapFactory.getInstance();
                } else if (mgmtDomain.isSan()) {
                    this.domain = "SAN";
                    this.mapFactory = MapFactory.getInstance();
                } else {
                    this.domain = mgmtDomain.getName();
                    this.mapFactory = MapFactory.getInstance();
                }
            }
            this.setTitle("Find - " + this.domain);
        }
        super.setVisible(isVisible);
    }

    private void addSelection(Object selection, ArrayList<String> selectionArrayList) {
        if (selection instanceof EndPort) {
            selectionArrayList.add(((EndPort)selection).getPortWwn().toString());
        } else if (selection instanceof Enclosure) {
            Enclosure enclosure = (Enclosure)selection;
            ArrayList<EndPort> members = enclosure.getMembers();
            EndPort endport = null;
            for (int i = 0; i < members.size(); ++i) {
                endport = members.get(i);
                selectionArrayList.add(endport.getPortWwn().toString());
            }
        }
    }

    private void setClientContext(Object selection, EndPort[] endPorts) {
        if (selection == null) {
            return;
        }
        ClientContext clientContext = null;
        if (selection instanceof DeviceAlias) {
            if (endPorts == null || endPorts.length == 0) {
                return;
            }
            for (int j = 0; j < endPorts.length; ++j) {
                DeviceAlias endPortDeviceAlias = endPorts[j].getDeviceAlias();
                if (endPortDeviceAlias == null || !endPortDeviceAlias.equals((DeviceAlias)selection)) continue;
                try {
                    clientContext = new ClientContext();
                    clientContext.setFabricName(endPorts[j].getFabricPK().getName());
                    break;
                }
                catch (Exception e) {
                    return;
                }
            }
        } else if (selection instanceof Enclosure) {
            Enclosure enclosure = San.getInstance().findEnclosureByName(((Enclosure)selection).getName());
            if (enclosure == null) {
                return;
            }
            ArrayList fabricPKs = enclosure.getFabricPKs();
            if (fabricPKs == null) {
                return;
            }
            for (int i = 0; i < fabricPKs.size(); ++i) {
                Fabric fabric;
                FabricPK fabricPK = (FabricPK)fabricPKs.get(i);
                if (fabricPK == null || (fabric = San.getInstance().getFabric(fabricPK)) == null) continue;
                clientContext = new ClientContext();
                clientContext.setFabricName(fabric.getFabricName());
                break;
            }
        } else if (selection instanceof Wwn) {
            EndPort endPort = ClientController.findFabricEndPortByWwn((Wwn)selection);
            if (endPort == null) {
                return;
            }
            try {
                clientContext = new ClientContext();
                clientContext.setFabricName(endPort.getFabricPK().getName());
            }
            catch (Exception e) {
                return;
            }
        }
        if (clientContext != null) {
            clientContext.setPhysicalAttributeSelection("End Devices");
            clientContext.setTableColumnIndex(4);
            BrowserFrame.getInstance().setContextNow(clientContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        ClientContext context;
        char ch;
        HashedArrayList<String> selectionArrayList = new HashedArrayList<String>();
        Object selectedEndPort = null;
        if (e.getSource() instanceof JButton && (ch = ((JButton)e.getSource()).getText().charAt(0)) == 'C') {
            this.setVisible(false);
            return;
        }
        Object[] vals = _filter.getSelectedValues();
        this.nodes = new HashedArrayList();
        this.links = new HashedArrayList();
        EndPort[] eps = SmFindDialog.getAllEndPorts();
        if (mgmtDomain.isDataCenter()) {
            this.setClientContext(vals[0], eps);
        }
        if (_findDeviceTypeIndex == 2) {
            if (eps == null || eps.length == 0) {
                return;
            }
        } else {
            AbstractSwitch sw = null;
            AbstractSwitch[] sws = SmFindDialog.getAllSwitches();
            block9: for (int i = 0; i < vals.length; ++i) {
                MapNode n;
                if (vals[i] instanceof DeviceAlias) {
                    if (eps == null || eps.length == 0) continue;
                    for (int j = 0; j < eps.length; ++j) {
                        DeviceAlias devAlias = eps[j].getDeviceAlias();
                        if (devAlias == null || !devAlias.equals((DeviceAlias)vals[i])) continue;
                        n = this.mapFactory.getNode(eps[j]);
                        if (n != null && !this.nodes.contains(n)) {
                            this.nodes.add(n);
                            this.addSelection(eps[j], selectionArrayList);
                            continue block9;
                        }
                        this.addSelection(eps[j], selectionArrayList);
                        continue block9;
                    }
                    continue;
                }
                if (vals[i] instanceof Enclosure) {
                    MapNode[] n2 = this.mapFactory.getNodes((Enclosure)vals[i]);
                    if (n2 != null && n2.length > 0) {
                        for (int j = 0; j < n2.length; ++j) {
                            if (this.nodes.contains(n2[j])) continue;
                            this.nodes.add(n2[j]);
                            this.addSelection(n2[j].getModel(), selectionArrayList);
                        }
                        continue;
                    }
                    this.addSelection((Enclosure)vals[i], selectionArrayList);
                    continue;
                }
                if (vals[i] instanceof AbstractModelObject) {
                    MapNode n3 = this.mapFactory.getNode((AbstractModelObject)vals[i]);
                    if (n3 == null || this.nodes.contains(n3)) continue;
                    this.nodes.add(n3);
                    this.addSelection(n3.getModel(), selectionArrayList);
                    continue;
                }
                if (vals[i] instanceof Wwn) {
                    if (_findDeviceTypeIndex == 1) {
                        MapNode n4;
                        sw = ClientController.findFabricSwitchByWwn((Wwn)vals[i], _findTypeIndex == 3);
                        if (sw == null || (n4 = this.mapFactory.getNode(sw)) == null || this.nodes.contains(n4)) continue;
                        this.nodes.add(n4);
                        ((ArrayList)selectionArrayList).add(sw.getName());
                        continue;
                    }
                    if (_findTypeIndex == 2) {
                        if (eps == null || eps.length == 0) continue;
                        for (int j = 0; j < eps.length; ++j) {
                            Wwn w = eps[j].getNodeWwn();
                            if (w == null || !w.equals((Wwn)vals[i])) continue;
                            n = this.mapFactory.getNode(eps[j]);
                            if (n == null || this.nodes.contains(n)) continue block9;
                            this.nodes.add(n);
                            this.addSelection(eps[j], selectionArrayList);
                            continue block9;
                        }
                        continue;
                    }
                    EndPort ep = ClientController.findFabricEndPortByWwn((Wwn)vals[i]);
                    if (ep == null) continue;
                    MapNode n5 = this.mapFactory.getNode(ep);
                    if (n5 != null) {
                        this.nodes.add(n5);
                        this.addSelection(ep, selectionArrayList);
                        continue;
                    }
                    this.addSelection(ep, selectionArrayList);
                    continue;
                }
                if (_findDeviceTypeIndex == 1) {
                    if (_findTypeIndex == 1) {
                        try {
                            MapNode n6;
                            sw = mgmtDomain.isDataCenter() ? DataCenter.getInstance().findSwitchByIpAddress(InetAddress.getByName((String)vals[i])) : (mgmtDomain.isLAN() ? Lan.getInstance().findSwitchByIpAddress(InetAddress.getByName((String)vals[i])) : ClientController.findFabricSwitchByIpAddress(InetAddress.getByName((String)vals[i])));
                            if (sw == null || (n6 = this.mapFactory.getNode(sw)) == null || this.nodes.contains(n6)) continue;
                            this.nodes.add(n6);
                            ((ArrayList)selectionArrayList).add(sw.getName());
                        }
                        catch (Exception ex) {
                            _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
                        }
                        continue;
                    }
                    if (sws == null || sws.length == 0) continue;
                    for (int j = 0; j < sws.length; ++j) {
                        switch (_findTypeIndex) {
                            case 0: {
                                String s = sws[j].getSysName();
                                if (s == null || s.length() == 0) {
                                    s = sws[j].getName();
                                }
                                if (s == null || !s.equals((String)vals[i])) break;
                                sw = sws[j];
                                break;
                            }
                            case 4: {
                                String s = sws[j].getVendor();
                                if (s == null || !s.equals((String)vals[i])) break;
                                sw = sws[j];
                                break;
                            }
                            case 5: {
                                String s = sws[j].getModel();
                                if (s == null || !s.equals((String)vals[i])) break;
                                sw = sws[j];
                                break;
                            }
                            case 6: {
                                String s = sws[j].getVersion();
                                if (s == null || !s.equals((String)vals[i])) break;
                                sw = sws[j];
                                break;
                            }
                            case 7: {
                                String s = sws[j].getSysLocation();
                                if (s == null || !s.equals((String)vals[i])) break;
                                sw = sws[j];
                            }
                        }
                        if (sw == null) continue;
                        n = this.mapFactory.getNode(sw);
                        if (n != null && !this.nodes.contains(n)) {
                            this.nodes.add(n);
                            ((ArrayList)selectionArrayList).add(sw.getName());
                        }
                        sw = null;
                    }
                    continue;
                }
                _Logger.error((Object)("can't find : " + vals[i]));
            }
        }
        if (!mgmtDomain.isDataCenter() && this.nodes.size() == 0 && this.links.size() == 0) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Selection not found in map.");
            return;
        }
        this.recordFabricsFromSelection(this.nodes, this.links);
        this.nodes.clear();
        SelectionAction.getInstance().setObjects(this.nodes, this.links);
        if (_findDeviceTypeIndex == 1) {
            context = new ClientContext();
            context.setFabricName(this.domain);
            context.setPhysicalAttributeSelection("Switches");
            context.setTableColumnIndex(0);
            context.setTableSelectionArrayList(selectionArrayList);
            BrowserFrame.getInstance().setContext(context);
        } else if (_findDeviceTypeIndex == 0) {
            context = new ClientContext();
            if (!mgmtDomain.isDataCenter()) {
                context.setFabricName(this.domain);
            }
            context.setPhysicalAttributeSelection("End Devices");
            context.setTableColumnIndex(4);
            context.setTableSelectionArrayList(selectionArrayList);
            BrowserFrame.getInstance().setContext(context);
        }
    }

    public static void getSelectedPorts(ArrayList selectedPorts) throws SnmpException {
        ArrayList coll = SmMap.getSelectedMap().getSelectedLinks();
        for (Object link : coll) {
            Object obNode;
            if (!(link instanceof EdgeMapLink) || !((obNode = ((EdgeMapLink)link).getModel()) instanceof EndPort)) continue;
            selectedPorts.add(obNode);
        }
    }

    private void recordFabricsFromSelection(ArrayList nodes, ArrayList links) {
        AbstractModelObject model;
        int i;
        this.fabricsMap.clear();
        if (nodes != null) {
            for (i = 0; i < nodes.size(); ++i) {
                MapNode mapNode = (MapNode)nodes.get(i);
                if (mapNode == null || (model = (AbstractModelObject)mapNode.getModel()) == null || model.getFabric() == null) continue;
                this.fabricsMap.put(model.getFabric(), model.getFabric());
            }
        }
        if (links != null) {
            for (i = 0; i < links.size(); ++i) {
                TopologyLink topologyLink = (TopologyLink)links.get(i);
                if (topologyLink == null || (model = (AbstractModelObject)topologyLink.getModel()) == null || model.getFabric() == null) continue;
                this.fabricsMap.put(model.getFabric(), model.getFabric());
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    public static Frame getParentFrame(Container parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof Frame) {
            return (Frame)parent;
        }
        return SmFindDialog.getParentFrame(parent.getParent());
    }

    public static void main(String[] args) {
        String[] cs = new String[]{"Lower", "Upper"};
        Object[] lower = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};
        String[] upper = new String[]{"ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE", "TEN"};
        ActionListener al = new ActionListener((String[])lower, upper){
            final /* synthetic */ String[] val$lower;
            final /* synthetic */ String[] val$upper;
            {
                this.val$lower = stringArray;
                this.val$upper = stringArray2;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox jc = (JComboBox)e.getSource();
                if (((String)jc.getSelectedItem()).equals("Lower")) {
                    fd.setListData(this.val$lower);
                } else {
                    fd.setListData(this.val$upper);
                }
            }
        };
        fd = new SmFindDialog(lower, cs, al);
        fd.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object source = e.getSource();
        if (source != null && source instanceof JList) {
            JList list = (JList)source;
            if (list.isSelectionEmpty()) {
                this._findButton.setEnabled(false);
            } else {
                this._findButton.setEnabled(true);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this._findButton != null) {
            this._findButton.doClick();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    class PWWNListCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        PWWNListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return renderer;
            }
            if (value instanceof Wwn) {
                renderer.setText(SnmpString.toHexString(((Wwn)value).getValue()));
            }
            return renderer;
        }
    }

    class SelectMapDialog
    extends JDialog
    implements ActionListener,
    ListSelectionListener {
        DefaultListModel listModel;
        JList mapList;
        JButton showButton;
        Runnable selectionRunnable;

        SelectMapDialog(Dialog owner, String title, HashMap fabricsMap, Runnable selectionRunnable) {
            super(owner, title, true);
            this.listModel = null;
            this.listModel = new DefaultListModel();
            this.mapList = new JList(this.listModel);
            this.showButton = null;
            JPanel panel = new JPanel();
            int insets = Filter._IsMetal ? 3 : 5;
            panel.setLayout(new BorderLayout(insets, insets));
            this.selectionRunnable = selectionRunnable;
            AbstractButton[] b = DialogUtil.buildButtons(_SELECT_MAP_BUTTONS, (ActionListener)this);
            this.showButton = DialogUtil.getButton(_BUTTONS[0], (JButton[])b);
            DialogUtil.buildDialog((JDialog)this, (Container)BrowserFrame.getInstance(), (Container)panel, b);
            JPanel dmain = (JPanel)this.getContentPane().getComponent(0);
            this.setFabrics(fabricsMap);
            this.mapList.setSelectionMode(0);
            this.mapList.addListSelectionListener(this);
            dmain.add((Component)this.mapList, "Center");
            JPanel main = new JPanel(new BorderLayout());
            main.add((Component)dmain, "Center");
            main.add((Component)SmFindDialog.this._status, "South");
            this.getContentPane().add(main);
            this.setResizable(true);
            this.pack();
        }

        public void setFabrics(HashMap fabricsMap) {
            this.listModel.clear();
            if (fabricsMap == null) {
                return;
            }
            for (Fabric fabric : fabricsMap.keySet()) {
                this.listModel.addElement(fabric);
            }
            this.mapList.setSelectedIndex(0);
        }

        public Fabric getSelectedFabric() {
            return (Fabric)this.mapList.getSelectedValue();
        }

        @Override
        public void setVisible(boolean visible) {
            this.setLocationRelativeTo(this.getParent());
            super.setVisible(visible);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            char ch;
            if (e.getSource() instanceof JButton && (ch = ((JButton)e.getSource()).getText().charAt(0)) == 'C') {
                this.setVisible(false);
                return;
            }
            BrowserFrame.getInstance().showFabricTab(this.getSelectedFabric());
            SelectionAction.getInstance().setObjects(SmFindDialog.this.nodes, SmFindDialog.this.links);
            SelectionAction.getInstance().execute();
            this.selectionRunnable.run();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object source = e.getSource();
            if (source != null && source instanceof JList) {
                JList list = (JList)source;
                if (this.showButton != null) {
                    if (list.isSelectionEmpty()) {
                        this.showButton.setEnabled(false);
                    } else {
                        this.showButton.setEnabled(true);
                    }
                }
            }
        }
    }
}

