/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.Constants;
import com.cisco.dcbu.lib.jnm.CheckUpgrade;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.VshDumpAdv;
import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.SmlCommandsHandler;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.JFork;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.Device;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class DMMapAction
extends MapActionAdapter {
    public static Logger _Logger = Logger.getLogger(DMMapAction.class);
    static String[] minimumDmJars = new String[]{"bitmaps.jar", "dm.jar", "dmdb.jar", "jchart.jar", "jnm.jar", "log4j.jar", "snmp.jar"};
    private static Process _DMProcess;
    private static DatagramSocket _DMSocket;
    public static boolean _newWinDM;
    public static int DM_SOCKET;
    private static HashMap urlHashMap;
    private static DMMapAction _Instance;

    public static DMMapAction getInstance() {
        if (_Instance == null) {
            _Instance = new DMMapAction();
        }
        return _Instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("deviceManager")) {
            this.deviceManager();
        } else if (cmd.equals("reauthenticate")) {
            this.reauthenticate();
        } else if (cmd.equals("viewRunningConfig")) {
            String[] cmds = new String[]{"Show running\n"};
            this.viewConfiguration(cmds, "View Running Config");
        } else if (cmd.equals("viewStartupConfig")) {
            String[] cmds = new String[]{"Show startup\n"};
            this.viewConfiguration(cmds, "View Startup Config");
        } else if (cmd.equals("viewConfigDiffs")) {
            String[] cmds = new String[]{"Show running diff\n"};
            this.viewConfiguration(cmds, "View Running and Startup Config Differences");
        } else if (cmd.equals("reset")) {
            this.reset();
        } else if (cmd.equals("linkElementManager")) {
            this.linkElementManager();
        } else if (cmd.equals("ucsManager")) {
            this.ucsManager();
        }
    }

    public void linkElementManager() {
        ArrayList links = SmMap.getSelectedMap().getSelectedLinks();
        TopologyLink topologyLink = (TopologyLink)links.get(0);
        try {
            Object returnObject;
            String urlString = (String)urlHashMap.get(topologyLink.toString());
            if (urlString == null) {
                urlString = "";
            }
            if ((returnObject = JOptionPane.showInputDialog(BrowserFrame.getInstance(), "Element Manager URL/Path", "Element Manager", 3, null, null, urlString)) != null && returnObject instanceof String) {
                urlString = (String)returnObject;
                if (urlString != null && urlString.length() > 0) {
                    urlHashMap.put(topologyLink.toString(), urlString);
                    ExternalTools.openURL(urlString);
                } else {
                    Util.errorMessage((Component)BrowserFrame.getInstance(), "URL/Path cannot be empty.");
                }
            }
        }
        catch (Exception e) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), e);
        }
    }

    public void reauthenticate() {
        ArrayList nodes = SmMap.getSelectedMap().getSelectedNodes();
        boolean success = false;
        StringBuffer msg = null;
        for (int i = 0; i < nodes.size(); ++i) {
            Switch dev;
            TopologyNode n = (TopologyNode)nodes.get(i);
            if (n.getModel() == null || !(n.getModel() instanceof Switch) || (dev = (Switch)n.getModel()) == null || dev.getIpAddress() == null) continue;
            success = true;
            String s = dev.authenticate(true);
            if (s == null) continue;
            if (msg == null) {
                msg = new StringBuffer();
            }
            msg.append(dev.getIpAddress()).append(": ").append(s).append("\n");
        }
        if (!success) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Please select a switch with an IP address in the current map");
        } else if (msg != null) {
            msg.setLength(msg.length() - 1);
            Util.errorMessage((Component)BrowserFrame.getInstance(), msg.toString());
        }
    }

    public void viewConfiguration(String[] cmds, String label) {
        ArrayList nodes = SmMap.getSelectedMap().getSelectedNodes();
        if (nodes.size() > 1) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Please select one switch for this operation");
            return;
        }
        TopologyNode n = (TopologyNode)nodes.get(0);
        if (n.getModel() == null) {
            return;
        }
        if (!(n.getModel() instanceof Device)) {
            return;
        }
        try {
            Device dev = (Device)n.getModel();
            if (dev == null) {
                return;
            }
            if (dev instanceof Switch && (((Switch)dev).isMDS() || ((Switch)dev).isQuail())) {
                SnmpPeer peer = ((Switch)dev).getSnmpPeer();
                VshDumpAdv showConfig = new VshDumpAdv(BrowserFrame.getInstance(), peer.toString() + " " + label, cmds, peer);
                showConfig.setModal(true);
                showConfig.showDialog(peer, label);
            }
        }
        catch (IOException ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
            ex.printStackTrace();
        }
    }

    public void ucsManager() {
        ArrayList nodes = SmMap.getSelectedMap().getSelectedNodes();
        boolean success = false;
        boolean handledfail = false;
        boolean typefail = false;
        for (int i = 0; i < nodes.size(); ++i) {
            Device dev;
            TopologyNode n = (TopologyNode)nodes.get(i);
            if (n.getModel() == null || !(n.getModel() instanceof Device) || (dev = (Device)n.getModel()) == null) continue;
            String hostName = dev.getIpAddress();
            try {
                if (!(dev instanceof Switch) || !((Switch)dev).isUCS() || hostName == null || hostName.length() <= 0) continue;
                Switch sw = (Switch)dev;
                _Logger.info((Object)"fork UCS DM - install UCS DM from switch");
                String jnlpCmd = System.getProperty("java.home") + File.separator + "bin" + File.separator + "javaws http://" + hostName + "/ucsm/ucsm.jnlp";
                _Logger.info((Object)("forkDM jnlpCmd=" + jnlpCmd));
                Runtime.getRuntime().exec(jnlpCmd);
                success = true;
                continue;
            }
            catch (Exception ex) {
                handledfail = true;
                Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                _Logger.error((Object)("Exception while trying to talk to " + hostName + " message: " + ex.getMessage()), (Throwable)ex);
            }
        }
        if (!success && !handledfail) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Please select a UCS switch with an IP address.");
        }
    }

    public void deviceManager() {
        ArrayList nodes = SmMap.getSelectedMap().getSelectedNodes();
        boolean success = false;
        boolean handledfail = false;
        boolean typefail = false;
        boolean enclosureFailed = false;
        boolean switchFailed = false;
        if (nodes == null || nodes.size() == 0) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Please select a switch with an IP address.");
            return;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            TopologyNode n = (TopologyNode)nodes.get(i);
            if (n.getModel() == null) continue;
            if (n.getModel() instanceof Device) {
                Device dev = (Device)n.getModel();
                if (dev == null) continue;
                String hostName = dev.getIpAddress();
                try {
                    block26: {
                        String dmPath;
                        if (dev instanceof Switch && (((Switch)dev).isMDS() || ((Switch)dev).isQuail() || ((Switch)dev).isN7K() && ((Switch)dev).isVdc() && ((Switch)dev).isFcoeEnabled()) && JFork.jvmExists()) {
                            if (hostName == null || hostName.length() <= 0) continue;
                            Switch sw = (Switch)dev;
                            DMMapAction.forkDM(sw);
                            success = true;
                            continue;
                        }
                        if (n.getModel() instanceof EthSwitch && ((EthSwitch)n.getModel()).isN5K()) {
                            EthSwitch ethSwitch = (EthSwitch)n.getModel();
                            if (ethSwitch == null) continue;
                            hostName = ethSwitch.getIpAddress();
                            try {
                                if (ethSwitch.isN5K() && JFork.jvmExists()) {
                                    if (hostName == null || hostName.length() <= 0) continue;
                                    EthSwitch sw = ethSwitch;
                                    DMMapAction.forkDM(sw);
                                    success = true;
                                    continue;
                                }
                                break block26;
                            }
                            catch (Exception ex) {
                                handledfail = true;
                                Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                                _Logger.error((Object)("Exception while trying to talk to " + hostName + " message: " + ex.getMessage()), (Throwable)ex);
                                break block26;
                            }
                        }
                        if (n.getModel() instanceof AbstractSwitch && ((AbstractSwitch)n.getModel()).isN7K()) {
                            Util.errorMessage((Component)BrowserFrame.getInstance(), new Exception("Device Manager not supported for switch: " + n));
                            continue;
                        }
                        if (dev instanceof Enclosure && (dmPath = ((Enclosure)dev).getDMPath()) != null && dmPath.length() > 0) {
                            if (dmPath.startsWith("http")) {
                                if (dmPath.length() == 7) {
                                    String ipAddr = dev.getIpAddress();
                                    if (ipAddr == null || ipAddr.length() == 0) {
                                        ipAddr = ((Enclosure)dev).getName();
                                    }
                                    dmPath = dmPath + ipAddr;
                                }
                                ExternalTools.openURL(dmPath);
                            } else {
                                ExternalTools.invokeApp(dmPath, dev.getIpAddress());
                            }
                            success = true;
                            continue;
                        }
                    }
                    if (hostName != null && hostName.length() > 0) {
                        ExternalTools.openURL("http://" + hostName);
                        success = true;
                        continue;
                    }
                    if (dev instanceof Enclosure) {
                        enclosureFailed = true;
                        continue;
                    }
                    if (!(dev instanceof AbstractSwitch)) continue;
                    switchFailed = true;
                }
                catch (Exception ex) {
                    handledfail = true;
                    Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                    _Logger.error((Object)("Exception while trying to talk to " + hostName + " message: " + ex.getMessage()), (Throwable)ex);
                }
                continue;
            }
            typefail = true;
        }
        if (!success && typefail) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Device Manager does not support this switch");
        } else if (!success && !handledfail) {
            if (enclosureFailed && switchFailed) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Please select a switch or enclosure with an IP address.");
            } else if (enclosureFailed) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Please select an enclosure with an IP address.\n IP addresses can be assigned in the Enclosures tables.");
            } else if (switchFailed) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Please select a switch with an IP address.");
            }
        }
    }

    private static void forkDM(AbstractSwitch sw) throws Exception {
        EthSwitch ethSwitch;
        boolean isManageable = sw.isPresent() && sw.isManageable();
        boolean isQuail = sw.isQuail();
        String hostName = sw.getIpAddress();
        int version = 0;
        int authProtocol = 0;
        String userName = null;
        String authPassword = null;
        int privProtocol = 0;
        String privPassword = null;
        String readCommunity = null;
        String writeCommunity = null;
        SnmpUserOpt snmpUserOpt = null;
        SnmpPeer peer = sw.getPeer();
        if (peer == null) {
            SnmpPeer.findPeer(sw.getInetAddress());
        }
        if (peer != null) {
            version = peer.getVersion();
            authProtocol = peer.getAuthProtocol();
            userName = peer.getUserName();
            authPassword = peer.getAuthPassword();
            privProtocol = peer.getPrivProtocol();
            privPassword = peer.getPrivPassword();
            readCommunity = peer.getReadCommunity();
            writeCommunity = peer.getWriteCommunity();
        } else if (sw instanceof EthSwitch && (snmpUserOpt = (ethSwitch = (EthSwitch)sw).getSnmpUserOpt()) != null) {
            version = snmpUserOpt.isV3() ? 3 : 2;
            authProtocol = snmpUserOpt.getAuthProtocol();
            userName = snmpUserOpt.getUsername();
            authPassword = snmpUserOpt.getPassword();
            privProtocol = snmpUserOpt.getPrivProtocol();
            privPassword = snmpUserOpt.getPrivPassword();
            readCommunity = snmpUserOpt.getCommunity();
        }
        if (!_newWinDM && _DMProcess != null) {
            try {
                _DMProcess.exitValue();
                _DMProcess = null;
            }
            catch (IllegalThreadStateException ex) {
                try {
                    InetAddress inetAddress;
                    if (_DMSocket == null) {
                        _DMSocket = new DatagramSocket();
                    }
                    StringBuffer buff = new StringBuffer();
                    StringBuffer infoPrintBuff = new StringBuffer();
                    buff.append("open ");
                    if (!isManageable) {
                        buff.append(hostName);
                        infoPrintBuff.append(hostName);
                    } else if (version == 3) {
                        buff.append("v3 ");
                        buff.append(Integer.toString(authProtocol));
                        buff.append(" ");
                        buff.append(hostName);
                        buff.append(" ");
                        buff.append(userName);
                        buff.append(" ");
                        infoPrintBuff.append(buff.toString());
                        infoPrintBuff.append(" *printing passwords skipped* ");
                        buff.append(authPassword);
                        buff.append(" ");
                        buff.append(privProtocol);
                        buff.append(" ");
                        buff.append(privPassword != null ? privPassword : "");
                    } else {
                        buff.append("v2 ");
                        buff.append(hostName);
                        buff.append(" ");
                        infoPrintBuff.append(buff.toString());
                        infoPrintBuff.append(" *printing community strings skipped* ");
                        buff.append(readCommunity);
                        if (writeCommunity != null && writeCommunity.length() > 0) {
                            buff.append(" ");
                            buff.append(writeCommunity);
                        }
                    }
                    if (ClientController._ProxyAddress != null) {
                        buff.append(" proxy ").append(ClientController._ProxyAddress.getAddress().getHostAddress()).append(':').append(Integer.toString(ClientController._ProxyAddress.getPort())).append(' ');
                        infoPrintBuff.append(" proxy ").append(ClientController._ProxyAddress.getAddress().getHostAddress()).append(':').append(Integer.toString(ClientController._ProxyAddress.getPort())).append(' ');
                    }
                    if ((inetAddress = InetAddress.getByName(null)) != null) {
                        if (inetAddress.isLoopbackAddress()) {
                            _Logger.info((Object)("forkDM - inetAddress=" + inetAddress + " isLoopbackAddress()=true"));
                        } else {
                            _Logger.info((Object)("forkDM - inetAddress=" + inetAddress));
                        }
                    }
                    _Logger.info((Object)("forkDM - DeviceManagerPort=" + DM_SOCKET));
                    _Logger.info((Object)("forkDM - DMSocket dmArgs=" + infoPrintBuff));
                    byte[] data = buff.toString().getBytes();
                    DatagramPacket pkt = new DatagramPacket(data, data.length, inetAddress, DM_SOCKET);
                    _DMSocket.send(pkt);
                }
                catch (Exception e) {
                    Util.errorMessage((Component)BrowserFrame.getInstance(), e);
                }
                return;
            }
        }
        int dmLen = 6;
        if (!isManageable) {
            dmLen = isQuail ? 2 : 1;
        } else if (version == 3) {
            dmLen += 2;
            if (privPassword != null) {
                dmLen += 4;
            }
        } else if (writeCommunity == null || writeCommunity.length() == 0) {
            dmLen -= 2;
        }
        if (!_newWinDM) {
            dmLen += 2;
        }
        if (ClientController._ProxyAddress != null) {
            dmLen += 2;
        }
        ArrayList<Integer> dmArgIndexNotToPrint = new ArrayList<Integer>();
        String[] dmArgs = new String[dmLen];
        dmArgs[0] = hostName;
        int index = 1;
        if (!_newWinDM) {
            dmArgs[index] = "-socket";
            dmArgs[index + 1] = Integer.toString(DM_SOCKET);
            index += 2;
        }
        if ((peer != null || snmpUserOpt != null) && version == 3 && isManageable) {
            dmArgs[index] = "-v3";
            dmArgs[index + 1] = "-user";
            dmArgs[index + 2] = userName;
            dmArgs[index + 3] = "-auth";
            dmArgs[index + 4] = authPassword;
            dmArgIndexNotToPrint.add(index + 4);
            index += 5;
            if (privPassword != null) {
                dmArgs[index] = "-priv";
                dmArgs[index + 1] = privPassword;
                dmArgIndexNotToPrint.add(index + 1);
                index += 2;
            }
            dmArgs[index] = "-digest";
            dmArgs[index + 1] = authProtocol == 0 ? "md5" : "sha";
            index += 2;
            if (privPassword != null) {
                dmArgs[index] = "-r";
                dmArgs[index + 1] = privProtocol == 0 ? "DES" : "AES";
                index += 2;
            }
        } else if (isManageable) {
            dmArgs[index] = "-v2c";
            dmArgs[index + 1] = "-user";
            dmArgs[index + 2] = readCommunity;
            dmArgIndexNotToPrint.add(index + 2);
            if (writeCommunity != null && writeCommunity.length() > 0) {
                dmArgs[index + 3] = "-auth";
                dmArgs[index + 4] = writeCommunity;
                dmArgIndexNotToPrint.add(index + 4);
                index += 5;
            } else {
                index += 3;
            }
        } else if (isQuail) {
            dmArgs[index++] = "-v2c";
        }
        if (ClientController._ProxyAddress != null) {
            dmArgs[index] = "-x";
            dmArgs[index + 1] = ClientController._ProxyAddress.getAddress().getHostAddress() + ':' + Integer.toString(ClientController._ProxyAddress.getPort());
            index += 2;
        }
        String[] cp = new String[]{System.getProperty("java.class.path")};
        String[] tmpArgs = new String[14];
        int vmArgCount = 0;
        String laf = System.getProperty("swing.defaultlaf");
        if (laf != null) {
            tmpArgs[vmArgCount++] = "-Dswing.defaultlaf=" + laf;
        }
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("mds.")) continue;
            tmpArgs[vmArgCount++] = "-D" + key + "=" + System.getProperty(key);
        }
        ClientCache.resetDMInstallDir();
        String libPath1 = ClientCache.getDMInstallLocation() + "lib" + File.separator + "dm" + File.separator;
        tmpArgs[vmArgCount++] = "-Djava.endorsed.dirs=" + libPath1;
        tmpArgs[vmArgCount++] = "-Djavax.net.ssl.trustStore=fmsKS";
        tmpArgs[vmArgCount++] = "-Djavax.net.ssl.trustStorePassword=fmserver";
        String libPath = ClientCache.getDMInstallLocation() + "lib" + File.separator;
        boolean isDMInstalled = false;
        boolean getDMFromSwitch = false;
        if (DMMapAction.foundDeviceManagerScripts()) {
            if (DMMapAction.foundDeviceManagerJars(minimumDmJars, ClientCache.getDMInstallLocation() + "lib" + File.separator + "dm")) {
                _Logger.info((Object)("forkDM - foundDeviceManagerJars() in " + ClientCache.getDMInstallLocation() + "lib" + File.separator + "dm" + File.separator));
                libPath = ClientCache.getDMInstallLocation() + "lib" + File.separator + "dm" + File.separator;
                isDMInstalled = true;
            } else if (DMMapAction.foundDeviceManagerJars(minimumDmJars, ClientCache.getDMInstallLocation() + "lib")) {
                _Logger.info((Object)("forkDM - foundDeviceManagerJars() in " + ClientCache.getDMInstallLocation() + "lib" + File.separator));
                libPath = ClientCache.getDMInstallLocation() + "lib" + File.separator;
                isDMInstalled = true;
            }
            if (!isDMInstalled) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Please verify DM installation.  DM jar files not found in:\n" + ClientCache.getDMInstallLocation() + "lib" + File.separator + "dm\n" + ClientCache.getDMInstallLocation() + "lib");
                return;
            }
            getDMFromSwitch = false;
            _Logger.info((Object)"6.3(1)");
            if (!getDMFromSwitch) {
                _Logger.info((Object)"forkDM - launch locally installed DM");
                StringBuffer classpathBuffer = new StringBuffer();
                File directory = new File(libPath);
                if (directory != null) {
                    classpathBuffer.append(libPath + "patch.jar").append(File.pathSeparator);
                    classpathBuffer.append(libPath + "bitmaps.jar").append(File.pathSeparator);
                    classpathBuffer.append(libPath + "dm.jar").append(File.pathSeparator);
                    classpathBuffer.append(libPath + "dmdb.jar").append(File.pathSeparator);
                    HashMap<String, String> speciallyPlacedJars = new HashMap<String, String>();
                    speciallyPlacedJars.put(new String("patch.jar"), new String("patch.jar"));
                    speciallyPlacedJars.put(new String("bitmaps.jar"), new String("bitmaps.jar"));
                    speciallyPlacedJars.put(new String("dm.jar"), new String("dm.jar"));
                    speciallyPlacedJars.put(new String("dmdb.jar"), new String("dmdb.jar"));
                    speciallyPlacedJars.put(new String("activation.jar"), new String("activation.jar"));
                    speciallyPlacedJars.put(new String("installer.jar"), new String("installer.jar"));
                    speciallyPlacedJars.put(new String("mail.jar"), new String("mail.jar"));
                    File[] files = directory.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file == null || !file.canRead() || !file.isFile() || !file.getName().endsWith("jar") || speciallyPlacedJars.get(file.getName()) != null) continue;
                        classpathBuffer.append(libPath + file.getName()).append(File.pathSeparator);
                    }
                    classpathBuffer.append(libPath + "installer.jar").append(File.pathSeparator);
                    classpathBuffer.append(libPath + "mail.jar").append(File.pathSeparator);
                    classpathBuffer.append(libPath + "activation.jar");
                }
                String[] cp2 = new String[]{classpathBuffer.toString()};
                _Logger.info((Object)("forkDM - " + cp2[0]));
                String[] vmArgs = new String[vmArgCount];
                System.arraycopy(tmpArgs, 0, vmArgs, 0, vmArgCount);
                if (_Logger.isInfoEnabled() && dmArgs != null) {
                    StringBuffer dmArgsBuffer = new StringBuffer();
                    for (int i = 0; i < dmArgs.length; ++i) {
                        dmArgsBuffer.append(" ");
                        if (dmArgIndexNotToPrint.contains(i)) {
                            dmArgsBuffer.append("*****");
                            continue;
                        }
                        dmArgsBuffer.append(dmArgs[i]);
                    }
                    _Logger.info((Object)("forkDM - dmArgs=" + dmArgsBuffer));
                }
                if (!_newWinDM) {
                    _DMProcess = JFork.fork("com.cisco.dcbu.dm.DM", cp2, vmArgs, dmArgs);
                } else {
                    JFork.fork("com.cisco.dcbu.dm.DM", cp2, vmArgs, dmArgs);
                }
            }
        } else {
            getDMFromSwitch = true;
        }
        if (getDMFromSwitch) {
            if (sw.isN5K() || sw.isUCS()) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Nexus 5000 Series Switches & UCS Fabric Interconnects do not have a Device Manager on the switch.\nPlease download the appropriate DM from Cisco or the installed DCNM-SAN Server.");
                return;
            }
            if (sw.isVdc()) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Storage VDC's do not have Device Manager on the switch.\nPlease download the appropriate DM from Cisco or the installed DCNM-SAN Server.");
                return;
            }
            _Logger.info((Object)"forkDM - install DM from switch");
            String[] cmdarray = new String[]{System.getProperty("java.home") + File.separator + "bin" + File.separator + "javaws", "http://" + hostName + "/cgi-bin/element-manager.jnlp"};
            _Logger.info((Object)("forkDM cmdarray[]=" + cmdarray[0] + " " + cmdarray[1]));
            Runtime.getRuntime().exec(cmdarray);
        }
    }

    private static boolean isNewerDMVersionOnSwitch(Switch sw, String dmLibPath) {
        boolean isNewerDMVersionOnSwitch = true;
        String dmVersion = "unknown";
        try {
            URL[] urls = new URL[minimumDmJars.length];
            for (int i = 0; i < minimumDmJars.length; ++i) {
                urls[i] = new URL("file", "", dmLibPath + minimumDmJars[i]);
            }
            URLClassLoader cl = new URLClassLoader(urls);
            Class<?> cls = Class.forName(Constants.class.getName(), true, cl);
            Field f = cls.getDeclaredField("VERSION");
            dmVersion = (String)f.get(null);
            isNewerDMVersionOnSwitch = CheckUpgrade.isUpgradeNeeded(sw.getVersion(), dmVersion, sw.getModelType());
        }
        catch (Exception e) {
            _Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        _Logger.info((Object)("   Switch Model Type : " + FRUConstants.getMDSModelName(sw.getModelType()) + "   Switch Version : " + sw.getVersion() + "   DM version : " + dmVersion));
        return isNewerDMVersionOnSwitch;
    }

    public static boolean foundDeviceManagerFmClasspath() {
        ClassLoader ldr = Thread.currentThread().getContextClassLoader();
        URL dmURL = ldr.getResource("DM.class");
        URL dmPathURL = ldr.getResource("com/cisco/dcbu/dm/DM.class");
        if (dmURL != null || dmPathURL != null) {
            _Logger.info((Object)"foundDeviceManagerClass TRUE");
            return true;
        }
        _Logger.info((Object)"foundDeviceManagerClass FALSE");
        return false;
    }

    public static boolean foundDeviceManagerScripts() {
        String dmBatFile = ClientCache.getDMInstallLocation() + "bin" + File.separator + "DeviceManager.bat";
        String dmShFile = ClientCache.getDMInstallLocation() + "bin" + File.separator + "DeviceManager.sh";
        File dmFile = new File(dmBatFile);
        if (dmFile.exists()) {
            _Logger.info((Object)("foundDeviceManagerScripts DeviceManager.bat TRUE " + dmBatFile));
            return true;
        }
        dmFile = new File(dmShFile);
        if (dmFile.exists()) {
            _Logger.info((Object)("foundDeviceManagerScripts DeviceManager.sh TRUE " + dmShFile));
            return true;
        }
        _Logger.info((Object)("foundDeviceManagerScripts FALSE " + dmBatFile));
        _Logger.info((Object)("foundDeviceManagerScripts FALSE " + dmShFile));
        return false;
    }

    public static boolean foundDeviceManagerJars(String[] jarNames, String dmJarLocation) {
        if (jarNames == null || jarNames.length == 0 || dmJarLocation == null || dmJarLocation.length() == 0) {
            return false;
        }
        boolean somethingMissing = false;
        String jarName = null;
        File jarFile = null;
        for (int i = 0; i < jarNames.length; ++i) {
            jarName = dmJarLocation + File.separator + jarNames[i];
            jarFile = new File(jarName);
            if (!jarFile.exists()) {
                somethingMissing = true;
                _Logger.error((Object)("foundDeviceManagerJars()  missing:" + jarName));
                continue;
            }
            _Logger.info((Object)("foundDeviceManagerJars()    found:" + jarName));
        }
        return !somethingMissing;
    }

    boolean isSelectedSwitchHasMDS() {
        ArrayList nodes = SmMap.getSelectedMap().getSelectedNodes();
        if (nodes.size() != 1) {
            return false;
        }
        TopologyNode lastNode = (TopologyNode)nodes.get(nodes.size() - 1);
        if (lastNode.getModel() == null) {
            return false;
        }
        if (lastNode.getModel() instanceof Device) {
            Device dev = (Device)lastNode.getModel();
            if (dev == null || dev.getIpAddress() == null) {
                return false;
            }
            if (!dev.isManageable()) {
                return false;
            }
            if (dev instanceof Switch && (((Switch)dev).isMDS() || ((Switch)dev).isQuail())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void validate(JMenuItem menuitem, TopologyGraph g) {
        String cmd = menuitem.getText();
        if (cmd == null || cmd.length() == 0) {
            return;
        }
        if ("Reset".equals(cmd)) {
            menuitem.setEnabled(false);
            ArrayList nodes = SmMap.getSelectedMap().getSelectedNodes();
            if (nodes.size() != 1) {
                return;
            }
            TopologyNode lastNode = (TopologyNode)nodes.get(nodes.size() - 1);
            if (lastNode.getModel() == null) {
                return;
            }
            if (lastNode.getModel() instanceof Device) {
                Device dev = (Device)lastNode.getModel();
                if (dev == null || dev.getIpAddress() == null) {
                    return;
                }
                if (dev instanceof Switch && (((Switch)dev).isMDS() || ((Switch)dev).isQuail())) {
                    if (((Switch)dev).isNpvEnabled() && !ClientController.ENABLE_NPV_DISCOVERY) {
                        return;
                    }
                    menuitem.setEnabled(true);
                }
            }
        } else {
            if ("Element Manager".equals(cmd)) {
                int numSelectedLinks = SmMap.getSelectedMap().getSelectedLinks().size();
                if (numSelectedLinks == 1) {
                    menuitem.setEnabled(true);
                } else if (numSelectedLinks > 1) {
                    menuitem.setEnabled(false);
                }
                return;
            }
            if (cmd.equals("View Running Config")) {
                menuitem.setEnabled(this.isSelectedSwitchHasMDS());
            } else if (cmd.equals("View Startup Config")) {
                menuitem.setEnabled(this.isSelectedSwitchHasMDS());
            } else if (cmd.equals("View Config Differences")) {
                menuitem.setEnabled(this.isSelectedSwitchHasMDS());
            } else {
                ArrayList nodes = SmMap.getSelectedMap().getSelectedNodes();
                boolean valid = false;
                boolean exists = false;
                for (int i = 0; i < nodes.size(); ++i) {
                    try {
                        String dmPath;
                        Device dev;
                        TopologyNode n = (TopologyNode)nodes.get(i);
                        if (!(n.getModel() instanceof Device)) {
                            if (!(n.getModel() instanceof EthSwitch) || !((EthSwitch)n.getModel()).isN5K()) continue;
                            exists = true;
                            valid = true;
                        }
                        if ((dev = (Device)n.getModel()) == null) continue;
                        exists = true;
                        if (cmd.equals("Reauthenticate") && dev instanceof Switch && ((Switch)dev).isNpvEnabled() && !ClientController.ENABLE_NPV_DISCOVERY) {
                            valid = false;
                            break;
                        }
                        if (dev.getIpAddress() != null) {
                            valid = true;
                            continue;
                        }
                        if (!(dev instanceof Enclosure) || (dmPath = ((Enclosure)dev).getDMPath()) == null || dmPath.length() <= 0) continue;
                        valid = true;
                        continue;
                    }
                    catch (Exception e) {
                        _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
                    }
                }
                menuitem.setEnabled(valid && exists);
            }
        }
    }

    public static boolean getNewWinDM() {
        return _newWinDM;
    }

    public static void setNewWinDM(boolean flag) {
        _newWinDM = flag;
    }

    public static void setDmSocket(int portNumber) {
        DM_SOCKET = portNumber;
        _DMProcess = null;
    }

    void reset() {
        ArrayList nodes = SmMap.getSelectedMap().getSelectedNodes();
        TopologyNode lastNode = (TopologyNode)nodes.get(nodes.size() - 1);
        Switch sw = (Switch)lastNode.getModel();
        SnmpPeer peer = sw.getPeer();
        if (peer == null) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Switch " + sw + " is not manageable!");
            return;
        }
        if (JOptionPane.showOptionDialog(BrowserFrame.getDataView(), "Reset will disrupt traffic and lose any unsaved configuration changes.\nContinue?", "DCNM-SAN", 0, 2, null, new String[]{"Yes", "No"}, "No") == 0) {
            try {
                if (sw.isMDS()) {
                    SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
                    pdu.addVar(new SnmpOID(MibNode.get("cRFCfgAdminAction").getOid(), 0), new SnmpInt(2));
                    pdu.setIgnoreSetCount(true);
                    peer.set(pdu);
                    peer.resetNumSets();
                } else if (sw.isQuail()) {
                    SmlCommandsHandler smlCmd = new SmlCommandsHandler(BrowserFrame.getInstance(), sw.getPeer());
                    ArrayList<String> cmds = new ArrayList<String>();
                    cmds.add("Cmd.Switch.Reset");
                    String[] arCmd = cmds.toArray(new String[cmds.size()]);
                    smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, new String[][]{{"0"}, {"0"}}, null);
                    smlCmd.closeVsh();
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Error in switch reset: " + ex.getMessage());
            }
        }
    }

    static {
        _newWinDM = false;
        DM_SOCKET = 2222;
        urlHashMap = new HashMap();
        _Instance = null;
    }
}

