/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class FixLocationMapAction
extends MapActionAdapter {
    private static FixLocationMapAction _Instance = null;
    public static Logger _Logger = Logger.getLogger(FixLocationMapAction.class);

    public static FixLocationMapAction getInstance() {
        if (_Instance == null) {
            _Instance = new FixLocationMapAction();
        }
        return _Instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        SmMap map = SmMap.getSelectedMap();
        try {
            map.updateLayoutName();
        }
        catch (Exception ex1) {
            _Logger.trace((Object)"logEmptyCatch", (Throwable)ex1);
        }
        if (cmd.equals("fixAll")) {
            map.setLocationFixed(true, true);
            return;
        }
        if (cmd.equals("unfixAll")) {
            map.setLocationFixed(false, true);
            return;
        }
        ArrayList nodes = map.getSelectedNodes();
        if (nodes.size() == 0) {
            return;
        }
        boolean fix = true;
        try {
            fix = ((JCheckBoxMenuItem)e.getSource()).getState();
        }
        catch (Exception ex) {
            _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
        }
        for (int i = 0; i < nodes.size(); ++i) {
            TopologyNode n = (TopologyNode)nodes.get(i);
            if (n == null) continue;
            n.setLocationFixed(fix);
        }
    }

    @Override
    public void validate(JMenuItem menuItem, TopologyGraph g) {
        ArrayList nodes;
        if (g == null) {
            g = SmMap.getSelectedMap();
        }
        if ((nodes = g.getSelectedNodes()).size() == 0) {
            return;
        }
        boolean fix = true;
        for (int i = 0; i < nodes.size(); ++i) {
            TopologyNode n = (TopologyNode)nodes.get(i);
            if (n == null || n.isLocationFixed()) continue;
            fix = false;
            break;
        }
        try {
            if (menuItem instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)menuItem).setState(fix);
            }
        }
        catch (Exception ex) {
            _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
        }
    }
}

