/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmCommand;
import com.cisco.dcbu.sm.client.map.EdgeMapLink;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.zonewizard.ZoneMemWizard;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class PortZoneMembership
extends MapActionAdapter {
    private static PortZoneMembership _Instance = null;
    public static Logger _Logger = Logger.getLogger(PortZoneMembership.class);

    public static PortZoneMembership getInstance() {
        if (_Instance == null) {
            _Instance = new PortZoneMembership();
        }
        return _Instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            HashedArrayList selPorts = new HashedArrayList();
            Array vsanList = new Array();
            ZoneMemWizard.getSelectedPortsAndVsans(selPorts, vsanList, false);
            if (vsanList.size() > 1) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Please select End devices from a single VSAN.");
            } else if (vsanList.size() == 0) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Unable to find VSAN membership for End devices or devices are down.");
            } else {
                Vsan vv = (Vsan)vsanList.elementAt(0);
                SmCommand.portZoneSetReport(BrowserFrame.getDataView(), "Active Zone Membership for Selected End Ports in " + vv, vv, null, null, selPorts.toArray(new EndPort[selPorts.size()]));
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
        }
    }

    @Override
    public void validate(JMenuItem menuitem, TopologyGraph g) {
        SmMap map = SmMap.getSelectedMap();
        ArrayList links = map.getSelectedLinks();
        boolean exists = false;
        for (int i = 0; i < links.size(); ++i) {
            try {
                if (!(links.get(i) instanceof EdgeMapLink)) continue;
                exists = true;
                continue;
            }
            catch (Exception e) {
                _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
            }
        }
        menuitem.setEnabled(exists);
    }
}

