/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.map.PlatformNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ShowPathAction
extends MapActionAdapter {
    private static ShowPathAction _Instance;
    public static Logger _Logger;
    public static final String FROM_MAP = "FROM_MAP";
    public static final String FROM_ENDPORT_TABLE = "FROM_ENDPORT_TABLE";
    public static final String FROM_STORAGE_ENCLOSURE_TABLE = "FROM_STORAGE_ENCLOSURE_TABLE";
    public static final String FROM_HOST_ENCLOSURE_TABLE = "FROM_HOST_ENCLOSURE_TABLE";

    public static ShowPathAction getInstance() {
        if (_Instance == null) {
            _Instance = new ShowPathAction();
        }
        return _Instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!San.getInstance().fabricsAreLicensed()) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), "This feature is enabled for licensed fabrics only.");
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd == null || cmd.length() == 0) {
            return;
        }
        if (FROM_MAP.equals(cmd)) {
            SmMap map = SmMap.getSelectedMap();
            MgmtDomainIf selectedDomain = ClientController.getInstance().getSelectedDomain();
            ArrayList nodes = map.getSelectedNodes();
            HashedArrayList<EndPort> selectedEndPorts = new HashedArrayList<EndPort>();
            if (nodes != null && nodes.size() > 0) {
                for (int i = 0; i < nodes.size(); ++i) {
                    try {
                        PlatformNode tn = (PlatformNode)nodes.get(i);
                        if (tn.getModel() instanceof EndPort) {
                            ((ArrayList)selectedEndPorts).add((EndPort)tn.getModel());
                            continue;
                        }
                        if (!(tn.getModel() instanceof Enclosure)) continue;
                        Enclosure enc = (Enclosure)tn.getModel();
                        if (selectedDomain != null && (selectedDomain.isVsan() || selectedDomain.isZone())) {
                            ArrayList<EndPort> eps = enc.getMembers();
                            for (int j = 0; j < eps.size(); ++j) {
                                EndPort ep = eps.get(j);
                                if (((ArrayList)selectedEndPorts).contains(ep) || !ep.isMemberOf(selectedDomain)) continue;
                                ((ArrayList)selectedEndPorts).add(ep);
                            }
                            continue;
                        }
                        ((ArrayList)selectedEndPorts).addAll(enc.getMembers());
                        continue;
                    }
                    catch (Exception ex) {
                        _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
                    }
                }
                if (((EndPort)selectedEndPorts.get(0)).isTarget()) {
                    this.showPathFromTargetEndPorts(selectedEndPorts);
                } else if (((EndPort)selectedEndPorts.get(0)).isInitiator()) {
                    this.showPathFromHostEndPorts(selectedEndPorts);
                }
            }
        } else if (FROM_ENDPORT_TABLE.equals(cmd)) {
            ArrayList<Object> arrayList = BrowserFrame.getDataView().getSelectedRowDataObject();
            HashedArrayList<Object> selectedEndPorts = new HashedArrayList<Object>(arrayList);
            if (selectedEndPorts == null || selectedEndPorts.size() == 0) {
                Util.errorMessage((Component)BrowserFrame.getDataView(), "Please select one or more end ports.");
                return;
            }
            if (((EndPort)selectedEndPorts.get(0)).isTarget()) {
                this.showPathFromTargetEndPorts(selectedEndPorts);
            } else if (((EndPort)selectedEndPorts.get(0)).isInitiator()) {
                this.showPathFromHostEndPorts(selectedEndPorts);
            }
        } else if (FROM_STORAGE_ENCLOSURE_TABLE.equals(cmd)) {
            ArrayList<Object> arrayList = BrowserFrame.getDataView().getSelectedRowDataObject();
            HashedArrayList<Object> selectedEnclosures = new HashedArrayList<Object>(arrayList);
            this.showPathFromStorageEnclosures(selectedEnclosures);
        } else if (FROM_HOST_ENCLOSURE_TABLE.equals(cmd)) {
            ArrayList<Object> arrayList = BrowserFrame.getDataView().getSelectedRowDataObject();
            HashedArrayList<Object> selectedEnclosures = new HashedArrayList<Object>(arrayList);
            this.showPathFromHostEnclosures(selectedEnclosures);
        }
    }

    private void showPathFromTargetEndPorts(ArrayList<EndPort> selectedEndPorts) {
        if (selectedEndPorts == null || selectedEndPorts.size() == 0) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), "Please select one or more storage ports.");
            return;
        }
        if (selectedEndPorts.size() > 16) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), "Please select no more than 16 storage ports.");
            return;
        }
        ClientController.getInstance().restrictTopologyByTargetEndPorts(true, selectedEndPorts);
    }

    private void showPathFromHostEndPorts(ArrayList<EndPort> selectedEndPorts) {
        if (selectedEndPorts == null || selectedEndPorts.size() == 0) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), "Please select one or more host ports.");
            return;
        }
        if (selectedEndPorts.size() > 16) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), "Please select no more than 16 host ports.");
            return;
        }
        ClientController.getInstance().restrictTopologyByHostEndPorts(true, selectedEndPorts);
    }

    private void showPathFromStorageEnclosures(ArrayList<Enclosure> selectedEnclosures) {
        if (selectedEnclosures == null || selectedEnclosures.size() == 0) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), "Please select one or more storage enclosures.");
            return;
        }
        if (selectedEnclosures.size() > 16) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), "Please select no more than 16 storage enclosures.");
            return;
        }
        ClientController.getInstance().restrictTopologyByTargetEnclosures(true, selectedEnclosures);
    }

    private void showPathFromHostEnclosures(ArrayList<Enclosure> selectedEnclosures) {
        if (selectedEnclosures == null || selectedEnclosures.size() == 0) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), "Please select one or more host enclosures.");
            return;
        }
        if (selectedEnclosures.size() > 16) {
            Util.errorMessage((Component)BrowserFrame.getDataView(), "Please select no more than 16 host enclosures.");
            return;
        }
        ClientController.getInstance().restrictTopologyByHostEnclosures(true, selectedEnclosures);
    }

    static {
        _Logger = Logger.getLogger(ShowPathAction.class);
    }
}

