/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Hub;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.model.VsanUnion;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class VsanHighlightAction
extends MapActionAdapter {
    private static VsanHighlightAction _Instance = null;
    private MgmtDomainIf _vsan = null;
    public static Logger _Logger = Logger.getLogger(VsanHighlightAction.class);

    public static VsanHighlightAction getSharedInstance() {
        return VsanHighlightAction.getInstance();
    }

    public static VsanHighlightAction getInstance() {
        if (_Instance == null) {
            _Instance = new VsanHighlightAction();
        }
        return _Instance;
    }

    public void clear() {
        if (this._vsan == null) {
            return;
        }
        SmMap map = MapFactory.getInstance().getMap(this._vsan.getFabric());
        if (map == null) {
            return;
        }
        map.setDimmed(false);
        map.updateBounds();
    }

    @Override
    public void execute() {
        if (this._vsan == null) {
            return;
        }
        SmMap g = MapFactory.getInstance().getMap(this._vsan.getFabric());
        if (g == null) {
            return;
        }
        g.setDimmed(true);
        this.execute(g);
        g.repaint();
    }

    private void execute(SmMap g) {
        ArrayList<NpvLink> npvLinks;
        ArrayList<Isl> isls;
        MapLink l;
        int i;
        if (this._vsan == null) {
            return;
        }
        Switch[] sws = this._vsan.getSwitches();
        if (sws != null && sws.length > 0) {
            for (int i2 = 0; i2 < sws.length; ++i2) {
                try {
                    MapNode n = MapFactory.getInstance().getNode(sws[i2]);
                    if (n == null) continue;
                    n.setDimmed(false);
                    continue;
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - Switches", (Throwable)ex);
                }
            }
        }
        EndPort[] eps = null;
        if (this._vsan instanceof Vsan) {
            eps = ((Vsan)this._vsan).getEndPortsIgnoreSwitch();
        } else if (this._vsan instanceof VsanUnion) {
            eps = ((VsanUnion)this._vsan).getEndPortsIgnoreSwitch();
        }
        if (eps != null && eps.length > 0) {
            Hub hub = null;
            for (i = 0; i < eps.length; ++i) {
                try {
                    MapNode n = MapFactory.getInstance().getNode(eps[i]);
                    if (n != null) {
                        n.setDimmed(false);
                    }
                    if ((l = MapFactory.getInstance().getLink(eps[i])) != null) {
                        l.setDimmed(false);
                    }
                    if ((hub = eps[i].getHub()) == null) continue;
                    n = MapFactory.getInstance().getNode(hub);
                    if (n != null) {
                        n.setDimmed(false);
                    }
                    if ((l = MapFactory.getInstance().getLink(hub)) == null) continue;
                    l.setDimmed(false);
                    continue;
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - EndPorts", (Throwable)ex);
                }
            }
        }
        if ((isls = this._vsan.getIsls(null)) != null && isls.size() > 0) {
            for (i = 0; i < isls.size(); ++i) {
                try {
                    MapLink l2 = MapFactory.getInstance().getLink(isls.get(i));
                    if (l2 == null) continue;
                    l2.setDimmed(false);
                    continue;
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - Isls", (Throwable)ex);
                }
            }
        }
        if ((npvLinks = this._vsan.getNpvLinks(null)) != null && npvLinks.size() > 0) {
            for (int i3 = 0; i3 < npvLinks.size(); ++i3) {
                try {
                    l = MapFactory.getInstance().getLink(npvLinks.get(i3));
                    if (l == null) continue;
                    l.setDimmed(false);
                    continue;
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - npvLinks", (Throwable)ex);
                }
            }
        }
        if (g.graphs() != null) {
            Iterator iter = g.graphs().iterator();
            while (iter.hasNext()) {
                SmMap tg = (SmMap)iter.next();
                this.execute(tg);
            }
        }
        g.updateBounds();
    }

    public Vsan getVsan() {
        if (this._vsan instanceof Vsan) {
            return (Vsan)this._vsan;
        }
        return null;
    }

    public void setVsan(Vsan vsan) {
        this._vsan = vsan;
    }

    public void setVsan(VsanUnion vsanUnion) {
        this._vsan = vsanUnion;
    }
}

