/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.concurrent.PooledThreadExecutor;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.AbstractFcLink;
import com.cisco.dcbu.sm.client.model.AbstractLink;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.ChannelMemberIsl;
import com.cisco.dcbu.sm.client.model.ChannelMemberNpvLink;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EthIsl;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.Lan;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.dto.PCMemberTrustSec;
import com.cisco.dcbu.sm.common.dto.VsanDomain;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.InventoryChangeEvent;
import com.cisco.dcbu.sm.common.model.AbstractFcLinkBase;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.ClusterBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.InventoryComponent;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.type.ClusterPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.NpvSwitchIntKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class DataCenter
extends Lan {
    public static final String NAME = "DataCenter";
    private static DataCenter _Instance;
    private HashMap<WwnKey, Switch> _switchByPK = new HashMap();
    private HashMap<InetAddress, Switch> _switchByIpAddress = new HashMap();
    private HashMap<SwitchIntKey, Isl> _islBySwitchIntKey = new HashMap();
    private HashMap<SwitchIntKey, NpvLink> _npvLinkByFPortPK = new HashMap();
    private HashMap<SwitchIntKey, NpvLink> _npvLinkByPCMemberSwitchIntKey = new HashMap();
    private HashMap<SwitchIntKey, Isl> _islByPCMemberSwitchIntKey = new HashMap();
    private ArrayList<IslBase> danglingIsls = new HashedArrayList<IslBase>();
    private ArrayList<NpvLinkBase> danglingNpvLinks = new HashedArrayList<NpvLinkBase>();
    private Map<PKIf, PKIf> allCoexistSwPKs = new HashMap<PKIf, PKIf>();
    private static PooledThreadExecutor _executor;
    protected boolean _inited = false;

    @Override
    public boolean inited() {
        return this._inited;
    }

    protected DataCenter() {
    }

    public static DataCenter getInstance() {
        return _Instance;
    }

    @Override
    public String getPath(char separator) {
        return separator + NAME;
    }

    @Override
    public boolean isDataCenter() {
        return true;
    }

    @Override
    public boolean isLAN() {
        return false;
    }

    @Override
    public AbstractSwitch[] getAbstractSwitches() {
        int i;
        Switch[] switchList = this.getSwitches();
        EthSwitch[] ethSwitchList = this.getEthSwitches();
        HashedArrayList<AbstractSwitch> abstractSwitchList = new HashedArrayList<AbstractSwitch>(switchList.length + ethSwitchList.length);
        if (switchList != null) {
            for (i = 0; i < switchList.length; ++i) {
                ((ArrayList)abstractSwitchList).add(switchList[i]);
            }
        }
        if (ethSwitchList != null) {
            for (i = 0; i < ethSwitchList.length; ++i) {
                ((ArrayList)abstractSwitchList).add(ethSwitchList[i]);
            }
        }
        return abstractSwitchList.toArray(new AbstractSwitch[abstractSwitchList.size()]);
    }

    @Override
    public ArrayList<AbstractLink> getAbstractLinks(ArrayList<AbstractLink> isls) {
        ArrayList<EthIsl> ethernetLinks = this.getEthIsls(null);
        ArrayList<Isl> fcLinks = this.getIsls(null);
        ArrayList<NpvLink> npvLinks = this.getNpvLinks(null);
        if (isls == null) {
            isls = new HashedArrayList<AbstractLink>(ethernetLinks.size() + fcLinks.size() + npvLinks.size());
        }
        if (ethernetLinks != null) {
            isls.addAll(ethernetLinks);
        }
        if (fcLinks != null) {
            isls.addAll(fcLinks);
        }
        if (npvLinks != null) {
            isls.addAll(npvLinks);
        }
        return isls;
    }

    @Override
    public void dump(String item) {
        if (!this.inited()) {
            this.refresh(false);
        }
        if (item.equals(NAME)) {
            super.dump("LAN");
        } else {
            super.dump(item);
        }
        if (item.equals(NAME)) {
            DefaultLogger._DumpLogger.info((Object)this.dumpDataCenter(false));
        } else if (item.equals("Switches")) {
            DefaultLogger._DumpLogger.info((Object)this.dumpSwitches(true, 0));
        } else if (item.equals("ISLs")) {
            DefaultLogger._DumpLogger.info((Object)this.dumpIsls(true, 0));
        } else if (item.equals("NP Links")) {
            DefaultLogger._DumpLogger.info((Object)this.dumpNpvLinks(true, 0));
        } else if (item.equals("Hashes")) {
            DefaultLogger._DumpLogger.info((Object)this.dumpHashes());
        }
    }

    public String dumpDataCenter(boolean inDetail) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n').append(this.dumpSwitches(inDetail, 1));
        sb.append('\n').append(this.dumpIsls(inDetail, 1));
        sb.append("\n").append(this.dumpNpvLinks(inDetail, 1));
        return sb.toString();
    }

    @Override
    public String dumpHashes() {
        Field[] flds;
        StringBuilder sb = new StringBuilder();
        for (Field field : flds = this.getClass().getDeclaredFields()) {
            try {
                Object o = field.get(this);
                if (!(o instanceof Map)) continue;
                String name = field.getName();
                Map map = (Map)o;
                sb.append('\n');
                if (name.charAt(0) == '_') {
                    sb.append(name.substring(1));
                } else {
                    sb.append(name);
                }
                sb.append(": ");
                if (map == null) {
                    sb.append("none");
                } else {
                    sb.append(map.size());
                    Set s = map.entrySet();
                    for (Map.Entry ent : s) {
                        Object value;
                        sb.append("\n\tkey=").append(ent.getKey()).append(" \tvalue=").append(ent.getValue());
                        if (!name.contains("switchByPK") && !name.contains("switchByIpAddress") || (value = ent.getValue()) == null || !(value instanceof AbstractSwitch)) continue;
                        AbstractSwitch sw = (AbstractSwitch)value;
                        sb.append(" \tpk=").append(sw.getPK()).append(" \tip=").append(sw.getInetAddress());
                    }
                }
                sb.append('\n');
            }
            catch (Exception ex) {
                this._logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return sb.toString();
    }

    public Map<PKIf, PKIf> getAllCoexistSwPKs() {
        return this.allCoexistSwPKs;
    }

    public void destroy() {
        if (this.danglingIsls != null) {
            this.danglingIsls.clear();
        }
        if (this.danglingNpvLinks != null) {
            this.danglingNpvLinks.clear();
        }
    }

    @Override
    public void refresh(boolean force) {
        force = true;
        if (!this.inited() || force) {
            Fabric[] fabrics;
            try {
                if (this.allCoexistSwPKs != null) {
                    this.allCoexistSwPKs.clear();
                }
                this.allCoexistSwPKs = ClientController.getInstance().getAllCoexistSwPKs();
            }
            catch (Exception e1) {
                this._logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
            super.refresh(force);
            if (this._switchByPK != null) {
                this._switchByPK.clear();
            }
            if (this._switchByIpAddress != null) {
                this._switchByIpAddress.clear();
            }
            if (this._islBySwitchIntKey != null) {
                this._islBySwitchIntKey.clear();
            }
            if (this._npvLinkByFPortPK != null) {
                this._npvLinkByFPortPK.clear();
            }
            if (this._npvLinkByPCMemberSwitchIntKey != null) {
                this._npvLinkByPCMemberSwitchIntKey.clear();
            }
            if (this._islByPCMemberSwitchIntKey != null) {
                this._islByPCMemberSwitchIntKey.clear();
            }
            if (this.danglingIsls != null) {
                this.danglingIsls.clear();
            }
            if (this.danglingNpvLinks != null) {
                this.danglingNpvLinks.clear();
            }
            if ((fabrics = San.getInstance().getFabrics()) != null) {
                for (int i = 0; i < fabrics.length; ++i) {
                    NpvLink[] npvLinks;
                    Isl[] isls;
                    Switch[] switches = fabrics[i].getSwitches();
                    if (switches != null) {
                        for (int j = 0; j < switches.length; ++j) {
                            Switch sw = switches[j];
                            if (sw == null || sw.getBaseModelObject() == null) continue;
                            this.addSwitch((SwitchBase)sw.getBaseModelObject(), fabrics[i]);
                        }
                    }
                    if ((isls = fabrics[i].getIsls()) != null) {
                        for (int j = 0; j < isls.length; ++j) {
                            Isl isl = isls[j];
                            if (isl == null || isl.getBaseModelObject() == null) continue;
                            this.addIsl((IslBase)isl.getBaseModelObject(), fabrics[i]);
                        }
                    }
                    if ((npvLinks = fabrics[i].getNpvLinks()) == null) continue;
                    for (int j = 0; j < npvLinks.length; ++j) {
                        NpvLink isl = npvLinks[j];
                        if (isl == null || isl.getBaseModelObject() == null) continue;
                        this.addNpvLink((NpvLinkBase)isl.getBaseModelObject(), fabrics[i]);
                    }
                }
            }
            try {
                this.setPeersUsingSanSwitches();
            }
            catch (Exception e) {
                this._logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this._inited = true;
        }
    }

    private NpvLink addNpvLink(NpvLinkBase npvlBase, Fabric fabric) {
        if (npvlBase == null) {
            return null;
        }
        WwnKey coreSwitchPK = npvlBase.getCoreSwitchPK();
        WwnKey edgeSwitchPK = npvlBase.getEdgeSwitchPK();
        if (coreSwitchPK != null && this.addSwitch(coreSwitchPK) == null) {
            int i = this.danglingNpvLinks.indexOf(npvlBase);
            if (i == -1) {
                this.danglingNpvLinks.add(npvlBase);
            } else {
                this.danglingNpvLinks.set(i, npvlBase);
            }
            if (this._logger.isInfoEnabled()) {
                this._logger.info((Object)("addNpvLink failed: core switch not found in client & server " + coreSwitchPK));
            }
            return null;
        }
        if (edgeSwitchPK != null && this.addSwitch(edgeSwitchPK) == null) {
            int i = this.danglingNpvLinks.indexOf(npvlBase);
            if (i == -1) {
                this.danglingNpvLinks.add(npvlBase);
            } else {
                this.danglingNpvLinks.set(i, npvlBase);
            }
            if (this._logger.isInfoEnabled()) {
                this._logger.info((Object)("addNpvLink failed: edge switch not found in client & server " + edgeSwitchPK));
            }
            return null;
        }
        NpvLink npvl = new NpvLink((AbstractFcLinkBase)npvlBase, fabric, this);
        this._npvLinkByFPortPK.put(npvlBase.getFPortPK(), npvl);
        if (npvl.isPortChannel() && npvl.getNumPCMembers() > 0) {
            List<NpvLink> members = npvl.getPCMemberLinksAsNpvLink();
            for (int i = 0; i < members.size(); ++i) {
                ChannelMemberNpvLink mem = (ChannelMemberNpvLink)members.get(i);
                SwitchIntKey pk = (SwitchIntKey)mem.getPK();
                this._npvLinkByPCMemberSwitchIntKey.put(pk, npvl);
            }
        }
        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "npvLinkAdded", null, npvl));
        return npvl;
    }

    private Isl addIsl(IslBase islBase, Fabric fabric) {
        Isl isl;
        this._logger.trace((Object)"addIsl(IslBase)");
        if (islBase == null) {
            return null;
        }
        WwnKey switch1PK = islBase.getSwitch1PK();
        WwnKey switch2PK = islBase.getSwitch2PK();
        if (switch1PK != null) {
            this.addSwitch(switch1PK);
        }
        if (switch2PK != null) {
            this.addSwitch(switch2PK);
        }
        if ((isl = new Isl((AbstractFcLinkBase)islBase, fabric, this)).getSwitch1() == null && isl.getSwitch2() == null) {
            if (this._logger.isInfoEnabled()) {
                this._logger.info((Object)("addIsl() isl=" + isl.getPK().toString() + " MISSING_SWITCH_BOTH_SWITCHES"), (Throwable)new NullPointerException());
            }
            return null;
        }
        if (isl.getSwitch1() == null) {
            int i;
            if (this._logger.isInfoEnabled()) {
                this._logger.info((Object)("addIsl() isl=" + isl.getPK().toString() + " MISSING_SWITCH_1"), (Throwable)new NullPointerException());
            }
            if ((i = this.danglingIsls.indexOf(islBase)) == -1) {
                this.danglingIsls.add(islBase);
            } else {
                this.danglingIsls.set(i, islBase);
            }
            return null;
        }
        if (isl.getSwitch2() == null) {
            int i;
            if (this._logger.isInfoEnabled()) {
                this._logger.info((Object)("addIsl() isl=" + isl.getPK().toString() + " MISSING_SWITCH_2"), (Throwable)new NullPointerException());
            }
            if ((i = this.danglingIsls.indexOf(islBase)) == -1) {
                this.danglingIsls.add(islBase);
            } else {
                this.danglingIsls.set(i, islBase);
            }
            return null;
        }
        this._logger.trace((Object)("addIsl() islAdded " + islBase.toString()));
        this._logger.trace((Object)("addIsl() islAdded " + isl.toString()));
        this._islBySwitchIntKey.put(islBase.getIslPK().getSwitchIntKey1(), isl);
        this._islBySwitchIntKey.put(islBase.getIslPK().getSwitchIntKey2(), isl);
        if (isl.isPortChannel() && isl.getNumPCMembers() > 0) {
            List<Isl> members = isl.getPCMemberLinksAsIsls();
            for (int i = 0; i < members.size(); ++i) {
                ChannelMemberIsl mem = (ChannelMemberIsl)members.get(i);
                IslPK pk = (IslPK)mem.getPK();
                this._islByPCMemberSwitchIntKey.put(pk.getSwitchIntKey1(), isl);
                this._islByPCMemberSwitchIntKey.put(pk.getSwitchIntKey2(), isl);
            }
        }
        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "islAdded", null, isl));
        return isl;
    }

    Switch addSwitch(WwnKey switchKey) {
        Switch sw = this._switchByPK.get(switchKey);
        if (sw == null && ClientController.getInstance().isServerActive()) {
            try {
                SwitchBase swBase;
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("adding switch - " + switchKey));
                }
                if ((swBase = ClientController.getInstance().assertModelFacade().findSwitchByPK(switchKey)) == null) {
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug((Object)("addSwitch " + switchKey + " swBase == null"), (Throwable)new NullPointerException());
                    }
                    return null;
                }
                sw = this.addSwitch(swBase, San.getInstance().getFabricBySwitchPK(swBase.getPK()));
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("switch added for switchkey - " + switchKey + " - " + sw));
                }
                if (sw != null) {
                    if (this.inited()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DataCenter.this.firePropertyChangeEvents();
                            }
                        });
                    }
                    final Switch swtch = sw;
                    Runnable authSw = new Runnable(){

                        @Override
                        public void run() {
                            if (DataCenter.this._logger.isDebugEnabled()) {
                                DataCenter.this._logger.debug((Object)("authenticating switch - " + swtch));
                            }
                            swtch.authenticate();
                            if (DataCenter.this._logger.isDebugEnabled()) {
                                DataCenter.this._logger.debug((Object)("DONE authenticating switch - " + swtch));
                            }
                        }
                    };
                    _executor.execute(authSw);
                }
                return sw;
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in addSwitch " + switchKey), (Throwable)ex);
            }
        }
        return sw;
    }

    private Switch addSwitch(SwitchBase switchBase, Fabric fabric) {
        if (fabric == null) {
            return null;
        }
        if (switchBase == null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"addSwitch() switchBase == null", (Throwable)new NullPointerException());
            }
            return null;
        }
        if (switchBase.getFabricPK() == null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"addSwitch() switchBase.getFabricPK() == null", (Throwable)new NullPointerException());
            }
            return null;
        }
        Switch sw = this._switchByPK.get(switchBase.getPK());
        boolean added = false;
        if (sw == null) {
            sw = new Switch(switchBase, fabric, this);
            added = true;
            sw.setFCPortMap(fabric.findSwitchByPK(switchBase.getPK()).getFCPortMap());
        }
        if (this._switchByPK.get(switchBase.getPK()) == null) {
            this._switchByPK.put((WwnKey)switchBase.getSwitchPK(), sw);
        }
        if (switchBase.getPK() == null && this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("addSwitch() switchBase.getPK()==null" + sw), (Throwable)new NullPointerException());
        }
        this.addSwitchByIpAddress(sw);
        if (this.inited() && added) {
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "switchAdded", null, sw));
        }
        this.addDanglingLinks();
        return sw;
    }

    private void addDanglingLinks() {
        int i;
        if (this.danglingIsls != null && this.danglingIsls.size() > 0) {
            for (i = this.danglingIsls.size() - 1; i >= 0; --i) {
                try {
                    IslBase islBase1 = ClientController.getInstance().assertModelFacade().findIslBySwitchIntKey(this.danglingIsls.get(i).getIslPK().getSwitchIntKey1());
                    IslBase islBase2 = ClientController.getInstance().assertModelFacade().findIslBySwitchIntKey(this.danglingIsls.get(i).getIslPK().getSwitchIntKey2());
                    if (islBase1 == null || islBase2 == null || !islBase1.getIslPK().equals(islBase2.getIslPK())) {
                        this.danglingIsls.remove(i);
                        continue;
                    }
                    Isl isl = this.addIsl(islBase1, San.getInstance().getFabricByIslSwitchIntKey(islBase1.getIslPK().getSwitchIntKey1()));
                    if (isl == null) continue;
                    this.danglingIsls.remove(i);
                    continue;
                }
                catch (Exception ex) {
                    this.danglingIsls.remove(i);
                    this._logger.warn((Object)ex);
                }
            }
        }
        if (this.danglingNpvLinks != null && this.danglingNpvLinks.size() > 0) {
            for (i = this.danglingNpvLinks.size() - 1; i >= 0; --i) {
                try {
                    NpvLinkBase npvLinkBase = ClientController.getInstance().assertModelFacade().findNpvLinkByFPortPK(this.danglingNpvLinks.get(i).getFPortPK());
                    if (npvLinkBase == null) {
                        this.danglingNpvLinks.remove(i);
                        continue;
                    }
                    NpvLink npvLink = this.addNpvLink(npvLinkBase, San.getInstance().getFabricByNpvLinkByFportKey(npvLinkBase.getFPortPK()));
                    if (npvLink == null) continue;
                    this.danglingNpvLinks.remove(i);
                    continue;
                }
                catch (Exception ex) {
                    this.danglingNpvLinks.remove(i);
                    this._logger.warn((Object)ex);
                }
            }
        }
    }

    private void addSwitchByIpAddress(Switch sw) {
        if (sw.getInetAddress() == null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("addSwitchByIpAddress() sw.getInetAddress()==null sw=" + sw));
            }
            return;
        }
        if (sw.getInetAddress() != null && this._switchByIpAddress.get(sw.getInetAddress()) == null) {
            this._switchByIpAddress.put(sw.getInetAddress(), sw);
        }
    }

    @Override
    public AbstractSwitch findSwitchByIpAddress(InetAddress ipAddr) {
        AbstractSwitch sw = this._switchByIpAddress.get(ipAddr);
        if (sw != null) {
            return sw;
        }
        return super.findSwitchByIpAddress(ipAddr);
    }

    public Switch getSwitchByPK(WwnKey swWwnKey) {
        if (swWwnKey == null || this._switchByPK == null) {
            return null;
        }
        return this._switchByPK.get(swWwnKey);
    }

    public Switch findSwitchByPK(WwnKey swWwnKey) {
        if (swWwnKey == null || this._switchByPK == null) {
            return null;
        }
        Switch sw = this._switchByPK.get(swWwnKey);
        if (sw == null) {
            sw = this.addSwitch(swWwnKey);
            if (this.inited() && sw != null) {
                this.firePropertyChangeEvents();
            }
        }
        return sw;
    }

    public Switch findSwitchByPKNoAdd(PKIf swWwnKey) {
        if (swWwnKey == null || this._switchByPK == null) {
            return null;
        }
        return this._switchByPK.get(swWwnKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Isl> getIsls(ArrayList<Isl> list) {
        if (list == null) {
            list = new HashedArrayList<Isl>(this._islBySwitchIntKey.size());
        }
        HashMap<SwitchIntKey, Isl> hashMap = this._islBySwitchIntKey;
        synchronized (hashMap) {
            for (Map.Entry<SwitchIntKey, Isl> entry : this._islBySwitchIntKey.entrySet()) {
                Isl isl = entry.getValue();
                if (!((PKIf)entry.getKey()).equals(((IslPK)isl.getPK())._p1)) continue;
                list.add(isl);
            }
        }
        return list;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<NpvLink> getNpvLinks(ArrayList<NpvLink> list) {
        if (list == null) {
            list = new HashedArrayList<NpvLink>(this._npvLinkByFPortPK.size());
        }
        HashMap<SwitchIntKey, NpvLink> hashMap = this._npvLinkByFPortPK;
        synchronized (hashMap) {
            for (Map.Entry<SwitchIntKey, NpvLink> entry : this._npvLinkByFPortPK.entrySet()) {
                NpvLink isl = entry.getValue();
                if (!entry.getKey().equals(isl.getFPortPK())) continue;
                list.add(isl);
            }
        }
        return list;
    }

    @Override
    public SnmpPeer[] getSnmpPeers() {
        return this.getSnmpPeers(false);
    }

    @Override
    public SnmpPeer[] getSnmpPeers(boolean needQuail) {
        return this.getSnmpPeers(needQuail, false);
    }

    public SnmpPeer[] getSnmpPeers(boolean needQuail, boolean filterNPV) {
        ArrayList<SnmpPeer> modlist = this.getSnmpPeers(null, needQuail, filterNPV);
        return modlist.size() == 0 ? null : modlist.toArray(new SnmpPeer[modlist.size()]);
    }

    private ArrayList<SnmpPeer> getSnmpPeers(ArrayList<SnmpPeer> list, boolean needQuail, boolean filterNPV) {
        Switch[] switches = this.getSwitches();
        if (switches == null || switches.length == 0) {
            return new HashedArrayList<SnmpPeer>();
        }
        if (list == null) {
            list = new HashedArrayList<SnmpPeer>(switches.length);
        }
        for (int j = 0; j < switches.length; ++j) {
            Switch sw = switches[j];
            if ((!sw.isMDS() || (sw.isNpvEnabled() || !filterNPV) && filterNPV) && (!needQuail || !sw.isQuail()) || !sw.isLocallyManageable() || sw.getPeer() == null) continue;
            list.add(sw.getPeer());
        }
        return list;
    }

    public void setupPeer(WwnKey switchPK) {
        block3: {
            try {
                Switch swFromDC = this.findSwitchByPK(switchPK);
                Switch swFromSan = San.getInstance().getSwitchByPK(switchPK);
                if (swFromDC != null && swFromSan != null) {
                    swFromDC.setSnmpPeer(swFromSan.getSnmpPeer());
                    this.firePropertyChangeEvents();
                }
            }
            catch (Exception ex) {
                if (!this._logger.isDebugEnabled()) break block3;
                this._logger.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void setPeersUsingSanSwitches() {
        final Switch[] dcSwitches = this.getSwitches();
        Thread t = new Thread("DataCenter setPeersUsingSanSwitches Thread"){

            @Override
            public void run() {
                if (dcSwitches == null) {
                    return;
                }
                int numLoopsExecuted = 0;
                int numPeersSet = 0;
                int numUnmanagedSW = dcSwitches.length;
                do {
                    numUnmanagedSW = dcSwitches.length;
                    if (DataCenter.this._logger.isDebugEnabled()) {
                        DataCenter.this._logger.debug((Object)("do numUnmanagedSW=" + numUnmanagedSW + " numLoopsExecuted=" + numLoopsExecuted));
                    }
                    for (int i = 0; i < dcSwitches.length; ++i) {
                        if (dcSwitches[i] != null && dcSwitches[i].getPeer() == null) {
                            try {
                                Switch sanSwitch = San.getInstance().getSwitchByPK(dcSwitches[i].getPK());
                                if (sanSwitch == null || sanSwitch.getPeer() == null) continue;
                                dcSwitches[i].setSnmpPeer(sanSwitch.getSnmpPeer());
                                if (DataCenter.this._logger.isDebugEnabled()) {
                                    DataCenter.this._logger.debug((Object)("Sharing peer " + dcSwitches[i].getName()));
                                }
                                ++numPeersSet;
                                --numUnmanagedSW;
                            }
                            catch (Exception ex) {
                                if (!DataCenter.this._logger.isDebugEnabled()) continue;
                                DataCenter.this._logger.debug((Object)ex.getMessage(), (Throwable)ex);
                            }
                            continue;
                        }
                        --numUnmanagedSW;
                    }
                    if (numPeersSet > 0) {
                        numPeersSet = 0;
                        if (DataCenter.this._logger.isDebugEnabled()) {
                            DataCenter.this._logger.debug((Object)"firePropertyChangeEvents");
                        }
                        DataCenter.this.firePropertyChangeEvents();
                    }
                    if (numUnmanagedSW <= 0) continue;
                    try {
                        if (DataCenter.this._logger.isDebugEnabled()) {
                            DataCenter.this._logger.debug((Object)("sleep numUnmanagedSW=" + numUnmanagedSW));
                        }
                        3.sleep(10000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                } while (numUnmanagedSW > 0 && ++numLoopsExecuted <= 12);
                if (DataCenter.this._logger.isDebugEnabled()) {
                    DataCenter.this._logger.debug((Object)("done numUnmanagedSW=" + numUnmanagedSW));
                }
            }
        };
        t.setPriority(1);
        t.start();
    }

    @Override
    public Switch[] getSwitches() {
        HashedArrayList<Switch> list = new HashedArrayList<Switch>();
        this.getSwitches(list);
        if (list == null) {
            return new Switch[0];
        }
        return list.toArray(new Switch[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Switch> getSwitches(ArrayList<Switch> list) {
        if (list == null) {
            list = new HashedArrayList<Switch>();
        }
        HashMap<WwnKey, Switch> hashMap = this._switchByPK;
        synchronized (hashMap) {
            for (Map.Entry<WwnKey, Switch> entry : this._switchByPK.entrySet()) {
                Switch sw = entry.getValue();
                list.add(sw);
            }
        }
        return list;
    }

    @Override
    public Fabric[] getFabrics() {
        return San.getInstance().getFabrics();
    }

    @Override
    public Fabric getFabric() {
        return null;
    }

    public void fabricMembersAdded(BaseModelObject[] o) {
        if (o == null || o.length == 0) {
            return;
        }
        AbstractModelObject obj = null;
        for (int i = 0; i < o.length; ++i) {
            try {
                if (o[i] == null) continue;
                if (o[i] instanceof SwitchBase) {
                    Switch sw = this._switchByPK.get(o[i].getPK());
                    if (sw == null) {
                        SwitchBase swBase = (SwitchBase)o[i];
                        sw = this.addSwitch(swBase, San.getInstance().getFabricBySwitchPK(swBase.getPK()));
                    } else {
                        sw.getBaseModelObject().sync(o[i]);
                    }
                    final Switch swtch = sw;
                    Runnable authSw = new Runnable(){

                        @Override
                        public void run() {
                            if (DataCenter.this._logger.isDebugEnabled()) {
                                DataCenter.this._logger.debug((Object)("authenticating switch - " + swtch));
                            }
                            swtch.authenticate();
                            if (DataCenter.this._logger.isDebugEnabled()) {
                                DataCenter.this._logger.debug((Object)("DONE authenticating switch - " + swtch));
                            }
                        }
                    };
                    _executor.execute(authSw);
                    obj = sw;
                } else if (!(o[i] instanceof EndPortBase) && !(o[i] instanceof VsanBase)) {
                    if (o[i] instanceof IslBase) {
                        IslPK islPK = (IslPK)o[i].getPK();
                        Isl isl = this.findIslBySwitchIntKey(islPK.getSwitchIntKey1(), false);
                        if (isl == null) {
                            IslBase islBase = (IslBase)o[i];
                            isl = this.addIsl(islBase, San.getInstance().getFabricByIslSwitchIntKey(islBase.getIslPK().getSwitchIntKey1()));
                        } else if (islPK.equals(isl.getPK())) {
                            isl.getBaseModelObject().sync(o[i]);
                            this.addPropertyChangeEvent(new PropertyChangeEvent(isl, "islSynced", null, isl));
                        } else {
                            IslPK removeIslPK = (IslPK)isl.getPK();
                            this.removeIsl(removeIslPK);
                            IslBase islBase = (IslBase)o[i];
                            isl = this.addIsl(islBase, San.getInstance().getFabricByIslSwitchIntKey(islBase.getIslPK().getSwitchIntKey1()));
                        }
                        obj = isl;
                    } else if (o[i] instanceof NpvLinkBase) {
                        NpvLink npvLink = this.findNpvLinkByFportKey((SwitchIntKey)o[i].getPK());
                        if (npvLink == null) {
                            NpvLinkBase npvlBase = (NpvLinkBase)o[i];
                            npvLink = this.addNpvLink(npvlBase, San.getInstance().getFabricByNpvLinkByFportKey(npvlBase.getFPortPK()));
                        } else {
                            npvLink.getBaseModelObject().sync(o[i]);
                            this.addPropertyChangeEvent(new PropertyChangeEvent(npvLink, "islSynced", null, npvLink));
                        }
                        obj = npvLink;
                    } else if (o[i] instanceof ClusterBase) {
                        // empty if block
                    }
                }
                if (!ClientController.isTrace() || obj == null) continue;
                ClientController.trace("ADDED: " + obj);
                continue;
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in fabricMembersAdded " + o[i]), (Throwable)ex);
            }
        }
        this.firePropertyChangeEvents();
    }

    public NpvLink findNpvLinkByFportKey(SwitchIntKey fpkey) {
        return this._npvLinkByFPortPK.get(fpkey);
    }

    public Isl findIslBySwitchIntKey(PKIf swIntKey, boolean checkPCMembers) {
        Isl isl = this._islBySwitchIntKey.get(swIntKey);
        if (isl == null && checkPCMembers) {
            isl = this._islByPCMemberSwitchIntKey.get(swIntKey);
        }
        if (isl == null) {
            isl = this.addIsl((SwitchIntKey)swIntKey);
        }
        return isl;
    }

    public Isl addIsl(SwitchIntKey swIntKey) {
        this._logger.trace((Object)"addIsl(SwitchIntKey)");
        Isl isl = this._islBySwitchIntKey.get(swIntKey);
        if (isl == null && ClientController.getInstance().isServerActive()) {
            try {
                IslBase islBase = ClientController.getInstance().assertModelFacade().findIslBySwitchIntKey(swIntKey);
                if (islBase == null || !islBase.isPresent()) {
                    return null;
                }
                isl = this.addIsl(islBase, San.getInstance().getFabricByIslSwitchIntKey(islBase.getIslPK().getSwitchIntKey1()));
                if (this.inited()) {
                    this.firePropertyChangeEvents();
                }
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in addIsl " + swIntKey), (Throwable)ex);
            }
        }
        return isl;
    }

    private boolean checkIsPresent(short propId, AbstractModelObject obj, Serializable nval) {
        if (obj == null || nval == null) {
            return false;
        }
        if (propId == 769 || propId == 1025 || propId == 1281 || propId == 3073 || propId == 1537 || propId == 1793) {
            if (!((Boolean)nval).booleanValue()) {
                obj.setLastScanTime(System.currentTimeMillis());
            }
            obj.setPresent((Boolean)nval);
            if (ClientController.isTrace()) {
                ClientController.trace(obj.toString() + " :::isPresent: " + obj.isPresent());
            }
            return true;
        }
        return false;
    }

    public void nonFabricMembersChanged(ChangedModelObject[] o) {
        if (o == null || o.length == 0) {
            return;
        }
        for (int i = 0; i < o.length; ++i) {
            try {
                if (o[i] == null) continue;
                short propId = o[i]._propId;
                short attrType = (short)((propId & 0xFF00) >> 8 << 8);
                switch (attrType) {
                    case 1024: {
                        switch (propId) {
                            case 1070: {
                                ClientController.getInstance().loadNewOUIs();
                            }
                        }
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void fabricMembersChanged(ChangedModelObject[] o) {
        if (o == null || o.length == 0) {
            return;
        }
        AbstractModelObject obj = null;
        block83: for (int i = 0; i < o.length; ++i) {
            try {
                if (o[i] == null) continue;
                PKIf pk = o[i].getPK();
                short propId = o[i]._propId;
                short attrType = (short)((propId & 0xFF00) >> 8 << 8);
                Serializable oval = o[i].getOldValue();
                Serializable nval = o[i].getNewValue();
                obj = null;
                switch (attrType) {
                    case 1024: {
                        Switch sw = this.findSwitchByPK((WwnKey)pk);
                        if (sw == null) {
                            if (!ClientController.getInstance().isServerActive()) break;
                            obj = this.addSwitch((WwnKey)pk);
                            break;
                        }
                        obj = sw;
                        switch (propId) {
                            case 1025: {
                                this.checkIsPresent(propId, obj, nval);
                                if (!((Boolean)nval).booleanValue()) break;
                                final Switch swtch = sw;
                                Runnable authSw = new Runnable(){

                                    @Override
                                    public void run() {
                                        if (DataCenter.this._logger.isDebugEnabled()) {
                                            DataCenter.this._logger.debug((Object)("authenticating switch - " + swtch));
                                        }
                                        swtch.authenticate();
                                        if (DataCenter.this._logger.isDebugEnabled()) {
                                            DataCenter.this._logger.debug((Object)("DONE authenticating switch - " + swtch));
                                        }
                                    }
                                };
                                _executor.execute(authSw);
                                break;
                            }
                            case 1040: {
                                sw.setManagementAddresses((InetAddress[])nval);
                                break;
                            }
                            case 1041: {
                                sw.setManagementAddressInUse((InetAddress)nval);
                                if (nval != null && !this._switchByIpAddress.containsKey(nval)) {
                                    this._switchByIpAddress.put((InetAddress)nval, sw);
                                }
                                final Switch swtch = sw;
                                Runnable authSw = new Runnable(){

                                    @Override
                                    public void run() {
                                        if (DataCenter.this._logger.isDebugEnabled()) {
                                            DataCenter.this._logger.debug((Object)("authenticating switch - " + swtch));
                                        }
                                        swtch.authenticate(true);
                                        if (DataCenter.this._logger.isDebugEnabled()) {
                                            DataCenter.this._logger.debug((Object)("DONE authenticating switch - " + swtch));
                                        }
                                    }
                                };
                                _executor.execute(authSw);
                                break;
                            }
                            case 1039: {
                                ((SwitchBase)sw._baseModelObject).setUnmanageableCause((String)((Object)nval));
                                break;
                            }
                            case 1038: {
                                sw.setManageable((Boolean)nval);
                                break;
                            }
                            case 1047: {
                                VsanDomain oldDomain = (VsanDomain)oval;
                                VsanDomain newDomain = (VsanDomain)nval;
                                if (newDomain != null) {
                                    sw.addVsan(newDomain);
                                    break;
                                }
                                if (oldDomain == null) break;
                                sw.removeVsan(oldDomain._vsanPK._id);
                                break;
                            }
                            case 1034: {
                                sw.setMDS((Boolean)nval);
                                break;
                            }
                            case 1035: {
                                sw.setModelType((Integer)nval);
                                break;
                            }
                            case 1027: {
                                sw.setSysName((String)((Object)nval));
                                break;
                            }
                            case 1028: {
                                sw.setSysContact((String)((Object)nval));
                                break;
                            }
                            case 1029: {
                                sw.setSysLocation((String)((Object)nval));
                                break;
                            }
                            case 1030: {
                                sw.setSysLastBootTime((Long)nval);
                                break;
                            }
                            case 1044: {
                                sw.setStandbySupState((Integer)nval);
                                break;
                            }
                            case 1046: {
                                sw.setFeatureFlags((boolean[])nval);
                                break;
                            }
                            case 1042: {
                                sw.setActiveSupPhysicalIndex((Integer)nval);
                                break;
                            }
                            case 1043: {
                                sw.setStandbySupSlot((Integer)nval);
                                break;
                            }
                            case 1045: {
                                sw.setConnUnitStatus((Integer)nval);
                                break;
                            }
                            case 1031: {
                                sw.setVersion((String)((Object)nval));
                                break;
                            }
                            case 1036: {
                                sw.setModelName((String)((Object)nval));
                                break;
                            }
                            case 1050: {
                                sw.setIsLicenseViolation((Boolean)nval);
                                break;
                            }
                            case 1048: {
                                sw.setTrapRegistered((Boolean)nval);
                                break;
                            }
                            case 1033: {
                                sw.setNumFcPorts((Integer)nval);
                                break;
                            }
                            case 1064: {
                                sw.setNumEthPorts((Integer)nval);
                                break;
                            }
                            case 1051: {
                                sw.setLicenses((LicenseInfo[])nval);
                                break;
                            }
                            case 1053: {
                                sw.setFcFeModuleId((Integer)nval);
                                break;
                            }
                            case 1054: {
                                sw.setModuleIndexOffset((Integer)nval);
                                break;
                            }
                            case 1037: {
                                sw.setCardTypeInSlots((int[])nval);
                                break;
                            }
                            case 1026: {
                                break;
                            }
                            case 1032: {
                                sw.setSerialNumber((String)((Object)nval));
                                break;
                            }
                            case 1052: {
                                sw.setSysDescr((String)((Object)nval));
                                break;
                            }
                            case 1049: {
                                sw.setSyslogRegistered((Boolean)nval);
                                break;
                            }
                            case 1055: {
                                sw.setTelnetEnabled((Boolean)nval);
                                break;
                            }
                            case 1057: {
                                sw.setSSHEnabled((Boolean)nval);
                                break;
                            }
                            case 1056: {
                                sw.setDeviceAliasMode((Integer)nval);
                                break;
                            }
                            case 1065: {
                                sw.setVlanByVsanMap((Map)((Object)nval));
                                break;
                            }
                            case 1066: {
                                sw.setFCoECapable((Boolean)nval);
                                break;
                            }
                            case 1067: {
                                sw.setDelayLinkEnabled((Boolean)nval);
                                break;
                            }
                            case 1068: {
                                sw.setVsanZoneAttrs((Map)((Object)nval));
                                break;
                            }
                            case 1069: {
                                sw.setSwitchLastBootTime((Long)nval);
                                break;
                            }
                            case 1071: {
                                ((SwitchBase)sw._baseModelObject).setVdcId((Integer)nval);
                                break;
                            }
                            case 1072: {
                                ((SwitchBase)sw._baseModelObject).setFCoECapability((Short)nval);
                            }
                        }
                        break;
                    }
                    case 2048: {
                        break;
                    }
                    case 1536: {
                        break;
                    }
                    case 768: {
                        break;
                    }
                    case 1280: {
                        Isl isl;
                        obj = this.findIslBySwitchIntKey(((IslPK)pk).getSwitchIntKey1(), false);
                        if (obj == null || obj.getUserObject() == null) {
                            IslBase islBase;
                            if (!ClientController.getInstance().isServerActive() || (islBase = ClientController.getInstance().assertModelFacade().findIslBySwitchIntKey(((IslPK)pk).getSwitchIntKey1())) == null) break;
                            obj = this.addIsl(islBase, San.getInstance().getFabricByIslSwitchIntKey(islBase.getIslPK().getSwitchIntKey1()));
                            break;
                        }
                        if (!pk.equals(obj.getPK())) {
                            obj = null;
                        }
                        if ((isl = (Isl)obj) == null) break;
                        switch (propId) {
                            case 1284: {
                                isl.setVsanMembership((List)((Object)nval));
                                break;
                            }
                            case 1287: {
                                IslPK islpk;
                                ChannelMemberIsl mem;
                                List<AbstractFcLink> members;
                                if (isl.isPortChannel() && isl.getNumPCMembers() > 0) {
                                    members = isl.getPCMemberLinks();
                                    for (int j = 0; j < members.size(); ++j) {
                                        mem = (ChannelMemberIsl)members.get(j);
                                        islpk = (IslPK)mem.getPK();
                                        this._islByPCMemberSwitchIntKey.remove(islpk.getSwitchIntKey1());
                                        this._islByPCMemberSwitchIntKey.remove(islpk.getSwitchIntKey2());
                                    }
                                }
                                isl.setChildren((List)((Object)nval));
                                if (!isl.isPortChannel() || isl.getNumPCMembers() <= 0) break;
                                members = isl.getPCMemberLinks();
                                for (int j = 0; j < members.size(); ++j) {
                                    mem = (ChannelMemberIsl)members.get(j);
                                    islpk = (IslPK)mem.getPK();
                                    this._islByPCMemberSwitchIntKey.put(islpk.getSwitchIntKey1(), isl);
                                    this._islByPCMemberSwitchIntKey.put(islpk.getSwitchIntKey2(), isl);
                                }
                                break;
                            }
                            case 1286: {
                                isl.setConfigChildCount((Short)nval);
                                break;
                            }
                            case 1282: {
                                isl.setOperMode((Short)nval);
                                break;
                            }
                            case 1283: {
                                ((Isl)obj).setOperStatusCause(((Short)nval).shortValue());
                                break;
                            }
                            case 1285: {
                                ((Isl)obj).setAutoCreated((Boolean)nval);
                                break;
                            }
                            case 1288: {
                                ((Isl)obj).setSpeed((Long)nval);
                                break;
                            }
                            case 1289: {
                                ((Isl)obj).setFiconAddresses((Integer)nval);
                                break;
                            }
                            case 1292: {
                                ((Isl)obj).setFcspAuthenticated((Boolean)nval);
                                break;
                            }
                            case 1294: {
                                ((Isl)obj).setEspReady((Boolean)nval);
                                break;
                            }
                            case 1293: {
                                ((Isl)obj).setEspSecure((Boolean)nval);
                                break;
                            }
                            case 1290: {
                                ((Isl)obj).setFcConnectorType((Short)nval);
                                break;
                            }
                            case 1295: {
                                PCMemberTrustSec pcTS = (PCMemberTrustSec)nval;
                                ((Isl)obj).getIslBase().addTrustSec(pcTS.getIfIndexPair(), pcTS);
                            }
                        }
                        this.checkIsPresent(propId, obj, nval);
                        break;
                    }
                    case 3072: {
                        NpvLink npvl = this.findNpvLinkByFportKey((SwitchIntKey)pk);
                        obj = npvl;
                        if (npvl == null || npvl.getUserObject() == null) {
                            NpvLinkBase npvlBase;
                            if (!ClientController.getInstance().isServerActive() || (npvlBase = ClientController.getInstance().assertModelFacade().findNpvLinkByFPortPK((SwitchIntKey)pk)) == null) break;
                            npvl = this.addNpvLink(npvlBase, San.getInstance().getFabricByNpvLinkByFportKey(npvlBase.getFPortPK()));
                            obj = npvl;
                            break;
                        }
                        switch (propId) {
                            case 3074: {
                                if (nval instanceof Short) {
                                    npvl.setOperStatusCause(((Short)nval).shortValue());
                                    break;
                                }
                                npvl.setOperStatusCause((Integer)nval);
                                break;
                            }
                            case 3075: {
                                npvl.setSpeed((Long)nval);
                                break;
                            }
                            case 3076: {
                                npvl.setVsanMembership((List)((Object)nval));
                                break;
                            }
                            case 3080: {
                                SwitchIntKey fPortPK;
                                ChannelMemberNpvLink mem;
                                List<AbstractFcLink> members;
                                if (npvl.isPortChannel() && npvl.getNumPCMembers() > 0) {
                                    members = npvl.getPCMemberLinks();
                                    for (int j = 0; j < members.size(); ++j) {
                                        mem = (ChannelMemberNpvLink)members.get(j);
                                        fPortPK = (SwitchIntKey)mem.getPK();
                                        this._npvLinkByPCMemberSwitchIntKey.remove(fPortPK);
                                    }
                                }
                                npvl.setChildren((List)((Object)nval));
                                if (!npvl.isPortChannel() || npvl.getNumPCMembers() <= 0) break;
                                members = npvl.getPCMemberLinks();
                                for (int j = 0; j < members.size(); ++j) {
                                    mem = (ChannelMemberNpvLink)members.get(j);
                                    fPortPK = (SwitchIntKey)mem.getPK();
                                    this._npvLinkByPCMemberSwitchIntKey.put(fPortPK, npvl);
                                }
                                break;
                            }
                            case 3079: {
                                npvl.setConfigChildCount((Short)nval);
                                break;
                            }
                            case 3081: {
                                npvl.setOperMode((Short)nval);
                                break;
                            }
                            case 3077: {
                                npvl.setNpPortPK((SwitchIntKey)nval);
                                break;
                            }
                            case 3078: {
                                npvl.setNpPortWwn((Wwn)nval);
                                break;
                            }
                            case 3082: {
                                npvl.setAutoCreated((Boolean)nval);
                            }
                        }
                        this.checkIsPresent(propId, obj, nval);
                        break;
                    }
                    case 1792: {
                        break;
                    }
                    case 2560: {
                        break;
                    }
                    case 2304: {
                        break;
                    }
                    case 512: {
                        continue block83;
                    }
                    default: {
                        if (!ClientController.isTrace()) break;
                        ClientController.trace("Unknown type changed : " + attrType + ": " + o[i].getClass().getName() + ": " + o[i]);
                    }
                }
                if (obj != null) {
                    if (!this._logger.isDebugEnabled()) continue;
                    this._logger.debug((Object)("CHANGED: " + o[i] + " ::: " + propId + " : " + oval + " -> " + nval));
                    continue;
                }
                if (!this._logger.isDebugEnabled()) continue;
                this._logger.debug((Object)("Couldn't find(CHANGED): " + o[i] + " ::: " + propId + " : " + oval + " -> " + nval));
                continue;
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in fabricMemeberChanged " + o[i]), (Throwable)ex);
            }
        }
        this.firePropertyChangeEvents();
    }

    public void fabricMembersRemoved(PKIf[] o) {
        if (o == null || o.length == 0) {
            this.purgeAll();
            this.firePropertyChangeEvents();
            return;
        }
        AbstractModelObject obj = null;
        for (int i = 0; i < o.length; ++i) {
            try {
                if (o[i] == null) continue;
                obj = null;
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("REMOVED: " + o[i]));
                }
                if (!(o[i] instanceof VsanPK)) {
                    if (o[i] instanceof SwitchIntKey) {
                        SwitchIntKey switchIntKey = (SwitchIntKey)o[i];
                        if (switchIntKey instanceof NpvSwitchIntKey) {
                            obj = (AbstractModelObject)this.removeNpvLink(switchIntKey);
                        } else {
                            Switch sw = this.findSwitchByPKNoAdd(switchIntKey.getSwitchKey());
                            if (sw != null) {
                                sw.removeFCPort(switchIntKey.getIfindex());
                            }
                        }
                    } else if (o[i] instanceof WwnKey) {
                        obj = this.removeSwitch(o[i]);
                    } else if (o[i] instanceof IslPK) {
                        obj = (Isl)this.removeIsl((IslPK)o[i]);
                    } else if (!(o[i] instanceof ClusterPK)) {
                        if (o[i] instanceof FabricPK) {
                            this.purgeAll();
                            break;
                        }
                        if (!(o[i] instanceof NameKey)) {
                            // empty if block
                        }
                    }
                }
                if (obj == null || !ClientController.isTrace() || !this._logger.isInfoEnabled()) continue;
                this._logger.info((Object)("Removed : " + obj));
                continue;
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in fabricMembersRemoved " + o[i]), (Throwable)ex);
            }
        }
        this.firePropertyChangeEvents();
    }

    public Object removeNpvLink(SwitchIntKey fportPK) {
        NpvLink npvl = this._npvLinkByFPortPK.remove(fportPK);
        if (npvl != null) {
            if (npvl.isPortChannel() && npvl.getNumPCMembers() > 0) {
                List<NpvLink> members = npvl.getPCMemberLinksAsNpvLink();
                for (int i = 0; i < members.size(); ++i) {
                    ChannelMemberNpvLink mem = (ChannelMemberNpvLink)members.get(i);
                    SwitchIntKey pk = (SwitchIntKey)mem.getPK();
                    this._npvLinkByPCMemberSwitchIntKey.remove(pk);
                }
            }
            if (this.inited()) {
                this.addPropertyChangeEvent(new PropertyChangeEvent(this, "npvLinkRemoved", npvl, null));
            }
        }
        return npvl;
    }

    public Switch removeSwitch(PKIf switchPK) {
        Switch sw = this._switchByPK.remove(switchPK);
        if (sw != null) {
            if (sw.getInetAddress() != null) {
                this.removeSwitchByIpAddress(sw.getInetAddress());
            }
            if (this.inited()) {
                this.addPropertyChangeEvent(new PropertyChangeEvent(this, "switchRemoved", sw, null));
            }
        }
        return sw;
    }

    private void removeSwitchByIpAddress(InetAddress swIpAddr) {
        this._switchByIpAddress.remove(swIpAddr);
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("removeSwitchByIpAddress switch removed swIpAddr=" + swIpAddr));
        }
    }

    public Object removeIsl(IslPK islPK) {
        Isl isl = this._islBySwitchIntKey.get(islPK.getSwitchIntKey1());
        if (isl != null && islPK.equals(isl.getPK())) {
            this.removeIsl(islPK.getSwitchIntKey1());
            this.removeIsl(islPK.getSwitchIntKey2());
            if (isl.isPortChannel() && isl.getNumPCMembers() > 0) {
                List<Isl> members = isl.getPCMemberLinksAsIsls();
                for (int i = 0; i < members.size(); ++i) {
                    ChannelMemberIsl mem = (ChannelMemberIsl)members.get(i);
                    IslPK pk = (IslPK)mem.getPK();
                    this._islByPCMemberSwitchIntKey.remove(pk.getSwitchIntKey1());
                    this._islByPCMemberSwitchIntKey.remove(pk.getSwitchIntKey2());
                }
            }
            if (this.inited()) {
                this.addPropertyChangeEvent(new PropertyChangeEvent(this, "islRemoved", isl, null));
            }
            return isl;
        }
        return null;
    }

    private Object removeIsl(PKIf switchIntKey) {
        return this._islBySwitchIntKey.remove(switchIntKey);
    }

    public void fabricMembersPurged(PKIf[] pks) {
        this.fabricMembersRemoved(pks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKIf[] purgeAll() {
        HashedArrayList<PKIf> purgedKeys = new HashedArrayList<PKIf>(0);
        HashMap<SwitchIntKey, Isl> hashMap = this._islBySwitchIntKey;
        synchronized (hashMap) {
            Iterator<Map.Entry<SwitchIntKey, Isl>> it = this._islBySwitchIntKey.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<SwitchIntKey, Isl> entry = it.next();
                Isl isl = entry.getValue();
                if (isl.isPresent()) continue;
                if (((IslPK)isl.getPK())._p1.equals(entry.getKey())) {
                    purgedKeys.add(isl.getPK());
                }
                it.remove();
            }
        }
        purgedKeys.addAll(this.purge(this._switchByPK));
        this.purge(this._switchByIpAddress);
        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "purge", null, purgedKeys.toArray(new PKIf[purgedKeys.size()])));
        return purgedKeys.toArray(new PKIf[purgedKeys.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<PKIf> purge(HashMap map) {
        HashedArrayList<PKIf> purgedKeys = new HashedArrayList<PKIf>(map.size() / 4);
        boolean endportHash = false;
        try {
            HashMap hashMap = map;
            synchronized (hashMap) {
                Iterator en = map.entrySet().iterator();
                while (en.hasNext()) {
                    Map.Entry entry = en.next();
                    AbstractModelObject mo = (AbstractModelObject)entry.getValue();
                    if (mo.isPresent() && (!endportHash || ((EndPort)mo).getSwitch() != null && ((EndPort)mo).getSwitch().isPresent())) continue;
                    en.remove();
                    ((ArrayList)purgedKeys).add(mo.getPK());
                }
            }
        }
        catch (Exception ex) {
            this._logger.error((Object)"Error in purge", (Throwable)ex);
        }
        return purgedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchIpAddressesChanged(Switch sw, InetAddress[] oldAddrs, InetAddress[] newAddrs) {
        HashMap<InetAddress, Switch> hashMap = this._switchByIpAddress;
        synchronized (hashMap) {
            int i;
            boolean doRemove = true;
            for (i = 0; i < newAddrs.length; ++i) {
                if (newAddrs[i] != null) continue;
                doRemove = false;
            }
            if (oldAddrs != null && doRemove) {
                for (i = 0; i < oldAddrs.length; ++i) {
                    if (newAddrs != null && GenUtil.linearSearch(newAddrs, oldAddrs[i]) >= 0) continue;
                    this._switchByIpAddress.remove(oldAddrs[i]);
                    this._logger.warn((Object)("switchIpAddressesChanged removed _switchByIpAddress oldAddrs=" + oldAddrs[i]));
                }
            }
            if (newAddrs != null) {
                for (i = 0; i < newAddrs.length; ++i) {
                    if (oldAddrs != null && GenUtil.linearSearch(oldAddrs, newAddrs[i]) >= 0) continue;
                    this._switchByIpAddress.put(newAddrs[i], sw);
                    this._logger.warn((Object)("switchIpAddressesChanged newAddrs=" + newAddrs[i] + " for switch=" + sw));
                }
            }
        }
    }

    public void removeSwitchByVsanDomainPK(VsanDomain vsanDomain) {
    }

    public void addSwitchByVsanDomainPK(Switch switch1, VsanDomain vdomain) {
    }

    @Override
    public void ipAddressDisplayTypeChanged() {
        AbstractSwitch[] sws = this.getAbstractSwitches();
        if (sws != null && sws.length > 0) {
            for (int i = 0; i < sws.length; ++i) {
                if (sws[i].getInetAddress() == null) continue;
                this.addPropertyChangeEvent(new PropertyChangeEvent(sws[i], "name", null, sws[i].getName()));
            }
        }
    }

    @Override
    public void inventoryEventReceived(InventoryChangeEvent event) {
        if (event == null) {
            return;
        }
        InventoryComponent comp = event.getEntity();
        if (comp instanceof HwInventoryComponent) {
            HwInventoryComponent hwComp = (HwInventoryComponent)comp;
            Object swPK = hwComp.getSwitchPK();
            if (swPK instanceof SerialNumKey) {
                super.inventoryEventReceived(event);
            } else if (swPK instanceof VdcPK) {
                super.inventoryEventReceived(event);
            } else {
                WwnKey switchPK = (WwnKey)swPK;
                Switch sw = this.getSwitchByPK(switchPK);
                if (sw != null) {
                    if (sw instanceof Switch) {
                        sw.inventoryEventReceived(event);
                    } else if (this._logger.isInfoEnabled()) {
                        this._logger.info((Object)("inventoryEventReceived, rejected in LAN for Ethernet switch as DataCenter expects LAN to update inventory events for these switches: switchPK=" + swPK));
                    }
                } else if (this._logger.isInfoEnabled()) {
                    this._logger.info((Object)("inventoryEventReceived, rejected due to LAN not contain switch: switchPK=" + swPK));
                }
            }
        }
    }

    static {
        _executor = new PooledThreadExecutor("SwitchThreadPool", 1, 10, 20000L);
        _Instance = new DataCenter();
    }
}

