/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmQlogicCommandHandler;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import java.util.Date;
import java.util.List;

public class DefaultZoneMembers
implements SnmpCallbackIf {
    static final int ZONE_PERMIT = 1;
    static final int MAX_WAIT = 11000;
    static final int[] _DefZoneBehaviour = MibNode.get("zoneDefaultZoneBehaviour").getOid();
    private List<Switch> _permitSwitches;
    private SyncedInt _syncObj;
    private EnforcedZone _defaultZone;

    DefaultZoneMembers(EnforcedZone defaultZone) {
        this._defaultZone = defaultZone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws SnmpException {
        Vsan vsan;
        block15: {
            this._permitSwitches = new HashedArrayList<Switch>();
            this._defaultZone.clearMembers();
            this._syncObj = new SyncedInt(0);
            vsan = this._defaultZone.getVsan();
            Switch[] switches = vsan.getSwitches();
            if (switches != null && switches.length > 0) {
                for (int i = 0; i < switches.length; ++i) {
                    Switch sw = switches[i];
                    if (!sw.isManageable() || !sw.isMDS() && !sw.isQuail()) continue;
                    this._syncObj.increment();
                    if (sw.isMDS() && !sw.isQuail()) {
                        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
                        pdu.addNull(new SnmpOID(_DefZoneBehaviour, (int)vsan.getId()));
                        sw.getSnmpPeer().send(pdu, this);
                        continue;
                    }
                    try {
                        VersionPeer verPeer = SmZoneUtil.buildVersionnPeer(sw);
                        SmQlogicCommandHandler cdHandler = new SmQlogicCommandHandler(vsan == null ? verPeer.getIvrCapability() : verPeer.getNonIvrCapability(), vsan, verPeer, null);
                        if (cdHandler.discoverDefaultZoneAttributes().isPermitDefaultPolicy()) {
                            this._permitSwitches.add(sw);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this._syncObj.decrement();
                }
            }
            try {
                if (this._syncObj.get() <= 0) break block15;
                Object i = this._syncObj.getLock();
                synchronized (i) {
                    this._syncObj.getLock().wait(11000L);
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (this._permitSwitches != null) {
            EndPort[] ep = vsan.getFabric().getEndPorts();
            Array<ZoneMemberBase> members = new Array<ZoneMemberBase>();
            if (ep != null && ep.length > 0) {
                for (int i = 0; i < ep.length; ++i) {
                    if (!this._permitSwitches.contains(ep[i].getSwitch()) || !ep[i].isMemberOfVsan(vsan)) continue;
                    ZoneMemberBase ezm = new ZoneMemberBase(this._defaultZone.getZoneBase(), 1, ep[i].getPortWwn().getValue());
                    members.addElement(ezm);
                }
                if (members.size() > 0) {
                    this._defaultZone.addMembers(members);
                }
            }
        }
        this._permitSwitches = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (timedOut) {
            DefaultLogger._DefLogger.error((Object)(new Date() + " " + pdu.getHostAddress() + " timed out"));
        } else {
            SnmpInt b;
            Vsan vsan = this._defaultZone.getVsan();
            Switch sw = vsan.getFabric().findSwitchByIpAddress(pdu.getAddress());
            if (sw == null) {
                DefaultLogger._DefLogger.error((Object)(new Date() + " " + pdu.getHostAddress() + " unknown ipAddr"));
            } else if (pdu.getVar(0).getType() == 2 && (b = (SnmpInt)pdu.getVar(0)).getValue() == 1 && this._permitSwitches != null) {
                this._permitSwitches.add(sw);
            }
        }
        this._syncObj.decrement();
        if (this._syncObj.get() == 0) {
            Object object = this._syncObj.getLock();
            synchronized (object) {
                this._syncObj.getLock().notify();
            }
        }
    }
}

