/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import java.util.List;

public class IfCache {
    int[] _fxIfIndeces;
    int[] _xeIfIndeces;
    int[] _otherIfIndeces;
    int[] _channelIfIndeces;

    IfCache(Switch sw) {
        int j;
        int i;
        int i2;
        Card[] cards = sw.getCards();
        if (cards == null) {
            return;
        }
        int[][] fcIndeces = new int[cards.length][];
        for (int i3 = 0; i3 < cards.length; ++i3) {
            fcIndeces[i3] = cards[i3] != null && cards[i3].getIfType() != 5 ? new int[cards[i3].getNumPorts()] : new int[0];
        }
        int numFxPorts = 0;
        EndPort[] eps = sw.getFabric().getEndPorts();
        for (i2 = 0; i2 < eps.length; ++i2) {
            int port;
            int card;
            EndPort ep = eps[i2];
            if (ep.getSwitch() != sw || !this.checkIndeces(fcIndeces, card = IfIndexUtil.ifIndex2Card(ep.getIfIndex()), port = IfIndexUtil.ifIndex2Port(ep.getIfIndex())) || fcIndeces[card][port] != 0) continue;
            fcIndeces[card][port] = ep.getIfIndex();
            ++numFxPorts;
        }
        this._fxIfIndeces = new int[numFxPorts];
        numFxPorts = 0;
        for (i2 = 0; i2 < fcIndeces.length; ++i2) {
            for (int j2 = 0; j2 < fcIndeces[i2].length; ++j2) {
                if (fcIndeces[i2].length == 0 || fcIndeces[i2][j2] == 0) continue;
                this._fxIfIndeces[numFxPorts++] = fcIndeces[i2][j2];
            }
        }
        int[] channelIfIndeces = new int[128];
        int numChannels = 0;
        int[] xeIfIndeces = new int[128];
        int numXEs = 0;
        Isl[] isls = sw.getFabric().getIsls();
        for (int j3 = 0; j3 < isls.length; ++j3) {
            int port;
            Isl isl = isls[j3];
            if (!isl.isPresent() || isl.isFCIP() || isl.isFcipPortChannel()) continue;
            int ifIndex = 0;
            if (isl.getSwitch1() == sw) {
                if (isl.isPortChannel()) {
                    channelIfIndeces[numChannels++] = isl.getIfIndex1();
                } else {
                    ifIndex = isl.getIfIndex1();
                }
            } else {
                if (isl.getSwitch2() != sw) continue;
                if (isl.isPortChannel()) {
                    channelIfIndeces[numChannels++] = isl.getIfIndex2();
                    ifIndex = 1;
                } else {
                    ifIndex = isl.getIfIndex2();
                }
            }
            List<int[]> children = isl.getChildren();
            if (isl.isPortChannel() && children != null && children.size() > 0) {
                for (int[] members : children) {
                    int port2;
                    int card = IfIndexUtil.ifIndex2Card(members[ifIndex]);
                    if (!this.checkIndeces(fcIndeces, card, port2 = IfIndexUtil.ifIndex2Port(members[ifIndex]))) continue;
                    fcIndeces[card][port2] = members[ifIndex];
                    xeIfIndeces[numXEs++] = members[ifIndex];
                }
                continue;
            }
            int card = IfIndexUtil.ifIndex2Card(ifIndex);
            if (this.checkIndeces(fcIndeces, card, port = IfIndexUtil.ifIndex2Port(ifIndex))) {
                fcIndeces[card][port] = ifIndex;
            }
            xeIfIndeces[numXEs++] = ifIndex;
        }
        this._channelIfIndeces = new int[numChannels];
        System.arraycopy(channelIfIndeces, 0, this._channelIfIndeces, 0, numChannels);
        this._xeIfIndeces = new int[numXEs];
        System.arraycopy(xeIfIndeces, 0, this._xeIfIndeces, 0, numXEs);
        int numOther = 0;
        for (i = 0; i < fcIndeces.length; ++i) {
            for (j = 0; j < fcIndeces[i].length; ++j) {
                if (fcIndeces[i].length == 0 || fcIndeces[i][j] != 0) continue;
                ++numOther;
            }
        }
        this._otherIfIndeces = new int[numOther];
        numOther = 0;
        for (i = 0; i < fcIndeces.length; ++i) {
            for (j = 0; j < fcIndeces[i].length; ++j) {
                if (fcIndeces[i].length == 0 || fcIndeces[i][j] != 0) continue;
                this._otherIfIndeces[numOther++] = IfIndexUtil.nameToIfIndex(i + 1, j + 1, 1);
            }
        }
    }

    public int[] getFxIfIndeces() {
        return this._fxIfIndeces;
    }

    public int[] getXEIfIndeces() {
        return this._xeIfIndeces;
    }

    public int[] getOtherIfIndeces() {
        return this._otherIfIndeces;
    }

    public int[] getChannelIfIndeces() {
        return this._channelIfIndeces;
    }

    boolean checkIndeces(int[][] fcIndeces, int card, int port) {
        return card >= 0 && card < fcIndeces.length && port >= 0 && port < fcIndeces[card].length;
    }
}

