/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.model.AbstractFcLink;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.ChannelMemberIsl;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.FcLinkIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.dto.PCMemberTrustSec;
import com.cisco.dcbu.sm.common.model.AbstractFcLinkBase;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Isl
extends AbstractFcLink
implements FcLinkIf,
Cloneable {
    protected Switch _switch1;
    protected Switch _switch2;
    protected Fabric _fabric;
    protected DataCenter _dataCenter;
    protected San _san;
    protected IslBase _islBase;

    public Isl(AbstractFcLinkBase islBase, Fabric fabric) {
        super(islBase);
        if (islBase instanceof IslBase) {
            this._islBase = (IslBase)islBase;
        }
        this._fabric = fabric;
    }

    public Isl(AbstractFcLinkBase islBase, Fabric fabric, DataCenter dataCenter) {
        super(islBase);
        if (islBase instanceof IslBase) {
            this._islBase = (IslBase)islBase;
        }
        this._fabric = fabric;
        this._dataCenter = dataCenter;
    }

    public Isl(AbstractFcLinkBase islBase, Fabric fabric, San san) {
        super(islBase);
        if (islBase instanceof IslBase) {
            this._islBase = (IslBase)islBase;
        }
        this._fabric = fabric;
        this._san = san;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        Isl isl1 = (Isl)o1;
        Isl isl2 = (Isl)o2;
        int result = isl1._switch1.getName().compareTo(isl2._switch1.getName());
        if (result == 0) {
            return isl1.getIfIndex1Name().compareTo(isl2.getIfIndex1Name());
        }
        return result;
    }

    @Override
    public Fabric getFabric() {
        return this._fabric;
    }

    @Override
    public DataCenter getDataCenter() {
        return this._dataCenter;
    }

    public San getSan() {
        return this._san;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public WwnKey getSwitch1PK() {
        return this._islBase.getSwitch1PK();
    }

    @Override
    public WwnKey getSwitch2PK() {
        return this._islBase.getSwitch2PK();
    }

    @Override
    public Switch getSwitch1() {
        if (this._switch1 != null) {
            return this._switch1;
        }
        if (this._switch1 == null && this.getDataCenter() != null) {
            this._switch1 = this.getDataCenter().findSwitchByPK(((IslPK)this.getPK()).getSwitchIntKey1()._swPK);
        } else if (this._switch1 == null && this.getSan() != null) {
            this._switch1 = this.getSan().findSwitchByPKInRestrictedTopology(((IslPK)this.getPK()).getSwitchIntKey1()._swPK);
        } else if (this._switch1 == null && this.getFabric() != null) {
            this._switch1 = this.getFabric().findSwitchByPK(((IslPK)this.getPK()).getSwitchIntKey1()._swPK);
        }
        return this._switch1;
    }

    @Override
    public Switch getSwitch2() {
        if (this._switch2 != null) {
            return this._switch2;
        }
        if (this._switch2 == null && this.getDataCenter() != null) {
            this._switch2 = this.getDataCenter().findSwitchByPK(((IslPK)this.getPK()).getSwitchIntKey2()._swPK);
        } else if (this._switch2 == null && this.getSan() != null) {
            this._switch2 = this.getSan().findSwitchByPKInRestrictedTopology(((IslPK)this.getPK()).getSwitchIntKey2()._swPK);
        } else if (this._switch2 == null && this.getFabric() != null) {
            this._switch2 = this.getFabric().findSwitchByPK(((IslPK)this.getPK()).getSwitchIntKey2()._swPK);
        }
        return this._switch2;
    }

    @Override
    public AbstractSwitch getAbstractSwitch1() {
        return this.getSwitch1();
    }

    @Override
    public AbstractSwitch getAbstractSwitch2() {
        return this.getSwitch2();
    }

    public Switch getNbrSwitch(Switch sw) {
        if (sw.equals(this.getSwitch1())) {
            return this.getSwitch2();
        }
        if (sw.equals(this.getSwitch2())) {
            return this.getSwitch1();
        }
        return null;
    }

    @Override
    public void setOperStatusCause(int operStatusCause) {
        short old = this.getOperStatusCause();
        if (old != operStatusCause) {
            this._abstractFcLinkBase.setOperStatusCause(operStatusCause);
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "operStatusCause", new Integer(old), new Integer(operStatusCause)));
        }
    }

    public boolean isAutoCreated() {
        if (this._islBase == null) {
            return false;
        }
        return this._islBase.isAutoCreated();
    }

    public void setAutoCreated(boolean autoCreated) {
        if (this._islBase == null) {
            return;
        }
        this._islBase.setAutoCreated(autoCreated);
    }

    @Override
    public void setOperMode(short operMode) {
        short old = this.getOperMode();
        if (old != operMode) {
            this._abstractFcLinkBase.setOperMode(operMode);
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "operMode", new Integer(old), new Integer(operMode)));
        }
    }

    @Override
    public void setSpeed(long speed) {
        long old = this._abstractFcLinkBase.getSpeed();
        if (old != speed) {
            this._abstractFcLinkBase.setSpeed(speed);
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "speed", new Long(old), new Long(speed)));
        }
    }

    public void setFiconAddresses(int ficonAddrs) {
        if (this._islBase == null) {
            return;
        }
        this._islBase.setFiconAddresses(ficonAddrs);
    }

    public void setFcspAuthenticated(boolean fspAuthenticated) {
        if (this._islBase == null) {
            return;
        }
        this._islBase.setFcspAuthenticated(fspAuthenticated);
    }

    public void setEspSecure(boolean espSecured) {
        if (this._islBase == null) {
            return;
        }
        this._islBase.setEspSecure(espSecured);
    }

    public void setEspReady(boolean espReady) {
        if (this._islBase == null) {
            return;
        }
        this._islBase.setEspReady(espReady);
    }

    public void setFcConnectorType(short fcConnType) {
        short old = this._abstractFcLinkBase.getFcConnectorType();
        this._abstractFcLinkBase.setFcConnectorType(fcConnType);
        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "fcConnType", new Integer(old), new Integer(fcConnType)));
    }

    public int getNumPCMembers() {
        if (this._islBase == null) {
            return 0;
        }
        return this._islBase.getNumPCMembers();
    }

    @Override
    public boolean isTrunk() {
        if (this._islBase == null) {
            return false;
        }
        return this._islBase.isTrunk();
    }

    @Override
    public boolean isMinorAlarm() {
        if (this._islBase == null) {
            return false;
        }
        if (this._islBase.getOperStatusCause() == 108) {
            return true;
        }
        if (this.isPresent() && this._islBase.hasPCdegraded()) {
            return true;
        }
        return this._islBase.getOperStatusCause() != 2;
    }

    @Override
    public String getStatus() {
        if (this._islBase == null) {
            return "ok";
        }
        if (!this.isPresent()) {
            return "last seen " + SnmpTimeticks.getDateFormat().format(new Date(this._baseModelObject.getLastScanTime()));
        }
        if (this._islBase.getOperStatusCause() == 108) {
            return "Trunk Not Fully Active";
        }
        if (this.isPresent() && this._islBase.hasPCdegraded()) {
            int childrenSize = 0;
            List<int[]> children = this._islBase.getChildren();
            if (children != null) {
                childrenSize = children.size();
            }
            return this._islBase.getConfigChildCount() - childrenSize + " member(s) down";
        }
        if (this._islBase.getOperStatusCause() != 2) {
            return MibVariableFormat.toCauseString(this._islBase.getOperStatusCause()) + " " + SnmpTimeticks.getDateFormat().format(new Date(this._islBase.getLastScanTime()));
        }
        return "ok";
    }

    @Override
    public boolean isMemberOfVsan(int vsanId) {
        return this._abstractFcLinkBase.isMemberOfVsan((short)vsanId);
    }

    public boolean isMemberOfVsan(Vsan vsan) {
        Vsan[] vsans = this.getVsans();
        if (vsans != null && vsans.length > 0) {
            for (int i = 0; i < vsans.length; ++i) {
                if (!vsans[i].getPK().equals(vsan.getPK())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getIfIndex1() {
        if (this._islBase == null) {
            return 0;
        }
        return this._islBase.getIfIndex1();
    }

    @Override
    public int getIfIndex2() {
        if (this._islBase == null) {
            return 0;
        }
        return this._islBase.getIfIndex2();
    }

    @Override
    public String getIfIndex1Name() {
        if (this._islBase == null) {
            return "";
        }
        return this.ifIndexToName(this.getSwitch1(), this._islBase.getIfIndex1());
    }

    @Override
    public String getIfIndex2Name() {
        if (this._islBase == null) {
            return null;
        }
        return this.ifIndexToName(this.getSwitch2(), this._islBase.getIfIndex2());
    }

    String ifIndexToName(Switch sw, int ifIndex) {
        return sw.ifIndexToDisplayName(ifIndex);
    }

    @Override
    public List<int[]> getChildren() {
        if (this._islBase == null) {
            return null;
        }
        return this._islBase.getChildren();
    }

    @Override
    public int getChildCount() {
        if (this._islBase == null) {
            return 0;
        }
        return this._islBase.getChildCount();
    }

    void setChildren(List<int[]> children) {
        if (this._islBase == null) {
            return;
        }
        List<int[]> old = this.getChildren();
        if (old != children) {
            this._islBase.setChildren(children);
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "children", old, children));
        }
    }

    public short getConfigChildCount() {
        if (this._islBase == null) {
            return 0;
        }
        return this._islBase.getConfigChildCount();
    }

    @Override
    public void setConfigChildCount(short count) {
        if (this._islBase == null) {
            return;
        }
        short old = this.getConfigChildCount();
        if (old != count) {
            this._islBase.setConfigChildCount(count);
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "configChildCount", new Integer(old), new Integer(count)));
        }
    }

    public boolean isFcipPortChannel() {
        if (this._islBase == null) {
            return false;
        }
        List<int[]> children = this._islBase.getChildren();
        if (this.isPortChannel() && children != null && children.size() > 0) {
            int[] ifIndeces = children.get(0);
            return this.getSwitch1().isManageable() ? IfIndexUtil.getType(ifIndeces[0]) == 10 : IfIndexUtil.getType(ifIndeces[1]) == 10;
        }
        return false;
    }

    public List<Isl> getPCMemberLinksAsIsls() {
        if (this._islBase == null) {
            return new HashedArrayList<Isl>();
        }
        List<int[]> children = this._islBase.getChildren();
        if (children == null) {
            return new HashedArrayList<Isl>();
        }
        HashedArrayList<Isl> links = new HashedArrayList<Isl>(children.size());
        for (int[] ifs : children) {
            ChannelMemberIsl mem = new ChannelMemberIsl(ifs[0], ifs[1], this);
            PCMemberTrustSec pcTrustSec = this._islBase.findTrustSecs(ifs);
            if (pcTrustSec != null) {
                mem.setFcspAuthenticated(pcTrustSec.getFcspAuthenticated());
                mem.setEspReady(pcTrustSec.getEspReady());
                mem.setEspSecure(pcTrustSec.getEspSecure());
            }
            links.add(mem);
        }
        return links;
    }

    public List<AbstractFcLink> getPCMemberLinks() {
        if (this._islBase == null) {
            return null;
        }
        List<int[]> children = this._islBase.getChildren();
        if (children == null) {
            return null;
        }
        HashedArrayList<AbstractFcLink> links = new HashedArrayList<AbstractFcLink>(children.size());
        for (int[] ifs : children) {
            ChannelMemberIsl mem = new ChannelMemberIsl(ifs[0], ifs[1], this);
            PCMemberTrustSec pcTrustSec = this._islBase.findTrustSecs(ifs);
            if (pcTrustSec != null) {
                mem.setFcspAuthenticated(pcTrustSec.getFcspAuthenticated());
                mem.setEspReady(pcTrustSec.getEspReady());
                mem.setEspSecure(pcTrustSec.getEspSecure());
            }
            links.add(mem);
        }
        return links;
    }

    @Override
    public String getPCMemberLinksAsString() {
        return this.getPCMemberLinksAsString(false);
    }

    public String getPCMemberLinksAsString(boolean swap) {
        return this.getPCMemberLinksAsString(swap, -1);
    }

    public String getPCMemberLinksAsString(boolean swap, int eachSideLength) {
        if (this._islBase == null) {
            return null;
        }
        List<int[]> children = this._islBase.getChildren();
        if (children == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int length = 0;
        for (int i = 0; i < children.size(); ++i) {
            int[] pair = children.get(i);
            String str = IfIndexUtil.ifIndexToName(pair[swap ? 1 : 0]);
            String str2 = IfIndexUtil.ifIndexToName(pair[swap ? 0 : 1]);
            if (eachSideLength > 20) {
                length += str.length() + str2.length() + 5 + 2;
                if (i == 3 || i == 6) {
                    sb.append("\n").append(str).append(" <-> ").append(str2).append(", ");
                    length = str.length() + str2.length() + 5 + 2;
                    continue;
                }
                sb.append(str).append(" <-> ").append(str2).append(", ");
                continue;
            }
            sb.append(str).append(" <-> ").append(str2).append(", ");
        }
        if (sb.length() > 2 && sb.charAt(sb.length() - 2) == ',') {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    @Override
    public boolean isFCIP() {
        if (this.getSwitch1().isMDS()) {
            return IfIndexUtil.getType(this.getIfIndex1()) == 10 || this.isFcipPortChannel();
        }
        return this.getSwitch1().getModelType() == 529 && (this.getIfIndex1() == 0 || this.getIfIndex1() == 15);
    }

    public boolean isTunnel() {
        return this.isFCIP();
    }

    public boolean isDWDM() {
        if (this._islBase == null) {
            return false;
        }
        return this._islBase.isDWDM();
    }

    public boolean isFCoE() {
        Switch sw1 = this.getSwitch1();
        Switch sw2 = this.getSwitch2();
        if (sw1 == null || sw2 == null) {
            return false;
        }
        return sw1.getSwitchBase().isVfcIfIndex(this.getIfIndex1()) && sw2.getSwitchBase().isVfcIfIndex(this.getIfIndex2());
    }

    @Override
    public String getName() {
        return this.getSwitch1().getName() + ',' + this.getIfIndex1Name() + " <-> " + this.getSwitch2().getName() + ',' + this.getIfIndex2Name();
    }

    @Override
    public String toString() {
        return this.toString(false, false);
    }

    @Override
    public String getDetails(boolean swap) {
        return this.toString(swap, false);
    }

    @Override
    public String toString(boolean swap) {
        return this.toString(swap, false);
    }

    public String toString(boolean swap, boolean dump) {
        if (this._islBase == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean lineBreak = false;
        if (swap) {
            sb.append(this.getSwitch2().getName()).append(',').append(this.getIfIndex2Name()).append(this.getSwitch2().hasFiconVsan() && this._islBase.getFiconAddress2() != -1 ? ", FICON: 0x" + Integer.toHexString(this._islBase.getFiconAddress2()) : "").append(" <-> ").append(this.getSwitch1().getName()).append(',').append(this.getIfIndex1Name()).append(this.getSwitch1().hasFiconVsan() && this._islBase.getFiconAddress1() != -1 ? ", FICON: 0x" + Integer.toHexString(this._islBase.getFiconAddress1()) : "");
        } else {
            sb.append(this.getSwitch1().getName()).append(',').append(this.getIfIndex1Name()).append(this.getSwitch1().hasFiconVsan() && this._islBase.getFiconAddress1() != -1 ? ", FICON: 0x" + Integer.toHexString(this._islBase.getFiconAddress1()) : "").append(" <-> ").append(this.getSwitch2().getName()).append(',').append(this.getIfIndex2Name()).append(this.getSwitch2().hasFiconVsan() && this._islBase.getFiconAddress2() != -1 ? ", FICON: 0x" + Integer.toHexString(this._islBase.getFiconAddress2()) : "");
        }
        if (this.getSpeed() != 0L) {
            sb.append(", " + MibVariableFormat.highSpeed(this.getSpeed() / 1000000L));
        }
        if (!this.isPresent() || this.isMinorAlarm()) {
            sb.append(", " + this.getStatus());
        }
        String vsans = null;
        try {
            vsans = this._islBase.getVsansAsString();
            lineBreak = sb.length() + vsans.length() > Switch.TooltipLineLength;
        }
        catch (Exception ex) {
            vsans = "";
        }
        if (this._islBase.getChildren() != null) {
            sb.append("\n");
            sb.append(this.getPCMemberLinksAsString(swap, Switch.TooltipLineLength));
            lineBreak = true;
        }
        if (dump && this._islBase.isPortChannel()) {
            sb.append("\n");
            sb.append("isPortChannel = true");
            lineBreak = true;
        }
        if (lineBreak) {
            sb.append("\n");
        } else {
            sb.append(", ");
        }
        if (this._islBase.getNumVsans() > 1) {
            sb.append("VSANs:");
        } else {
            if (this._islBase.getOperMode() == 12) {
                sb.append("TE, ");
            }
            sb.append("VSAN ");
        }
        if (vsans.length() > 100) {
            sb.append(vsans.substring(0, 100));
        } else {
            sb.append(vsans);
        }
        if (this._islBase.getFcspAuthenticated()) {
            sb.append(", FC-SP secured");
        }
        if (this._islBase.getEspSecure()) {
            sb.append(", ESP secured");
        }
        if (this.isDWDM()) {
            if (lineBreak) {
                sb.append("\n");
            } else {
                sb.append(", ");
            }
            sb.append("[DWDM]");
        }
        return sb.toString();
    }

    public boolean isEspSecured() {
        if (this._islBase == null) {
            return false;
        }
        return this._islBase.getEspSecure();
    }

    @Override
    public String getAdditionalDetailsForDisplay() {
        if (this._islBase == null) {
            return null;
        }
        StringBuffer sbAdd = new StringBuffer();
        boolean entryAdded = false;
        if (this._islBase.getOperMode() == 12) {
            sbAdd.append("TE");
            entryAdded = true;
        }
        if (this._islBase.getFcspAuthenticated()) {
            if (entryAdded) {
                sbAdd.append(",");
            }
            sbAdd.append(" FC-SP secured");
            entryAdded = true;
        }
        if (this._islBase.getEspSecure()) {
            if (entryAdded) {
                sbAdd.append(",");
            }
            sbAdd.append(" ESP secured");
            entryAdded = true;
        }
        if (this.isDWDM()) {
            if (entryAdded) {
                sbAdd.append(",");
            }
            sbAdd.append(" [DWDM]");
            entryAdded = true;
        }
        return sbAdd.toString();
    }

    public Vsan getVsan(short vsanId) {
        return this.getSwitch1().getVsan(vsanId);
    }

    public Vsan[] getVsans() {
        if (this._islBase == null) {
            return null;
        }
        int numVsans = this.getNumVsans();
        HashedArrayList<Vsan> vsans = new HashedArrayList<Vsan>(numVsans);
        List<Short> vsanIds = this._islBase.getVsanMembership();
        Switch sw = this.getSwitch1();
        for (short vid : vsanIds) {
            Vsan vsan = sw.getVsan(vid);
            if (vsan == null || vsan.getFabric() == null || ((ArrayList)vsans).contains(vsan)) continue;
            ((ArrayList)vsans).add(vsan);
        }
        return vsans.toArray(new Vsan[vsans.size()]);
    }

    @Override
    public void setVsanMembership(List<Short> vm) {
        HashedArrayList<Short> old = new HashedArrayList<Short>(this._abstractFcLinkBase.getVsanMembership());
        if (this._abstractFcLinkBase.setVsanMembership(vm)) {
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "vsanMembership", old, vm));
        }
    }

    @Override
    public void destroy() {
        if (this._islBase != null) {
            this._islBase.setChildren(null);
            this._islBase.clearVsanMembership();
        }
        this._dataCenter = null;
        this._fabric = null;
        this._islBase = null;
        this._san = null;
        this._switch1 = null;
        this._switch2 = null;
        super.destroy();
    }

    public IslBase getIslBase() {
        return this._islBase;
    }

    @Override
    public void setBaseModelObject(BaseModelObject baseModelObject) {
        super.setBaseModelObject(baseModelObject);
        this._islBase = (IslBase)baseModelObject;
    }
}

