/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.model.AbstractFcLink;
import com.cisco.dcbu.sm.client.model.ChannelMemberNpvLink;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.FcLinkIf;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.AbstractFcLinkBase;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class NpvLink
extends Isl
implements FcLinkIf,
Cloneable {
    protected NpvLinkBase _npvLinkBase;

    public NpvLink(AbstractFcLinkBase npvLinkBase, Fabric fabric) {
        super(npvLinkBase, fabric);
        if (npvLinkBase instanceof NpvLinkBase) {
            this._npvLinkBase = (NpvLinkBase)npvLinkBase;
        }
    }

    public NpvLink(AbstractFcLinkBase npvLinkBase, Fabric fabric, DataCenter dataCenter) {
        super(npvLinkBase, fabric, dataCenter);
        if (npvLinkBase instanceof NpvLinkBase) {
            this._npvLinkBase = (NpvLinkBase)npvLinkBase;
        }
    }

    public NpvLink(AbstractFcLinkBase npvLinkBase, Fabric fabric, San san) {
        super(npvLinkBase, fabric, san);
        if (npvLinkBase instanceof NpvLinkBase) {
            this._npvLinkBase = (NpvLinkBase)npvLinkBase;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean isNpvLink() {
        return true;
    }

    public WwnKey getCoreSwitchPK() {
        return this._npvLinkBase.getCoreSwitchPK();
    }

    @Override
    public WwnKey getSwitch1PK() {
        return this.getCoreSwitchPK();
    }

    public Switch getCoreSwitch() {
        if (this._switch1 == null && this.getDataCenter() != null) {
            WwnKey wwnKey = this._npvLinkBase.getCoreSwitchPK();
            this._switch1 = this.getDataCenter().findSwitchByPK(wwnKey);
        } else if (this._switch1 == null && this.getSan() != null) {
            WwnKey wwnKey = this._npvLinkBase.getCoreSwitchPK();
            this._switch1 = this.getSan().findSwitchByPKInRestrictedTopology(wwnKey);
        } else if (this._switch1 == null && this.getFabric() != null) {
            WwnKey wwnKey = this._npvLinkBase.getCoreSwitchPK();
            this._switch1 = this.getFabric().findSwitchByPK(wwnKey);
        }
        return this._switch1;
    }

    @Override
    public String getPCMemberLinksAsString() {
        return this.getPCMemberLinksAsString(false);
    }

    @Override
    public String getPCMemberLinksAsString(boolean swap) {
        return this.getPCMemberLinksAsString(swap, -1);
    }

    @Override
    public String getPCMemberLinksAsString(boolean swap, int eachSideLength) {
        List<int[]> children = this._npvLinkBase.getChildren();
        if (children == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int length = 0;
        for (int i = 0; i < children.size(); ++i) {
            int[] pair = children.get(i);
            String str = IfIndexUtil.ifIndexToName(pair[swap ? 1 : 0]);
            String str2 = IfIndexUtil.ifIndexToName(pair[swap ? 0 : 1]);
            if (eachSideLength > 20) {
                length += str.length() + str2.length() + 5 + 2;
                if (i == 3 || i == 6) {
                    sb.append("\n").append(str).append(" <-> ").append(str2).append(", ");
                    length = str.length() + str2.length() + 5 + 2;
                    continue;
                }
                sb.append(str).append(" <-> ").append(str2).append(", ");
                continue;
            }
            sb.append(str).append(" <-> ").append(str2).append(", ");
        }
        if (sb.length() > 2 && sb.charAt(sb.length() - 2) == ',') {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    public List<NpvLink> getPCMemberLinksAsNpvLink() {
        List<int[]> children = this._npvLinkBase.getChildren();
        if (children == null) {
            return null;
        }
        HashedArrayList<NpvLink> links = new HashedArrayList<NpvLink>(children.size());
        for (int[] ifs : children) {
            ChannelMemberNpvLink mem = new ChannelMemberNpvLink(ifs[0], ifs[1], this);
            links.add(mem);
            mem.setNpPortPK(new SwitchIntKey(this._npvLinkBase.getNpPortPK()._swPK, ifs[1]));
        }
        return links;
    }

    @Override
    public List<AbstractFcLink> getPCMemberLinks() {
        List<int[]> children = this._npvLinkBase.getChildren();
        if (children == null) {
            return null;
        }
        HashedArrayList<AbstractFcLink> links = new HashedArrayList<AbstractFcLink>(children.size());
        for (int[] ifs : children) {
            ChannelMemberNpvLink mem = new ChannelMemberNpvLink(ifs[0], ifs[1], this);
            links.add(mem);
            mem.setNpPortPK(new SwitchIntKey(this._npvLinkBase.getNpPortPK()._swPK, ifs[1]));
        }
        return links;
    }

    @Override
    public List<int[]> getChildren() {
        return this._npvLinkBase.getChildren();
    }

    @Override
    public boolean isTrunk() {
        return this._npvLinkBase.isTrunk();
    }

    @Override
    public int getChildCount() {
        return this._npvLinkBase.getChildCount();
    }

    @Override
    void setChildren(List<int[]> children) {
        List<int[]> old = this.getChildren();
        if (old != children) {
            this._npvLinkBase.setChildren(children);
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "children", old, children));
        }
    }

    public SwitchIntKey getFPortPK() {
        return this._npvLinkBase.getFPortPK();
    }

    public Wwn getFPortWwn() {
        return this._npvLinkBase.getFPortWwn();
    }

    public WwnKey getEdgeSwitchPK() {
        return this._npvLinkBase.getEdgeSwitchPK();
    }

    @Override
    public WwnKey getSwitch2PK() {
        return this.getEdgeSwitchPK();
    }

    public Switch getEdgeSwitch() {
        if (this._switch2 == null && this.getDataCenter() != null) {
            WwnKey wwnKey = this._npvLinkBase.getEdgeSwitchPK();
            this._switch2 = this.getDataCenter().findSwitchByPK(wwnKey);
        } else if (this._switch2 == null && this.getSan() != null) {
            WwnKey wwnKey = this._npvLinkBase.getEdgeSwitchPK();
            this._switch2 = this.getSan().findSwitchByPKInRestrictedTopology(wwnKey);
        } else if (this._switch2 == null && this.getFabric() != null) {
            WwnKey wwnKey = this._npvLinkBase.getEdgeSwitchPK();
            this._switch2 = this.getFabric().findSwitchByPK(wwnKey);
        }
        return this._switch2;
    }

    @Override
    public boolean isMinorAlarm() {
        if (this._npvLinkBase.getOperStatusCause() == 108) {
            return true;
        }
        if (this.isPresent() && this._npvLinkBase.hasPCdegraded()) {
            return true;
        }
        return this._npvLinkBase.getOperStatusCause() != 2;
    }

    @Override
    public String getStatus() {
        if (!this.isPresent()) {
            return "last seen " + SnmpTimeticks.getDateFormat().format(new Date(this._baseModelObject.getLastScanTime()));
        }
        if (this._npvLinkBase.getOperStatusCause() == 108) {
            return "Trunk Not Fully Active";
        }
        if (this.isPresent() && this._npvLinkBase.hasPCdegraded()) {
            int childrenSize = 0;
            List<int[]> children = this._npvLinkBase.getChildren();
            if (children != null) {
                childrenSize = children.size();
            }
            return this._npvLinkBase.getConfigChildCount() - childrenSize + " member(s) down";
        }
        if (this._npvLinkBase.getOperStatusCause() != 2) {
            return MibVariableFormat.toCauseString(this._npvLinkBase.getOperStatusCause()) + " " + SnmpTimeticks.getDateFormat().format(new Date(this._npvLinkBase.getLastScanTime()));
        }
        return "ok";
    }

    @Override
    public boolean isMemberOfVsan(Vsan vsan) {
        return this._npvLinkBase.isMemberOfVsan((short)vsan.getVsanId());
    }

    public int getFPortIfIndex() {
        return this._npvLinkBase.getFPortIfIndex();
    }

    public int getNpPortIfIndex() {
        return this._npvLinkBase.getNpPortIfIndex();
    }

    public String getFPortIfname() {
        if (this.getCoreSwitch().isMDS()) {
            return this.getCoreSwitch().ifIndexToName(this._npvLinkBase.getFPortIfIndex());
        }
        return this.ifIndexToName(this.getCoreSwitch(), this._npvLinkBase.getFPortIfIndex());
    }

    public String getFPortDisplayName() {
        return this.getCoreSwitch().ifIndexToDisplayName(this._npvLinkBase.getFPortIfIndex());
    }

    public String getNpPortIfname() {
        return this.getEdgeSwitch().ifIndexToName(this._npvLinkBase.getNpPortIfIndex());
    }

    public String getNpPortDisplayName() {
        return this.getEdgeSwitch().ifIndexToDisplayName(this._npvLinkBase.getNpPortIfIndex());
    }

    public void setNpPortPK(SwitchIntKey portPK) {
        this._npvLinkBase.setNpPortPK(portPK);
        if (this._switch2 != null && this.getDataCenter() != null) {
            this._switch2 = this.getDataCenter().findSwitchByPK(portPK._swPK);
        } else if (this._switch2 != null && this.getSan() != null) {
            this._switch2 = this.getSan().findSwitchByPKInRestrictedTopology(portPK._swPK);
        } else if (this._switch2 != null && this.getFabric() != null) {
            this._switch2 = this.getFabric().findSwitchByPK(portPK._swPK);
        }
    }

    public void setNpPortWwn(Wwn npWwn) {
        this._npvLinkBase.setNpPortWwn(npWwn);
    }

    @Override
    public void setAutoCreated(boolean autoCreated) {
        this._npvLinkBase.setAutoCreated(autoCreated);
    }

    @Override
    String ifIndexToName(Switch sw, int ifIndex) {
        if (sw.getModelType() == 529) {
            if (ifIndex == 0 || ifIndex == 15) {
                return "fcip" + ifIndex;
            }
            return "fc" + ifIndex;
        }
        return Integer.toString(ifIndex);
    }

    @Override
    public String getName() {
        return this.getCoreSwitch().getName() + ',' + this.getFPortDisplayName() + " <-> " + this.getEdgeSwitch().getName() + ',' + this.getNpPortDisplayName();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String getDetails(boolean swap) {
        return this.toString(swap);
    }

    @Override
    public String toString(boolean swap) {
        StringBuilder sb = new StringBuilder();
        boolean lineBreak = false;
        if (swap) {
            sb.append(this.getEdgeSwitch().getName()).append(',').append(this.getNpPortDisplayName()).append(" <-> ").append(this.getCoreSwitch().getName()).append(',').append(this.getFPortDisplayName());
        } else {
            sb.append(this.getCoreSwitch().getName()).append(',').append(this.getFPortDisplayName()).append(" <-> ").append(this.getEdgeSwitch().getName()).append(',').append(this.getNpPortDisplayName());
        }
        if (this.getSpeed() != 0L) {
            sb.append(", " + MibVariableFormat.highSpeed(this.getSpeed() / 1000000L));
        }
        if (!this.isPresent() || this.isMinorAlarm()) {
            sb.append(", " + this.getStatus());
        }
        String vsans = null;
        try {
            vsans = this._npvLinkBase.getVsansAsString();
            lineBreak = sb.length() + vsans.length() > Switch.TooltipLineLength;
        }
        catch (Exception ex) {
            vsans = "";
        }
        if (this._npvLinkBase.getChildren() != null) {
            sb.append("\n");
            sb.append(this.getPCMemberLinksAsString(swap, Switch.TooltipLineLength));
            lineBreak = true;
        }
        if (lineBreak) {
            sb.append("\n");
        } else {
            sb.append(", ");
        }
        if (this._npvLinkBase.getNumVsans() > 1) {
            sb.append("VSANs:");
        } else {
            if (this._npvLinkBase.getOperMode() == 12) {
                sb.append("TE, ");
            }
            sb.append("VSAN ");
        }
        if (vsans.length() > 100) {
            sb.append(vsans.substring(0, 100));
        } else {
            sb.append(vsans);
        }
        if (lineBreak) {
            sb.append("\n");
        } else {
            sb.append(", ");
        }
        if (this._npvLinkBase.isTrunk()) {
            sb.append("[TF/TNP Link]");
        } else {
            sb.append("[NP Link]");
        }
        return sb.toString();
    }

    @Override
    public String getAdditionalDetailsForDisplay() {
        StringBuilder sbAdd = new StringBuilder();
        if (this._npvLinkBase.isTrunk()) {
            sbAdd.append("[TF/TNP Link]");
        } else {
            sbAdd.append("[NP Link]");
        }
        return sbAdd.toString();
    }

    public Vsan getVsan() {
        return this.getCoreSwitch().getVsan(this._npvLinkBase.getVsanId());
    }

    @Override
    public Vsan[] getVsans() {
        if (this._npvLinkBase == null) {
            return null;
        }
        int numVsans = this.getNumVsans();
        HashedArrayList<Vsan> vsans = new HashedArrayList<Vsan>(numVsans);
        List<Short> vsanIds = this._npvLinkBase.getVsanMembership();
        Switch sw = this.getSwitch1();
        for (short vid : vsanIds) {
            Vsan vsan = sw.getVsan(vid);
            if (vsan == null || vsan.getFabric() == null || ((ArrayList)vsans).contains(vsan)) continue;
            ((ArrayList)vsans).add(vsan);
        }
        return vsans.toArray(new Vsan[vsans.size()]);
    }

    @Override
    public void destroy() {
        if (this._npvLinkBase != null) {
            this._npvLinkBase.clearVsanMembership();
        }
        this._npvLinkBase = null;
        super.destroy();
    }

    @Override
    public void setConfigChildCount(short count) {
        short old = this.getConfigChildCount();
        if (old != count) {
            this._npvLinkBase.setConfigChildCount(count);
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "configChildCount", new Integer(old), new Integer(count)));
        }
    }

    @Override
    public short getConfigChildCount() {
        return this._npvLinkBase.getConfigChildCount();
    }

    @Override
    public int getIfIndex1() {
        return this.getFPortIfIndex();
    }

    @Override
    public String getIfIndex1Name() {
        return this.getFPortIfname();
    }

    @Override
    public int getIfIndex2() {
        return this.getNpPortIfIndex();
    }

    @Override
    public String getIfIndex2Name() {
        return this.getNpPortIfname();
    }

    @Override
    public Switch getSwitch1() {
        return this.getCoreSwitch();
    }

    @Override
    public Switch getSwitch2() {
        return this.getEdgeSwitch();
    }

    @Override
    public boolean isFCIP() {
        return false;
    }

    public NpvLinkBase getNpvLinkBase() {
        return this._npvLinkBase;
    }

    @Override
    public void setBaseModelObject(BaseModelObject baseModelObject) {
        super.setBaseModelObject(baseModelObject);
        this._npvLinkBase = baseModelObject instanceof NpvLinkBase ? (NpvLinkBase)baseModelObject : null;
    }
}

